# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class RecordSet(ProxyResource):
    """Describes a DNS record set (a collection of DNS records with the same name
    and type) in a Private DNS zone.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Example -
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Example -
     'Microsoft.Network/privateDnsZones'.
    :vartype type: str
    :param etag: The ETag of the record set.
    :type etag: str
    :param metadata: The metadata attached to the record set.
    :type metadata: dict[str, str]
    :param ttl: The TTL (time-to-live) of the records in the record set.
    :type ttl: long
    :ivar fqdn: Fully qualified domain name of the record set.
    :vartype fqdn: str
    :ivar is_auto_registered: Is the record set auto-registered in the Private
     DNS zone through a virtual network link?
    :vartype is_auto_registered: bool
    :param a_records: The list of A records in the record set.
    :type a_records: list[~azure.mgmt.privatedns.models.ARecord]
    :param aaaa_records: The list of AAAA records in the record set.
    :type aaaa_records: list[~azure.mgmt.privatedns.models.AaaaRecord]
    :param cname_record: The CNAME record in the record set.
    :type cname_record: ~azure.mgmt.privatedns.models.CnameRecord
    :param mx_records: The list of MX records in the record set.
    :type mx_records: list[~azure.mgmt.privatedns.models.MxRecord]
    :param ptr_records: The list of PTR records in the record set.
    :type ptr_records: list[~azure.mgmt.privatedns.models.PtrRecord]
    :param soa_record: The SOA record in the record set.
    :type soa_record: ~azure.mgmt.privatedns.models.SoaRecord
    :param srv_records: The list of SRV records in the record set.
    :type srv_records: list[~azure.mgmt.privatedns.models.SrvRecord]
    :param txt_records: The list of TXT records in the record set.
    :type txt_records: list[~azure.mgmt.privatedns.models.TxtRecord]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'fqdn': {'readonly': True},
        'is_auto_registered': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': '{str}'},
        'ttl': {'key': 'properties.ttl', 'type': 'long'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'is_auto_registered': {'key': 'properties.isAutoRegistered', 'type': 'bool'},
        'a_records': {'key': 'properties.aRecords', 'type': '[ARecord]'},
        'aaaa_records': {'key': 'properties.aaaaRecords', 'type': '[AaaaRecord]'},
        'cname_record': {'key': 'properties.cnameRecord', 'type': 'CnameRecord'},
        'mx_records': {'key': 'properties.mxRecords', 'type': '[MxRecord]'},
        'ptr_records': {'key': 'properties.ptrRecords', 'type': '[PtrRecord]'},
        'soa_record': {'key': 'properties.soaRecord', 'type': 'SoaRecord'},
        'srv_records': {'key': 'properties.srvRecords', 'type': '[SrvRecord]'},
        'txt_records': {'key': 'properties.txtRecords', 'type': '[TxtRecord]'},
    }

    def __init__(self, **kwargs):
        super(RecordSet, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.metadata = kwargs.get('metadata', None)
        self.ttl = kwargs.get('ttl', None)
        self.fqdn = None
        self.is_auto_registered = None
        self.a_records = kwargs.get('a_records', None)
        self.aaaa_records = kwargs.get('aaaa_records', None)
        self.cname_record = kwargs.get('cname_record', None)
        self.mx_records = kwargs.get('mx_records', None)
        self.ptr_records = kwargs.get('ptr_records', None)
        self.soa_record = kwargs.get('soa_record', None)
        self.srv_records = kwargs.get('srv_records', None)
        self.txt_records = kwargs.get('txt_records', None)
