# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class Action(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The action of virtual network rule.
    """

    ALLOW = "Allow"

class ActionsRequired(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """A message indicating if changes on the service provider require any updates on the consumer.
    """

    NONE = "None"
    RECREATE = "Recreate"

class ConnectionStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The private link service connection status.
    """

    APPROVED = "Approved"
    PENDING = "Pending"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"

class CreatedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class DefaultAction(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The default action of allow or deny when no other rules match.
    """

    ALLOW = "Allow"
    DENY = "Deny"

class EncryptionStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates whether or not the encryption is enabled for container registry.
    """

    ENABLED = "enabled"
    DISABLED = "disabled"

class ImportMode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """When Force, any existing target tags will be overwritten. When NoForce, any existing target
    tags will fail the operation before any copying begins.
    """

    NO_FORCE = "NoForce"
    FORCE = "Force"

class LastModifiedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that last modified the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class NetworkRuleBypassOptions(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Whether to allow trusted Azure services to access a network restricted registry.
    """

    AZURE_SERVICES = "AzureServices"
    NONE = "None"

class PasswordName(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The password name.
    """

    PASSWORD = "password"
    PASSWORD2 = "password2"

class PipelineOptions(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    OVERWRITE_TAGS = "OverwriteTags"
    OVERWRITE_BLOBS = "OverwriteBlobs"
    DELETE_SOURCE_BLOB_ON_SUCCESS = "DeleteSourceBlobOnSuccess"
    CONTINUE_ON_ERRORS = "ContinueOnErrors"

class PipelineRunSourceType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the source.
    """

    AZURE_STORAGE_BLOB = "AzureStorageBlob"

class PipelineRunTargetType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the target.
    """

    AZURE_STORAGE_BLOB = "AzureStorageBlob"

class PipelineSourceType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of source for the import pipeline.
    """

    AZURE_STORAGE_BLOB_CONTAINER = "AzureStorageBlobContainer"

class PolicyStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The value that indicates whether the policy is enabled or not.
    """

    ENABLED = "enabled"
    DISABLED = "disabled"

class ProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state of the pipeline at the time the operation was called.
    """

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class PublicNetworkAccess(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Whether or not public network access is allowed for the container registry.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class RegistryUsageUnit(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The unit of measurement.
    """

    COUNT = "Count"
    BYTES = "Bytes"

class ResourceIdentityType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The identity type.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"

class SkuName(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The SKU name of the container registry. Required for registry creation.
    """

    CLASSIC = "Classic"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"

class SkuTier(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The SKU tier based on the SKU name.
    """

    CLASSIC = "Classic"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"

class TriggerStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The current status of the source trigger.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class TrustPolicyType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of trust policy.
    """

    NOTARY = "Notary"

class WebhookAction(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    PUSH = "push"
    DELETE = "delete"
    QUARANTINE = "quarantine"
    CHART_PUSH = "chart_push"
    CHART_DELETE = "chart_delete"

class WebhookStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the webhook at the time the operation was called.
    """

    ENABLED = "enabled"
    DISABLED = "disabled"
