/******************************************************************************
*												*
*	(C) 1993 by K. Ballueder								*
*												*
*	See README and COPYING for details.							*
*												*
*	Please feel free to contact me:								*
*		kballued@charon.physik.uni-osnabrueck.de					*
*		kballued@jupiter.rz.uni-osnabrueck.de						*
*												*
*******************************************************************************
*/

/***********************************************************************

linux_gl.c:	graphic interface for LinuX's svgalib/vgagllib

*****************************************************end of header*****/
#include "config.h"

#ifdef OS_LINUX

#include <stdio.h>
#include <stdlib.h>
#include <string.h>	/* fuer memmove */
#include <assert.h>

#include "bdash.h"
#include "io.h"		/* fatal_error() */
#include "gr_interface.h"
#include "linux_gl.h"

#include <vga.h>
#include <vgagl.h>
#include "vgax.h"

#include "GObject.h"

#define TEXTWIDTH(string)	(strlen(string)<<3)
#define TEXTHEIGHT(string)	8


#define TEXTCOLOR	15

static int gr_width, gr_height;
static size_t	gr_screensize;
int graphics_initialized = 0;

static void initfont(void) 	/* initializes font from vgagl-lib */
{
	void *font;

	font = malloc(256 * 8 * 8 * BYTESPERPIXEL);
	gl_expandfont(8, 8, TEXTCOLOR, gl_font8x8, font);
	gl_setfont(8, 8, font);
	gl_setwritemode(WRITEMODE_MASKED);
}
#ifdef VIRTUAL_SCREEN
	static GraphicsContext screen;
#endif

void update_graphics(void)
{
#ifdef VIRTUAL_SCREEN
	debug_printf("update_graphic()\n");
	gl_copyscreen(&screen);	/* copy graphics to screen */
#endif
}
void initgraphics(void)
{
	if(vga_setmode(GRAPHICS_MODE) != 0)
		fatal_error("No graphics mode!\a");
	graphics_initialized = 1;
	vga_clear();
	gl_setcontextvga(GRAPHICS_MODE);	/* vgagl */
#ifdef VIRTUAL_SCREEN
	gl_getcontext(&screen);
	gl_setcontextvgavirtual(GRAPHICS_MODE);
#endif
	gl_enableclipping();
	gr_maxx = (gr_width=vga_getxdim())-1;
	gr_maxy = (gr_height=vga_getydim())-1;
	gr_screensize = gr_width * gr_height;
	initfont();
}

void leavegraphics(void)
{
	vga_setmode(TEXT);
}

void setpalette(DacPalette256 *dp)
{
	register int i;

	for(i=0;i<256;i++)
		vga_setpalette(i,(*dp)[i][0],(*dp)[i][1],(*dp)[i][2]);
}

void write_text(int x, int y, char *text)
{
	gl_writen(x,y,strlen(text),text);
}

void _scroll_up(void)
{
	void *buf = alloca(gr_screensize);
	assert(buf);

	gl_getbox(0,25,gr_width,gr_height-25,buf);
	gl_putbox(0,0,gr_width,gr_height-25,buf);
}

void _scroll_down(void)
{
	void *buf = alloca(gr_screensize);
	assert(buf);

	gl_getbox(0,0,gr_width,gr_height-25,buf);
	gl_putbox(0,25,gr_width,gr_height-25,buf);
}

void _scroll_left(void)
{
	void *buf = alloca(gr_screensize);
	assert(buf);

	gl_getbox(32,0,gr_width-32,gr_height,buf);
	gl_putbox(0,0,gr_width-32,gr_height,buf);
}

void _scroll_right(void)
{
	void *buf = alloca(gr_screensize);
	assert(buf);

	gl_getbox(0,0,gr_width-32,gr_height,buf);
	gl_putbox(32,0,gr_width-32,gr_height,buf);
}

void display_image(int x0, int y0, void *buf)
{
	godisplay(buf,x0,y0);
}

void gr_line(int a, int b, int c, int d, int color)
{
	if(b == d)
		gl_hline(a,b,c,color);
	else
		gl_line(a,b,c,d,color);
}

void gr_fillbox(int a, int b, int w, int h, int color)
{
	gl_fillbox(a,b,w,h,color);
}
#endif
