/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types;

import com.izforge.izpack.util.file.types.DataType;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileList
extends DataType {
    private Vector<String> filenames = new Vector();
    private File dir;

    public FileList() {
    }

    protected FileList(FileList filelist) {
        this.dir = filelist.dir;
        this.filenames = filelist.filenames;
    }

    public void setDir(File dir) throws Exception {
        this.dir = dir;
    }

    public File getDir() {
        return this.dir;
    }

    public void setFiles(String filenames) {
        if (filenames != null && filenames.length() > 0) {
            StringTokenizer tok = new StringTokenizer(filenames, ", \t\n\r\f", false);
            while (tok.hasMoreTokens()) {
                this.filenames.addElement(tok.nextToken());
            }
        }
    }

    public String[] getFiles() throws Exception {
        if (this.dir == null) {
            throw new Exception("No directory specified for filelist.");
        }
        if (this.filenames.size() == 0) {
            throw new Exception("No files specified for filelist.");
        }
        Object[] result = new String[this.filenames.size()];
        this.filenames.copyInto(result);
        return result;
    }

    public void addConfiguredFile(FileName name) throws Exception {
        if (name.getName() == null) {
            throw new Exception("No name specified in nested file element");
        }
        this.filenames.addElement(name.getName());
    }

    public static class FileName {
        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

