#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Gethlp (term, option)


***********************************************************
*                                                         *
*  Subroutine Get_Help_File                               *
*                                                         *
*     This routine allows the user to access a file       *
*     containing instructions on a specified option.      *
*     The files which may be accessed explain the         *
*     following options:                                  *
*                                                         *
*    help1 - Overview        help8 -  Tic Marks           *
*    help2 - Terminal Type   help9 -  Labels              *
*    help3 - Data Input      help10 - Color               *
*    help4 - Window          help11 - Shading             *
*    help5 - Plot Type       help12 - Debug               *
*    help6 - Line Type       help13 - What have I done!?  *
*    help7 - Interpolation   help14 - Version 2 mods      *
*                                                         *
***********************************************************



        Integer nlines, I
        Parameter (nlines = 18)

        Character     dummy
        Character*26  name(14)
        Character*80  line
        Integer       term, option, IOerr
        Logical       done

        Data name /'/usr/new/lib/xyplot/help1',
     +             '/usr/new/lib/xyplot/help2',
     +             '/usr/new/lib/xyplot/help3',
     +             '/usr/new/lib/xyplot/help4',
     +             '/usr/new/lib/xyplot/help5',
     +             '/usr/new/lib/xyplot/help6',
     +             '/usr/new/lib/xyplot/help7',
     +             '/usr/new/lib/xyplot/help8',
     +             '/usr/new/lib/xyplot/help9',
     +             '/usr/new/lib/xyplot/help10',
     +             '/usr/new/lib/xyplot/help11',
     +             '/usr/new/lib/xyplot/help12',
     +             '/usr/new/lib/xyplot/help13',
     +             '/usr/new/lib/xyplot/help14'/


        done = .false.

*       (* Open the file to be seen by the user. *)
        Open (unit = 1, file = name(option), status = 'old', 
     +        iostat = IOerr)

        IF (IOerr .NE. 0) THEN
*         (* Disaster!! The help file wasn't found.  *)
          Call clear(term)
          Write (*,10) option
   10     Format (/15x,'Help!',//5x,'Sorry, but help option ',
     +            i2,' does not ',/,5x,'seem to be accessible at ',
     +            'this time!')
        ELSE
          Rewind 1

  100     IF (.NOT. (done)) THEN

    1       Call clear(term)
            DO 200 I = 1, nlines
              Read (1,20,end=300) line
   20         Format (1a75)
              Write (*,30) line
   30         Format (5x,1a75)
  200       Continue

            Write (*,40)
   40       Format (/,5x,'Press <return> to continue or <q> to ',
     +              'quit ...')
            Read (*,'(a1)',err=1) dummy

*           (* Check to see if the user wants to quit. *)
            IF (dummy .EQ. 'Q' .OR. dummy .EQ. 'q') done = .true.
            GOTO 100
          ENDIF
  300     Close (unit=1)
        ENDIF

          IF (.NOT. (done)) THEN
    2       Write (*,50)
   50       Format (/,5x,'Press <return> to continue ...')
            Read (*,'(a1)',err=2) 
          ENDIF

        RETURN
        END
