/* kvx-opc.c -- KVX opcode support.
   Copyright (C) 2009-2025 Free Software Foundation, Inc.
   Contributed by Kalray SA.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include <stddef.h>
#include <stdio.h>
#include "bfd.h"
#include "libbfd.h"
#include <elf/kvx.h>
#include <opcode/kvx.h>

int kvx_kv3_v1_regfiles[] = {
  0, 	/* KVX_REGFILE_FIRST_GPR */
  189, 	/* KVX_REGFILE_LAST_GPR */
  0, 	/* KVX_REGFILE_DEC_GPR */
  190, 	/* KVX_REGFILE_FIRST_PGR */
  253, 	/* KVX_REGFILE_LAST_PGR */
  64, 	/* KVX_REGFILE_DEC_PGR */
  254, 	/* KVX_REGFILE_FIRST_QGR */
  269, 	/* KVX_REGFILE_LAST_QGR */
  96, 	/* KVX_REGFILE_DEC_QGR */
  270, 	/* KVX_REGFILE_FIRST_SFR */
  1293, 	/* KVX_REGFILE_LAST_SFR */
  112, 	/* KVX_REGFILE_DEC_SFR */
  1294, 	/* KVX_REGFILE_FIRST_X16R */
  1297, 	/* KVX_REGFILE_LAST_X16R */
  624, 	/* KVX_REGFILE_DEC_X16R */
  1298, 	/* KVX_REGFILE_FIRST_X2R */
  1329, 	/* KVX_REGFILE_LAST_X2R */
  628, 	/* KVX_REGFILE_DEC_X2R */
  1330, 	/* KVX_REGFILE_FIRST_X32R */
  1331, 	/* KVX_REGFILE_LAST_X32R */
  660, 	/* KVX_REGFILE_DEC_X32R */
  1332, 	/* KVX_REGFILE_FIRST_X4R */
  1347, 	/* KVX_REGFILE_LAST_X4R */
  662, 	/* KVX_REGFILE_DEC_X4R */
  1348, 	/* KVX_REGFILE_FIRST_X64R */
  1348, 	/* KVX_REGFILE_LAST_X64R */
  678, 	/* KVX_REGFILE_DEC_X64R */
  1349, 	/* KVX_REGFILE_FIRST_X8R */
  1356, 	/* KVX_REGFILE_LAST_X8R */
  679, 	/* KVX_REGFILE_DEC_X8R */
  1357, 	/* KVX_REGFILE_FIRST_XBR */
  1612, 	/* KVX_REGFILE_LAST_XBR */
  687, 	/* KVX_REGFILE_DEC_XBR */
  1613, 	/* KVX_REGFILE_FIRST_XCR */
  2124, 	/* KVX_REGFILE_LAST_XCR */
  815, 	/* KVX_REGFILE_DEC_XCR */
  2125, 	/* KVX_REGFILE_FIRST_XMR */
  2140, 	/* KVX_REGFILE_LAST_XMR */
  1071, 	/* KVX_REGFILE_DEC_XMR */
  2141, 	/* KVX_REGFILE_FIRST_XTR */
  2204, 	/* KVX_REGFILE_LAST_XTR */
  1087, 	/* KVX_REGFILE_DEC_XTR */
  2205, 	/* KVX_REGFILE_FIRST_XVR */
  2396, 	/* KVX_REGFILE_LAST_XVR */
  1119, 	/* KVX_REGFILE_DEC_XVR */
  2397, 	/* KVX_REGFILE_REGISTERS*/
  1183, 	/* KVX_REGFILE_DEC_REGISTERS*/
};

struct kvx_Register kvx_kv3_v1_registers[] = {
  { 0, "$r0"}, /* 0 */
  { 0, "$r0r1.lo"}, /* 1 */
  { 0, "$r0r1r2r3.x"}, /* 2 */
  { 1, "$r1"}, /* 3 */
  { 1, "$r0r1.hi"}, /* 4 */
  { 1, "$r0r1r2r3.y"}, /* 5 */
  { 2, "$r2"}, /* 6 */
  { 2, "$r2r3.lo"}, /* 7 */
  { 2, "$r0r1r2r3.z"}, /* 8 */
  { 3, "$r3"}, /* 9 */
  { 3, "$r2r3.hi"}, /* 10 */
  { 3, "$r0r1r2r3.t"}, /* 11 */
  { 4, "$r4"}, /* 12 */
  { 4, "$r4r5.lo"}, /* 13 */
  { 4, "$r4r5r6r7.x"}, /* 14 */
  { 5, "$r5"}, /* 15 */
  { 5, "$r4r5.hi"}, /* 16 */
  { 5, "$r4r5r6r7.y"}, /* 17 */
  { 6, "$r6"}, /* 18 */
  { 6, "$r6r7.lo"}, /* 19 */
  { 6, "$r4r5r6r7.z"}, /* 20 */
  { 7, "$r7"}, /* 21 */
  { 7, "$r6r7.hi"}, /* 22 */
  { 7, "$r4r5r6r7.t"}, /* 23 */
  { 8, "$r8"}, /* 24 */
  { 8, "$r8r9.lo"}, /* 25 */
  { 8, "$r8r9r10r11.x"}, /* 26 */
  { 9, "$r9"}, /* 27 */
  { 9, "$r8r9.hi"}, /* 28 */
  { 9, "$r8r9r10r11.y"}, /* 29 */
  { 10, "$r10"}, /* 30 */
  { 10, "$r10r11.lo"}, /* 31 */
  { 10, "$r8r9r10r11.z"}, /* 32 */
  { 11, "$r11"}, /* 33 */
  { 11, "$r10r11.hi"}, /* 34 */
  { 11, "$r8r9r10r11.t"}, /* 35 */
  { 12, "$r12"}, /* 36 */
  { 12, "$sp"}, /* 37 */
  { 13, "$r13"}, /* 38 */
  { 13, "$tp"}, /* 39 */
  { 14, "$r14"}, /* 40 */
  { 14, "$fp"}, /* 41 */
  { 14, "$r14r15.lo"}, /* 42 */
  { 15, "$r15"}, /* 43 */
  { 15, "$rp"}, /* 44 */
  { 15, "$r14r15.hi"}, /* 45 */
  { 16, "$r16"}, /* 46 */
  { 16, "$r16r17.lo"}, /* 47 */
  { 16, "$r16r17r18r19.x"}, /* 48 */
  { 17, "$r17"}, /* 49 */
  { 17, "$r16r17.hi"}, /* 50 */
  { 17, "$r16r17r18r19.y"}, /* 51 */
  { 18, "$r18"}, /* 52 */
  { 18, "$r18r19.lo"}, /* 53 */
  { 18, "$r16r17r18r19.z"}, /* 54 */
  { 19, "$r19"}, /* 55 */
  { 19, "$r18r19.hi"}, /* 56 */
  { 19, "$r16r17r18r19.t"}, /* 57 */
  { 20, "$r20"}, /* 58 */
  { 20, "$r20r21.lo"}, /* 59 */
  { 20, "$r20r21r22r23.x"}, /* 60 */
  { 21, "$r21"}, /* 61 */
  { 21, "$r20r21.hi"}, /* 62 */
  { 21, "$r20r21r22r23.y"}, /* 63 */
  { 22, "$r22"}, /* 64 */
  { 22, "$r22r23.lo"}, /* 65 */
  { 22, "$r20r21r22r23.z"}, /* 66 */
  { 23, "$r23"}, /* 67 */
  { 23, "$r22r23.hi"}, /* 68 */
  { 23, "$r20r21r22r23.t"}, /* 69 */
  { 24, "$r24"}, /* 70 */
  { 24, "$r24r25.lo"}, /* 71 */
  { 24, "$r24r25r26r27.x"}, /* 72 */
  { 25, "$r25"}, /* 73 */
  { 25, "$r24r25.hi"}, /* 74 */
  { 25, "$r24r25r26r27.y"}, /* 75 */
  { 26, "$r26"}, /* 76 */
  { 26, "$r26r27.lo"}, /* 77 */
  { 26, "$r24r25r26r27.z"}, /* 78 */
  { 27, "$r27"}, /* 79 */
  { 27, "$r26r27.hi"}, /* 80 */
  { 27, "$r24r25r26r27.t"}, /* 81 */
  { 28, "$r28"}, /* 82 */
  { 28, "$r28r29.lo"}, /* 83 */
  { 28, "$r28r29r30r31.x"}, /* 84 */
  { 29, "$r29"}, /* 85 */
  { 29, "$r28r29.hi"}, /* 86 */
  { 29, "$r28r29r30r31.y"}, /* 87 */
  { 30, "$r30"}, /* 88 */
  { 30, "$r30r31.lo"}, /* 89 */
  { 30, "$r28r29r30r31.z"}, /* 90 */
  { 31, "$r31"}, /* 91 */
  { 31, "$r30r31.hi"}, /* 92 */
  { 31, "$r28r29r30r31.t"}, /* 93 */
  { 32, "$r32"}, /* 94 */
  { 32, "$r32r33.lo"}, /* 95 */
  { 32, "$r32r33r34r35.x"}, /* 96 */
  { 33, "$r33"}, /* 97 */
  { 33, "$r32r33.hi"}, /* 98 */
  { 33, "$r32r33r34r35.y"}, /* 99 */
  { 34, "$r34"}, /* 100 */
  { 34, "$r34r35.lo"}, /* 101 */
  { 34, "$r32r33r34r35.z"}, /* 102 */
  { 35, "$r35"}, /* 103 */
  { 35, "$r34r35.hi"}, /* 104 */
  { 35, "$r32r33r34r35.t"}, /* 105 */
  { 36, "$r36"}, /* 106 */
  { 36, "$r36r37.lo"}, /* 107 */
  { 36, "$r36r37r38r39.x"}, /* 108 */
  { 37, "$r37"}, /* 109 */
  { 37, "$r36r37.hi"}, /* 110 */
  { 37, "$r36r37r38r39.y"}, /* 111 */
  { 38, "$r38"}, /* 112 */
  { 38, "$r38r39.lo"}, /* 113 */
  { 38, "$r36r37r38r39.z"}, /* 114 */
  { 39, "$r39"}, /* 115 */
  { 39, "$r38r39.hi"}, /* 116 */
  { 39, "$r36r37r38r39.t"}, /* 117 */
  { 40, "$r40"}, /* 118 */
  { 40, "$r40r41.lo"}, /* 119 */
  { 40, "$r40r41r42r43.x"}, /* 120 */
  { 41, "$r41"}, /* 121 */
  { 41, "$r40r41.hi"}, /* 122 */
  { 41, "$r40r41r42r43.y"}, /* 123 */
  { 42, "$r42"}, /* 124 */
  { 42, "$r42r43.lo"}, /* 125 */
  { 42, "$r40r41r42r43.z"}, /* 126 */
  { 43, "$r43"}, /* 127 */
  { 43, "$r42r43.hi"}, /* 128 */
  { 43, "$r40r41r42r43.t"}, /* 129 */
  { 44, "$r44"}, /* 130 */
  { 44, "$r44r45.lo"}, /* 131 */
  { 44, "$r44r45r46r47.x"}, /* 132 */
  { 45, "$r45"}, /* 133 */
  { 45, "$r44r45.hi"}, /* 134 */
  { 45, "$r44r45r46r47.y"}, /* 135 */
  { 46, "$r46"}, /* 136 */
  { 46, "$r46r47.lo"}, /* 137 */
  { 46, "$r44r45r46r47.z"}, /* 138 */
  { 47, "$r47"}, /* 139 */
  { 47, "$r46r47.hi"}, /* 140 */
  { 47, "$r44r45r46r47.t"}, /* 141 */
  { 48, "$r48"}, /* 142 */
  { 48, "$r48r49.lo"}, /* 143 */
  { 48, "$r48r49r50r51.x"}, /* 144 */
  { 49, "$r49"}, /* 145 */
  { 49, "$r48r49.hi"}, /* 146 */
  { 49, "$r48r49r50r51.y"}, /* 147 */
  { 50, "$r50"}, /* 148 */
  { 50, "$r50r51.lo"}, /* 149 */
  { 50, "$r48r49r50r51.z"}, /* 150 */
  { 51, "$r51"}, /* 151 */
  { 51, "$r50r51.hi"}, /* 152 */
  { 51, "$r48r49r50r51.t"}, /* 153 */
  { 52, "$r52"}, /* 154 */
  { 52, "$r52r53.lo"}, /* 155 */
  { 52, "$r52r53r54r55.x"}, /* 156 */
  { 53, "$r53"}, /* 157 */
  { 53, "$r52r53.hi"}, /* 158 */
  { 53, "$r52r53r54r55.y"}, /* 159 */
  { 54, "$r54"}, /* 160 */
  { 54, "$r54r55.lo"}, /* 161 */
  { 54, "$r52r53r54r55.z"}, /* 162 */
  { 55, "$r55"}, /* 163 */
  { 55, "$r54r55.hi"}, /* 164 */
  { 55, "$r52r53r54r55.t"}, /* 165 */
  { 56, "$r56"}, /* 166 */
  { 56, "$r56r57.lo"}, /* 167 */
  { 56, "$r56r57r58r59.x"}, /* 168 */
  { 57, "$r57"}, /* 169 */
  { 57, "$r56r57.hi"}, /* 170 */
  { 57, "$r56r57r58r59.y"}, /* 171 */
  { 58, "$r58"}, /* 172 */
  { 58, "$r58r59.lo"}, /* 173 */
  { 58, "$r56r57r58r59.z"}, /* 174 */
  { 59, "$r59"}, /* 175 */
  { 59, "$r58r59.hi"}, /* 176 */
  { 59, "$r56r57r58r59.t"}, /* 177 */
  { 60, "$r60"}, /* 178 */
  { 60, "$r60r61.lo"}, /* 179 */
  { 60, "$r60r61r62r63.x"}, /* 180 */
  { 61, "$r61"}, /* 181 */
  { 61, "$r60r61.hi"}, /* 182 */
  { 61, "$r60r61r62r63.y"}, /* 183 */
  { 62, "$r62"}, /* 184 */
  { 62, "$r62r63.lo"}, /* 185 */
  { 62, "$r60r61r62r63.z"}, /* 186 */
  { 63, "$r63"}, /* 187 */
  { 63, "$r62r63.hi"}, /* 188 */
  { 63, "$r60r61r62r63.t"}, /* 189 */
  { 0, "$r0r1"}, /* 190 */
  { 0, "$r0r1r2r3.lo"}, /* 191 */
  { 1, "$r2r3"}, /* 192 */
  { 1, "$r0r1r2r3.hi"}, /* 193 */
  { 2, "$r4r5"}, /* 194 */
  { 2, "$r4r5r6r7.lo"}, /* 195 */
  { 3, "$r6r7"}, /* 196 */
  { 3, "$r4r5r6r7.hi"}, /* 197 */
  { 4, "$r8r9"}, /* 198 */
  { 4, "$r8r9r10r11.lo"}, /* 199 */
  { 5, "$r10r11"}, /* 200 */
  { 5, "$r8r9r10r11.hi"}, /* 201 */
  { 6, "$r12r13"}, /* 202 */
  { 6, "$r12r13r14r15.lo"}, /* 203 */
  { 7, "$r14r15"}, /* 204 */
  { 7, "$r12r13r14r15.hi"}, /* 205 */
  { 8, "$r16r17"}, /* 206 */
  { 8, "$r16r17r18r19.lo"}, /* 207 */
  { 9, "$r18r19"}, /* 208 */
  { 9, "$r16r17r18r19.hi"}, /* 209 */
  { 10, "$r20r21"}, /* 210 */
  { 10, "$r20r21r22r23.lo"}, /* 211 */
  { 11, "$r22r23"}, /* 212 */
  { 11, "$r20r21r22r23.hi"}, /* 213 */
  { 12, "$r24r25"}, /* 214 */
  { 12, "$r24r25r26r27.lo"}, /* 215 */
  { 13, "$r26r27"}, /* 216 */
  { 13, "$r24r25r26r27.hi"}, /* 217 */
  { 14, "$r28r29"}, /* 218 */
  { 14, "$r28r29r30r31.lo"}, /* 219 */
  { 15, "$r30r31"}, /* 220 */
  { 15, "$r28r29r30r31.hi"}, /* 221 */
  { 16, "$r32r33"}, /* 222 */
  { 16, "$r32r33r34r35.lo"}, /* 223 */
  { 17, "$r34r35"}, /* 224 */
  { 17, "$r32r33r34r35.hi"}, /* 225 */
  { 18, "$r36r37"}, /* 226 */
  { 18, "$r36r37r38r39.lo"}, /* 227 */
  { 19, "$r38r39"}, /* 228 */
  { 19, "$r36r37r38r39.hi"}, /* 229 */
  { 20, "$r40r41"}, /* 230 */
  { 20, "$r40r41r42r43.lo"}, /* 231 */
  { 21, "$r42r43"}, /* 232 */
  { 21, "$r40r41r42r43.hi"}, /* 233 */
  { 22, "$r44r45"}, /* 234 */
  { 22, "$r44r45r46r47.lo"}, /* 235 */
  { 23, "$r46r47"}, /* 236 */
  { 23, "$r44r45r46r47.hi"}, /* 237 */
  { 24, "$r48r49"}, /* 238 */
  { 24, "$r48r49r50r51.lo"}, /* 239 */
  { 25, "$r50r51"}, /* 240 */
  { 25, "$r48r49r50r51.hi"}, /* 241 */
  { 26, "$r52r53"}, /* 242 */
  { 26, "$r52r53r54r55.lo"}, /* 243 */
  { 27, "$r54r55"}, /* 244 */
  { 27, "$r52r53r54r55.hi"}, /* 245 */
  { 28, "$r56r57"}, /* 246 */
  { 28, "$r56r57r58r59.lo"}, /* 247 */
  { 29, "$r58r59"}, /* 248 */
  { 29, "$r56r57r58r59.hi"}, /* 249 */
  { 30, "$r60r61"}, /* 250 */
  { 30, "$r60r61r62r63.lo"}, /* 251 */
  { 31, "$r62r63"}, /* 252 */
  { 31, "$r60r61r62r63.hi"}, /* 253 */
  { 0, "$r0r1r2r3"}, /* 254 */
  { 1, "$r4r5r6r7"}, /* 255 */
  { 2, "$r8r9r10r11"}, /* 256 */
  { 3, "$r12r13r14r15"}, /* 257 */
  { 4, "$r16r17r18r19"}, /* 258 */
  { 5, "$r20r21r22r23"}, /* 259 */
  { 6, "$r24r25r26r27"}, /* 260 */
  { 7, "$r28r29r30r31"}, /* 261 */
  { 8, "$r32r33r34r35"}, /* 262 */
  { 9, "$r36r37r38r39"}, /* 263 */
  { 10, "$r40r41r42r43"}, /* 264 */
  { 11, "$r44r45r46r47"}, /* 265 */
  { 12, "$r48r49r50r51"}, /* 266 */
  { 13, "$r52r53r54r55"}, /* 267 */
  { 14, "$r56r57r58r59"}, /* 268 */
  { 15, "$r60r61r62r63"}, /* 269 */
  { 0, "$pc"}, /* 270 */
  { 0, "$s0"}, /* 271 */
  { 1, "$ps"}, /* 272 */
  { 1, "$s1"}, /* 273 */
  { 2, "$pcr"}, /* 274 */
  { 2, "$s2"}, /* 275 */
  { 3, "$ra"}, /* 276 */
  { 3, "$s3"}, /* 277 */
  { 4, "$cs"}, /* 278 */
  { 4, "$s4"}, /* 279 */
  { 5, "$csit"}, /* 280 */
  { 5, "$s5"}, /* 281 */
  { 6, "$aespc"}, /* 282 */
  { 6, "$s6"}, /* 283 */
  { 7, "$ls"}, /* 284 */
  { 7, "$s7"}, /* 285 */
  { 8, "$le"}, /* 286 */
  { 8, "$s8"}, /* 287 */
  { 9, "$lc"}, /* 288 */
  { 9, "$s9"}, /* 289 */
  { 10, "$ipe"}, /* 290 */
  { 10, "$s10"}, /* 291 */
  { 11, "$men"}, /* 292 */
  { 11, "$s11"}, /* 293 */
  { 12, "$pmc"}, /* 294 */
  { 12, "$s12"}, /* 295 */
  { 13, "$pm0"}, /* 296 */
  { 13, "$s13"}, /* 297 */
  { 14, "$pm1"}, /* 298 */
  { 14, "$s14"}, /* 299 */
  { 15, "$pm2"}, /* 300 */
  { 15, "$s15"}, /* 301 */
  { 16, "$pm3"}, /* 302 */
  { 16, "$s16"}, /* 303 */
  { 17, "$pmsa"}, /* 304 */
  { 17, "$s17"}, /* 305 */
  { 18, "$tcr"}, /* 306 */
  { 18, "$s18"}, /* 307 */
  { 19, "$t0v"}, /* 308 */
  { 19, "$s19"}, /* 309 */
  { 20, "$t1v"}, /* 310 */
  { 20, "$s20"}, /* 311 */
  { 21, "$t0r"}, /* 312 */
  { 21, "$s21"}, /* 313 */
  { 22, "$t1r"}, /* 314 */
  { 22, "$s22"}, /* 315 */
  { 23, "$wdv"}, /* 316 */
  { 23, "$s23"}, /* 317 */
  { 24, "$wdr"}, /* 318 */
  { 24, "$s24"}, /* 319 */
  { 25, "$ile"}, /* 320 */
  { 25, "$s25"}, /* 321 */
  { 26, "$ill"}, /* 322 */
  { 26, "$s26"}, /* 323 */
  { 27, "$ilr"}, /* 324 */
  { 27, "$s27"}, /* 325 */
  { 28, "$mmc"}, /* 326 */
  { 28, "$s28"}, /* 327 */
  { 29, "$tel"}, /* 328 */
  { 29, "$s29"}, /* 329 */
  { 30, "$teh"}, /* 330 */
  { 30, "$s30"}, /* 331 */
  { 31, "$ixc"}, /* 332 */
  { 31, "$s31"}, /* 333 */
  { 32, "$syo"}, /* 334 */
  { 32, "$s32"}, /* 335 */
  { 33, "$hto"}, /* 336 */
  { 33, "$s33"}, /* 337 */
  { 34, "$ito"}, /* 338 */
  { 34, "$s34"}, /* 339 */
  { 35, "$do"}, /* 340 */
  { 35, "$s35"}, /* 341 */
  { 36, "$mo"}, /* 342 */
  { 36, "$s36"}, /* 343 */
  { 37, "$pso"}, /* 344 */
  { 37, "$s37"}, /* 345 */
  { 38, "$res38"}, /* 346 */
  { 38, "$s38"}, /* 347 */
  { 39, "$res39"}, /* 348 */
  { 39, "$s39"}, /* 349 */
  { 40, "$dc"}, /* 350 */
  { 40, "$s40"}, /* 351 */
  { 41, "$dba0"}, /* 352 */
  { 41, "$s41"}, /* 353 */
  { 42, "$dba1"}, /* 354 */
  { 42, "$s42"}, /* 355 */
  { 43, "$dwa0"}, /* 356 */
  { 43, "$s43"}, /* 357 */
  { 44, "$dwa1"}, /* 358 */
  { 44, "$s44"}, /* 359 */
  { 45, "$mes"}, /* 360 */
  { 45, "$s45"}, /* 361 */
  { 46, "$ws"}, /* 362 */
  { 46, "$s46"}, /* 363 */
  { 47, "$res47"}, /* 364 */
  { 47, "$s47"}, /* 365 */
  { 48, "$res48"}, /* 366 */
  { 48, "$s48"}, /* 367 */
  { 49, "$res49"}, /* 368 */
  { 49, "$s49"}, /* 369 */
  { 50, "$res50"}, /* 370 */
  { 50, "$s50"}, /* 371 */
  { 51, "$res51"}, /* 372 */
  { 51, "$s51"}, /* 373 */
  { 52, "$res52"}, /* 374 */
  { 52, "$s52"}, /* 375 */
  { 53, "$res53"}, /* 376 */
  { 53, "$s53"}, /* 377 */
  { 54, "$res54"}, /* 378 */
  { 54, "$s54"}, /* 379 */
  { 55, "$res55"}, /* 380 */
  { 55, "$s55"}, /* 381 */
  { 56, "$res56"}, /* 382 */
  { 56, "$s56"}, /* 383 */
  { 57, "$res57"}, /* 384 */
  { 57, "$s57"}, /* 385 */
  { 58, "$res58"}, /* 386 */
  { 58, "$s58"}, /* 387 */
  { 59, "$res59"}, /* 388 */
  { 59, "$s59"}, /* 389 */
  { 60, "$res60"}, /* 390 */
  { 60, "$s60"}, /* 391 */
  { 61, "$res61"}, /* 392 */
  { 61, "$s61"}, /* 393 */
  { 62, "$res62"}, /* 394 */
  { 62, "$s62"}, /* 395 */
  { 63, "$res63"}, /* 396 */
  { 63, "$s63"}, /* 397 */
  { 64, "$spc_pl0"}, /* 398 */
  { 64, "$s64"}, /* 399 */
  { 65, "$spc_pl1"}, /* 400 */
  { 65, "$s65"}, /* 401 */
  { 66, "$spc_pl2"}, /* 402 */
  { 66, "$s66"}, /* 403 */
  { 67, "$spc_pl3"}, /* 404 */
  { 67, "$s67"}, /* 405 */
  { 68, "$sps_pl0"}, /* 406 */
  { 68, "$s68"}, /* 407 */
  { 69, "$sps_pl1"}, /* 408 */
  { 69, "$s69"}, /* 409 */
  { 70, "$sps_pl2"}, /* 410 */
  { 70, "$s70"}, /* 411 */
  { 71, "$sps_pl3"}, /* 412 */
  { 71, "$s71"}, /* 413 */
  { 72, "$ea_pl0"}, /* 414 */
  { 72, "$s72"}, /* 415 */
  { 73, "$ea_pl1"}, /* 416 */
  { 73, "$s73"}, /* 417 */
  { 74, "$ea_pl2"}, /* 418 */
  { 74, "$s74"}, /* 419 */
  { 75, "$ea_pl3"}, /* 420 */
  { 75, "$s75"}, /* 421 */
  { 76, "$ev_pl0"}, /* 422 */
  { 76, "$s76"}, /* 423 */
  { 77, "$ev_pl1"}, /* 424 */
  { 77, "$s77"}, /* 425 */
  { 78, "$ev_pl2"}, /* 426 */
  { 78, "$s78"}, /* 427 */
  { 79, "$ev_pl3"}, /* 428 */
  { 79, "$s79"}, /* 429 */
  { 80, "$sr_pl0"}, /* 430 */
  { 80, "$s80"}, /* 431 */
  { 81, "$sr_pl1"}, /* 432 */
  { 81, "$s81"}, /* 433 */
  { 82, "$sr_pl2"}, /* 434 */
  { 82, "$s82"}, /* 435 */
  { 83, "$sr_pl3"}, /* 436 */
  { 83, "$s83"}, /* 437 */
  { 84, "$es_pl0"}, /* 438 */
  { 84, "$s84"}, /* 439 */
  { 85, "$es_pl1"}, /* 440 */
  { 85, "$s85"}, /* 441 */
  { 86, "$es_pl2"}, /* 442 */
  { 86, "$s86"}, /* 443 */
  { 87, "$es_pl3"}, /* 444 */
  { 87, "$s87"}, /* 445 */
  { 88, "$res88"}, /* 446 */
  { 88, "$s88"}, /* 447 */
  { 89, "$res89"}, /* 448 */
  { 89, "$s89"}, /* 449 */
  { 90, "$res90"}, /* 450 */
  { 90, "$s90"}, /* 451 */
  { 91, "$res91"}, /* 452 */
  { 91, "$s91"}, /* 453 */
  { 92, "$res92"}, /* 454 */
  { 92, "$s92"}, /* 455 */
  { 93, "$res93"}, /* 456 */
  { 93, "$s93"}, /* 457 */
  { 94, "$res94"}, /* 458 */
  { 94, "$s94"}, /* 459 */
  { 95, "$res95"}, /* 460 */
  { 95, "$s95"}, /* 461 */
  { 96, "$syow"}, /* 462 */
  { 96, "$s96"}, /* 463 */
  { 97, "$htow"}, /* 464 */
  { 97, "$s97"}, /* 465 */
  { 98, "$itow"}, /* 466 */
  { 98, "$s98"}, /* 467 */
  { 99, "$dow"}, /* 468 */
  { 99, "$s99"}, /* 469 */
  { 100, "$mow"}, /* 470 */
  { 100, "$s100"}, /* 471 */
  { 101, "$psow"}, /* 472 */
  { 101, "$s101"}, /* 473 */
  { 102, "$res102"}, /* 474 */
  { 102, "$s102"}, /* 475 */
  { 103, "$res103"}, /* 476 */
  { 103, "$s103"}, /* 477 */
  { 104, "$res104"}, /* 478 */
  { 104, "$s104"}, /* 479 */
  { 105, "$res105"}, /* 480 */
  { 105, "$s105"}, /* 481 */
  { 106, "$res106"}, /* 482 */
  { 106, "$s106"}, /* 483 */
  { 107, "$res107"}, /* 484 */
  { 107, "$s107"}, /* 485 */
  { 108, "$res108"}, /* 486 */
  { 108, "$s108"}, /* 487 */
  { 109, "$res109"}, /* 488 */
  { 109, "$s109"}, /* 489 */
  { 110, "$res110"}, /* 490 */
  { 110, "$s110"}, /* 491 */
  { 111, "$res111"}, /* 492 */
  { 111, "$s111"}, /* 493 */
  { 112, "$res112"}, /* 494 */
  { 112, "$s112"}, /* 495 */
  { 113, "$res113"}, /* 496 */
  { 113, "$s113"}, /* 497 */
  { 114, "$res114"}, /* 498 */
  { 114, "$s114"}, /* 499 */
  { 115, "$res115"}, /* 500 */
  { 115, "$s115"}, /* 501 */
  { 116, "$res116"}, /* 502 */
  { 116, "$s116"}, /* 503 */
  { 117, "$res117"}, /* 504 */
  { 117, "$s117"}, /* 505 */
  { 118, "$res118"}, /* 506 */
  { 118, "$s118"}, /* 507 */
  { 119, "$res119"}, /* 508 */
  { 119, "$s119"}, /* 509 */
  { 120, "$res120"}, /* 510 */
  { 120, "$s120"}, /* 511 */
  { 121, "$res121"}, /* 512 */
  { 121, "$s121"}, /* 513 */
  { 122, "$res122"}, /* 514 */
  { 122, "$s122"}, /* 515 */
  { 123, "$res123"}, /* 516 */
  { 123, "$s123"}, /* 517 */
  { 124, "$res124"}, /* 518 */
  { 124, "$s124"}, /* 519 */
  { 125, "$res125"}, /* 520 */
  { 125, "$s125"}, /* 521 */
  { 126, "$res126"}, /* 522 */
  { 126, "$s126"}, /* 523 */
  { 127, "$res127"}, /* 524 */
  { 127, "$s127"}, /* 525 */
  { 128, "$spc"}, /* 526 */
  { 128, "$s128"}, /* 527 */
  { 129, "$res129"}, /* 528 */
  { 129, "$s129"}, /* 529 */
  { 130, "$res130"}, /* 530 */
  { 130, "$s130"}, /* 531 */
  { 131, "$res131"}, /* 532 */
  { 131, "$s131"}, /* 533 */
  { 132, "$sps"}, /* 534 */
  { 132, "$s132"}, /* 535 */
  { 133, "$res133"}, /* 536 */
  { 133, "$s133"}, /* 537 */
  { 134, "$res134"}, /* 538 */
  { 134, "$s134"}, /* 539 */
  { 135, "$res135"}, /* 540 */
  { 135, "$s135"}, /* 541 */
  { 136, "$ea"}, /* 542 */
  { 136, "$s136"}, /* 543 */
  { 137, "$res137"}, /* 544 */
  { 137, "$s137"}, /* 545 */
  { 138, "$res138"}, /* 546 */
  { 138, "$s138"}, /* 547 */
  { 139, "$res139"}, /* 548 */
  { 139, "$s139"}, /* 549 */
  { 140, "$ev"}, /* 550 */
  { 140, "$s140"}, /* 551 */
  { 141, "$res141"}, /* 552 */
  { 141, "$s141"}, /* 553 */
  { 142, "$res142"}, /* 554 */
  { 142, "$s142"}, /* 555 */
  { 143, "$res143"}, /* 556 */
  { 143, "$s143"}, /* 557 */
  { 144, "$sr"}, /* 558 */
  { 144, "$s144"}, /* 559 */
  { 145, "$res145"}, /* 560 */
  { 145, "$s145"}, /* 561 */
  { 146, "$res146"}, /* 562 */
  { 146, "$s146"}, /* 563 */
  { 147, "$res147"}, /* 564 */
  { 147, "$s147"}, /* 565 */
  { 148, "$es"}, /* 566 */
  { 148, "$s148"}, /* 567 */
  { 149, "$res149"}, /* 568 */
  { 149, "$s149"}, /* 569 */
  { 150, "$res150"}, /* 570 */
  { 150, "$s150"}, /* 571 */
  { 151, "$res151"}, /* 572 */
  { 151, "$s151"}, /* 573 */
  { 152, "$res152"}, /* 574 */
  { 152, "$s152"}, /* 575 */
  { 153, "$res153"}, /* 576 */
  { 153, "$s153"}, /* 577 */
  { 154, "$res154"}, /* 578 */
  { 154, "$s154"}, /* 579 */
  { 155, "$res155"}, /* 580 */
  { 155, "$s155"}, /* 581 */
  { 156, "$res156"}, /* 582 */
  { 156, "$s156"}, /* 583 */
  { 157, "$res157"}, /* 584 */
  { 157, "$s157"}, /* 585 */
  { 158, "$res158"}, /* 586 */
  { 158, "$s158"}, /* 587 */
  { 159, "$res159"}, /* 588 */
  { 159, "$s159"}, /* 589 */
  { 160, "$res160"}, /* 590 */
  { 160, "$s160"}, /* 591 */
  { 161, "$res161"}, /* 592 */
  { 161, "$s161"}, /* 593 */
  { 162, "$res162"}, /* 594 */
  { 162, "$s162"}, /* 595 */
  { 163, "$res163"}, /* 596 */
  { 163, "$s163"}, /* 597 */
  { 164, "$res164"}, /* 598 */
  { 164, "$s164"}, /* 599 */
  { 165, "$res165"}, /* 600 */
  { 165, "$s165"}, /* 601 */
  { 166, "$res166"}, /* 602 */
  { 166, "$s166"}, /* 603 */
  { 167, "$res167"}, /* 604 */
  { 167, "$s167"}, /* 605 */
  { 168, "$res168"}, /* 606 */
  { 168, "$s168"}, /* 607 */
  { 169, "$res169"}, /* 608 */
  { 169, "$s169"}, /* 609 */
  { 170, "$res170"}, /* 610 */
  { 170, "$s170"}, /* 611 */
  { 171, "$res171"}, /* 612 */
  { 171, "$s171"}, /* 613 */
  { 172, "$res172"}, /* 614 */
  { 172, "$s172"}, /* 615 */
  { 173, "$res173"}, /* 616 */
  { 173, "$s173"}, /* 617 */
  { 174, "$res174"}, /* 618 */
  { 174, "$s174"}, /* 619 */
  { 175, "$res175"}, /* 620 */
  { 175, "$s175"}, /* 621 */
  { 176, "$res176"}, /* 622 */
  { 176, "$s176"}, /* 623 */
  { 177, "$res177"}, /* 624 */
  { 177, "$s177"}, /* 625 */
  { 178, "$res178"}, /* 626 */
  { 178, "$s178"}, /* 627 */
  { 179, "$res179"}, /* 628 */
  { 179, "$s179"}, /* 629 */
  { 180, "$res180"}, /* 630 */
  { 180, "$s180"}, /* 631 */
  { 181, "$res181"}, /* 632 */
  { 181, "$s181"}, /* 633 */
  { 182, "$res182"}, /* 634 */
  { 182, "$s182"}, /* 635 */
  { 183, "$res183"}, /* 636 */
  { 183, "$s183"}, /* 637 */
  { 184, "$res184"}, /* 638 */
  { 184, "$s184"}, /* 639 */
  { 185, "$res185"}, /* 640 */
  { 185, "$s185"}, /* 641 */
  { 186, "$res186"}, /* 642 */
  { 186, "$s186"}, /* 643 */
  { 187, "$res187"}, /* 644 */
  { 187, "$s187"}, /* 645 */
  { 188, "$res188"}, /* 646 */
  { 188, "$s188"}, /* 647 */
  { 189, "$res189"}, /* 648 */
  { 189, "$s189"}, /* 649 */
  { 190, "$res190"}, /* 650 */
  { 190, "$s190"}, /* 651 */
  { 191, "$res191"}, /* 652 */
  { 191, "$s191"}, /* 653 */
  { 192, "$res192"}, /* 654 */
  { 192, "$s192"}, /* 655 */
  { 193, "$res193"}, /* 656 */
  { 193, "$s193"}, /* 657 */
  { 194, "$res194"}, /* 658 */
  { 194, "$s194"}, /* 659 */
  { 195, "$res195"}, /* 660 */
  { 195, "$s195"}, /* 661 */
  { 196, "$res196"}, /* 662 */
  { 196, "$s196"}, /* 663 */
  { 197, "$res197"}, /* 664 */
  { 197, "$s197"}, /* 665 */
  { 198, "$res198"}, /* 666 */
  { 198, "$s198"}, /* 667 */
  { 199, "$res199"}, /* 668 */
  { 199, "$s199"}, /* 669 */
  { 200, "$res200"}, /* 670 */
  { 200, "$s200"}, /* 671 */
  { 201, "$res201"}, /* 672 */
  { 201, "$s201"}, /* 673 */
  { 202, "$res202"}, /* 674 */
  { 202, "$s202"}, /* 675 */
  { 203, "$res203"}, /* 676 */
  { 203, "$s203"}, /* 677 */
  { 204, "$res204"}, /* 678 */
  { 204, "$s204"}, /* 679 */
  { 205, "$res205"}, /* 680 */
  { 205, "$s205"}, /* 681 */
  { 206, "$res206"}, /* 682 */
  { 206, "$s206"}, /* 683 */
  { 207, "$res207"}, /* 684 */
  { 207, "$s207"}, /* 685 */
  { 208, "$res208"}, /* 686 */
  { 208, "$s208"}, /* 687 */
  { 209, "$res209"}, /* 688 */
  { 209, "$s209"}, /* 689 */
  { 210, "$res210"}, /* 690 */
  { 210, "$s210"}, /* 691 */
  { 211, "$res211"}, /* 692 */
  { 211, "$s211"}, /* 693 */
  { 212, "$res212"}, /* 694 */
  { 212, "$s212"}, /* 695 */
  { 213, "$res213"}, /* 696 */
  { 213, "$s213"}, /* 697 */
  { 214, "$res214"}, /* 698 */
  { 214, "$s214"}, /* 699 */
  { 215, "$res215"}, /* 700 */
  { 215, "$s215"}, /* 701 */
  { 216, "$res216"}, /* 702 */
  { 216, "$s216"}, /* 703 */
  { 217, "$res217"}, /* 704 */
  { 217, "$s217"}, /* 705 */
  { 218, "$res218"}, /* 706 */
  { 218, "$s218"}, /* 707 */
  { 219, "$res219"}, /* 708 */
  { 219, "$s219"}, /* 709 */
  { 220, "$res220"}, /* 710 */
  { 220, "$s220"}, /* 711 */
  { 221, "$res221"}, /* 712 */
  { 221, "$s221"}, /* 713 */
  { 222, "$res222"}, /* 714 */
  { 222, "$s222"}, /* 715 */
  { 223, "$res223"}, /* 716 */
  { 223, "$s223"}, /* 717 */
  { 224, "$res224"}, /* 718 */
  { 224, "$s224"}, /* 719 */
  { 225, "$res225"}, /* 720 */
  { 225, "$s225"}, /* 721 */
  { 226, "$res226"}, /* 722 */
  { 226, "$s226"}, /* 723 */
  { 227, "$res227"}, /* 724 */
  { 227, "$s227"}, /* 725 */
  { 228, "$res228"}, /* 726 */
  { 228, "$s228"}, /* 727 */
  { 229, "$res229"}, /* 728 */
  { 229, "$s229"}, /* 729 */
  { 230, "$res230"}, /* 730 */
  { 230, "$s230"}, /* 731 */
  { 231, "$res231"}, /* 732 */
  { 231, "$s231"}, /* 733 */
  { 232, "$res232"}, /* 734 */
  { 232, "$s232"}, /* 735 */
  { 233, "$res233"}, /* 736 */
  { 233, "$s233"}, /* 737 */
  { 234, "$res234"}, /* 738 */
  { 234, "$s234"}, /* 739 */
  { 235, "$res235"}, /* 740 */
  { 235, "$s235"}, /* 741 */
  { 236, "$res236"}, /* 742 */
  { 236, "$s236"}, /* 743 */
  { 237, "$res237"}, /* 744 */
  { 237, "$s237"}, /* 745 */
  { 238, "$res238"}, /* 746 */
  { 238, "$s238"}, /* 747 */
  { 239, "$res239"}, /* 748 */
  { 239, "$s239"}, /* 749 */
  { 240, "$res240"}, /* 750 */
  { 240, "$s240"}, /* 751 */
  { 241, "$res241"}, /* 752 */
  { 241, "$s241"}, /* 753 */
  { 242, "$res242"}, /* 754 */
  { 242, "$s242"}, /* 755 */
  { 243, "$res243"}, /* 756 */
  { 243, "$s243"}, /* 757 */
  { 244, "$res244"}, /* 758 */
  { 244, "$s244"}, /* 759 */
  { 245, "$res245"}, /* 760 */
  { 245, "$s245"}, /* 761 */
  { 246, "$res246"}, /* 762 */
  { 246, "$s246"}, /* 763 */
  { 247, "$res247"}, /* 764 */
  { 247, "$s247"}, /* 765 */
  { 248, "$res248"}, /* 766 */
  { 248, "$s248"}, /* 767 */
  { 249, "$res249"}, /* 768 */
  { 249, "$s249"}, /* 769 */
  { 250, "$res250"}, /* 770 */
  { 250, "$s250"}, /* 771 */
  { 251, "$res251"}, /* 772 */
  { 251, "$s251"}, /* 773 */
  { 252, "$res252"}, /* 774 */
  { 252, "$s252"}, /* 775 */
  { 253, "$res253"}, /* 776 */
  { 253, "$s253"}, /* 777 */
  { 254, "$res254"}, /* 778 */
  { 254, "$s254"}, /* 779 */
  { 255, "$res255"}, /* 780 */
  { 255, "$s255"}, /* 781 */
  { 256, "$vsfr0"}, /* 782 */
  { 256, "$s256"}, /* 783 */
  { 257, "$vsfr1"}, /* 784 */
  { 257, "$s257"}, /* 785 */
  { 258, "$vsfr2"}, /* 786 */
  { 258, "$s258"}, /* 787 */
  { 259, "$vsfr3"}, /* 788 */
  { 259, "$s259"}, /* 789 */
  { 260, "$vsfr4"}, /* 790 */
  { 260, "$s260"}, /* 791 */
  { 261, "$vsfr5"}, /* 792 */
  { 261, "$s261"}, /* 793 */
  { 262, "$vsfr6"}, /* 794 */
  { 262, "$s262"}, /* 795 */
  { 263, "$vsfr7"}, /* 796 */
  { 263, "$s263"}, /* 797 */
  { 264, "$vsfr8"}, /* 798 */
  { 264, "$s264"}, /* 799 */
  { 265, "$vsfr9"}, /* 800 */
  { 265, "$s265"}, /* 801 */
  { 266, "$vsfr10"}, /* 802 */
  { 266, "$s266"}, /* 803 */
  { 267, "$vsfr11"}, /* 804 */
  { 267, "$s267"}, /* 805 */
  { 268, "$vsfr12"}, /* 806 */
  { 268, "$s268"}, /* 807 */
  { 269, "$vsfr13"}, /* 808 */
  { 269, "$s269"}, /* 809 */
  { 270, "$vsfr14"}, /* 810 */
  { 270, "$s270"}, /* 811 */
  { 271, "$vsfr15"}, /* 812 */
  { 271, "$s271"}, /* 813 */
  { 272, "$vsfr16"}, /* 814 */
  { 272, "$s272"}, /* 815 */
  { 273, "$vsfr17"}, /* 816 */
  { 273, "$s273"}, /* 817 */
  { 274, "$vsfr18"}, /* 818 */
  { 274, "$s274"}, /* 819 */
  { 275, "$vsfr19"}, /* 820 */
  { 275, "$s275"}, /* 821 */
  { 276, "$vsfr20"}, /* 822 */
  { 276, "$s276"}, /* 823 */
  { 277, "$vsfr21"}, /* 824 */
  { 277, "$s277"}, /* 825 */
  { 278, "$vsfr22"}, /* 826 */
  { 278, "$s278"}, /* 827 */
  { 279, "$vsfr23"}, /* 828 */
  { 279, "$s279"}, /* 829 */
  { 280, "$vsfr24"}, /* 830 */
  { 280, "$s280"}, /* 831 */
  { 281, "$vsfr25"}, /* 832 */
  { 281, "$s281"}, /* 833 */
  { 282, "$vsfr26"}, /* 834 */
  { 282, "$s282"}, /* 835 */
  { 283, "$vsfr27"}, /* 836 */
  { 283, "$s283"}, /* 837 */
  { 284, "$vsfr28"}, /* 838 */
  { 284, "$s284"}, /* 839 */
  { 285, "$vsfr29"}, /* 840 */
  { 285, "$s285"}, /* 841 */
  { 286, "$vsfr30"}, /* 842 */
  { 286, "$s286"}, /* 843 */
  { 287, "$vsfr31"}, /* 844 */
  { 287, "$s287"}, /* 845 */
  { 288, "$vsfr32"}, /* 846 */
  { 288, "$s288"}, /* 847 */
  { 289, "$vsfr33"}, /* 848 */
  { 289, "$s289"}, /* 849 */
  { 290, "$vsfr34"}, /* 850 */
  { 290, "$s290"}, /* 851 */
  { 291, "$vsfr35"}, /* 852 */
  { 291, "$s291"}, /* 853 */
  { 292, "$vsfr36"}, /* 854 */
  { 292, "$s292"}, /* 855 */
  { 293, "$vsfr37"}, /* 856 */
  { 293, "$s293"}, /* 857 */
  { 294, "$vsfr38"}, /* 858 */
  { 294, "$s294"}, /* 859 */
  { 295, "$vsfr39"}, /* 860 */
  { 295, "$s295"}, /* 861 */
  { 296, "$vsfr40"}, /* 862 */
  { 296, "$s296"}, /* 863 */
  { 297, "$vsfr41"}, /* 864 */
  { 297, "$s297"}, /* 865 */
  { 298, "$vsfr42"}, /* 866 */
  { 298, "$s298"}, /* 867 */
  { 299, "$vsfr43"}, /* 868 */
  { 299, "$s299"}, /* 869 */
  { 300, "$vsfr44"}, /* 870 */
  { 300, "$s300"}, /* 871 */
  { 301, "$vsfr45"}, /* 872 */
  { 301, "$s301"}, /* 873 */
  { 302, "$vsfr46"}, /* 874 */
  { 302, "$s302"}, /* 875 */
  { 303, "$vsfr47"}, /* 876 */
  { 303, "$s303"}, /* 877 */
  { 304, "$vsfr48"}, /* 878 */
  { 304, "$s304"}, /* 879 */
  { 305, "$vsfr49"}, /* 880 */
  { 305, "$s305"}, /* 881 */
  { 306, "$vsfr50"}, /* 882 */
  { 306, "$s306"}, /* 883 */
  { 307, "$vsfr51"}, /* 884 */
  { 307, "$s307"}, /* 885 */
  { 308, "$vsfr52"}, /* 886 */
  { 308, "$s308"}, /* 887 */
  { 309, "$vsfr53"}, /* 888 */
  { 309, "$s309"}, /* 889 */
  { 310, "$vsfr54"}, /* 890 */
  { 310, "$s310"}, /* 891 */
  { 311, "$vsfr55"}, /* 892 */
  { 311, "$s311"}, /* 893 */
  { 312, "$vsfr56"}, /* 894 */
  { 312, "$s312"}, /* 895 */
  { 313, "$vsfr57"}, /* 896 */
  { 313, "$s313"}, /* 897 */
  { 314, "$vsfr58"}, /* 898 */
  { 314, "$s314"}, /* 899 */
  { 315, "$vsfr59"}, /* 900 */
  { 315, "$s315"}, /* 901 */
  { 316, "$vsfr60"}, /* 902 */
  { 316, "$s316"}, /* 903 */
  { 317, "$vsfr61"}, /* 904 */
  { 317, "$s317"}, /* 905 */
  { 318, "$vsfr62"}, /* 906 */
  { 318, "$s318"}, /* 907 */
  { 319, "$vsfr63"}, /* 908 */
  { 319, "$s319"}, /* 909 */
  { 320, "$vsfr64"}, /* 910 */
  { 320, "$s320"}, /* 911 */
  { 321, "$vsfr65"}, /* 912 */
  { 321, "$s321"}, /* 913 */
  { 322, "$vsfr66"}, /* 914 */
  { 322, "$s322"}, /* 915 */
  { 323, "$vsfr67"}, /* 916 */
  { 323, "$s323"}, /* 917 */
  { 324, "$vsfr68"}, /* 918 */
  { 324, "$s324"}, /* 919 */
  { 325, "$vsfr69"}, /* 920 */
  { 325, "$s325"}, /* 921 */
  { 326, "$vsfr70"}, /* 922 */
  { 326, "$s326"}, /* 923 */
  { 327, "$vsfr71"}, /* 924 */
  { 327, "$s327"}, /* 925 */
  { 328, "$vsfr72"}, /* 926 */
  { 328, "$s328"}, /* 927 */
  { 329, "$vsfr73"}, /* 928 */
  { 329, "$s329"}, /* 929 */
  { 330, "$vsfr74"}, /* 930 */
  { 330, "$s330"}, /* 931 */
  { 331, "$vsfr75"}, /* 932 */
  { 331, "$s331"}, /* 933 */
  { 332, "$vsfr76"}, /* 934 */
  { 332, "$s332"}, /* 935 */
  { 333, "$vsfr77"}, /* 936 */
  { 333, "$s333"}, /* 937 */
  { 334, "$vsfr78"}, /* 938 */
  { 334, "$s334"}, /* 939 */
  { 335, "$vsfr79"}, /* 940 */
  { 335, "$s335"}, /* 941 */
  { 336, "$vsfr80"}, /* 942 */
  { 336, "$s336"}, /* 943 */
  { 337, "$vsfr81"}, /* 944 */
  { 337, "$s337"}, /* 945 */
  { 338, "$vsfr82"}, /* 946 */
  { 338, "$s338"}, /* 947 */
  { 339, "$vsfr83"}, /* 948 */
  { 339, "$s339"}, /* 949 */
  { 340, "$vsfr84"}, /* 950 */
  { 340, "$s340"}, /* 951 */
  { 341, "$vsfr85"}, /* 952 */
  { 341, "$s341"}, /* 953 */
  { 342, "$vsfr86"}, /* 954 */
  { 342, "$s342"}, /* 955 */
  { 343, "$vsfr87"}, /* 956 */
  { 343, "$s343"}, /* 957 */
  { 344, "$vsfr88"}, /* 958 */
  { 344, "$s344"}, /* 959 */
  { 345, "$vsfr89"}, /* 960 */
  { 345, "$s345"}, /* 961 */
  { 346, "$vsfr90"}, /* 962 */
  { 346, "$s346"}, /* 963 */
  { 347, "$vsfr91"}, /* 964 */
  { 347, "$s347"}, /* 965 */
  { 348, "$vsfr92"}, /* 966 */
  { 348, "$s348"}, /* 967 */
  { 349, "$vsfr93"}, /* 968 */
  { 349, "$s349"}, /* 969 */
  { 350, "$vsfr94"}, /* 970 */
  { 350, "$s350"}, /* 971 */
  { 351, "$vsfr95"}, /* 972 */
  { 351, "$s351"}, /* 973 */
  { 352, "$vsfr96"}, /* 974 */
  { 352, "$s352"}, /* 975 */
  { 353, "$vsfr97"}, /* 976 */
  { 353, "$s353"}, /* 977 */
  { 354, "$vsfr98"}, /* 978 */
  { 354, "$s354"}, /* 979 */
  { 355, "$vsfr99"}, /* 980 */
  { 355, "$s355"}, /* 981 */
  { 356, "$vsfr100"}, /* 982 */
  { 356, "$s356"}, /* 983 */
  { 357, "$vsfr101"}, /* 984 */
  { 357, "$s357"}, /* 985 */
  { 358, "$vsfr102"}, /* 986 */
  { 358, "$s358"}, /* 987 */
  { 359, "$vsfr103"}, /* 988 */
  { 359, "$s359"}, /* 989 */
  { 360, "$vsfr104"}, /* 990 */
  { 360, "$s360"}, /* 991 */
  { 361, "$vsfr105"}, /* 992 */
  { 361, "$s361"}, /* 993 */
  { 362, "$vsfr106"}, /* 994 */
  { 362, "$s362"}, /* 995 */
  { 363, "$vsfr107"}, /* 996 */
  { 363, "$s363"}, /* 997 */
  { 364, "$vsfr108"}, /* 998 */
  { 364, "$s364"}, /* 999 */
  { 365, "$vsfr109"}, /* 1000 */
  { 365, "$s365"}, /* 1001 */
  { 366, "$vsfr110"}, /* 1002 */
  { 366, "$s366"}, /* 1003 */
  { 367, "$vsfr111"}, /* 1004 */
  { 367, "$s367"}, /* 1005 */
  { 368, "$vsfr112"}, /* 1006 */
  { 368, "$s368"}, /* 1007 */
  { 369, "$vsfr113"}, /* 1008 */
  { 369, "$s369"}, /* 1009 */
  { 370, "$vsfr114"}, /* 1010 */
  { 370, "$s370"}, /* 1011 */
  { 371, "$vsfr115"}, /* 1012 */
  { 371, "$s371"}, /* 1013 */
  { 372, "$vsfr116"}, /* 1014 */
  { 372, "$s372"}, /* 1015 */
  { 373, "$vsfr117"}, /* 1016 */
  { 373, "$s373"}, /* 1017 */
  { 374, "$vsfr118"}, /* 1018 */
  { 374, "$s374"}, /* 1019 */
  { 375, "$vsfr119"}, /* 1020 */
  { 375, "$s375"}, /* 1021 */
  { 376, "$vsfr120"}, /* 1022 */
  { 376, "$s376"}, /* 1023 */
  { 377, "$vsfr121"}, /* 1024 */
  { 377, "$s377"}, /* 1025 */
  { 378, "$vsfr122"}, /* 1026 */
  { 378, "$s378"}, /* 1027 */
  { 379, "$vsfr123"}, /* 1028 */
  { 379, "$s379"}, /* 1029 */
  { 380, "$vsfr124"}, /* 1030 */
  { 380, "$s380"}, /* 1031 */
  { 381, "$vsfr125"}, /* 1032 */
  { 381, "$s381"}, /* 1033 */
  { 382, "$vsfr126"}, /* 1034 */
  { 382, "$s382"}, /* 1035 */
  { 383, "$vsfr127"}, /* 1036 */
  { 383, "$s383"}, /* 1037 */
  { 384, "$vsfr128"}, /* 1038 */
  { 384, "$s384"}, /* 1039 */
  { 385, "$vsfr129"}, /* 1040 */
  { 385, "$s385"}, /* 1041 */
  { 386, "$vsfr130"}, /* 1042 */
  { 386, "$s386"}, /* 1043 */
  { 387, "$vsfr131"}, /* 1044 */
  { 387, "$s387"}, /* 1045 */
  { 388, "$vsfr132"}, /* 1046 */
  { 388, "$s388"}, /* 1047 */
  { 389, "$vsfr133"}, /* 1048 */
  { 389, "$s389"}, /* 1049 */
  { 390, "$vsfr134"}, /* 1050 */
  { 390, "$s390"}, /* 1051 */
  { 391, "$vsfr135"}, /* 1052 */
  { 391, "$s391"}, /* 1053 */
  { 392, "$vsfr136"}, /* 1054 */
  { 392, "$s392"}, /* 1055 */
  { 393, "$vsfr137"}, /* 1056 */
  { 393, "$s393"}, /* 1057 */
  { 394, "$vsfr138"}, /* 1058 */
  { 394, "$s394"}, /* 1059 */
  { 395, "$vsfr139"}, /* 1060 */
  { 395, "$s395"}, /* 1061 */
  { 396, "$vsfr140"}, /* 1062 */
  { 396, "$s396"}, /* 1063 */
  { 397, "$vsfr141"}, /* 1064 */
  { 397, "$s397"}, /* 1065 */
  { 398, "$vsfr142"}, /* 1066 */
  { 398, "$s398"}, /* 1067 */
  { 399, "$vsfr143"}, /* 1068 */
  { 399, "$s399"}, /* 1069 */
  { 400, "$vsfr144"}, /* 1070 */
  { 400, "$s400"}, /* 1071 */
  { 401, "$vsfr145"}, /* 1072 */
  { 401, "$s401"}, /* 1073 */
  { 402, "$vsfr146"}, /* 1074 */
  { 402, "$s402"}, /* 1075 */
  { 403, "$vsfr147"}, /* 1076 */
  { 403, "$s403"}, /* 1077 */
  { 404, "$vsfr148"}, /* 1078 */
  { 404, "$s404"}, /* 1079 */
  { 405, "$vsfr149"}, /* 1080 */
  { 405, "$s405"}, /* 1081 */
  { 406, "$vsfr150"}, /* 1082 */
  { 406, "$s406"}, /* 1083 */
  { 407, "$vsfr151"}, /* 1084 */
  { 407, "$s407"}, /* 1085 */
  { 408, "$vsfr152"}, /* 1086 */
  { 408, "$s408"}, /* 1087 */
  { 409, "$vsfr153"}, /* 1088 */
  { 409, "$s409"}, /* 1089 */
  { 410, "$vsfr154"}, /* 1090 */
  { 410, "$s410"}, /* 1091 */
  { 411, "$vsfr155"}, /* 1092 */
  { 411, "$s411"}, /* 1093 */
  { 412, "$vsfr156"}, /* 1094 */
  { 412, "$s412"}, /* 1095 */
  { 413, "$vsfr157"}, /* 1096 */
  { 413, "$s413"}, /* 1097 */
  { 414, "$vsfr158"}, /* 1098 */
  { 414, "$s414"}, /* 1099 */
  { 415, "$vsfr159"}, /* 1100 */
  { 415, "$s415"}, /* 1101 */
  { 416, "$vsfr160"}, /* 1102 */
  { 416, "$s416"}, /* 1103 */
  { 417, "$vsfr161"}, /* 1104 */
  { 417, "$s417"}, /* 1105 */
  { 418, "$vsfr162"}, /* 1106 */
  { 418, "$s418"}, /* 1107 */
  { 419, "$vsfr163"}, /* 1108 */
  { 419, "$s419"}, /* 1109 */
  { 420, "$vsfr164"}, /* 1110 */
  { 420, "$s420"}, /* 1111 */
  { 421, "$vsfr165"}, /* 1112 */
  { 421, "$s421"}, /* 1113 */
  { 422, "$vsfr166"}, /* 1114 */
  { 422, "$s422"}, /* 1115 */
  { 423, "$vsfr167"}, /* 1116 */
  { 423, "$s423"}, /* 1117 */
  { 424, "$vsfr168"}, /* 1118 */
  { 424, "$s424"}, /* 1119 */
  { 425, "$vsfr169"}, /* 1120 */
  { 425, "$s425"}, /* 1121 */
  { 426, "$vsfr170"}, /* 1122 */
  { 426, "$s426"}, /* 1123 */
  { 427, "$vsfr171"}, /* 1124 */
  { 427, "$s427"}, /* 1125 */
  { 428, "$vsfr172"}, /* 1126 */
  { 428, "$s428"}, /* 1127 */
  { 429, "$vsfr173"}, /* 1128 */
  { 429, "$s429"}, /* 1129 */
  { 430, "$vsfr174"}, /* 1130 */
  { 430, "$s430"}, /* 1131 */
  { 431, "$vsfr175"}, /* 1132 */
  { 431, "$s431"}, /* 1133 */
  { 432, "$vsfr176"}, /* 1134 */
  { 432, "$s432"}, /* 1135 */
  { 433, "$vsfr177"}, /* 1136 */
  { 433, "$s433"}, /* 1137 */
  { 434, "$vsfr178"}, /* 1138 */
  { 434, "$s434"}, /* 1139 */
  { 435, "$vsfr179"}, /* 1140 */
  { 435, "$s435"}, /* 1141 */
  { 436, "$vsfr180"}, /* 1142 */
  { 436, "$s436"}, /* 1143 */
  { 437, "$vsfr181"}, /* 1144 */
  { 437, "$s437"}, /* 1145 */
  { 438, "$vsfr182"}, /* 1146 */
  { 438, "$s438"}, /* 1147 */
  { 439, "$vsfr183"}, /* 1148 */
  { 439, "$s439"}, /* 1149 */
  { 440, "$vsfr184"}, /* 1150 */
  { 440, "$s440"}, /* 1151 */
  { 441, "$vsfr185"}, /* 1152 */
  { 441, "$s441"}, /* 1153 */
  { 442, "$vsfr186"}, /* 1154 */
  { 442, "$s442"}, /* 1155 */
  { 443, "$vsfr187"}, /* 1156 */
  { 443, "$s443"}, /* 1157 */
  { 444, "$vsfr188"}, /* 1158 */
  { 444, "$s444"}, /* 1159 */
  { 445, "$vsfr189"}, /* 1160 */
  { 445, "$s445"}, /* 1161 */
  { 446, "$vsfr190"}, /* 1162 */
  { 446, "$s446"}, /* 1163 */
  { 447, "$vsfr191"}, /* 1164 */
  { 447, "$s447"}, /* 1165 */
  { 448, "$vsfr192"}, /* 1166 */
  { 448, "$s448"}, /* 1167 */
  { 449, "$vsfr193"}, /* 1168 */
  { 449, "$s449"}, /* 1169 */
  { 450, "$vsfr194"}, /* 1170 */
  { 450, "$s450"}, /* 1171 */
  { 451, "$vsfr195"}, /* 1172 */
  { 451, "$s451"}, /* 1173 */
  { 452, "$vsfr196"}, /* 1174 */
  { 452, "$s452"}, /* 1175 */
  { 453, "$vsfr197"}, /* 1176 */
  { 453, "$s453"}, /* 1177 */
  { 454, "$vsfr198"}, /* 1178 */
  { 454, "$s454"}, /* 1179 */
  { 455, "$vsfr199"}, /* 1180 */
  { 455, "$s455"}, /* 1181 */
  { 456, "$vsfr200"}, /* 1182 */
  { 456, "$s456"}, /* 1183 */
  { 457, "$vsfr201"}, /* 1184 */
  { 457, "$s457"}, /* 1185 */
  { 458, "$vsfr202"}, /* 1186 */
  { 458, "$s458"}, /* 1187 */
  { 459, "$vsfr203"}, /* 1188 */
  { 459, "$s459"}, /* 1189 */
  { 460, "$vsfr204"}, /* 1190 */
  { 460, "$s460"}, /* 1191 */
  { 461, "$vsfr205"}, /* 1192 */
  { 461, "$s461"}, /* 1193 */
  { 462, "$vsfr206"}, /* 1194 */
  { 462, "$s462"}, /* 1195 */
  { 463, "$vsfr207"}, /* 1196 */
  { 463, "$s463"}, /* 1197 */
  { 464, "$vsfr208"}, /* 1198 */
  { 464, "$s464"}, /* 1199 */
  { 465, "$vsfr209"}, /* 1200 */
  { 465, "$s465"}, /* 1201 */
  { 466, "$vsfr210"}, /* 1202 */
  { 466, "$s466"}, /* 1203 */
  { 467, "$vsfr211"}, /* 1204 */
  { 467, "$s467"}, /* 1205 */
  { 468, "$vsfr212"}, /* 1206 */
  { 468, "$s468"}, /* 1207 */
  { 469, "$vsfr213"}, /* 1208 */
  { 469, "$s469"}, /* 1209 */
  { 470, "$vsfr214"}, /* 1210 */
  { 470, "$s470"}, /* 1211 */
  { 471, "$vsfr215"}, /* 1212 */
  { 471, "$s471"}, /* 1213 */
  { 472, "$vsfr216"}, /* 1214 */
  { 472, "$s472"}, /* 1215 */
  { 473, "$vsfr217"}, /* 1216 */
  { 473, "$s473"}, /* 1217 */
  { 474, "$vsfr218"}, /* 1218 */
  { 474, "$s474"}, /* 1219 */
  { 475, "$vsfr219"}, /* 1220 */
  { 475, "$s475"}, /* 1221 */
  { 476, "$vsfr220"}, /* 1222 */
  { 476, "$s476"}, /* 1223 */
  { 477, "$vsfr221"}, /* 1224 */
  { 477, "$s477"}, /* 1225 */
  { 478, "$vsfr222"}, /* 1226 */
  { 478, "$s478"}, /* 1227 */
  { 479, "$vsfr223"}, /* 1228 */
  { 479, "$s479"}, /* 1229 */
  { 480, "$vsfr224"}, /* 1230 */
  { 480, "$s480"}, /* 1231 */
  { 481, "$vsfr225"}, /* 1232 */
  { 481, "$s481"}, /* 1233 */
  { 482, "$vsfr226"}, /* 1234 */
  { 482, "$s482"}, /* 1235 */
  { 483, "$vsfr227"}, /* 1236 */
  { 483, "$s483"}, /* 1237 */
  { 484, "$vsfr228"}, /* 1238 */
  { 484, "$s484"}, /* 1239 */
  { 485, "$vsfr229"}, /* 1240 */
  { 485, "$s485"}, /* 1241 */
  { 486, "$vsfr230"}, /* 1242 */
  { 486, "$s486"}, /* 1243 */
  { 487, "$vsfr231"}, /* 1244 */
  { 487, "$s487"}, /* 1245 */
  { 488, "$vsfr232"}, /* 1246 */
  { 488, "$s488"}, /* 1247 */
  { 489, "$vsfr233"}, /* 1248 */
  { 489, "$s489"}, /* 1249 */
  { 490, "$vsfr234"}, /* 1250 */
  { 490, "$s490"}, /* 1251 */
  { 491, "$vsfr235"}, /* 1252 */
  { 491, "$s491"}, /* 1253 */
  { 492, "$vsfr236"}, /* 1254 */
  { 492, "$s492"}, /* 1255 */
  { 493, "$vsfr237"}, /* 1256 */
  { 493, "$s493"}, /* 1257 */
  { 494, "$vsfr238"}, /* 1258 */
  { 494, "$s494"}, /* 1259 */
  { 495, "$vsfr239"}, /* 1260 */
  { 495, "$s495"}, /* 1261 */
  { 496, "$vsfr240"}, /* 1262 */
  { 496, "$s496"}, /* 1263 */
  { 497, "$vsfr241"}, /* 1264 */
  { 497, "$s497"}, /* 1265 */
  { 498, "$vsfr242"}, /* 1266 */
  { 498, "$s498"}, /* 1267 */
  { 499, "$vsfr243"}, /* 1268 */
  { 499, "$s499"}, /* 1269 */
  { 500, "$vsfr244"}, /* 1270 */
  { 500, "$s500"}, /* 1271 */
  { 501, "$vsfr245"}, /* 1272 */
  { 501, "$s501"}, /* 1273 */
  { 502, "$vsfr246"}, /* 1274 */
  { 502, "$s502"}, /* 1275 */
  { 503, "$vsfr247"}, /* 1276 */
  { 503, "$s503"}, /* 1277 */
  { 504, "$vsfr248"}, /* 1278 */
  { 504, "$s504"}, /* 1279 */
  { 505, "$vsfr249"}, /* 1280 */
  { 505, "$s505"}, /* 1281 */
  { 506, "$vsfr250"}, /* 1282 */
  { 506, "$s506"}, /* 1283 */
  { 507, "$vsfr251"}, /* 1284 */
  { 507, "$s507"}, /* 1285 */
  { 508, "$vsfr252"}, /* 1286 */
  { 508, "$s508"}, /* 1287 */
  { 509, "$vsfr253"}, /* 1288 */
  { 509, "$s509"}, /* 1289 */
  { 510, "$vsfr254"}, /* 1290 */
  { 510, "$s510"}, /* 1291 */
  { 511, "$vsfr255"}, /* 1292 */
  { 511, "$s511"}, /* 1293 */
  { 0, "$a0..a15"}, /* 1294 */
  { 1, "$a16..a31"}, /* 1295 */
  { 2, "$a32..a47"}, /* 1296 */
  { 3, "$a48..a63"}, /* 1297 */
  { 0, "$a0..a1"}, /* 1298 */
  { 1, "$a2..a3"}, /* 1299 */
  { 2, "$a4..a5"}, /* 1300 */
  { 3, "$a6..a7"}, /* 1301 */
  { 4, "$a8..a9"}, /* 1302 */
  { 5, "$a10..a11"}, /* 1303 */
  { 6, "$a12..a13"}, /* 1304 */
  { 7, "$a14..a15"}, /* 1305 */
  { 8, "$a16..a17"}, /* 1306 */
  { 9, "$a18..a19"}, /* 1307 */
  { 10, "$a20..a21"}, /* 1308 */
  { 11, "$a22..a23"}, /* 1309 */
  { 12, "$a24..a25"}, /* 1310 */
  { 13, "$a26..a27"}, /* 1311 */
  { 14, "$a28..a29"}, /* 1312 */
  { 15, "$a30..a31"}, /* 1313 */
  { 16, "$a32..a33"}, /* 1314 */
  { 17, "$a34..a35"}, /* 1315 */
  { 18, "$a36..a37"}, /* 1316 */
  { 19, "$a38..a39"}, /* 1317 */
  { 20, "$a40..a41"}, /* 1318 */
  { 21, "$a42..a43"}, /* 1319 */
  { 22, "$a44..a45"}, /* 1320 */
  { 23, "$a46..a47"}, /* 1321 */
  { 24, "$a48..a49"}, /* 1322 */
  { 25, "$a50..a51"}, /* 1323 */
  { 26, "$a52..a53"}, /* 1324 */
  { 27, "$a54..a55"}, /* 1325 */
  { 28, "$a56..a57"}, /* 1326 */
  { 29, "$a58..a59"}, /* 1327 */
  { 30, "$a60..a61"}, /* 1328 */
  { 31, "$a62..a63"}, /* 1329 */
  { 0, "$a0..a31"}, /* 1330 */
  { 1, "$a32..a63"}, /* 1331 */
  { 0, "$a0..a3"}, /* 1332 */
  { 1, "$a4..a7"}, /* 1333 */
  { 2, "$a8..a11"}, /* 1334 */
  { 3, "$a12..a15"}, /* 1335 */
  { 4, "$a16..a19"}, /* 1336 */
  { 5, "$a20..a23"}, /* 1337 */
  { 6, "$a24..a27"}, /* 1338 */
  { 7, "$a28..a31"}, /* 1339 */
  { 8, "$a32..a35"}, /* 1340 */
  { 9, "$a36..a39"}, /* 1341 */
  { 10, "$a40..a43"}, /* 1342 */
  { 11, "$a44..a47"}, /* 1343 */
  { 12, "$a48..a51"}, /* 1344 */
  { 13, "$a52..a55"}, /* 1345 */
  { 14, "$a56..a59"}, /* 1346 */
  { 15, "$a60..a63"}, /* 1347 */
  { 0, "$a0..a63"}, /* 1348 */
  { 0, "$a0..a7"}, /* 1349 */
  { 1, "$a8..a15"}, /* 1350 */
  { 2, "$a16..a23"}, /* 1351 */
  { 3, "$a24..a31"}, /* 1352 */
  { 4, "$a32..a39"}, /* 1353 */
  { 5, "$a40..a47"}, /* 1354 */
  { 6, "$a48..a55"}, /* 1355 */
  { 7, "$a56..a63"}, /* 1356 */
  { 0, "$a0_lo"}, /* 1357 */
  { 0, "$a0.lo"}, /* 1358 */
  { 1, "$a0_hi"}, /* 1359 */
  { 1, "$a0.hi"}, /* 1360 */
  { 2, "$a1_lo"}, /* 1361 */
  { 2, "$a1.lo"}, /* 1362 */
  { 3, "$a1_hi"}, /* 1363 */
  { 3, "$a1.hi"}, /* 1364 */
  { 4, "$a2_lo"}, /* 1365 */
  { 4, "$a2.lo"}, /* 1366 */
  { 5, "$a2_hi"}, /* 1367 */
  { 5, "$a2.hi"}, /* 1368 */
  { 6, "$a3_lo"}, /* 1369 */
  { 6, "$a3.lo"}, /* 1370 */
  { 7, "$a3_hi"}, /* 1371 */
  { 7, "$a3.hi"}, /* 1372 */
  { 8, "$a4_lo"}, /* 1373 */
  { 8, "$a4.lo"}, /* 1374 */
  { 9, "$a4_hi"}, /* 1375 */
  { 9, "$a4.hi"}, /* 1376 */
  { 10, "$a5_lo"}, /* 1377 */
  { 10, "$a5.lo"}, /* 1378 */
  { 11, "$a5_hi"}, /* 1379 */
  { 11, "$a5.hi"}, /* 1380 */
  { 12, "$a6_lo"}, /* 1381 */
  { 12, "$a6.lo"}, /* 1382 */
  { 13, "$a6_hi"}, /* 1383 */
  { 13, "$a6.hi"}, /* 1384 */
  { 14, "$a7_lo"}, /* 1385 */
  { 14, "$a7.lo"}, /* 1386 */
  { 15, "$a7_hi"}, /* 1387 */
  { 15, "$a7.hi"}, /* 1388 */
  { 16, "$a8_lo"}, /* 1389 */
  { 16, "$a8.lo"}, /* 1390 */
  { 17, "$a8_hi"}, /* 1391 */
  { 17, "$a8.hi"}, /* 1392 */
  { 18, "$a9_lo"}, /* 1393 */
  { 18, "$a9.lo"}, /* 1394 */
  { 19, "$a9_hi"}, /* 1395 */
  { 19, "$a9.hi"}, /* 1396 */
  { 20, "$a10_lo"}, /* 1397 */
  { 20, "$a10.lo"}, /* 1398 */
  { 21, "$a10_hi"}, /* 1399 */
  { 21, "$a10.hi"}, /* 1400 */
  { 22, "$a11_lo"}, /* 1401 */
  { 22, "$a11.lo"}, /* 1402 */
  { 23, "$a11_hi"}, /* 1403 */
  { 23, "$a11.hi"}, /* 1404 */
  { 24, "$a12_lo"}, /* 1405 */
  { 24, "$a12.lo"}, /* 1406 */
  { 25, "$a12_hi"}, /* 1407 */
  { 25, "$a12.hi"}, /* 1408 */
  { 26, "$a13_lo"}, /* 1409 */
  { 26, "$a13.lo"}, /* 1410 */
  { 27, "$a13_hi"}, /* 1411 */
  { 27, "$a13.hi"}, /* 1412 */
  { 28, "$a14_lo"}, /* 1413 */
  { 28, "$a14.lo"}, /* 1414 */
  { 29, "$a14_hi"}, /* 1415 */
  { 29, "$a14.hi"}, /* 1416 */
  { 30, "$a15_lo"}, /* 1417 */
  { 30, "$a15.lo"}, /* 1418 */
  { 31, "$a15_hi"}, /* 1419 */
  { 31, "$a15.hi"}, /* 1420 */
  { 32, "$a16_lo"}, /* 1421 */
  { 32, "$a16.lo"}, /* 1422 */
  { 33, "$a16_hi"}, /* 1423 */
  { 33, "$a16.hi"}, /* 1424 */
  { 34, "$a17_lo"}, /* 1425 */
  { 34, "$a17.lo"}, /* 1426 */
  { 35, "$a17_hi"}, /* 1427 */
  { 35, "$a17.hi"}, /* 1428 */
  { 36, "$a18_lo"}, /* 1429 */
  { 36, "$a18.lo"}, /* 1430 */
  { 37, "$a18_hi"}, /* 1431 */
  { 37, "$a18.hi"}, /* 1432 */
  { 38, "$a19_lo"}, /* 1433 */
  { 38, "$a19.lo"}, /* 1434 */
  { 39, "$a19_hi"}, /* 1435 */
  { 39, "$a19.hi"}, /* 1436 */
  { 40, "$a20_lo"}, /* 1437 */
  { 40, "$a20.lo"}, /* 1438 */
  { 41, "$a20_hi"}, /* 1439 */
  { 41, "$a20.hi"}, /* 1440 */
  { 42, "$a21_lo"}, /* 1441 */
  { 42, "$a21.lo"}, /* 1442 */
  { 43, "$a21_hi"}, /* 1443 */
  { 43, "$a21.hi"}, /* 1444 */
  { 44, "$a22_lo"}, /* 1445 */
  { 44, "$a22.lo"}, /* 1446 */
  { 45, "$a22_hi"}, /* 1447 */
  { 45, "$a22.hi"}, /* 1448 */
  { 46, "$a23_lo"}, /* 1449 */
  { 46, "$a23.lo"}, /* 1450 */
  { 47, "$a23_hi"}, /* 1451 */
  { 47, "$a23.hi"}, /* 1452 */
  { 48, "$a24_lo"}, /* 1453 */
  { 48, "$a24.lo"}, /* 1454 */
  { 49, "$a24_hi"}, /* 1455 */
  { 49, "$a24.hi"}, /* 1456 */
  { 50, "$a25_lo"}, /* 1457 */
  { 50, "$a25.lo"}, /* 1458 */
  { 51, "$a25_hi"}, /* 1459 */
  { 51, "$a25.hi"}, /* 1460 */
  { 52, "$a26_lo"}, /* 1461 */
  { 52, "$a26.lo"}, /* 1462 */
  { 53, "$a26_hi"}, /* 1463 */
  { 53, "$a26.hi"}, /* 1464 */
  { 54, "$a27_lo"}, /* 1465 */
  { 54, "$a27.lo"}, /* 1466 */
  { 55, "$a27_hi"}, /* 1467 */
  { 55, "$a27.hi"}, /* 1468 */
  { 56, "$a28_lo"}, /* 1469 */
  { 56, "$a28.lo"}, /* 1470 */
  { 57, "$a28_hi"}, /* 1471 */
  { 57, "$a28.hi"}, /* 1472 */
  { 58, "$a29_lo"}, /* 1473 */
  { 58, "$a29.lo"}, /* 1474 */
  { 59, "$a29_hi"}, /* 1475 */
  { 59, "$a29.hi"}, /* 1476 */
  { 60, "$a30_lo"}, /* 1477 */
  { 60, "$a30.lo"}, /* 1478 */
  { 61, "$a30_hi"}, /* 1479 */
  { 61, "$a30.hi"}, /* 1480 */
  { 62, "$a31_lo"}, /* 1481 */
  { 62, "$a31.lo"}, /* 1482 */
  { 63, "$a31_hi"}, /* 1483 */
  { 63, "$a31.hi"}, /* 1484 */
  { 64, "$a32_lo"}, /* 1485 */
  { 64, "$a32.lo"}, /* 1486 */
  { 65, "$a32_hi"}, /* 1487 */
  { 65, "$a32.hi"}, /* 1488 */
  { 66, "$a33_lo"}, /* 1489 */
  { 66, "$a33.lo"}, /* 1490 */
  { 67, "$a33_hi"}, /* 1491 */
  { 67, "$a33.hi"}, /* 1492 */
  { 68, "$a34_lo"}, /* 1493 */
  { 68, "$a34.lo"}, /* 1494 */
  { 69, "$a34_hi"}, /* 1495 */
  { 69, "$a34.hi"}, /* 1496 */
  { 70, "$a35_lo"}, /* 1497 */
  { 70, "$a35.lo"}, /* 1498 */
  { 71, "$a35_hi"}, /* 1499 */
  { 71, "$a35.hi"}, /* 1500 */
  { 72, "$a36_lo"}, /* 1501 */
  { 72, "$a36.lo"}, /* 1502 */
  { 73, "$a36_hi"}, /* 1503 */
  { 73, "$a36.hi"}, /* 1504 */
  { 74, "$a37_lo"}, /* 1505 */
  { 74, "$a37.lo"}, /* 1506 */
  { 75, "$a37_hi"}, /* 1507 */
  { 75, "$a37.hi"}, /* 1508 */
  { 76, "$a38_lo"}, /* 1509 */
  { 76, "$a38.lo"}, /* 1510 */
  { 77, "$a38_hi"}, /* 1511 */
  { 77, "$a38.hi"}, /* 1512 */
  { 78, "$a39_lo"}, /* 1513 */
  { 78, "$a39.lo"}, /* 1514 */
  { 79, "$a39_hi"}, /* 1515 */
  { 79, "$a39.hi"}, /* 1516 */
  { 80, "$a40_lo"}, /* 1517 */
  { 80, "$a40.lo"}, /* 1518 */
  { 81, "$a40_hi"}, /* 1519 */
  { 81, "$a40.hi"}, /* 1520 */
  { 82, "$a41_lo"}, /* 1521 */
  { 82, "$a41.lo"}, /* 1522 */
  { 83, "$a41_hi"}, /* 1523 */
  { 83, "$a41.hi"}, /* 1524 */
  { 84, "$a42_lo"}, /* 1525 */
  { 84, "$a42.lo"}, /* 1526 */
  { 85, "$a42_hi"}, /* 1527 */
  { 85, "$a42.hi"}, /* 1528 */
  { 86, "$a43_lo"}, /* 1529 */
  { 86, "$a43.lo"}, /* 1530 */
  { 87, "$a43_hi"}, /* 1531 */
  { 87, "$a43.hi"}, /* 1532 */
  { 88, "$a44_lo"}, /* 1533 */
  { 88, "$a44.lo"}, /* 1534 */
  { 89, "$a44_hi"}, /* 1535 */
  { 89, "$a44.hi"}, /* 1536 */
  { 90, "$a45_lo"}, /* 1537 */
  { 90, "$a45.lo"}, /* 1538 */
  { 91, "$a45_hi"}, /* 1539 */
  { 91, "$a45.hi"}, /* 1540 */
  { 92, "$a46_lo"}, /* 1541 */
  { 92, "$a46.lo"}, /* 1542 */
  { 93, "$a46_hi"}, /* 1543 */
  { 93, "$a46.hi"}, /* 1544 */
  { 94, "$a47_lo"}, /* 1545 */
  { 94, "$a47.lo"}, /* 1546 */
  { 95, "$a47_hi"}, /* 1547 */
  { 95, "$a47.hi"}, /* 1548 */
  { 96, "$a48_lo"}, /* 1549 */
  { 96, "$a48.lo"}, /* 1550 */
  { 97, "$a48_hi"}, /* 1551 */
  { 97, "$a48.hi"}, /* 1552 */
  { 98, "$a49_lo"}, /* 1553 */
  { 98, "$a49.lo"}, /* 1554 */
  { 99, "$a49_hi"}, /* 1555 */
  { 99, "$a49.hi"}, /* 1556 */
  { 100, "$a50_lo"}, /* 1557 */
  { 100, "$a50.lo"}, /* 1558 */
  { 101, "$a50_hi"}, /* 1559 */
  { 101, "$a50.hi"}, /* 1560 */
  { 102, "$a51_lo"}, /* 1561 */
  { 102, "$a51.lo"}, /* 1562 */
  { 103, "$a51_hi"}, /* 1563 */
  { 103, "$a51.hi"}, /* 1564 */
  { 104, "$a52_lo"}, /* 1565 */
  { 104, "$a52.lo"}, /* 1566 */
  { 105, "$a52_hi"}, /* 1567 */
  { 105, "$a52.hi"}, /* 1568 */
  { 106, "$a53_lo"}, /* 1569 */
  { 106, "$a53.lo"}, /* 1570 */
  { 107, "$a53_hi"}, /* 1571 */
  { 107, "$a53.hi"}, /* 1572 */
  { 108, "$a54_lo"}, /* 1573 */
  { 108, "$a54.lo"}, /* 1574 */
  { 109, "$a54_hi"}, /* 1575 */
  { 109, "$a54.hi"}, /* 1576 */
  { 110, "$a55_lo"}, /* 1577 */
  { 110, "$a55.lo"}, /* 1578 */
  { 111, "$a55_hi"}, /* 1579 */
  { 111, "$a55.hi"}, /* 1580 */
  { 112, "$a56_lo"}, /* 1581 */
  { 112, "$a56.lo"}, /* 1582 */
  { 113, "$a56_hi"}, /* 1583 */
  { 113, "$a56.hi"}, /* 1584 */
  { 114, "$a57_lo"}, /* 1585 */
  { 114, "$a57.lo"}, /* 1586 */
  { 115, "$a57_hi"}, /* 1587 */
  { 115, "$a57.hi"}, /* 1588 */
  { 116, "$a58_lo"}, /* 1589 */
  { 116, "$a58.lo"}, /* 1590 */
  { 117, "$a58_hi"}, /* 1591 */
  { 117, "$a58.hi"}, /* 1592 */
  { 118, "$a59_lo"}, /* 1593 */
  { 118, "$a59.lo"}, /* 1594 */
  { 119, "$a59_hi"}, /* 1595 */
  { 119, "$a59.hi"}, /* 1596 */
  { 120, "$a60_lo"}, /* 1597 */
  { 120, "$a60.lo"}, /* 1598 */
  { 121, "$a60_hi"}, /* 1599 */
  { 121, "$a60.hi"}, /* 1600 */
  { 122, "$a61_lo"}, /* 1601 */
  { 122, "$a61.lo"}, /* 1602 */
  { 123, "$a61_hi"}, /* 1603 */
  { 123, "$a61.hi"}, /* 1604 */
  { 124, "$a62_lo"}, /* 1605 */
  { 124, "$a62.lo"}, /* 1606 */
  { 125, "$a62_hi"}, /* 1607 */
  { 125, "$a62.hi"}, /* 1608 */
  { 126, "$a63_lo"}, /* 1609 */
  { 126, "$a63.lo"}, /* 1610 */
  { 127, "$a63_hi"}, /* 1611 */
  { 127, "$a63.hi"}, /* 1612 */
  { 0, "$a0_x"}, /* 1613 */
  { 0, "$a0.x"}, /* 1614 */
  { 1, "$a0_y"}, /* 1615 */
  { 1, "$a0.y"}, /* 1616 */
  { 2, "$a0_z"}, /* 1617 */
  { 2, "$a0.z"}, /* 1618 */
  { 3, "$a0_t"}, /* 1619 */
  { 3, "$a0.t"}, /* 1620 */
  { 4, "$a1_x"}, /* 1621 */
  { 4, "$a1.x"}, /* 1622 */
  { 5, "$a1_y"}, /* 1623 */
  { 5, "$a1.y"}, /* 1624 */
  { 6, "$a1_z"}, /* 1625 */
  { 6, "$a1.z"}, /* 1626 */
  { 7, "$a1_t"}, /* 1627 */
  { 7, "$a1.t"}, /* 1628 */
  { 8, "$a2_x"}, /* 1629 */
  { 8, "$a2.x"}, /* 1630 */
  { 9, "$a2_y"}, /* 1631 */
  { 9, "$a2.y"}, /* 1632 */
  { 10, "$a2_z"}, /* 1633 */
  { 10, "$a2.z"}, /* 1634 */
  { 11, "$a2_t"}, /* 1635 */
  { 11, "$a2.t"}, /* 1636 */
  { 12, "$a3_x"}, /* 1637 */
  { 12, "$a3.x"}, /* 1638 */
  { 13, "$a3_y"}, /* 1639 */
  { 13, "$a3.y"}, /* 1640 */
  { 14, "$a3_z"}, /* 1641 */
  { 14, "$a3.z"}, /* 1642 */
  { 15, "$a3_t"}, /* 1643 */
  { 15, "$a3.t"}, /* 1644 */
  { 16, "$a4_x"}, /* 1645 */
  { 16, "$a4.x"}, /* 1646 */
  { 17, "$a4_y"}, /* 1647 */
  { 17, "$a4.y"}, /* 1648 */
  { 18, "$a4_z"}, /* 1649 */
  { 18, "$a4.z"}, /* 1650 */
  { 19, "$a4_t"}, /* 1651 */
  { 19, "$a4.t"}, /* 1652 */
  { 20, "$a5_x"}, /* 1653 */
  { 20, "$a5.x"}, /* 1654 */
  { 21, "$a5_y"}, /* 1655 */
  { 21, "$a5.y"}, /* 1656 */
  { 22, "$a5_z"}, /* 1657 */
  { 22, "$a5.z"}, /* 1658 */
  { 23, "$a5_t"}, /* 1659 */
  { 23, "$a5.t"}, /* 1660 */
  { 24, "$a6_x"}, /* 1661 */
  { 24, "$a6.x"}, /* 1662 */
  { 25, "$a6_y"}, /* 1663 */
  { 25, "$a6.y"}, /* 1664 */
  { 26, "$a6_z"}, /* 1665 */
  { 26, "$a6.z"}, /* 1666 */
  { 27, "$a6_t"}, /* 1667 */
  { 27, "$a6.t"}, /* 1668 */
  { 28, "$a7_x"}, /* 1669 */
  { 28, "$a7.x"}, /* 1670 */
  { 29, "$a7_y"}, /* 1671 */
  { 29, "$a7.y"}, /* 1672 */
  { 30, "$a7_z"}, /* 1673 */
  { 30, "$a7.z"}, /* 1674 */
  { 31, "$a7_t"}, /* 1675 */
  { 31, "$a7.t"}, /* 1676 */
  { 32, "$a8_x"}, /* 1677 */
  { 32, "$a8.x"}, /* 1678 */
  { 33, "$a8_y"}, /* 1679 */
  { 33, "$a8.y"}, /* 1680 */
  { 34, "$a8_z"}, /* 1681 */
  { 34, "$a8.z"}, /* 1682 */
  { 35, "$a8_t"}, /* 1683 */
  { 35, "$a8.t"}, /* 1684 */
  { 36, "$a9_x"}, /* 1685 */
  { 36, "$a9.x"}, /* 1686 */
  { 37, "$a9_y"}, /* 1687 */
  { 37, "$a9.y"}, /* 1688 */
  { 38, "$a9_z"}, /* 1689 */
  { 38, "$a9.z"}, /* 1690 */
  { 39, "$a9_t"}, /* 1691 */
  { 39, "$a9.t"}, /* 1692 */
  { 40, "$a10_x"}, /* 1693 */
  { 40, "$a10.x"}, /* 1694 */
  { 41, "$a10_y"}, /* 1695 */
  { 41, "$a10.y"}, /* 1696 */
  { 42, "$a10_z"}, /* 1697 */
  { 42, "$a10.z"}, /* 1698 */
  { 43, "$a10_t"}, /* 1699 */
  { 43, "$a10.t"}, /* 1700 */
  { 44, "$a11_x"}, /* 1701 */
  { 44, "$a11.x"}, /* 1702 */
  { 45, "$a11_y"}, /* 1703 */
  { 45, "$a11.y"}, /* 1704 */
  { 46, "$a11_z"}, /* 1705 */
  { 46, "$a11.z"}, /* 1706 */
  { 47, "$a11_t"}, /* 1707 */
  { 47, "$a11.t"}, /* 1708 */
  { 48, "$a12_x"}, /* 1709 */
  { 48, "$a12.x"}, /* 1710 */
  { 49, "$a12_y"}, /* 1711 */
  { 49, "$a12.y"}, /* 1712 */
  { 50, "$a12_z"}, /* 1713 */
  { 50, "$a12.z"}, /* 1714 */
  { 51, "$a12_t"}, /* 1715 */
  { 51, "$a12.t"}, /* 1716 */
  { 52, "$a13_x"}, /* 1717 */
  { 52, "$a13.x"}, /* 1718 */
  { 53, "$a13_y"}, /* 1719 */
  { 53, "$a13.y"}, /* 1720 */
  { 54, "$a13_z"}, /* 1721 */
  { 54, "$a13.z"}, /* 1722 */
  { 55, "$a13_t"}, /* 1723 */
  { 55, "$a13.t"}, /* 1724 */
  { 56, "$a14_x"}, /* 1725 */
  { 56, "$a14.x"}, /* 1726 */
  { 57, "$a14_y"}, /* 1727 */
  { 57, "$a14.y"}, /* 1728 */
  { 58, "$a14_z"}, /* 1729 */
  { 58, "$a14.z"}, /* 1730 */
  { 59, "$a14_t"}, /* 1731 */
  { 59, "$a14.t"}, /* 1732 */
  { 60, "$a15_x"}, /* 1733 */
  { 60, "$a15.x"}, /* 1734 */
  { 61, "$a15_y"}, /* 1735 */
  { 61, "$a15.y"}, /* 1736 */
  { 62, "$a15_z"}, /* 1737 */
  { 62, "$a15.z"}, /* 1738 */
  { 63, "$a15_t"}, /* 1739 */
  { 63, "$a15.t"}, /* 1740 */
  { 64, "$a16_x"}, /* 1741 */
  { 64, "$a16.x"}, /* 1742 */
  { 65, "$a16_y"}, /* 1743 */
  { 65, "$a16.y"}, /* 1744 */
  { 66, "$a16_z"}, /* 1745 */
  { 66, "$a16.z"}, /* 1746 */
  { 67, "$a16_t"}, /* 1747 */
  { 67, "$a16.t"}, /* 1748 */
  { 68, "$a17_x"}, /* 1749 */
  { 68, "$a17.x"}, /* 1750 */
  { 69, "$a17_y"}, /* 1751 */
  { 69, "$a17.y"}, /* 1752 */
  { 70, "$a17_z"}, /* 1753 */
  { 70, "$a17.z"}, /* 1754 */
  { 71, "$a17_t"}, /* 1755 */
  { 71, "$a17.t"}, /* 1756 */
  { 72, "$a18_x"}, /* 1757 */
  { 72, "$a18.x"}, /* 1758 */
  { 73, "$a18_y"}, /* 1759 */
  { 73, "$a18.y"}, /* 1760 */
  { 74, "$a18_z"}, /* 1761 */
  { 74, "$a18.z"}, /* 1762 */
  { 75, "$a18_t"}, /* 1763 */
  { 75, "$a18.t"}, /* 1764 */
  { 76, "$a19_x"}, /* 1765 */
  { 76, "$a19.x"}, /* 1766 */
  { 77, "$a19_y"}, /* 1767 */
  { 77, "$a19.y"}, /* 1768 */
  { 78, "$a19_z"}, /* 1769 */
  { 78, "$a19.z"}, /* 1770 */
  { 79, "$a19_t"}, /* 1771 */
  { 79, "$a19.t"}, /* 1772 */
  { 80, "$a20_x"}, /* 1773 */
  { 80, "$a20.x"}, /* 1774 */
  { 81, "$a20_y"}, /* 1775 */
  { 81, "$a20.y"}, /* 1776 */
  { 82, "$a20_z"}, /* 1777 */
  { 82, "$a20.z"}, /* 1778 */
  { 83, "$a20_t"}, /* 1779 */
  { 83, "$a20.t"}, /* 1780 */
  { 84, "$a21_x"}, /* 1781 */
  { 84, "$a21.x"}, /* 1782 */
  { 85, "$a21_y"}, /* 1783 */
  { 85, "$a21.y"}, /* 1784 */
  { 86, "$a21_z"}, /* 1785 */
  { 86, "$a21.z"}, /* 1786 */
  { 87, "$a21_t"}, /* 1787 */
  { 87, "$a21.t"}, /* 1788 */
  { 88, "$a22_x"}, /* 1789 */
  { 88, "$a22.x"}, /* 1790 */
  { 89, "$a22_y"}, /* 1791 */
  { 89, "$a22.y"}, /* 1792 */
  { 90, "$a22_z"}, /* 1793 */
  { 90, "$a22.z"}, /* 1794 */
  { 91, "$a22_t"}, /* 1795 */
  { 91, "$a22.t"}, /* 1796 */
  { 92, "$a23_x"}, /* 1797 */
  { 92, "$a23.x"}, /* 1798 */
  { 93, "$a23_y"}, /* 1799 */
  { 93, "$a23.y"}, /* 1800 */
  { 94, "$a23_z"}, /* 1801 */
  { 94, "$a23.z"}, /* 1802 */
  { 95, "$a23_t"}, /* 1803 */
  { 95, "$a23.t"}, /* 1804 */
  { 96, "$a24_x"}, /* 1805 */
  { 96, "$a24.x"}, /* 1806 */
  { 97, "$a24_y"}, /* 1807 */
  { 97, "$a24.y"}, /* 1808 */
  { 98, "$a24_z"}, /* 1809 */
  { 98, "$a24.z"}, /* 1810 */
  { 99, "$a24_t"}, /* 1811 */
  { 99, "$a24.t"}, /* 1812 */
  { 100, "$a25_x"}, /* 1813 */
  { 100, "$a25.x"}, /* 1814 */
  { 101, "$a25_y"}, /* 1815 */
  { 101, "$a25.y"}, /* 1816 */
  { 102, "$a25_z"}, /* 1817 */
  { 102, "$a25.z"}, /* 1818 */
  { 103, "$a25_t"}, /* 1819 */
  { 103, "$a25.t"}, /* 1820 */
  { 104, "$a26_x"}, /* 1821 */
  { 104, "$a26.x"}, /* 1822 */
  { 105, "$a26_y"}, /* 1823 */
  { 105, "$a26.y"}, /* 1824 */
  { 106, "$a26_z"}, /* 1825 */
  { 106, "$a26.z"}, /* 1826 */
  { 107, "$a26_t"}, /* 1827 */
  { 107, "$a26.t"}, /* 1828 */
  { 108, "$a27_x"}, /* 1829 */
  { 108, "$a27.x"}, /* 1830 */
  { 109, "$a27_y"}, /* 1831 */
  { 109, "$a27.y"}, /* 1832 */
  { 110, "$a27_z"}, /* 1833 */
  { 110, "$a27.z"}, /* 1834 */
  { 111, "$a27_t"}, /* 1835 */
  { 111, "$a27.t"}, /* 1836 */
  { 112, "$a28_x"}, /* 1837 */
  { 112, "$a28.x"}, /* 1838 */
  { 113, "$a28_y"}, /* 1839 */
  { 113, "$a28.y"}, /* 1840 */
  { 114, "$a28_z"}, /* 1841 */
  { 114, "$a28.z"}, /* 1842 */
  { 115, "$a28_t"}, /* 1843 */
  { 115, "$a28.t"}, /* 1844 */
  { 116, "$a29_x"}, /* 1845 */
  { 116, "$a29.x"}, /* 1846 */
  { 117, "$a29_y"}, /* 1847 */
  { 117, "$a29.y"}, /* 1848 */
  { 118, "$a29_z"}, /* 1849 */
  { 118, "$a29.z"}, /* 1850 */
  { 119, "$a29_t"}, /* 1851 */
  { 119, "$a29.t"}, /* 1852 */
  { 120, "$a30_x"}, /* 1853 */
  { 120, "$a30.x"}, /* 1854 */
  { 121, "$a30_y"}, /* 1855 */
  { 121, "$a30.y"}, /* 1856 */
  { 122, "$a30_z"}, /* 1857 */
  { 122, "$a30.z"}, /* 1858 */
  { 123, "$a30_t"}, /* 1859 */
  { 123, "$a30.t"}, /* 1860 */
  { 124, "$a31_x"}, /* 1861 */
  { 124, "$a31.x"}, /* 1862 */
  { 125, "$a31_y"}, /* 1863 */
  { 125, "$a31.y"}, /* 1864 */
  { 126, "$a31_z"}, /* 1865 */
  { 126, "$a31.z"}, /* 1866 */
  { 127, "$a31_t"}, /* 1867 */
  { 127, "$a31.t"}, /* 1868 */
  { 128, "$a32_x"}, /* 1869 */
  { 128, "$a32.x"}, /* 1870 */
  { 129, "$a32_y"}, /* 1871 */
  { 129, "$a32.y"}, /* 1872 */
  { 130, "$a32_z"}, /* 1873 */
  { 130, "$a32.z"}, /* 1874 */
  { 131, "$a32_t"}, /* 1875 */
  { 131, "$a32.t"}, /* 1876 */
  { 132, "$a33_x"}, /* 1877 */
  { 132, "$a33.x"}, /* 1878 */
  { 133, "$a33_y"}, /* 1879 */
  { 133, "$a33.y"}, /* 1880 */
  { 134, "$a33_z"}, /* 1881 */
  { 134, "$a33.z"}, /* 1882 */
  { 135, "$a33_t"}, /* 1883 */
  { 135, "$a33.t"}, /* 1884 */
  { 136, "$a34_x"}, /* 1885 */
  { 136, "$a34.x"}, /* 1886 */
  { 137, "$a34_y"}, /* 1887 */
  { 137, "$a34.y"}, /* 1888 */
  { 138, "$a34_z"}, /* 1889 */
  { 138, "$a34.z"}, /* 1890 */
  { 139, "$a34_t"}, /* 1891 */
  { 139, "$a34.t"}, /* 1892 */
  { 140, "$a35_x"}, /* 1893 */
  { 140, "$a35.x"}, /* 1894 */
  { 141, "$a35_y"}, /* 1895 */
  { 141, "$a35.y"}, /* 1896 */
  { 142, "$a35_z"}, /* 1897 */
  { 142, "$a35.z"}, /* 1898 */
  { 143, "$a35_t"}, /* 1899 */
  { 143, "$a35.t"}, /* 1900 */
  { 144, "$a36_x"}, /* 1901 */
  { 144, "$a36.x"}, /* 1902 */
  { 145, "$a36_y"}, /* 1903 */
  { 145, "$a36.y"}, /* 1904 */
  { 146, "$a36_z"}, /* 1905 */
  { 146, "$a36.z"}, /* 1906 */
  { 147, "$a36_t"}, /* 1907 */
  { 147, "$a36.t"}, /* 1908 */
  { 148, "$a37_x"}, /* 1909 */
  { 148, "$a37.x"}, /* 1910 */
  { 149, "$a37_y"}, /* 1911 */
  { 149, "$a37.y"}, /* 1912 */
  { 150, "$a37_z"}, /* 1913 */
  { 150, "$a37.z"}, /* 1914 */
  { 151, "$a37_t"}, /* 1915 */
  { 151, "$a37.t"}, /* 1916 */
  { 152, "$a38_x"}, /* 1917 */
  { 152, "$a38.x"}, /* 1918 */
  { 153, "$a38_y"}, /* 1919 */
  { 153, "$a38.y"}, /* 1920 */
  { 154, "$a38_z"}, /* 1921 */
  { 154, "$a38.z"}, /* 1922 */
  { 155, "$a38_t"}, /* 1923 */
  { 155, "$a38.t"}, /* 1924 */
  { 156, "$a39_x"}, /* 1925 */
  { 156, "$a39.x"}, /* 1926 */
  { 157, "$a39_y"}, /* 1927 */
  { 157, "$a39.y"}, /* 1928 */
  { 158, "$a39_z"}, /* 1929 */
  { 158, "$a39.z"}, /* 1930 */
  { 159, "$a39_t"}, /* 1931 */
  { 159, "$a39.t"}, /* 1932 */
  { 160, "$a40_x"}, /* 1933 */
  { 160, "$a40.x"}, /* 1934 */
  { 161, "$a40_y"}, /* 1935 */
  { 161, "$a40.y"}, /* 1936 */
  { 162, "$a40_z"}, /* 1937 */
  { 162, "$a40.z"}, /* 1938 */
  { 163, "$a40_t"}, /* 1939 */
  { 163, "$a40.t"}, /* 1940 */
  { 164, "$a41_x"}, /* 1941 */
  { 164, "$a41.x"}, /* 1942 */
  { 165, "$a41_y"}, /* 1943 */
  { 165, "$a41.y"}, /* 1944 */
  { 166, "$a41_z"}, /* 1945 */
  { 166, "$a41.z"}, /* 1946 */
  { 167, "$a41_t"}, /* 1947 */
  { 167, "$a41.t"}, /* 1948 */
  { 168, "$a42_x"}, /* 1949 */
  { 168, "$a42.x"}, /* 1950 */
  { 169, "$a42_y"}, /* 1951 */
  { 169, "$a42.y"}, /* 1952 */
  { 170, "$a42_z"}, /* 1953 */
  { 170, "$a42.z"}, /* 1954 */
  { 171, "$a42_t"}, /* 1955 */
  { 171, "$a42.t"}, /* 1956 */
  { 172, "$a43_x"}, /* 1957 */
  { 172, "$a43.x"}, /* 1958 */
  { 173, "$a43_y"}, /* 1959 */
  { 173, "$a43.y"}, /* 1960 */
  { 174, "$a43_z"}, /* 1961 */
  { 174, "$a43.z"}, /* 1962 */
  { 175, "$a43_t"}, /* 1963 */
  { 175, "$a43.t"}, /* 1964 */
  { 176, "$a44_x"}, /* 1965 */
  { 176, "$a44.x"}, /* 1966 */
  { 177, "$a44_y"}, /* 1967 */
  { 177, "$a44.y"}, /* 1968 */
  { 178, "$a44_z"}, /* 1969 */
  { 178, "$a44.z"}, /* 1970 */
  { 179, "$a44_t"}, /* 1971 */
  { 179, "$a44.t"}, /* 1972 */
  { 180, "$a45_x"}, /* 1973 */
  { 180, "$a45.x"}, /* 1974 */
  { 181, "$a45_y"}, /* 1975 */
  { 181, "$a45.y"}, /* 1976 */
  { 182, "$a45_z"}, /* 1977 */
  { 182, "$a45.z"}, /* 1978 */
  { 183, "$a45_t"}, /* 1979 */
  { 183, "$a45.t"}, /* 1980 */
  { 184, "$a46_x"}, /* 1981 */
  { 184, "$a46.x"}, /* 1982 */
  { 185, "$a46_y"}, /* 1983 */
  { 185, "$a46.y"}, /* 1984 */
  { 186, "$a46_z"}, /* 1985 */
  { 186, "$a46.z"}, /* 1986 */
  { 187, "$a46_t"}, /* 1987 */
  { 187, "$a46.t"}, /* 1988 */
  { 188, "$a47_x"}, /* 1989 */
  { 188, "$a47.x"}, /* 1990 */
  { 189, "$a47_y"}, /* 1991 */
  { 189, "$a47.y"}, /* 1992 */
  { 190, "$a47_z"}, /* 1993 */
  { 190, "$a47.z"}, /* 1994 */
  { 191, "$a47_t"}, /* 1995 */
  { 191, "$a47.t"}, /* 1996 */
  { 192, "$a48_x"}, /* 1997 */
  { 192, "$a48.x"}, /* 1998 */
  { 193, "$a48_y"}, /* 1999 */
  { 193, "$a48.y"}, /* 2000 */
  { 194, "$a48_z"}, /* 2001 */
  { 194, "$a48.z"}, /* 2002 */
  { 195, "$a48_t"}, /* 2003 */
  { 195, "$a48.t"}, /* 2004 */
  { 196, "$a49_x"}, /* 2005 */
  { 196, "$a49.x"}, /* 2006 */
  { 197, "$a49_y"}, /* 2007 */
  { 197, "$a49.y"}, /* 2008 */
  { 198, "$a49_z"}, /* 2009 */
  { 198, "$a49.z"}, /* 2010 */
  { 199, "$a49_t"}, /* 2011 */
  { 199, "$a49.t"}, /* 2012 */
  { 200, "$a50_x"}, /* 2013 */
  { 200, "$a50.x"}, /* 2014 */
  { 201, "$a50_y"}, /* 2015 */
  { 201, "$a50.y"}, /* 2016 */
  { 202, "$a50_z"}, /* 2017 */
  { 202, "$a50.z"}, /* 2018 */
  { 203, "$a50_t"}, /* 2019 */
  { 203, "$a50.t"}, /* 2020 */
  { 204, "$a51_x"}, /* 2021 */
  { 204, "$a51.x"}, /* 2022 */
  { 205, "$a51_y"}, /* 2023 */
  { 205, "$a51.y"}, /* 2024 */
  { 206, "$a51_z"}, /* 2025 */
  { 206, "$a51.z"}, /* 2026 */
  { 207, "$a51_t"}, /* 2027 */
  { 207, "$a51.t"}, /* 2028 */
  { 208, "$a52_x"}, /* 2029 */
  { 208, "$a52.x"}, /* 2030 */
  { 209, "$a52_y"}, /* 2031 */
  { 209, "$a52.y"}, /* 2032 */
  { 210, "$a52_z"}, /* 2033 */
  { 210, "$a52.z"}, /* 2034 */
  { 211, "$a52_t"}, /* 2035 */
  { 211, "$a52.t"}, /* 2036 */
  { 212, "$a53_x"}, /* 2037 */
  { 212, "$a53.x"}, /* 2038 */
  { 213, "$a53_y"}, /* 2039 */
  { 213, "$a53.y"}, /* 2040 */
  { 214, "$a53_z"}, /* 2041 */
  { 214, "$a53.z"}, /* 2042 */
  { 215, "$a53_t"}, /* 2043 */
  { 215, "$a53.t"}, /* 2044 */
  { 216, "$a54_x"}, /* 2045 */
  { 216, "$a54.x"}, /* 2046 */
  { 217, "$a54_y"}, /* 2047 */
  { 217, "$a54.y"}, /* 2048 */
  { 218, "$a54_z"}, /* 2049 */
  { 218, "$a54.z"}, /* 2050 */
  { 219, "$a54_t"}, /* 2051 */
  { 219, "$a54.t"}, /* 2052 */
  { 220, "$a55_x"}, /* 2053 */
  { 220, "$a55.x"}, /* 2054 */
  { 221, "$a55_y"}, /* 2055 */
  { 221, "$a55.y"}, /* 2056 */
  { 222, "$a55_z"}, /* 2057 */
  { 222, "$a55.z"}, /* 2058 */
  { 223, "$a55_t"}, /* 2059 */
  { 223, "$a55.t"}, /* 2060 */
  { 224, "$a56_x"}, /* 2061 */
  { 224, "$a56.x"}, /* 2062 */
  { 225, "$a56_y"}, /* 2063 */
  { 225, "$a56.y"}, /* 2064 */
  { 226, "$a56_z"}, /* 2065 */
  { 226, "$a56.z"}, /* 2066 */
  { 227, "$a56_t"}, /* 2067 */
  { 227, "$a56.t"}, /* 2068 */
  { 228, "$a57_x"}, /* 2069 */
  { 228, "$a57.x"}, /* 2070 */
  { 229, "$a57_y"}, /* 2071 */
  { 229, "$a57.y"}, /* 2072 */
  { 230, "$a57_z"}, /* 2073 */
  { 230, "$a57.z"}, /* 2074 */
  { 231, "$a57_t"}, /* 2075 */
  { 231, "$a57.t"}, /* 2076 */
  { 232, "$a58_x"}, /* 2077 */
  { 232, "$a58.x"}, /* 2078 */
  { 233, "$a58_y"}, /* 2079 */
  { 233, "$a58.y"}, /* 2080 */
  { 234, "$a58_z"}, /* 2081 */
  { 234, "$a58.z"}, /* 2082 */
  { 235, "$a58_t"}, /* 2083 */
  { 235, "$a58.t"}, /* 2084 */
  { 236, "$a59_x"}, /* 2085 */
  { 236, "$a59.x"}, /* 2086 */
  { 237, "$a59_y"}, /* 2087 */
  { 237, "$a59.y"}, /* 2088 */
  { 238, "$a59_z"}, /* 2089 */
  { 238, "$a59.z"}, /* 2090 */
  { 239, "$a59_t"}, /* 2091 */
  { 239, "$a59.t"}, /* 2092 */
  { 240, "$a60_x"}, /* 2093 */
  { 240, "$a60.x"}, /* 2094 */
  { 241, "$a60_y"}, /* 2095 */
  { 241, "$a60.y"}, /* 2096 */
  { 242, "$a60_z"}, /* 2097 */
  { 242, "$a60.z"}, /* 2098 */
  { 243, "$a60_t"}, /* 2099 */
  { 243, "$a60.t"}, /* 2100 */
  { 244, "$a61_x"}, /* 2101 */
  { 244, "$a61.x"}, /* 2102 */
  { 245, "$a61_y"}, /* 2103 */
  { 245, "$a61.y"}, /* 2104 */
  { 246, "$a61_z"}, /* 2105 */
  { 246, "$a61.z"}, /* 2106 */
  { 247, "$a61_t"}, /* 2107 */
  { 247, "$a61.t"}, /* 2108 */
  { 248, "$a62_x"}, /* 2109 */
  { 248, "$a62.x"}, /* 2110 */
  { 249, "$a62_y"}, /* 2111 */
  { 249, "$a62.y"}, /* 2112 */
  { 250, "$a62_z"}, /* 2113 */
  { 250, "$a62.z"}, /* 2114 */
  { 251, "$a62_t"}, /* 2115 */
  { 251, "$a62.t"}, /* 2116 */
  { 252, "$a63_x"}, /* 2117 */
  { 252, "$a63.x"}, /* 2118 */
  { 253, "$a63_y"}, /* 2119 */
  { 253, "$a63.y"}, /* 2120 */
  { 254, "$a63_z"}, /* 2121 */
  { 254, "$a63.z"}, /* 2122 */
  { 255, "$a63_t"}, /* 2123 */
  { 255, "$a63.t"}, /* 2124 */
  { 0, "$a0a1a2a3"}, /* 2125 */
  { 1, "$a4a5a6a7"}, /* 2126 */
  { 2, "$a8a9a10a11"}, /* 2127 */
  { 3, "$a12a13a14a15"}, /* 2128 */
  { 4, "$a16a17a18a19"}, /* 2129 */
  { 5, "$a20a21a22a23"}, /* 2130 */
  { 6, "$a24a25a26a27"}, /* 2131 */
  { 7, "$a28a29a30a31"}, /* 2132 */
  { 8, "$a32a33a34a35"}, /* 2133 */
  { 9, "$a36a37a38a39"}, /* 2134 */
  { 10, "$a40a41a42a43"}, /* 2135 */
  { 11, "$a44a45a46a47"}, /* 2136 */
  { 12, "$a48a49a50a51"}, /* 2137 */
  { 13, "$a52a53a54a55"}, /* 2138 */
  { 14, "$a56a57a58a59"}, /* 2139 */
  { 15, "$a60a61a62a63"}, /* 2140 */
  { 0, "$a0a1"}, /* 2141 */
  { 0, "$a0a1a2a3.lo"}, /* 2142 */
  { 1, "$a2a3"}, /* 2143 */
  { 1, "$a0a1a2a3.hi"}, /* 2144 */
  { 2, "$a4a5"}, /* 2145 */
  { 2, "$a4a5a6a7.lo"}, /* 2146 */
  { 3, "$a6a7"}, /* 2147 */
  { 3, "$a4a5a6a7.hi"}, /* 2148 */
  { 4, "$a8a9"}, /* 2149 */
  { 4, "$a8a9a10a11.lo"}, /* 2150 */
  { 5, "$a10a11"}, /* 2151 */
  { 5, "$a8a9a10a11.hi"}, /* 2152 */
  { 6, "$a12a13"}, /* 2153 */
  { 6, "$a12a13a14a15.lo"}, /* 2154 */
  { 7, "$a14a15"}, /* 2155 */
  { 7, "$a12a13a14a15.hi"}, /* 2156 */
  { 8, "$a16a17"}, /* 2157 */
  { 8, "$a16a17a18a19.lo"}, /* 2158 */
  { 9, "$a18a19"}, /* 2159 */
  { 9, "$a16a17a18a19.hi"}, /* 2160 */
  { 10, "$a20a21"}, /* 2161 */
  { 10, "$a20a21a22a23.lo"}, /* 2162 */
  { 11, "$a22a23"}, /* 2163 */
  { 11, "$a20a21a22a23.hi"}, /* 2164 */
  { 12, "$a24a25"}, /* 2165 */
  { 12, "$a24a25a26a27.lo"}, /* 2166 */
  { 13, "$a26a27"}, /* 2167 */
  { 13, "$a24a25a26a27.hi"}, /* 2168 */
  { 14, "$a28a29"}, /* 2169 */
  { 14, "$a28a29a30a31.lo"}, /* 2170 */
  { 15, "$a30a31"}, /* 2171 */
  { 15, "$a28a29a30a31.hi"}, /* 2172 */
  { 16, "$a32a33"}, /* 2173 */
  { 16, "$a32a33a34a35.lo"}, /* 2174 */
  { 17, "$a34a35"}, /* 2175 */
  { 17, "$a32a33a34a35.hi"}, /* 2176 */
  { 18, "$a36a37"}, /* 2177 */
  { 18, "$a36a37a38a39.lo"}, /* 2178 */
  { 19, "$a38a39"}, /* 2179 */
  { 19, "$a36a37a38a39.hi"}, /* 2180 */
  { 20, "$a40a41"}, /* 2181 */
  { 20, "$a40a41a42a43.lo"}, /* 2182 */
  { 21, "$a42a43"}, /* 2183 */
  { 21, "$a40a41a42a43.hi"}, /* 2184 */
  { 22, "$a44a45"}, /* 2185 */
  { 22, "$a44a45a46a47.lo"}, /* 2186 */
  { 23, "$a46a47"}, /* 2187 */
  { 23, "$a44a45a46a47.hi"}, /* 2188 */
  { 24, "$a48a49"}, /* 2189 */
  { 24, "$a48a49a50a51.lo"}, /* 2190 */
  { 25, "$a50a51"}, /* 2191 */
  { 25, "$a48a49a50a51.hi"}, /* 2192 */
  { 26, "$a52a53"}, /* 2193 */
  { 26, "$a52a53a54a55.lo"}, /* 2194 */
  { 27, "$a54a55"}, /* 2195 */
  { 27, "$a52a53a54a55.hi"}, /* 2196 */
  { 28, "$a56a57"}, /* 2197 */
  { 28, "$a56a57a58a59.lo"}, /* 2198 */
  { 29, "$a58a59"}, /* 2199 */
  { 29, "$a56a57a58a59.hi"}, /* 2200 */
  { 30, "$a60a61"}, /* 2201 */
  { 30, "$a60a61a62a63.lo"}, /* 2202 */
  { 31, "$a62a63"}, /* 2203 */
  { 31, "$a60a61a62a63.hi"}, /* 2204 */
  { 0, "$a0"}, /* 2205 */
  { 0, "$a0a1.lo"}, /* 2206 */
  { 0, "$a0a1a2a3.x"}, /* 2207 */
  { 1, "$a1"}, /* 2208 */
  { 1, "$a0a1.hi"}, /* 2209 */
  { 1, "$a0a1a2a3.y"}, /* 2210 */
  { 2, "$a2"}, /* 2211 */
  { 2, "$a2a3.lo"}, /* 2212 */
  { 2, "$a0a1a2a3.z"}, /* 2213 */
  { 3, "$a3"}, /* 2214 */
  { 3, "$a2a3.hi"}, /* 2215 */
  { 3, "$a0a1a2a3.t"}, /* 2216 */
  { 4, "$a4"}, /* 2217 */
  { 4, "$a4a5.lo"}, /* 2218 */
  { 4, "$a4a5a6a7.x"}, /* 2219 */
  { 5, "$a5"}, /* 2220 */
  { 5, "$a4a5.hi"}, /* 2221 */
  { 5, "$a4a5a6a7.y"}, /* 2222 */
  { 6, "$a6"}, /* 2223 */
  { 6, "$a6a7.lo"}, /* 2224 */
  { 6, "$a4a5a6a7.z"}, /* 2225 */
  { 7, "$a7"}, /* 2226 */
  { 7, "$a6a7.hi"}, /* 2227 */
  { 7, "$a4a5a6a7.t"}, /* 2228 */
  { 8, "$a8"}, /* 2229 */
  { 8, "$a8a9.lo"}, /* 2230 */
  { 8, "$a8a9a10a11.x"}, /* 2231 */
  { 9, "$a9"}, /* 2232 */
  { 9, "$a8a9.hi"}, /* 2233 */
  { 9, "$a8a9a10a11.y"}, /* 2234 */
  { 10, "$a10"}, /* 2235 */
  { 10, "$a10a11.lo"}, /* 2236 */
  { 10, "$a8a9a10a11.z"}, /* 2237 */
  { 11, "$a11"}, /* 2238 */
  { 11, "$a10a11.hi"}, /* 2239 */
  { 11, "$a8a9a10a11.t"}, /* 2240 */
  { 12, "$a12"}, /* 2241 */
  { 12, "$a12a13.lo"}, /* 2242 */
  { 12, "$a12a13a14a15.x"}, /* 2243 */
  { 13, "$a13"}, /* 2244 */
  { 13, "$a12a13.hi"}, /* 2245 */
  { 13, "$a12a13a14a15.y"}, /* 2246 */
  { 14, "$a14"}, /* 2247 */
  { 14, "$a14a15.lo"}, /* 2248 */
  { 14, "$a12a13a14a15.z"}, /* 2249 */
  { 15, "$a15"}, /* 2250 */
  { 15, "$a14a15.hi"}, /* 2251 */
  { 15, "$a12a13a14a15.t"}, /* 2252 */
  { 16, "$a16"}, /* 2253 */
  { 16, "$a16a17.lo"}, /* 2254 */
  { 16, "$a16a17a18a19.x"}, /* 2255 */
  { 17, "$a17"}, /* 2256 */
  { 17, "$a16a17.hi"}, /* 2257 */
  { 17, "$a16a17a18a19.y"}, /* 2258 */
  { 18, "$a18"}, /* 2259 */
  { 18, "$a18a19.lo"}, /* 2260 */
  { 18, "$a16a17a18a19.z"}, /* 2261 */
  { 19, "$a19"}, /* 2262 */
  { 19, "$a18a19.hi"}, /* 2263 */
  { 19, "$a16a17a18a19.t"}, /* 2264 */
  { 20, "$a20"}, /* 2265 */
  { 20, "$a20a21.lo"}, /* 2266 */
  { 20, "$a20a21a22a23.x"}, /* 2267 */
  { 21, "$a21"}, /* 2268 */
  { 21, "$a20a21.hi"}, /* 2269 */
  { 21, "$a20a21a22a23.y"}, /* 2270 */
  { 22, "$a22"}, /* 2271 */
  { 22, "$a22a23.lo"}, /* 2272 */
  { 22, "$a20a21a22a23.z"}, /* 2273 */
  { 23, "$a23"}, /* 2274 */
  { 23, "$a22a23.hi"}, /* 2275 */
  { 23, "$a20a21a22a23.t"}, /* 2276 */
  { 24, "$a24"}, /* 2277 */
  { 24, "$a24a25.lo"}, /* 2278 */
  { 24, "$a24a25a26a27.x"}, /* 2279 */
  { 25, "$a25"}, /* 2280 */
  { 25, "$a24a25.hi"}, /* 2281 */
  { 25, "$a24a25a26a27.y"}, /* 2282 */
  { 26, "$a26"}, /* 2283 */
  { 26, "$a26a27.lo"}, /* 2284 */
  { 26, "$a24a25a26a27.z"}, /* 2285 */
  { 27, "$a27"}, /* 2286 */
  { 27, "$a26a27.hi"}, /* 2287 */
  { 27, "$a24a25a26a27.t"}, /* 2288 */
  { 28, "$a28"}, /* 2289 */
  { 28, "$a28a29.lo"}, /* 2290 */
  { 28, "$a28a29a30a31.x"}, /* 2291 */
  { 29, "$a29"}, /* 2292 */
  { 29, "$a28a29.hi"}, /* 2293 */
  { 29, "$a28a29a30a31.y"}, /* 2294 */
  { 30, "$a30"}, /* 2295 */
  { 30, "$a30a31.lo"}, /* 2296 */
  { 30, "$a28a29a30a31.z"}, /* 2297 */
  { 31, "$a31"}, /* 2298 */
  { 31, "$a30a31.hi"}, /* 2299 */
  { 31, "$a28a29a30a31.t"}, /* 2300 */
  { 32, "$a32"}, /* 2301 */
  { 32, "$a32a33.lo"}, /* 2302 */
  { 32, "$a32a33a34a35.x"}, /* 2303 */
  { 33, "$a33"}, /* 2304 */
  { 33, "$a32a33.hi"}, /* 2305 */
  { 33, "$a32a33a34a35.y"}, /* 2306 */
  { 34, "$a34"}, /* 2307 */
  { 34, "$a34a35.lo"}, /* 2308 */
  { 34, "$a32a33a34a35.z"}, /* 2309 */
  { 35, "$a35"}, /* 2310 */
  { 35, "$a34a35.hi"}, /* 2311 */
  { 35, "$a32a33a34a35.t"}, /* 2312 */
  { 36, "$a36"}, /* 2313 */
  { 36, "$a36a37.lo"}, /* 2314 */
  { 36, "$a36a37a38a39.x"}, /* 2315 */
  { 37, "$a37"}, /* 2316 */
  { 37, "$a36a37.hi"}, /* 2317 */
  { 37, "$a36a37a38a39.y"}, /* 2318 */
  { 38, "$a38"}, /* 2319 */
  { 38, "$a38a39.lo"}, /* 2320 */
  { 38, "$a36a37a38a39.z"}, /* 2321 */
  { 39, "$a39"}, /* 2322 */
  { 39, "$a38a39.hi"}, /* 2323 */
  { 39, "$a36a37a38a39.t"}, /* 2324 */
  { 40, "$a40"}, /* 2325 */
  { 40, "$a40a41.lo"}, /* 2326 */
  { 40, "$a40a41a42a43.x"}, /* 2327 */
  { 41, "$a41"}, /* 2328 */
  { 41, "$a40a41.hi"}, /* 2329 */
  { 41, "$a40a41a42a43.y"}, /* 2330 */
  { 42, "$a42"}, /* 2331 */
  { 42, "$a42a43.lo"}, /* 2332 */
  { 42, "$a40a41a42a43.z"}, /* 2333 */
  { 43, "$a43"}, /* 2334 */
  { 43, "$a42a43.hi"}, /* 2335 */
  { 43, "$a40a41a42a43.t"}, /* 2336 */
  { 44, "$a44"}, /* 2337 */
  { 44, "$a44a45.lo"}, /* 2338 */
  { 44, "$a44a45a46a47.x"}, /* 2339 */
  { 45, "$a45"}, /* 2340 */
  { 45, "$a44a45.hi"}, /* 2341 */
  { 45, "$a44a45a46a47.y"}, /* 2342 */
  { 46, "$a46"}, /* 2343 */
  { 46, "$a46a47.lo"}, /* 2344 */
  { 46, "$a44a45a46a47.z"}, /* 2345 */
  { 47, "$a47"}, /* 2346 */
  { 47, "$a46a47.hi"}, /* 2347 */
  { 47, "$a44a45a46a47.t"}, /* 2348 */
  { 48, "$a48"}, /* 2349 */
  { 48, "$a48a49.lo"}, /* 2350 */
  { 48, "$a48a49a50a51.x"}, /* 2351 */
  { 49, "$a49"}, /* 2352 */
  { 49, "$a48a49.hi"}, /* 2353 */
  { 49, "$a48a49a50a51.y"}, /* 2354 */
  { 50, "$a50"}, /* 2355 */
  { 50, "$a50a51.lo"}, /* 2356 */
  { 50, "$a48a49a50a51.z"}, /* 2357 */
  { 51, "$a51"}, /* 2358 */
  { 51, "$a50a51.hi"}, /* 2359 */
  { 51, "$a48a49a50a51.t"}, /* 2360 */
  { 52, "$a52"}, /* 2361 */
  { 52, "$a52a53.lo"}, /* 2362 */
  { 52, "$a52a53a54a55.x"}, /* 2363 */
  { 53, "$a53"}, /* 2364 */
  { 53, "$a52a53.hi"}, /* 2365 */
  { 53, "$a52a53a54a55.y"}, /* 2366 */
  { 54, "$a54"}, /* 2367 */
  { 54, "$a54a55.lo"}, /* 2368 */
  { 54, "$a52a53a54a55.z"}, /* 2369 */
  { 55, "$a55"}, /* 2370 */
  { 55, "$a54a55.hi"}, /* 2371 */
  { 55, "$a52a53a54a55.t"}, /* 2372 */
  { 56, "$a56"}, /* 2373 */
  { 56, "$a56a57.lo"}, /* 2374 */
  { 56, "$a56a57a58a59.x"}, /* 2375 */
  { 57, "$a57"}, /* 2376 */
  { 57, "$a56a57.hi"}, /* 2377 */
  { 57, "$a56a57a58a59.y"}, /* 2378 */
  { 58, "$a58"}, /* 2379 */
  { 58, "$a58a59.lo"}, /* 2380 */
  { 58, "$a56a57a58a59.z"}, /* 2381 */
  { 59, "$a59"}, /* 2382 */
  { 59, "$a58a59.hi"}, /* 2383 */
  { 59, "$a56a57a58a59.t"}, /* 2384 */
  { 60, "$a60"}, /* 2385 */
  { 60, "$a60a61.lo"}, /* 2386 */
  { 60, "$a60a61a62a63.x"}, /* 2387 */
  { 61, "$a61"}, /* 2388 */
  { 61, "$a60a61.hi"}, /* 2389 */
  { 61, "$a60a61a62a63.y"}, /* 2390 */
  { 62, "$a62"}, /* 2391 */
  { 62, "$a62a63.lo"}, /* 2392 */
  { 62, "$a60a61a62a63.z"}, /* 2393 */
  { 63, "$a63"}, /* 2394 */
  { 63, "$a62a63.hi"}, /* 2395 */
  { 63, "$a60a61a62a63.t"}, /* 2396 */
};

int kvx_kv3_v1_dec_registers[] = {
  0, /* 0 $r0 */
  3, /* 1 $r1 */
  6, /* 2 $r2 */
  9, /* 3 $r3 */
  12, /* 4 $r4 */
  15, /* 5 $r5 */
  18, /* 6 $r6 */
  21, /* 7 $r7 */
  24, /* 8 $r8 */
  27, /* 9 $r9 */
  30, /* 10 $r10 */
  33, /* 11 $r11 */
  36, /* 12 $r12 */
  38, /* 13 $r13 */
  40, /* 14 $r14 */
  43, /* 15 $r15 */
  46, /* 16 $r16 */
  49, /* 17 $r17 */
  52, /* 18 $r18 */
  55, /* 19 $r19 */
  58, /* 20 $r20 */
  61, /* 21 $r21 */
  64, /* 22 $r22 */
  67, /* 23 $r23 */
  70, /* 24 $r24 */
  73, /* 25 $r25 */
  76, /* 26 $r26 */
  79, /* 27 $r27 */
  82, /* 28 $r28 */
  85, /* 29 $r29 */
  88, /* 30 $r30 */
  91, /* 31 $r31 */
  94, /* 32 $r32 */
  97, /* 33 $r33 */
  100, /* 34 $r34 */
  103, /* 35 $r35 */
  106, /* 36 $r36 */
  109, /* 37 $r37 */
  112, /* 38 $r38 */
  115, /* 39 $r39 */
  118, /* 40 $r40 */
  121, /* 41 $r41 */
  124, /* 42 $r42 */
  127, /* 43 $r43 */
  130, /* 44 $r44 */
  133, /* 45 $r45 */
  136, /* 46 $r46 */
  139, /* 47 $r47 */
  142, /* 48 $r48 */
  145, /* 49 $r49 */
  148, /* 50 $r50 */
  151, /* 51 $r51 */
  154, /* 52 $r52 */
  157, /* 53 $r53 */
  160, /* 54 $r54 */
  163, /* 55 $r55 */
  166, /* 56 $r56 */
  169, /* 57 $r57 */
  172, /* 58 $r58 */
  175, /* 59 $r59 */
  178, /* 60 $r60 */
  181, /* 61 $r61 */
  184, /* 62 $r62 */
  187, /* 63 $r63 */
  190, /* 64 $r0r1 */
  192, /* 65 $r2r3 */
  194, /* 66 $r4r5 */
  196, /* 67 $r6r7 */
  198, /* 68 $r8r9 */
  200, /* 69 $r10r11 */
  202, /* 70 $r12r13 */
  204, /* 71 $r14r15 */
  206, /* 72 $r16r17 */
  208, /* 73 $r18r19 */
  210, /* 74 $r20r21 */
  212, /* 75 $r22r23 */
  214, /* 76 $r24r25 */
  216, /* 77 $r26r27 */
  218, /* 78 $r28r29 */
  220, /* 79 $r30r31 */
  222, /* 80 $r32r33 */
  224, /* 81 $r34r35 */
  226, /* 82 $r36r37 */
  228, /* 83 $r38r39 */
  230, /* 84 $r40r41 */
  232, /* 85 $r42r43 */
  234, /* 86 $r44r45 */
  236, /* 87 $r46r47 */
  238, /* 88 $r48r49 */
  240, /* 89 $r50r51 */
  242, /* 90 $r52r53 */
  244, /* 91 $r54r55 */
  246, /* 92 $r56r57 */
  248, /* 93 $r58r59 */
  250, /* 94 $r60r61 */
  252, /* 95 $r62r63 */
  254, /* 96 $r0r1r2r3 */
  255, /* 97 $r4r5r6r7 */
  256, /* 98 $r8r9r10r11 */
  257, /* 99 $r12r13r14r15 */
  258, /* 100 $r16r17r18r19 */
  259, /* 101 $r20r21r22r23 */
  260, /* 102 $r24r25r26r27 */
  261, /* 103 $r28r29r30r31 */
  262, /* 104 $r32r33r34r35 */
  263, /* 105 $r36r37r38r39 */
  264, /* 106 $r40r41r42r43 */
  265, /* 107 $r44r45r46r47 */
  266, /* 108 $r48r49r50r51 */
  267, /* 109 $r52r53r54r55 */
  268, /* 110 $r56r57r58r59 */
  269, /* 111 $r60r61r62r63 */
  270, /* 112 $pc */
  272, /* 113 $ps */
  274, /* 114 $pcr */
  276, /* 115 $ra */
  278, /* 116 $cs */
  280, /* 117 $csit */
  282, /* 118 $aespc */
  284, /* 119 $ls */
  286, /* 120 $le */
  288, /* 121 $lc */
  290, /* 122 $ipe */
  292, /* 123 $men */
  294, /* 124 $pmc */
  296, /* 125 $pm0 */
  298, /* 126 $pm1 */
  300, /* 127 $pm2 */
  302, /* 128 $pm3 */
  304, /* 129 $pmsa */
  306, /* 130 $tcr */
  308, /* 131 $t0v */
  310, /* 132 $t1v */
  312, /* 133 $t0r */
  314, /* 134 $t1r */
  316, /* 135 $wdv */
  318, /* 136 $wdr */
  320, /* 137 $ile */
  322, /* 138 $ill */
  324, /* 139 $ilr */
  326, /* 140 $mmc */
  328, /* 141 $tel */
  330, /* 142 $teh */
  332, /* 143 $ixc */
  334, /* 144 $syo */
  336, /* 145 $hto */
  338, /* 146 $ito */
  340, /* 147 $do */
  342, /* 148 $mo */
  344, /* 149 $pso */
  346, /* 150 $res38 */
  348, /* 151 $res39 */
  350, /* 152 $dc */
  352, /* 153 $dba0 */
  354, /* 154 $dba1 */
  356, /* 155 $dwa0 */
  358, /* 156 $dwa1 */
  360, /* 157 $mes */
  362, /* 158 $ws */
  364, /* 159 $res47 */
  366, /* 160 $res48 */
  368, /* 161 $res49 */
  370, /* 162 $res50 */
  372, /* 163 $res51 */
  374, /* 164 $res52 */
  376, /* 165 $res53 */
  378, /* 166 $res54 */
  380, /* 167 $res55 */
  382, /* 168 $res56 */
  384, /* 169 $res57 */
  386, /* 170 $res58 */
  388, /* 171 $res59 */
  390, /* 172 $res60 */
  392, /* 173 $res61 */
  394, /* 174 $res62 */
  396, /* 175 $res63 */
  398, /* 176 $spc_pl0 */
  400, /* 177 $spc_pl1 */
  402, /* 178 $spc_pl2 */
  404, /* 179 $spc_pl3 */
  406, /* 180 $sps_pl0 */
  408, /* 181 $sps_pl1 */
  410, /* 182 $sps_pl2 */
  412, /* 183 $sps_pl3 */
  414, /* 184 $ea_pl0 */
  416, /* 185 $ea_pl1 */
  418, /* 186 $ea_pl2 */
  420, /* 187 $ea_pl3 */
  422, /* 188 $ev_pl0 */
  424, /* 189 $ev_pl1 */
  426, /* 190 $ev_pl2 */
  428, /* 191 $ev_pl3 */
  430, /* 192 $sr_pl0 */
  432, /* 193 $sr_pl1 */
  434, /* 194 $sr_pl2 */
  436, /* 195 $sr_pl3 */
  438, /* 196 $es_pl0 */
  440, /* 197 $es_pl1 */
  442, /* 198 $es_pl2 */
  444, /* 199 $es_pl3 */
  446, /* 200 $res88 */
  448, /* 201 $res89 */
  450, /* 202 $res90 */
  452, /* 203 $res91 */
  454, /* 204 $res92 */
  456, /* 205 $res93 */
  458, /* 206 $res94 */
  460, /* 207 $res95 */
  462, /* 208 $syow */
  464, /* 209 $htow */
  466, /* 210 $itow */
  468, /* 211 $dow */
  470, /* 212 $mow */
  472, /* 213 $psow */
  474, /* 214 $res102 */
  476, /* 215 $res103 */
  478, /* 216 $res104 */
  480, /* 217 $res105 */
  482, /* 218 $res106 */
  484, /* 219 $res107 */
  486, /* 220 $res108 */
  488, /* 221 $res109 */
  490, /* 222 $res110 */
  492, /* 223 $res111 */
  494, /* 224 $res112 */
  496, /* 225 $res113 */
  498, /* 226 $res114 */
  500, /* 227 $res115 */
  502, /* 228 $res116 */
  504, /* 229 $res117 */
  506, /* 230 $res118 */
  508, /* 231 $res119 */
  510, /* 232 $res120 */
  512, /* 233 $res121 */
  514, /* 234 $res122 */
  516, /* 235 $res123 */
  518, /* 236 $res124 */
  520, /* 237 $res125 */
  522, /* 238 $res126 */
  524, /* 239 $res127 */
  526, /* 240 $spc */
  528, /* 241 $res129 */
  530, /* 242 $res130 */
  532, /* 243 $res131 */
  534, /* 244 $sps */
  536, /* 245 $res133 */
  538, /* 246 $res134 */
  540, /* 247 $res135 */
  542, /* 248 $ea */
  544, /* 249 $res137 */
  546, /* 250 $res138 */
  548, /* 251 $res139 */
  550, /* 252 $ev */
  552, /* 253 $res141 */
  554, /* 254 $res142 */
  556, /* 255 $res143 */
  558, /* 256 $sr */
  560, /* 257 $res145 */
  562, /* 258 $res146 */
  564, /* 259 $res147 */
  566, /* 260 $es */
  568, /* 261 $res149 */
  570, /* 262 $res150 */
  572, /* 263 $res151 */
  574, /* 264 $res152 */
  576, /* 265 $res153 */
  578, /* 266 $res154 */
  580, /* 267 $res155 */
  582, /* 268 $res156 */
  584, /* 269 $res157 */
  586, /* 270 $res158 */
  588, /* 271 $res159 */
  590, /* 272 $res160 */
  592, /* 273 $res161 */
  594, /* 274 $res162 */
  596, /* 275 $res163 */
  598, /* 276 $res164 */
  600, /* 277 $res165 */
  602, /* 278 $res166 */
  604, /* 279 $res167 */
  606, /* 280 $res168 */
  608, /* 281 $res169 */
  610, /* 282 $res170 */
  612, /* 283 $res171 */
  614, /* 284 $res172 */
  616, /* 285 $res173 */
  618, /* 286 $res174 */
  620, /* 287 $res175 */
  622, /* 288 $res176 */
  624, /* 289 $res177 */
  626, /* 290 $res178 */
  628, /* 291 $res179 */
  630, /* 292 $res180 */
  632, /* 293 $res181 */
  634, /* 294 $res182 */
  636, /* 295 $res183 */
  638, /* 296 $res184 */
  640, /* 297 $res185 */
  642, /* 298 $res186 */
  644, /* 299 $res187 */
  646, /* 300 $res188 */
  648, /* 301 $res189 */
  650, /* 302 $res190 */
  652, /* 303 $res191 */
  654, /* 304 $res192 */
  656, /* 305 $res193 */
  658, /* 306 $res194 */
  660, /* 307 $res195 */
  662, /* 308 $res196 */
  664, /* 309 $res197 */
  666, /* 310 $res198 */
  668, /* 311 $res199 */
  670, /* 312 $res200 */
  672, /* 313 $res201 */
  674, /* 314 $res202 */
  676, /* 315 $res203 */
  678, /* 316 $res204 */
  680, /* 317 $res205 */
  682, /* 318 $res206 */
  684, /* 319 $res207 */
  686, /* 320 $res208 */
  688, /* 321 $res209 */
  690, /* 322 $res210 */
  692, /* 323 $res211 */
  694, /* 324 $res212 */
  696, /* 325 $res213 */
  698, /* 326 $res214 */
  700, /* 327 $res215 */
  702, /* 328 $res216 */
  704, /* 329 $res217 */
  706, /* 330 $res218 */
  708, /* 331 $res219 */
  710, /* 332 $res220 */
  712, /* 333 $res221 */
  714, /* 334 $res222 */
  716, /* 335 $res223 */
  718, /* 336 $res224 */
  720, /* 337 $res225 */
  722, /* 338 $res226 */
  724, /* 339 $res227 */
  726, /* 340 $res228 */
  728, /* 341 $res229 */
  730, /* 342 $res230 */
  732, /* 343 $res231 */
  734, /* 344 $res232 */
  736, /* 345 $res233 */
  738, /* 346 $res234 */
  740, /* 347 $res235 */
  742, /* 348 $res236 */
  744, /* 349 $res237 */
  746, /* 350 $res238 */
  748, /* 351 $res239 */
  750, /* 352 $res240 */
  752, /* 353 $res241 */
  754, /* 354 $res242 */
  756, /* 355 $res243 */
  758, /* 356 $res244 */
  760, /* 357 $res245 */
  762, /* 358 $res246 */
  764, /* 359 $res247 */
  766, /* 360 $res248 */
  768, /* 361 $res249 */
  770, /* 362 $res250 */
  772, /* 363 $res251 */
  774, /* 364 $res252 */
  776, /* 365 $res253 */
  778, /* 366 $res254 */
  780, /* 367 $res255 */
  782, /* 368 $vsfr0 */
  784, /* 369 $vsfr1 */
  786, /* 370 $vsfr2 */
  788, /* 371 $vsfr3 */
  790, /* 372 $vsfr4 */
  792, /* 373 $vsfr5 */
  794, /* 374 $vsfr6 */
  796, /* 375 $vsfr7 */
  798, /* 376 $vsfr8 */
  800, /* 377 $vsfr9 */
  802, /* 378 $vsfr10 */
  804, /* 379 $vsfr11 */
  806, /* 380 $vsfr12 */
  808, /* 381 $vsfr13 */
  810, /* 382 $vsfr14 */
  812, /* 383 $vsfr15 */
  814, /* 384 $vsfr16 */
  816, /* 385 $vsfr17 */
  818, /* 386 $vsfr18 */
  820, /* 387 $vsfr19 */
  822, /* 388 $vsfr20 */
  824, /* 389 $vsfr21 */
  826, /* 390 $vsfr22 */
  828, /* 391 $vsfr23 */
  830, /* 392 $vsfr24 */
  832, /* 393 $vsfr25 */
  834, /* 394 $vsfr26 */
  836, /* 395 $vsfr27 */
  838, /* 396 $vsfr28 */
  840, /* 397 $vsfr29 */
  842, /* 398 $vsfr30 */
  844, /* 399 $vsfr31 */
  846, /* 400 $vsfr32 */
  848, /* 401 $vsfr33 */
  850, /* 402 $vsfr34 */
  852, /* 403 $vsfr35 */
  854, /* 404 $vsfr36 */
  856, /* 405 $vsfr37 */
  858, /* 406 $vsfr38 */
  860, /* 407 $vsfr39 */
  862, /* 408 $vsfr40 */
  864, /* 409 $vsfr41 */
  866, /* 410 $vsfr42 */
  868, /* 411 $vsfr43 */
  870, /* 412 $vsfr44 */
  872, /* 413 $vsfr45 */
  874, /* 414 $vsfr46 */
  876, /* 415 $vsfr47 */
  878, /* 416 $vsfr48 */
  880, /* 417 $vsfr49 */
  882, /* 418 $vsfr50 */
  884, /* 419 $vsfr51 */
  886, /* 420 $vsfr52 */
  888, /* 421 $vsfr53 */
  890, /* 422 $vsfr54 */
  892, /* 423 $vsfr55 */
  894, /* 424 $vsfr56 */
  896, /* 425 $vsfr57 */
  898, /* 426 $vsfr58 */
  900, /* 427 $vsfr59 */
  902, /* 428 $vsfr60 */
  904, /* 429 $vsfr61 */
  906, /* 430 $vsfr62 */
  908, /* 431 $vsfr63 */
  910, /* 432 $vsfr64 */
  912, /* 433 $vsfr65 */
  914, /* 434 $vsfr66 */
  916, /* 435 $vsfr67 */
  918, /* 436 $vsfr68 */
  920, /* 437 $vsfr69 */
  922, /* 438 $vsfr70 */
  924, /* 439 $vsfr71 */
  926, /* 440 $vsfr72 */
  928, /* 441 $vsfr73 */
  930, /* 442 $vsfr74 */
  932, /* 443 $vsfr75 */
  934, /* 444 $vsfr76 */
  936, /* 445 $vsfr77 */
  938, /* 446 $vsfr78 */
  940, /* 447 $vsfr79 */
  942, /* 448 $vsfr80 */
  944, /* 449 $vsfr81 */
  946, /* 450 $vsfr82 */
  948, /* 451 $vsfr83 */
  950, /* 452 $vsfr84 */
  952, /* 453 $vsfr85 */
  954, /* 454 $vsfr86 */
  956, /* 455 $vsfr87 */
  958, /* 456 $vsfr88 */
  960, /* 457 $vsfr89 */
  962, /* 458 $vsfr90 */
  964, /* 459 $vsfr91 */
  966, /* 460 $vsfr92 */
  968, /* 461 $vsfr93 */
  970, /* 462 $vsfr94 */
  972, /* 463 $vsfr95 */
  974, /* 464 $vsfr96 */
  976, /* 465 $vsfr97 */
  978, /* 466 $vsfr98 */
  980, /* 467 $vsfr99 */
  982, /* 468 $vsfr100 */
  984, /* 469 $vsfr101 */
  986, /* 470 $vsfr102 */
  988, /* 471 $vsfr103 */
  990, /* 472 $vsfr104 */
  992, /* 473 $vsfr105 */
  994, /* 474 $vsfr106 */
  996, /* 475 $vsfr107 */
  998, /* 476 $vsfr108 */
  1000, /* 477 $vsfr109 */
  1002, /* 478 $vsfr110 */
  1004, /* 479 $vsfr111 */
  1006, /* 480 $vsfr112 */
  1008, /* 481 $vsfr113 */
  1010, /* 482 $vsfr114 */
  1012, /* 483 $vsfr115 */
  1014, /* 484 $vsfr116 */
  1016, /* 485 $vsfr117 */
  1018, /* 486 $vsfr118 */
  1020, /* 487 $vsfr119 */
  1022, /* 488 $vsfr120 */
  1024, /* 489 $vsfr121 */
  1026, /* 490 $vsfr122 */
  1028, /* 491 $vsfr123 */
  1030, /* 492 $vsfr124 */
  1032, /* 493 $vsfr125 */
  1034, /* 494 $vsfr126 */
  1036, /* 495 $vsfr127 */
  1038, /* 496 $vsfr128 */
  1040, /* 497 $vsfr129 */
  1042, /* 498 $vsfr130 */
  1044, /* 499 $vsfr131 */
  1046, /* 500 $vsfr132 */
  1048, /* 501 $vsfr133 */
  1050, /* 502 $vsfr134 */
  1052, /* 503 $vsfr135 */
  1054, /* 504 $vsfr136 */
  1056, /* 505 $vsfr137 */
  1058, /* 506 $vsfr138 */
  1060, /* 507 $vsfr139 */
  1062, /* 508 $vsfr140 */
  1064, /* 509 $vsfr141 */
  1066, /* 510 $vsfr142 */
  1068, /* 511 $vsfr143 */
  1070, /* 512 $vsfr144 */
  1072, /* 513 $vsfr145 */
  1074, /* 514 $vsfr146 */
  1076, /* 515 $vsfr147 */
  1078, /* 516 $vsfr148 */
  1080, /* 517 $vsfr149 */
  1082, /* 518 $vsfr150 */
  1084, /* 519 $vsfr151 */
  1086, /* 520 $vsfr152 */
  1088, /* 521 $vsfr153 */
  1090, /* 522 $vsfr154 */
  1092, /* 523 $vsfr155 */
  1094, /* 524 $vsfr156 */
  1096, /* 525 $vsfr157 */
  1098, /* 526 $vsfr158 */
  1100, /* 527 $vsfr159 */
  1102, /* 528 $vsfr160 */
  1104, /* 529 $vsfr161 */
  1106, /* 530 $vsfr162 */
  1108, /* 531 $vsfr163 */
  1110, /* 532 $vsfr164 */
  1112, /* 533 $vsfr165 */
  1114, /* 534 $vsfr166 */
  1116, /* 535 $vsfr167 */
  1118, /* 536 $vsfr168 */
  1120, /* 537 $vsfr169 */
  1122, /* 538 $vsfr170 */
  1124, /* 539 $vsfr171 */
  1126, /* 540 $vsfr172 */
  1128, /* 541 $vsfr173 */
  1130, /* 542 $vsfr174 */
  1132, /* 543 $vsfr175 */
  1134, /* 544 $vsfr176 */
  1136, /* 545 $vsfr177 */
  1138, /* 546 $vsfr178 */
  1140, /* 547 $vsfr179 */
  1142, /* 548 $vsfr180 */
  1144, /* 549 $vsfr181 */
  1146, /* 550 $vsfr182 */
  1148, /* 551 $vsfr183 */
  1150, /* 552 $vsfr184 */
  1152, /* 553 $vsfr185 */
  1154, /* 554 $vsfr186 */
  1156, /* 555 $vsfr187 */
  1158, /* 556 $vsfr188 */
  1160, /* 557 $vsfr189 */
  1162, /* 558 $vsfr190 */
  1164, /* 559 $vsfr191 */
  1166, /* 560 $vsfr192 */
  1168, /* 561 $vsfr193 */
  1170, /* 562 $vsfr194 */
  1172, /* 563 $vsfr195 */
  1174, /* 564 $vsfr196 */
  1176, /* 565 $vsfr197 */
  1178, /* 566 $vsfr198 */
  1180, /* 567 $vsfr199 */
  1182, /* 568 $vsfr200 */
  1184, /* 569 $vsfr201 */
  1186, /* 570 $vsfr202 */
  1188, /* 571 $vsfr203 */
  1190, /* 572 $vsfr204 */
  1192, /* 573 $vsfr205 */
  1194, /* 574 $vsfr206 */
  1196, /* 575 $vsfr207 */
  1198, /* 576 $vsfr208 */
  1200, /* 577 $vsfr209 */
  1202, /* 578 $vsfr210 */
  1204, /* 579 $vsfr211 */
  1206, /* 580 $vsfr212 */
  1208, /* 581 $vsfr213 */
  1210, /* 582 $vsfr214 */
  1212, /* 583 $vsfr215 */
  1214, /* 584 $vsfr216 */
  1216, /* 585 $vsfr217 */
  1218, /* 586 $vsfr218 */
  1220, /* 587 $vsfr219 */
  1222, /* 588 $vsfr220 */
  1224, /* 589 $vsfr221 */
  1226, /* 590 $vsfr222 */
  1228, /* 591 $vsfr223 */
  1230, /* 592 $vsfr224 */
  1232, /* 593 $vsfr225 */
  1234, /* 594 $vsfr226 */
  1236, /* 595 $vsfr227 */
  1238, /* 596 $vsfr228 */
  1240, /* 597 $vsfr229 */
  1242, /* 598 $vsfr230 */
  1244, /* 599 $vsfr231 */
  1246, /* 600 $vsfr232 */
  1248, /* 601 $vsfr233 */
  1250, /* 602 $vsfr234 */
  1252, /* 603 $vsfr235 */
  1254, /* 604 $vsfr236 */
  1256, /* 605 $vsfr237 */
  1258, /* 606 $vsfr238 */
  1260, /* 607 $vsfr239 */
  1262, /* 608 $vsfr240 */
  1264, /* 609 $vsfr241 */
  1266, /* 610 $vsfr242 */
  1268, /* 611 $vsfr243 */
  1270, /* 612 $vsfr244 */
  1272, /* 613 $vsfr245 */
  1274, /* 614 $vsfr246 */
  1276, /* 615 $vsfr247 */
  1278, /* 616 $vsfr248 */
  1280, /* 617 $vsfr249 */
  1282, /* 618 $vsfr250 */
  1284, /* 619 $vsfr251 */
  1286, /* 620 $vsfr252 */
  1288, /* 621 $vsfr253 */
  1290, /* 622 $vsfr254 */
  1292, /* 623 $vsfr255 */
  1294, /* 624 $a0..a15 */
  1295, /* 625 $a16..a31 */
  1296, /* 626 $a32..a47 */
  1297, /* 627 $a48..a63 */
  1298, /* 628 $a0..a1 */
  1299, /* 629 $a2..a3 */
  1300, /* 630 $a4..a5 */
  1301, /* 631 $a6..a7 */
  1302, /* 632 $a8..a9 */
  1303, /* 633 $a10..a11 */
  1304, /* 634 $a12..a13 */
  1305, /* 635 $a14..a15 */
  1306, /* 636 $a16..a17 */
  1307, /* 637 $a18..a19 */
  1308, /* 638 $a20..a21 */
  1309, /* 639 $a22..a23 */
  1310, /* 640 $a24..a25 */
  1311, /* 641 $a26..a27 */
  1312, /* 642 $a28..a29 */
  1313, /* 643 $a30..a31 */
  1314, /* 644 $a32..a33 */
  1315, /* 645 $a34..a35 */
  1316, /* 646 $a36..a37 */
  1317, /* 647 $a38..a39 */
  1318, /* 648 $a40..a41 */
  1319, /* 649 $a42..a43 */
  1320, /* 650 $a44..a45 */
  1321, /* 651 $a46..a47 */
  1322, /* 652 $a48..a49 */
  1323, /* 653 $a50..a51 */
  1324, /* 654 $a52..a53 */
  1325, /* 655 $a54..a55 */
  1326, /* 656 $a56..a57 */
  1327, /* 657 $a58..a59 */
  1328, /* 658 $a60..a61 */
  1329, /* 659 $a62..a63 */
  1330, /* 660 $a0..a31 */
  1331, /* 661 $a32..a63 */
  1332, /* 662 $a0..a3 */
  1333, /* 663 $a4..a7 */
  1334, /* 664 $a8..a11 */
  1335, /* 665 $a12..a15 */
  1336, /* 666 $a16..a19 */
  1337, /* 667 $a20..a23 */
  1338, /* 668 $a24..a27 */
  1339, /* 669 $a28..a31 */
  1340, /* 670 $a32..a35 */
  1341, /* 671 $a36..a39 */
  1342, /* 672 $a40..a43 */
  1343, /* 673 $a44..a47 */
  1344, /* 674 $a48..a51 */
  1345, /* 675 $a52..a55 */
  1346, /* 676 $a56..a59 */
  1347, /* 677 $a60..a63 */
  1348, /* 678 $a0..a63 */
  1349, /* 679 $a0..a7 */
  1350, /* 680 $a8..a15 */
  1351, /* 681 $a16..a23 */
  1352, /* 682 $a24..a31 */
  1353, /* 683 $a32..a39 */
  1354, /* 684 $a40..a47 */
  1355, /* 685 $a48..a55 */
  1356, /* 686 $a56..a63 */
  1357, /* 687 $a0_lo */
  1359, /* 688 $a0_hi */
  1361, /* 689 $a1_lo */
  1363, /* 690 $a1_hi */
  1365, /* 691 $a2_lo */
  1367, /* 692 $a2_hi */
  1369, /* 693 $a3_lo */
  1371, /* 694 $a3_hi */
  1373, /* 695 $a4_lo */
  1375, /* 696 $a4_hi */
  1377, /* 697 $a5_lo */
  1379, /* 698 $a5_hi */
  1381, /* 699 $a6_lo */
  1383, /* 700 $a6_hi */
  1385, /* 701 $a7_lo */
  1387, /* 702 $a7_hi */
  1389, /* 703 $a8_lo */
  1391, /* 704 $a8_hi */
  1393, /* 705 $a9_lo */
  1395, /* 706 $a9_hi */
  1397, /* 707 $a10_lo */
  1399, /* 708 $a10_hi */
  1401, /* 709 $a11_lo */
  1403, /* 710 $a11_hi */
  1405, /* 711 $a12_lo */
  1407, /* 712 $a12_hi */
  1409, /* 713 $a13_lo */
  1411, /* 714 $a13_hi */
  1413, /* 715 $a14_lo */
  1415, /* 716 $a14_hi */
  1417, /* 717 $a15_lo */
  1419, /* 718 $a15_hi */
  1421, /* 719 $a16_lo */
  1423, /* 720 $a16_hi */
  1425, /* 721 $a17_lo */
  1427, /* 722 $a17_hi */
  1429, /* 723 $a18_lo */
  1431, /* 724 $a18_hi */
  1433, /* 725 $a19_lo */
  1435, /* 726 $a19_hi */
  1437, /* 727 $a20_lo */
  1439, /* 728 $a20_hi */
  1441, /* 729 $a21_lo */
  1443, /* 730 $a21_hi */
  1445, /* 731 $a22_lo */
  1447, /* 732 $a22_hi */
  1449, /* 733 $a23_lo */
  1451, /* 734 $a23_hi */
  1453, /* 735 $a24_lo */
  1455, /* 736 $a24_hi */
  1457, /* 737 $a25_lo */
  1459, /* 738 $a25_hi */
  1461, /* 739 $a26_lo */
  1463, /* 740 $a26_hi */
  1465, /* 741 $a27_lo */
  1467, /* 742 $a27_hi */
  1469, /* 743 $a28_lo */
  1471, /* 744 $a28_hi */
  1473, /* 745 $a29_lo */
  1475, /* 746 $a29_hi */
  1477, /* 747 $a30_lo */
  1479, /* 748 $a30_hi */
  1481, /* 749 $a31_lo */
  1483, /* 750 $a31_hi */
  1485, /* 751 $a32_lo */
  1487, /* 752 $a32_hi */
  1489, /* 753 $a33_lo */
  1491, /* 754 $a33_hi */
  1493, /* 755 $a34_lo */
  1495, /* 756 $a34_hi */
  1497, /* 757 $a35_lo */
  1499, /* 758 $a35_hi */
  1501, /* 759 $a36_lo */
  1503, /* 760 $a36_hi */
  1505, /* 761 $a37_lo */
  1507, /* 762 $a37_hi */
  1509, /* 763 $a38_lo */
  1511, /* 764 $a38_hi */
  1513, /* 765 $a39_lo */
  1515, /* 766 $a39_hi */
  1517, /* 767 $a40_lo */
  1519, /* 768 $a40_hi */
  1521, /* 769 $a41_lo */
  1523, /* 770 $a41_hi */
  1525, /* 771 $a42_lo */
  1527, /* 772 $a42_hi */
  1529, /* 773 $a43_lo */
  1531, /* 774 $a43_hi */
  1533, /* 775 $a44_lo */
  1535, /* 776 $a44_hi */
  1537, /* 777 $a45_lo */
  1539, /* 778 $a45_hi */
  1541, /* 779 $a46_lo */
  1543, /* 780 $a46_hi */
  1545, /* 781 $a47_lo */
  1547, /* 782 $a47_hi */
  1549, /* 783 $a48_lo */
  1551, /* 784 $a48_hi */
  1553, /* 785 $a49_lo */
  1555, /* 786 $a49_hi */
  1557, /* 787 $a50_lo */
  1559, /* 788 $a50_hi */
  1561, /* 789 $a51_lo */
  1563, /* 790 $a51_hi */
  1565, /* 791 $a52_lo */
  1567, /* 792 $a52_hi */
  1569, /* 793 $a53_lo */
  1571, /* 794 $a53_hi */
  1573, /* 795 $a54_lo */
  1575, /* 796 $a54_hi */
  1577, /* 797 $a55_lo */
  1579, /* 798 $a55_hi */
  1581, /* 799 $a56_lo */
  1583, /* 800 $a56_hi */
  1585, /* 801 $a57_lo */
  1587, /* 802 $a57_hi */
  1589, /* 803 $a58_lo */
  1591, /* 804 $a58_hi */
  1593, /* 805 $a59_lo */
  1595, /* 806 $a59_hi */
  1597, /* 807 $a60_lo */
  1599, /* 808 $a60_hi */
  1601, /* 809 $a61_lo */
  1603, /* 810 $a61_hi */
  1605, /* 811 $a62_lo */
  1607, /* 812 $a62_hi */
  1609, /* 813 $a63_lo */
  1611, /* 814 $a63_hi */
  1613, /* 815 $a0_x */
  1615, /* 816 $a0_y */
  1617, /* 817 $a0_z */
  1619, /* 818 $a0_t */
  1621, /* 819 $a1_x */
  1623, /* 820 $a1_y */
  1625, /* 821 $a1_z */
  1627, /* 822 $a1_t */
  1629, /* 823 $a2_x */
  1631, /* 824 $a2_y */
  1633, /* 825 $a2_z */
  1635, /* 826 $a2_t */
  1637, /* 827 $a3_x */
  1639, /* 828 $a3_y */
  1641, /* 829 $a3_z */
  1643, /* 830 $a3_t */
  1645, /* 831 $a4_x */
  1647, /* 832 $a4_y */
  1649, /* 833 $a4_z */
  1651, /* 834 $a4_t */
  1653, /* 835 $a5_x */
  1655, /* 836 $a5_y */
  1657, /* 837 $a5_z */
  1659, /* 838 $a5_t */
  1661, /* 839 $a6_x */
  1663, /* 840 $a6_y */
  1665, /* 841 $a6_z */
  1667, /* 842 $a6_t */
  1669, /* 843 $a7_x */
  1671, /* 844 $a7_y */
  1673, /* 845 $a7_z */
  1675, /* 846 $a7_t */
  1677, /* 847 $a8_x */
  1679, /* 848 $a8_y */
  1681, /* 849 $a8_z */
  1683, /* 850 $a8_t */
  1685, /* 851 $a9_x */
  1687, /* 852 $a9_y */
  1689, /* 853 $a9_z */
  1691, /* 854 $a9_t */
  1693, /* 855 $a10_x */
  1695, /* 856 $a10_y */
  1697, /* 857 $a10_z */
  1699, /* 858 $a10_t */
  1701, /* 859 $a11_x */
  1703, /* 860 $a11_y */
  1705, /* 861 $a11_z */
  1707, /* 862 $a11_t */
  1709, /* 863 $a12_x */
  1711, /* 864 $a12_y */
  1713, /* 865 $a12_z */
  1715, /* 866 $a12_t */
  1717, /* 867 $a13_x */
  1719, /* 868 $a13_y */
  1721, /* 869 $a13_z */
  1723, /* 870 $a13_t */
  1725, /* 871 $a14_x */
  1727, /* 872 $a14_y */
  1729, /* 873 $a14_z */
  1731, /* 874 $a14_t */
  1733, /* 875 $a15_x */
  1735, /* 876 $a15_y */
  1737, /* 877 $a15_z */
  1739, /* 878 $a15_t */
  1741, /* 879 $a16_x */
  1743, /* 880 $a16_y */
  1745, /* 881 $a16_z */
  1747, /* 882 $a16_t */
  1749, /* 883 $a17_x */
  1751, /* 884 $a17_y */
  1753, /* 885 $a17_z */
  1755, /* 886 $a17_t */
  1757, /* 887 $a18_x */
  1759, /* 888 $a18_y */
  1761, /* 889 $a18_z */
  1763, /* 890 $a18_t */
  1765, /* 891 $a19_x */
  1767, /* 892 $a19_y */
  1769, /* 893 $a19_z */
  1771, /* 894 $a19_t */
  1773, /* 895 $a20_x */
  1775, /* 896 $a20_y */
  1777, /* 897 $a20_z */
  1779, /* 898 $a20_t */
  1781, /* 899 $a21_x */
  1783, /* 900 $a21_y */
  1785, /* 901 $a21_z */
  1787, /* 902 $a21_t */
  1789, /* 903 $a22_x */
  1791, /* 904 $a22_y */
  1793, /* 905 $a22_z */
  1795, /* 906 $a22_t */
  1797, /* 907 $a23_x */
  1799, /* 908 $a23_y */
  1801, /* 909 $a23_z */
  1803, /* 910 $a23_t */
  1805, /* 911 $a24_x */
  1807, /* 912 $a24_y */
  1809, /* 913 $a24_z */
  1811, /* 914 $a24_t */
  1813, /* 915 $a25_x */
  1815, /* 916 $a25_y */
  1817, /* 917 $a25_z */
  1819, /* 918 $a25_t */
  1821, /* 919 $a26_x */
  1823, /* 920 $a26_y */
  1825, /* 921 $a26_z */
  1827, /* 922 $a26_t */
  1829, /* 923 $a27_x */
  1831, /* 924 $a27_y */
  1833, /* 925 $a27_z */
  1835, /* 926 $a27_t */
  1837, /* 927 $a28_x */
  1839, /* 928 $a28_y */
  1841, /* 929 $a28_z */
  1843, /* 930 $a28_t */
  1845, /* 931 $a29_x */
  1847, /* 932 $a29_y */
  1849, /* 933 $a29_z */
  1851, /* 934 $a29_t */
  1853, /* 935 $a30_x */
  1855, /* 936 $a30_y */
  1857, /* 937 $a30_z */
  1859, /* 938 $a30_t */
  1861, /* 939 $a31_x */
  1863, /* 940 $a31_y */
  1865, /* 941 $a31_z */
  1867, /* 942 $a31_t */
  1869, /* 943 $a32_x */
  1871, /* 944 $a32_y */
  1873, /* 945 $a32_z */
  1875, /* 946 $a32_t */
  1877, /* 947 $a33_x */
  1879, /* 948 $a33_y */
  1881, /* 949 $a33_z */
  1883, /* 950 $a33_t */
  1885, /* 951 $a34_x */
  1887, /* 952 $a34_y */
  1889, /* 953 $a34_z */
  1891, /* 954 $a34_t */
  1893, /* 955 $a35_x */
  1895, /* 956 $a35_y */
  1897, /* 957 $a35_z */
  1899, /* 958 $a35_t */
  1901, /* 959 $a36_x */
  1903, /* 960 $a36_y */
  1905, /* 961 $a36_z */
  1907, /* 962 $a36_t */
  1909, /* 963 $a37_x */
  1911, /* 964 $a37_y */
  1913, /* 965 $a37_z */
  1915, /* 966 $a37_t */
  1917, /* 967 $a38_x */
  1919, /* 968 $a38_y */
  1921, /* 969 $a38_z */
  1923, /* 970 $a38_t */
  1925, /* 971 $a39_x */
  1927, /* 972 $a39_y */
  1929, /* 973 $a39_z */
  1931, /* 974 $a39_t */
  1933, /* 975 $a40_x */
  1935, /* 976 $a40_y */
  1937, /* 977 $a40_z */
  1939, /* 978 $a40_t */
  1941, /* 979 $a41_x */
  1943, /* 980 $a41_y */
  1945, /* 981 $a41_z */
  1947, /* 982 $a41_t */
  1949, /* 983 $a42_x */
  1951, /* 984 $a42_y */
  1953, /* 985 $a42_z */
  1955, /* 986 $a42_t */
  1957, /* 987 $a43_x */
  1959, /* 988 $a43_y */
  1961, /* 989 $a43_z */
  1963, /* 990 $a43_t */
  1965, /* 991 $a44_x */
  1967, /* 992 $a44_y */
  1969, /* 993 $a44_z */
  1971, /* 994 $a44_t */
  1973, /* 995 $a45_x */
  1975, /* 996 $a45_y */
  1977, /* 997 $a45_z */
  1979, /* 998 $a45_t */
  1981, /* 999 $a46_x */
  1983, /* 1000 $a46_y */
  1985, /* 1001 $a46_z */
  1987, /* 1002 $a46_t */
  1989, /* 1003 $a47_x */
  1991, /* 1004 $a47_y */
  1993, /* 1005 $a47_z */
  1995, /* 1006 $a47_t */
  1997, /* 1007 $a48_x */
  1999, /* 1008 $a48_y */
  2001, /* 1009 $a48_z */
  2003, /* 1010 $a48_t */
  2005, /* 1011 $a49_x */
  2007, /* 1012 $a49_y */
  2009, /* 1013 $a49_z */
  2011, /* 1014 $a49_t */
  2013, /* 1015 $a50_x */
  2015, /* 1016 $a50_y */
  2017, /* 1017 $a50_z */
  2019, /* 1018 $a50_t */
  2021, /* 1019 $a51_x */
  2023, /* 1020 $a51_y */
  2025, /* 1021 $a51_z */
  2027, /* 1022 $a51_t */
  2029, /* 1023 $a52_x */
  2031, /* 1024 $a52_y */
  2033, /* 1025 $a52_z */
  2035, /* 1026 $a52_t */
  2037, /* 1027 $a53_x */
  2039, /* 1028 $a53_y */
  2041, /* 1029 $a53_z */
  2043, /* 1030 $a53_t */
  2045, /* 1031 $a54_x */
  2047, /* 1032 $a54_y */
  2049, /* 1033 $a54_z */
  2051, /* 1034 $a54_t */
  2053, /* 1035 $a55_x */
  2055, /* 1036 $a55_y */
  2057, /* 1037 $a55_z */
  2059, /* 1038 $a55_t */
  2061, /* 1039 $a56_x */
  2063, /* 1040 $a56_y */
  2065, /* 1041 $a56_z */
  2067, /* 1042 $a56_t */
  2069, /* 1043 $a57_x */
  2071, /* 1044 $a57_y */
  2073, /* 1045 $a57_z */
  2075, /* 1046 $a57_t */
  2077, /* 1047 $a58_x */
  2079, /* 1048 $a58_y */
  2081, /* 1049 $a58_z */
  2083, /* 1050 $a58_t */
  2085, /* 1051 $a59_x */
  2087, /* 1052 $a59_y */
  2089, /* 1053 $a59_z */
  2091, /* 1054 $a59_t */
  2093, /* 1055 $a60_x */
  2095, /* 1056 $a60_y */
  2097, /* 1057 $a60_z */
  2099, /* 1058 $a60_t */
  2101, /* 1059 $a61_x */
  2103, /* 1060 $a61_y */
  2105, /* 1061 $a61_z */
  2107, /* 1062 $a61_t */
  2109, /* 1063 $a62_x */
  2111, /* 1064 $a62_y */
  2113, /* 1065 $a62_z */
  2115, /* 1066 $a62_t */
  2117, /* 1067 $a63_x */
  2119, /* 1068 $a63_y */
  2121, /* 1069 $a63_z */
  2123, /* 1070 $a63_t */
  2125, /* 1071 $a0a1a2a3 */
  2126, /* 1072 $a4a5a6a7 */
  2127, /* 1073 $a8a9a10a11 */
  2128, /* 1074 $a12a13a14a15 */
  2129, /* 1075 $a16a17a18a19 */
  2130, /* 1076 $a20a21a22a23 */
  2131, /* 1077 $a24a25a26a27 */
  2132, /* 1078 $a28a29a30a31 */
  2133, /* 1079 $a32a33a34a35 */
  2134, /* 1080 $a36a37a38a39 */
  2135, /* 1081 $a40a41a42a43 */
  2136, /* 1082 $a44a45a46a47 */
  2137, /* 1083 $a48a49a50a51 */
  2138, /* 1084 $a52a53a54a55 */
  2139, /* 1085 $a56a57a58a59 */
  2140, /* 1086 $a60a61a62a63 */
  2141, /* 1087 $a0a1 */
  2143, /* 1088 $a2a3 */
  2145, /* 1089 $a4a5 */
  2147, /* 1090 $a6a7 */
  2149, /* 1091 $a8a9 */
  2151, /* 1092 $a10a11 */
  2153, /* 1093 $a12a13 */
  2155, /* 1094 $a14a15 */
  2157, /* 1095 $a16a17 */
  2159, /* 1096 $a18a19 */
  2161, /* 1097 $a20a21 */
  2163, /* 1098 $a22a23 */
  2165, /* 1099 $a24a25 */
  2167, /* 1100 $a26a27 */
  2169, /* 1101 $a28a29 */
  2171, /* 1102 $a30a31 */
  2173, /* 1103 $a32a33 */
  2175, /* 1104 $a34a35 */
  2177, /* 1105 $a36a37 */
  2179, /* 1106 $a38a39 */
  2181, /* 1107 $a40a41 */
  2183, /* 1108 $a42a43 */
  2185, /* 1109 $a44a45 */
  2187, /* 1110 $a46a47 */
  2189, /* 1111 $a48a49 */
  2191, /* 1112 $a50a51 */
  2193, /* 1113 $a52a53 */
  2195, /* 1114 $a54a55 */
  2197, /* 1115 $a56a57 */
  2199, /* 1116 $a58a59 */
  2201, /* 1117 $a60a61 */
  2203, /* 1118 $a62a63 */
  2205, /* 1119 $a0 */
  2208, /* 1120 $a1 */
  2211, /* 1121 $a2 */
  2214, /* 1122 $a3 */
  2217, /* 1123 $a4 */
  2220, /* 1124 $a5 */
  2223, /* 1125 $a6 */
  2226, /* 1126 $a7 */
  2229, /* 1127 $a8 */
  2232, /* 1128 $a9 */
  2235, /* 1129 $a10 */
  2238, /* 1130 $a11 */
  2241, /* 1131 $a12 */
  2244, /* 1132 $a13 */
  2247, /* 1133 $a14 */
  2250, /* 1134 $a15 */
  2253, /* 1135 $a16 */
  2256, /* 1136 $a17 */
  2259, /* 1137 $a18 */
  2262, /* 1138 $a19 */
  2265, /* 1139 $a20 */
  2268, /* 1140 $a21 */
  2271, /* 1141 $a22 */
  2274, /* 1142 $a23 */
  2277, /* 1143 $a24 */
  2280, /* 1144 $a25 */
  2283, /* 1145 $a26 */
  2286, /* 1146 $a27 */
  2289, /* 1147 $a28 */
  2292, /* 1148 $a29 */
  2295, /* 1149 $a30 */
  2298, /* 1150 $a31 */
  2301, /* 1151 $a32 */
  2304, /* 1152 $a33 */
  2307, /* 1153 $a34 */
  2310, /* 1154 $a35 */
  2313, /* 1155 $a36 */
  2316, /* 1156 $a37 */
  2319, /* 1157 $a38 */
  2322, /* 1158 $a39 */
  2325, /* 1159 $a40 */
  2328, /* 1160 $a41 */
  2331, /* 1161 $a42 */
  2334, /* 1162 $a43 */
  2337, /* 1163 $a44 */
  2340, /* 1164 $a45 */
  2343, /* 1165 $a46 */
  2346, /* 1166 $a47 */
  2349, /* 1167 $a48 */
  2352, /* 1168 $a49 */
  2355, /* 1169 $a50 */
  2358, /* 1170 $a51 */
  2361, /* 1171 $a52 */
  2364, /* 1172 $a53 */
  2367, /* 1173 $a54 */
  2370, /* 1174 $a55 */
  2373, /* 1175 $a56 */
  2376, /* 1176 $a57 */
  2379, /* 1177 $a58 */
  2382, /* 1178 $a59 */
  2385, /* 1179 $a60 */
  2388, /* 1180 $a61 */
  2391, /* 1181 $a62 */
  2394, /* 1182 $a63 */
};

const char *mod_kv3_v1_exunum[] = {
  "alu0",
  "alu1",
  "mau",
  "lsu",
  NULL,
};

const char *mod_kv3_v1_scalarcond[] = {
  ".dnez",
  ".deqz",
  ".dltz",
  ".dgez",
  ".dlez",
  ".dgtz",
  ".odd",
  ".even",
  ".wnez",
  ".weqz",
  ".wltz",
  ".wgez",
  ".wlez",
  ".wgtz",
  NULL,
};

const char *mod_kv3_v1_simplecond[] = {
  ".nez",
  ".eqz",
  ".ltz",
  ".gez",
  ".lez",
  ".gtz",
  ".odd",
  ".even",
  NULL,
};

const char *mod_kv3_v1_comparison[] = {
  ".ne",
  ".eq",
  ".lt",
  ".ge",
  ".le",
  ".gt",
  ".ltu",
  ".geu",
  ".leu",
  ".gtu",
  ".all",
  ".nall",
  ".any",
  ".none",
  NULL,
};

const char *mod_kv3_v1_floatcomp[] = {
  ".one",
  ".ueq",
  ".oeq",
  ".une",
  ".olt",
  ".uge",
  ".oge",
  ".ult",
  NULL,
};

const char *mod_kv3_v1_rounding[] = {
  ".rn",
  ".ru",
  ".rd",
  ".rz",
  ".rna",
  ".rnz",
  ".ro",
  ".",
  NULL,
};

const char *mod_kv3_v1_silent[] = {
  ".",
  ".s",
  NULL,
};

const char *mod_kv3_v1_roundint[] = {
  ".rn",
  ".ru",
  ".rd",
  ".rz",
  ".rhu",
  NULL,
};

const char *mod_kv3_v1_saturate[] = {
  ".sat",
  ".satu",
  NULL,
};

const char *mod_kv3_v1_rectify[] = {
  ".",
  ".relu",
  NULL,
};

const char *mod_kv3_v1_variant[] = {
  ".",
  ".s",
  ".u",
  ".us",
  NULL,
};

const char *mod_kv3_v1_speculate[] = {
  ".u",
  ".us",
  NULL,
};

const char *mod_kv3_v1_column[] = {
  ".c0",
  ".c1",
  ".c2",
  ".c3",
  NULL,
};

const char *mod_kv3_v1_doscale[] = {
  ".",
  ".xs",
  NULL,
};

const char *mod_kv3_v1_qindex[] = {
  ".q0",
  ".q1",
  ".q2",
  ".q3",
  NULL,
};

const char *mod_kv3_v1_splat32[] = {
  ".",
  ".@",
  NULL,
};

const char **kvx_kv3_v1_modifiers[] = {
  mod_kv3_v1_column,
  mod_kv3_v1_comparison,
  mod_kv3_v1_doscale,
  mod_kv3_v1_exunum,
  mod_kv3_v1_floatcomp,
  mod_kv3_v1_qindex,
  mod_kv3_v1_rectify,
  mod_kv3_v1_rounding,
  mod_kv3_v1_roundint,
  mod_kv3_v1_saturate,
  mod_kv3_v1_scalarcond,
  mod_kv3_v1_silent,
  mod_kv3_v1_simplecond,
  mod_kv3_v1_speculate,
  mod_kv3_v1_splat32,
  mod_kv3_v1_variant
};

struct pseudo_func kvx_kv3_v1_pseudo_func[] = {
  // reloc pseudo functions:
  {
    .name = "signed32",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 32,
      .reloc_type = S32_LO5_UP27,
      .reloc_lo5 = BFD_RELOC_KVX_S32_LO5,
      .reloc_up27 = BFD_RELOC_KVX_S32_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_signed32_reloc,
    }
  },
  {
    .name = "gotoff",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_GOTOFF_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_GOTOFF_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_gotoff_signed37_reloc,
    }
  },
  {
    .name = "gotoff",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_32_ONLY,
      .bitsize = 32,
      .reloc_type = S32,
      .single = BFD_RELOC_KVX_32_GOTOFF,
      .kreloc = & kv3_v1_gotoff_32_reloc,
    }
  },
  {
    .name = "got",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_GOT_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_GOT_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_got_signed37_reloc,
    }
  },
  {
    .name = "got",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_32_ONLY,
      .bitsize = 32,
      .reloc_type = S32,
      .single = BFD_RELOC_KVX_32_GOT,
      .kreloc = & kv3_v1_got_32_reloc,
    }
  },
  {
    .name = "tlsgd",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_TLS_GD_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_TLS_GD_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsgd_signed37_reloc,
    }
  },
  {
    .name = "tlsgd",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_TLS_GD_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_TLS_GD_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_TLS_GD_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsgd_signed43_reloc,
    }
  },
  {
    .name = "tlsle",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_TLS_LE_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_TLS_LE_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsle_signed37_reloc,
    }
  },
  {
    .name = "tlsle",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_TLS_LE_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_TLS_LE_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_TLS_LE_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsle_signed43_reloc,
    }
  },
  {
    .name = "tlsld",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_TLS_LD_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_TLS_LD_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsld_signed37_reloc,
    }
  },
  {
    .name = "tlsld",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_TLS_LD_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_TLS_LD_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_TLS_LD_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsld_signed43_reloc,
    }
  },
  {
    .name = "dtpoff",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_TLS_DTPOFF_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_TLS_DTPOFF_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_dtpoff_signed37_reloc,
    }
  },
  {
    .name = "dtpoff",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_TLS_DTPOFF_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_TLS_DTPOFF_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_TLS_DTPOFF_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_dtpoff_signed43_reloc,
    }
  },
  {
    .name = "tlsie",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_TLS_IE_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_TLS_IE_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsie_signed37_reloc,
    }
  },
  {
    .name = "tlsie",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_TLS_IE_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_TLS_IE_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_TLS_IE_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_tlsie_signed43_reloc,
    }
  },
  {
    .name = "gotoff",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_GOTOFF_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_GOTOFF_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_GOTOFF_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_gotoff_signed43_reloc,
    }
  },
  {
    .name = "gotoff",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_64_ONLY,
      .bitsize = 64,
      .reloc_type = S64,
      .single = BFD_RELOC_KVX_64_GOTOFF,
      .kreloc = & kv3_v1_gotoff_64_reloc,
    }
  },
  {
    .name = "got",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_GOT_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_GOT_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_GOT_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_got_signed43_reloc,
    }
  },
  {
    .name = "got",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_64_ONLY,
      .bitsize = 64,
      .reloc_type = S64,
      .single = BFD_RELOC_KVX_64_GOT,
      .kreloc = & kv3_v1_got_64_reloc,
    }
  },
  {
    .name = "gotaddr",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_32_ONLY,
      .bitsize = 37,
      .has_no_arg = 1,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_GOTADDR_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_GOTADDR_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_gotaddr_signed37_reloc,
    }
  },
  {
    .name = "gotaddr",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_32_ONLY,
      .bitsize = 43,
      .has_no_arg = 1,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_GOTADDR_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_GOTADDR_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_GOTADDR_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_gotaddr_signed43_reloc,
    }
  },
  {
    .name = "gotaddr",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_64_ONLY,
      .bitsize = 64,
      .has_no_arg = 1,
      .reloc_type = S64_LO10_UP27_EX27,
      .reloc_lo10 = BFD_RELOC_KVX_S64_GOTADDR_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S64_GOTADDR_UP27,
      .reloc_ex = BFD_RELOC_KVX_S64_GOTADDR_EX27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_gotaddr_signed64_reloc,
    }
  },
  // pcrel()
  {
    // use pcrel16 to force the use of 16bits. This would normally not
    // be selected as symbol would not fit.
    .name = "pcrel16",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_ALL,
      .bitsize = 16,
      .single = BFD_RELOC_KVX_S16_PCREL,
      .reloc_type = S16,
      .kreloc = & kv3_v1_pcrel_signed16_reloc,
    }
  },
  {
    .name = "pcrel",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_32_ONLY,
      .bitsize = 37,
      .reloc_type = S37_LO10_UP27,
      .reloc_lo10 = BFD_RELOC_KVX_S37_PCREL_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S37_PCREL_UP27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_pcrel_signed37_reloc,
    }
  },
  {
    .name = "pcrel",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_32_ONLY,
      .bitsize = 43,
      .reloc_type = S43_LO10_UP27_EX6,
      .reloc_lo10 = BFD_RELOC_KVX_S43_PCREL_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S43_PCREL_UP27,
      .reloc_ex = BFD_RELOC_KVX_S43_PCREL_EX6,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_pcrel_signed43_reloc,
    }
  },
  {
    .name = "pcrel",
    .pseudo_relocs = {
      .avail_modes = PSEUDO_64_ONLY,
      .bitsize = 64,
      .reloc_type = S64_LO10_UP27_EX27,
      .reloc_lo10 = BFD_RELOC_KVX_S64_PCREL_LO10,
      .reloc_up27 = BFD_RELOC_KVX_S64_PCREL_UP27,
      .reloc_ex = BFD_RELOC_KVX_S64_PCREL_EX27,
      .single = BFD_RELOC_UNUSED,
      .kreloc = & kv3_v1_pcrel_signed64_reloc,
    }
  },
};

struct kvx_reloc kv3_v1_rel16_reloc __attribute__((unused)) = {
  .bitsize = 16,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_16 }
};
struct kvx_reloc kv3_v1_rel32_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_32 }
};
struct kvx_reloc kv3_v1_rel64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_64 }
};
struct kvx_reloc kv3_v1_pcrel_signed16_reloc __attribute__((unused)) = {
  .bitsize = 16,
  .relative = KVX_REL_PC,
  .reloc_nb = 1,
  .relocs = { R_KVX_S16_PCREL }
};
struct kvx_reloc kv3_v1_pcrel17_reloc __attribute__((unused)) = {
  .bitsize = 17,
  .relative = KVX_REL_PC,
  .reloc_nb = 1,
  .relocs = { R_KVX_PCREL17 }
};
struct kvx_reloc kv3_v1_pcrel27_reloc __attribute__((unused)) = {
  .bitsize = 27,
  .relative = KVX_REL_PC,
  .reloc_nb = 1,
  .relocs = { R_KVX_PCREL27 }
};
struct kvx_reloc kv3_v1_pcrel32_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_PC,
  .reloc_nb = 1,
  .relocs = { R_KVX_32_PCREL }
};
struct kvx_reloc kv3_v1_pcrel_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_PC,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_PCREL_UP27, R_KVX_S37_PCREL_LO10 }
};
struct kvx_reloc kv3_v1_pcrel_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_PC,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_PCREL_EX6, R_KVX_S43_PCREL_UP27, R_KVX_S43_PCREL_LO10 }
};
struct kvx_reloc kv3_v1_pcrel_signed64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_PC,
  .reloc_nb = 3,
  .relocs = { R_KVX_S64_PCREL_EX27, R_KVX_S64_PCREL_UP27, R_KVX_S64_PCREL_LO10 }
};
struct kvx_reloc kv3_v1_pcrel64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_PC,
  .reloc_nb = 1,
  .relocs = { R_KVX_64_PCREL }
};
struct kvx_reloc kv3_v1_signed16_reloc __attribute__((unused)) = {
  .bitsize = 16,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_S16 }
};
struct kvx_reloc kv3_v1_signed32_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_ABS,
  .reloc_nb = 2,
  .relocs = { R_KVX_S32_UP27, R_KVX_S32_LO5 }
};
struct kvx_reloc kv3_v1_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_ABS,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_UP27, R_KVX_S37_LO10 }
};
struct kvx_reloc kv3_v1_gotoff_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_GOT,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_GOTOFF_UP27, R_KVX_S37_GOTOFF_LO10 }
};
struct kvx_reloc kv3_v1_gotoff_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_GOT,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_GOTOFF_EX6, R_KVX_S43_GOTOFF_UP27, R_KVX_S43_GOTOFF_LO10 }
};
struct kvx_reloc kv3_v1_gotoff_32_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_GOT,
  .reloc_nb = 1,
  .relocs = { R_KVX_32_GOTOFF }
};
struct kvx_reloc kv3_v1_gotoff_64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_GOT,
  .reloc_nb = 1,
  .relocs = { R_KVX_64_GOTOFF }
};
struct kvx_reloc kv3_v1_got_32_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_GOT,
  .reloc_nb = 1,
  .relocs = { R_KVX_32_GOT }
};
struct kvx_reloc kv3_v1_got_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_GOT,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_GOT_UP27, R_KVX_S37_GOT_LO10 }
};
struct kvx_reloc kv3_v1_got_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_GOT,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_GOT_EX6, R_KVX_S43_GOT_UP27, R_KVX_S43_GOT_LO10 }
};
struct kvx_reloc kv3_v1_got_64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_GOT,
  .reloc_nb = 1,
  .relocs = { R_KVX_64_GOT }
};
struct kvx_reloc kv3_v1_glob_dat_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_GOT,
  .reloc_nb = 1,
  .relocs = { R_KVX_GLOB_DAT }
};
struct kvx_reloc kv3_v1_copy_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_COPY }
};
struct kvx_reloc kv3_v1_jump_slot_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_JMP_SLOT }
};
struct kvx_reloc kv3_v1_relative_reloc __attribute__((unused)) = {
  .bitsize = 32,
  .relative = KVX_REL_BASE,
  .reloc_nb = 1,
  .relocs = { R_KVX_RELATIVE }
};
struct kvx_reloc kv3_v1_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_ABS,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_EX6, R_KVX_S43_UP27, R_KVX_S43_LO10 }
};
struct kvx_reloc kv3_v1_signed64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_ABS,
  .reloc_nb = 3,
  .relocs = { R_KVX_S64_EX27, R_KVX_S64_UP27, R_KVX_S64_LO10 }
};
struct kvx_reloc kv3_v1_gotaddr_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_PC,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_GOTADDR_UP27, R_KVX_S37_GOTADDR_LO10 }
};
struct kvx_reloc kv3_v1_gotaddr_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_PC,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_GOTADDR_EX6, R_KVX_S43_GOTADDR_UP27, R_KVX_S43_GOTADDR_LO10 }
};
struct kvx_reloc kv3_v1_gotaddr_signed64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_PC,
  .reloc_nb = 3,
  .relocs = { R_KVX_S64_GOTADDR_EX27, R_KVX_S64_GOTADDR_UP27, R_KVX_S64_GOTADDR_LO10 }
};
struct kvx_reloc kv3_v1_dtpmod64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_64_DTPMOD }
};
struct kvx_reloc kv3_v1_dtpoff64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_64_DTPOFF }
};
struct kvx_reloc kv3_v1_dtpoff_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_ABS,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_TLS_DTPOFF_UP27, R_KVX_S37_TLS_DTPOFF_LO10 }
};
struct kvx_reloc kv3_v1_dtpoff_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_ABS,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_TLS_DTPOFF_EX6, R_KVX_S43_TLS_DTPOFF_UP27, R_KVX_S43_TLS_DTPOFF_LO10 }
};
struct kvx_reloc kv3_v1_tlsgd_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_GOT,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_TLS_GD_UP27, R_KVX_S37_TLS_GD_LO10 }
};
struct kvx_reloc kv3_v1_tlsgd_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_GOT,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_TLS_GD_EX6, R_KVX_S43_TLS_GD_UP27, R_KVX_S43_TLS_GD_LO10 }
};
struct kvx_reloc kv3_v1_tlsld_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_GOT,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_TLS_LD_UP27, R_KVX_S37_TLS_LD_LO10 }
};
struct kvx_reloc kv3_v1_tlsld_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_GOT,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_TLS_LD_EX6, R_KVX_S43_TLS_LD_UP27, R_KVX_S43_TLS_LD_LO10 }
};
struct kvx_reloc kv3_v1_tpoff64_reloc __attribute__((unused)) = {
  .bitsize = 64,
  .relative = KVX_REL_TP,
  .reloc_nb = 1,
  .relocs = { R_KVX_64_TPOFF }
};
struct kvx_reloc kv3_v1_tlsie_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_GOT,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_TLS_IE_UP27, R_KVX_S37_TLS_IE_LO10 }
};
struct kvx_reloc kv3_v1_tlsie_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_GOT,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_TLS_IE_EX6, R_KVX_S43_TLS_IE_UP27, R_KVX_S43_TLS_IE_LO10 }
};
struct kvx_reloc kv3_v1_tlsle_signed37_reloc __attribute__((unused)) = {
  .bitsize = 37,
  .relative = KVX_REL_TP,
  .reloc_nb = 2,
  .relocs = { R_KVX_S37_TLS_LE_UP27, R_KVX_S37_TLS_LE_LO10 }
};
struct kvx_reloc kv3_v1_tlsle_signed43_reloc __attribute__((unused)) = {
  .bitsize = 43,
  .relative = KVX_REL_TP,
  .reloc_nb = 3,
  .relocs = { R_KVX_S43_TLS_LE_EX6, R_KVX_S43_TLS_LE_UP27, R_KVX_S43_TLS_LE_LO10 }
};
struct kvx_reloc kv3_v1_rel8_reloc __attribute__((unused)) = {
  .bitsize = 8,
  .relative = KVX_REL_ABS,
  .reloc_nb = 1,
  .relocs = { R_KVX_8 }
};

static struct kvx_reloc *kv3_v1_branchcond_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_branchcond_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_branchcond_opnd",
  .type = Modifier_kv3_v1_scalarcond,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_branchcond_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 23 },  }
};

static struct kvx_reloc *kv3_v1_byteshift_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_byteshift_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_byteshift_opnd",
  .type = Immediate_kv3_v1_unsigned6,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_byteshift_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static struct kvx_reloc *kv3_v1_comparison_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_comparison_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_comparison_opnd",
  .type = Modifier_kv3_v1_comparison,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_comparison_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 24 },  }
};

static struct kvx_reloc *kv3_v1_doscale_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_doscale_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_doscale_opnd",
  .type = Modifier_kv3_v1_doscale,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_doscale_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 12 },  }
};

static struct kvx_reloc *kv3_v1_extend27_offset27_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_extend27_offset27_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_extend27_offset27_opnd",
  .type = Immediate_kv3_v1_signed54,
  .width = 54,
  .shift = 0,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_extend27_offset27_opnd_relocs,
  .bitfields = 2,
  .bfield = { { 27, 27, 64 }, { 27, 0, 32 },  }
};

static struct kvx_reloc *kv3_v1_extend27_upper27_lower10_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_pcrel_signed64_reloc,
  &kv3_v1_signed64_reloc,
  &kv3_v1_gotaddr_signed64_reloc,
  0
};
static struct kvx_operand kv3_v1_extend27_upper27_lower10_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_extend27_upper27_lower10_opnd",
  .type = Immediate_kv3_v1_wrapped64,
  .width = 64,
  .shift = 0,
  .bias = 0,
  .flags = kvxWRAPPED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 3,
  .relocs = kv3_v1_extend27_upper27_lower10_opnd_relocs,
  .bitfields = 3,
  .bfield = { { 27, 37, 64 }, { 27, 10, 32 }, { 10, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_extend6_upper27_lower10_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_pcrel_signed43_reloc,
  &kv3_v1_gotoff_signed43_reloc,
  &kv3_v1_got_signed43_reloc,
  &kv3_v1_signed43_reloc,
  &kv3_v1_gotaddr_signed43_reloc,
  &kv3_v1_dtpoff_signed43_reloc,
  &kv3_v1_tlsgd_signed43_reloc,
  &kv3_v1_tlsld_signed43_reloc,
  &kv3_v1_tlsie_signed43_reloc,
  &kv3_v1_tlsle_signed43_reloc,
  0
};
static struct kvx_operand kv3_v1_extend6_upper27_lower10_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_extend6_upper27_lower10_opnd",
  .type = Immediate_kv3_v1_signed43,
  .width = 43,
  .shift = 0,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 10,
  .relocs = kv3_v1_extend6_upper27_lower10_opnd_relocs,
  .bitfields = 3,
  .bfield = { { 6, 37, 0 }, { 27, 10, 32 }, { 10, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_floatcomp_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_floatcomp_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_floatcomp_opnd",
  .type = Modifier_kv3_v1_floatcomp,
  .width = 3,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_floatcomp_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 3, 0, 24 },  }
};

static struct kvx_reloc *kv3_v1_lsucond_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_lsucond_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_lsucond_opnd",
  .type = Modifier_kv3_v1_scalarcond,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_lsucond_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 12 },  }
};

static struct kvx_reloc *kv3_v1_offset27_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_offset27_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_offset27_opnd",
  .type = Immediate_kv3_v1_signed27,
  .width = 27,
  .shift = 0,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_offset27_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 27, 0, 32 },  }
};

static struct kvx_reloc *kv3_v1_pcrel17_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_pcrel17_reloc,
  0
};
static struct kvx_operand kv3_v1_pcrel17_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_pcrel17_opnd",
  .type = Immediate_kv3_v1_pcrel17,
  .width = 17,
  .shift = 2,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 1,
  .relocs = kv3_v1_pcrel17_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 17, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_pcrel27_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_pcrel27_reloc,
  0
};
static struct kvx_operand kv3_v1_pcrel27_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_pcrel27_opnd",
  .type = Immediate_kv3_v1_pcrel27,
  .width = 27,
  .shift = 2,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 1,
  .relocs = kv3_v1_pcrel27_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 27, 0, 0 },  }
};

static struct kvx_reloc *kv3_v1_qindex_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_qindex_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_qindex_opnd",
  .type = Modifier_kv3_v1_qindex,
  .width = 2,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_qindex_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 2, 0, 18 },  }
};

static struct kvx_reloc *kv3_v1_rectify_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_rectify_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_rectify_opnd",
  .type = Modifier_kv3_v1_rectify,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_rectify_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 7 },  }
};

static int kv3_v1_registera_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registera_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera_opnd",
  .type = RegClass_kv3_v1_vectorReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registera_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registera_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registera_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera_0_opnd",
  .type = RegClass_kv3_v1_vectorReg_0,
  .width = 6,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registera_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registera_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registera_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera_1_opnd",
  .type = RegClass_kv3_v1_vectorReg_1,
  .width = 6,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registera_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registera_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registera_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera_2_opnd",
  .type = RegClass_kv3_v1_vectorReg_2,
  .width = 6,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registera_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registera_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registera_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera_3_opnd",
  .type = RegClass_kv3_v1_vectorReg_3,
  .width = 6,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registera_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registera0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registera0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera0_opnd",
  .type = RegClass_kv3_v1_blockReg0M4,
  .width = 5,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 128,
  .regs = kv3_v1_registera0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registera1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registera1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera1_opnd",
  .type = RegClass_kv3_v1_blockReg1M4,
  .width = 5,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 128,
  .regs = kv3_v1_registera1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registera2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registera2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera2_opnd",
  .type = RegClass_kv3_v1_blockReg2M4,
  .width = 5,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 128,
  .regs = kv3_v1_registera2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registera3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registera3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registera3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registera3_opnd",
  .type = RegClass_kv3_v1_blockReg3M4,
  .width = 5,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 128,
  .regs = kv3_v1_registera3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registera3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registerae_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerae_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerae_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerae_opnd",
  .type = RegClass_kv3_v1_blockRegE,
  .width = 6,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 128,
  .regs = kv3_v1_registerae_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerae_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registerao_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerao_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerao_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerao_opnd",
  .type = RegClass_kv3_v1_blockRegO,
  .width = 6,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 128,
  .regs = kv3_v1_registerao_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerao_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registerap_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerap_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerap_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerap_opnd",
  .type = RegClass_kv3_v1_tileReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 32,
  .regs = kv3_v1_registerap_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerap_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registerap_0_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerap_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerap_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerap_0_opnd",
  .type = RegClass_kv3_v1_tileReg_0,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerap_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerap_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registerap_1_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerap_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerap_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerap_1_opnd",
  .type = RegClass_kv3_v1_tileReg_1,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerap_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerap_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registeraq_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registeraq_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeraq_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeraq_opnd",
  .type = RegClass_kv3_v1_matrixReg,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 16,
  .regs = kv3_v1_registeraq_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeraq_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registeraq_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registeraq_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeraq_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeraq_0_opnd",
  .type = RegClass_kv3_v1_matrixReg_0,
  .width = 4,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registeraq_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeraq_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registeraq_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registeraq_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeraq_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeraq_1_opnd",
  .type = RegClass_kv3_v1_matrixReg_1,
  .width = 4,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registeraq_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeraq_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registeraq_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registeraq_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeraq_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeraq_2_opnd",
  .type = RegClass_kv3_v1_matrixReg_2,
  .width = 4,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registeraq_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeraq_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registeraq_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registeraq_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeraq_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeraq_3_opnd",
  .type = RegClass_kv3_v1_matrixReg_3,
  .width = 4,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registeraq_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeraq_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registerat_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerat_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerat_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerat_opnd",
  .type = RegClass_kv3_v1_coproReg3M4,
  .width = 6,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerat_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerat_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registerax_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerax_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerax_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerax_opnd",
  .type = RegClass_kv3_v1_coproReg0M4,
  .width = 6,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerax_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerax_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registeray_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registeray_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeray_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeray_opnd",
  .type = RegClass_kv3_v1_coproReg1M4,
  .width = 6,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registeray_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeray_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registeraz_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registeraz_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeraz_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeraz_opnd",
  .type = RegClass_kv3_v1_coproReg2M4,
  .width = 6,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registeraz_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeraz_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registerb_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerb_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerb_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerb_opnd",
  .type = RegClass_kv3_v1_vectorReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerb_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerb_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 12 },  }
};

static int kv3_v1_registerb_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerb_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerb_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerb_0_opnd",
  .type = RegClass_kv3_v1_vectorReg_0,
  .width = 6,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerb_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerb_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 12 },  }
};

static int kv3_v1_registerb_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registerb_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerb_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerb_1_opnd",
  .type = RegClass_kv3_v1_vectorReg_1,
  .width = 6,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerb_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerb_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 12 },  }
};

static int kv3_v1_registerb_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerb_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerb_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerb_2_opnd",
  .type = RegClass_kv3_v1_vectorReg_2,
  .width = 6,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerb_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerb_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 12 },  }
};

static int kv3_v1_registerb_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerb_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerb_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerb_3_opnd",
  .type = RegClass_kv3_v1_vectorReg_3,
  .width = 6,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerb_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerb_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 12 },  }
};

static int kv3_v1_registerbe_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerbe_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbe_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbe_opnd",
  .type = RegClass_kv3_v1_vectorRegE,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbe_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbe_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 13 },  }
};

static int kv3_v1_registerbo_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerbo_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbo_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbo_opnd",
  .type = RegClass_kv3_v1_vectorRegO,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbo_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbo_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 13 },  }
};

static int kv3_v1_registerbp_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerbp_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbp_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbp_opnd",
  .type = RegClass_kv3_v1_tileReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 32,
  .regs = kv3_v1_registerbp_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbp_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 13 },  }
};

static int kv3_v1_registerbp_0_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerbp_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbp_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbp_0_opnd",
  .type = RegClass_kv3_v1_tileReg_0,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbp_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbp_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 13 },  }
};

static int kv3_v1_registerbp_1_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerbp_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbp_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbp_1_opnd",
  .type = RegClass_kv3_v1_tileReg_1,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbp_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbp_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 13 },  }
};

static int kv3_v1_registerbq_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerbq_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbq_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbq_opnd",
  .type = RegClass_kv3_v1_matrixReg,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 16,
  .regs = kv3_v1_registerbq_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbq_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 14 },  }
};

static int kv3_v1_registerbq_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerbq_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbq_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbq_0_opnd",
  .type = RegClass_kv3_v1_matrixReg_0,
  .width = 4,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbq_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbq_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 14 },  }
};

static int kv3_v1_registerbq_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registerbq_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbq_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbq_1_opnd",
  .type = RegClass_kv3_v1_matrixReg_1,
  .width = 4,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbq_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbq_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 14 },  }
};

static int kv3_v1_registerbq_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerbq_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbq_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbq_2_opnd",
  .type = RegClass_kv3_v1_matrixReg_2,
  .width = 4,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbq_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbq_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 14 },  }
};

static int kv3_v1_registerbq_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerbq_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerbq_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerbq_3_opnd",
  .type = RegClass_kv3_v1_matrixReg_3,
  .width = 4,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerbq_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerbq_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 14 },  }
};

static int kv3_v1_registerc_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerc_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerc_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerc_opnd",
  .type = RegClass_kv3_v1_vectorReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerc_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerc_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static int kv3_v1_registerc_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerc_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerc_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerc_0_opnd",
  .type = RegClass_kv3_v1_vectorReg_0,
  .width = 6,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerc_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerc_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static int kv3_v1_registerc_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registerc_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerc_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerc_1_opnd",
  .type = RegClass_kv3_v1_vectorReg_1,
  .width = 6,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerc_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerc_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static int kv3_v1_registerc_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerc_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerc_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerc_2_opnd",
  .type = RegClass_kv3_v1_vectorReg_2,
  .width = 6,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerc_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerc_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static int kv3_v1_registerc_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerc_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerc_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerc_3_opnd",
  .type = RegClass_kv3_v1_vectorReg_3,
  .width = 6,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerc_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerc_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static int kv3_v1_registerce_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerce_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerce_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerce_opnd",
  .type = RegClass_kv3_v1_vectorRegE,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerce_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerce_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 7 },  }
};

static int kv3_v1_registerco_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerco_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerco_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerco_opnd",
  .type = RegClass_kv3_v1_vectorRegO,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerco_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerco_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 7 },  }
};

static int kv3_v1_registerd_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerd_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerd_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerd_opnd",
  .type = RegClass_kv3_v1_vectorReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerd_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerd_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static int kv3_v1_registerd_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerd_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerd_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerd_0_opnd",
  .type = RegClass_kv3_v1_vectorReg_0,
  .width = 6,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerd_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerd_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static int kv3_v1_registerd_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registerd_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerd_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerd_1_opnd",
  .type = RegClass_kv3_v1_vectorReg_1,
  .width = 6,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerd_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerd_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static int kv3_v1_registerd_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerd_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerd_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerd_2_opnd",
  .type = RegClass_kv3_v1_vectorReg_2,
  .width = 6,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerd_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerd_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static int kv3_v1_registerd_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerd_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerd_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerd_3_opnd",
  .type = RegClass_kv3_v1_vectorReg_3,
  .width = 6,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registerd_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerd_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static int kv3_v1_registere_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registere_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registere_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registere_opnd",
  .type = RegClass_kv3_v1_vectorReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registere_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registere_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registere_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registere_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registere_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registere_0_opnd",
  .type = RegClass_kv3_v1_vectorReg_0,
  .width = 6,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registere_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registere_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registere_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registere_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registere_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registere_1_opnd",
  .type = RegClass_kv3_v1_vectorReg_1,
  .width = 6,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registere_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registere_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registere_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registere_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registere_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registere_2_opnd",
  .type = RegClass_kv3_v1_vectorReg_2,
  .width = 6,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registere_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registere_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registere_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registere_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registere_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registere_3_opnd",
  .type = RegClass_kv3_v1_vectorReg_3,
  .width = 6,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 256,
  .regs = kv3_v1_registere_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registere_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registerm_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerm_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerm_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerm_opnd",
  .type = RegClass_kv3_v1_pairedReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 32,
  .regs = kv3_v1_registerm_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerm_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registerm_0_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerm_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerm_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerm_0_opnd",
  .type = RegClass_kv3_v1_pairedReg_0,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerm_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerm_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registerm_1_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerm_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerm_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerm_1_opnd",
  .type = RegClass_kv3_v1_pairedReg_1,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerm_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerm_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registern_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registern_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registern_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registern_opnd",
  .type = RegClass_kv3_v1_quadReg,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 16,
  .regs = kv3_v1_registern_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registern_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registern_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registern_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registern_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registern_0_opnd",
  .type = RegClass_kv3_v1_quadReg_0,
  .width = 4,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registern_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registern_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registern_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registern_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registern_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registern_1_opnd",
  .type = RegClass_kv3_v1_quadReg_1,
  .width = 4,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registern_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registern_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registern_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registern_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registern_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registern_2_opnd",
  .type = RegClass_kv3_v1_quadReg_2,
  .width = 4,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registern_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registern_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registern_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registern_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registern_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registern_3_opnd",
  .type = RegClass_kv3_v1_quadReg_3,
  .width = 4,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registern_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registern_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registero_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registero_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registero_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registero_opnd",
  .type = RegClass_kv3_v1_pairedReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 32,
  .regs = kv3_v1_registero_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registero_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 7 },  }
};

static int kv3_v1_registero_0_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registero_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registero_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registero_0_opnd",
  .type = RegClass_kv3_v1_pairedReg_0,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registero_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registero_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 7 },  }
};

static int kv3_v1_registero_1_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registero_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registero_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registero_1_opnd",
  .type = RegClass_kv3_v1_pairedReg_1,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registero_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registero_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 7 },  }
};

static int kv3_v1_registerp_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerp_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerp_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerp_opnd",
  .type = RegClass_kv3_v1_pairedReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 32,
  .regs = kv3_v1_registerp_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerp_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 1 },  }
};

static int kv3_v1_registerp_0_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerp_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerp_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerp_0_opnd",
  .type = RegClass_kv3_v1_pairedReg_0,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerp_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerp_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 1 },  }
};

static int kv3_v1_registerp_1_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registerp_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerp_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerp_1_opnd",
  .type = RegClass_kv3_v1_pairedReg_1,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerp_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerp_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 1 },  }
};

static int kv3_v1_registerr_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerr_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerr_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerr_opnd",
  .type = RegClass_kv3_v1_quadReg,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 16,
  .regs = kv3_v1_registerr_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerr_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 2 },  }
};

static int kv3_v1_registerr_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerr_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerr_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerr_0_opnd",
  .type = RegClass_kv3_v1_quadReg_0,
  .width = 4,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerr_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerr_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 2 },  }
};

static int kv3_v1_registerr_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registerr_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerr_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerr_1_opnd",
  .type = RegClass_kv3_v1_quadReg_1,
  .width = 4,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerr_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerr_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 2 },  }
};

static int kv3_v1_registerr_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerr_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerr_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerr_2_opnd",
  .type = RegClass_kv3_v1_quadReg_2,
  .width = 4,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerr_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerr_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 2 },  }
};

static int kv3_v1_registerr_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerr_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerr_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerr_3_opnd",
  .type = RegClass_kv3_v1_quadReg_3,
  .width = 4,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerr_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerr_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 2 },  }
};

static int kv3_v1_registert_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registert_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registert_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registert_opnd",
  .type = RegClass_kv3_v1_singleReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registert_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registert_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registeru_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registeru_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeru_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeru_opnd",
  .type = RegClass_kv3_v1_pairedReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 32,
  .regs = kv3_v1_registeru_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeru_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registeru_0_opnd_regs[] = {
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registeru_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeru_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeru_0_opnd",
  .type = RegClass_kv3_v1_pairedReg_0,
  .width = 5,
  .shift = 1,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registeru_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeru_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registeru_1_opnd_regs[] = {
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, };
static struct kvx_reloc *kv3_v1_registeru_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registeru_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registeru_1_opnd",
  .type = RegClass_kv3_v1_pairedReg_1,
  .width = 5,
  .shift = 1,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registeru_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registeru_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 5, 0, 19 },  }
};

static int kv3_v1_registerv_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerv_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerv_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerv_opnd",
  .type = RegClass_kv3_v1_quadReg,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 16,
  .regs = kv3_v1_registerv_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerv_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registerv_0_opnd_regs[] = {
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_registerv_0_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerv_0_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerv_0_opnd",
  .type = RegClass_kv3_v1_quadReg_0,
  .width = 4,
  .shift = 2,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerv_0_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerv_0_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registerv_1_opnd_regs[] = {
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, };
static struct kvx_reloc *kv3_v1_registerv_1_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerv_1_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerv_1_opnd",
  .type = RegClass_kv3_v1_quadReg_1,
  .width = 4,
  .shift = 2,
  .bias = 1,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerv_1_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerv_1_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registerv_2_opnd_regs[] = {
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
      0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, };
static struct kvx_reloc *kv3_v1_registerv_2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerv_2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerv_2_opnd",
  .type = RegClass_kv3_v1_quadReg_2,
  .width = 4,
  .shift = 2,
  .bias = 2,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerv_2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerv_2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registerv_3_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, };
static struct kvx_reloc *kv3_v1_registerv_3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerv_3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerv_3_opnd",
  .type = RegClass_kv3_v1_quadReg_3,
  .width = 4,
  .shift = 2,
  .bias = 3,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerv_3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerv_3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 20 },  }
};

static int kv3_v1_registerw_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerw_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerw_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerw_opnd",
  .type = RegClass_kv3_v1_singleReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerw_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerw_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 18 },  }
};

static int kv3_v1_registery_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registery_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registery_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registery_opnd",
  .type = RegClass_kv3_v1_singleReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registery_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registery_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static int kv3_v1_registerz_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_registerz_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_registerz_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_registerz_opnd",
  .type = RegClass_kv3_v1_singleReg,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 64,
  .regs = kv3_v1_registerz_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_registerz_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 0 },  }
};

static struct kvx_reloc *kv3_v1_rounding_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_rounding_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_rounding_opnd",
  .type = Modifier_kv3_v1_rounding,
  .width = 3,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_rounding_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 3, 0, 12 },  }
};

static struct kvx_reloc *kv3_v1_rounding2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_rounding2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_rounding2_opnd",
  .type = Modifier_kv3_v1_rounding,
  .width = 3,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_rounding2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 3, 0, 8 },  }
};

static struct kvx_reloc *kv3_v1_roundint_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_roundint_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_roundint_opnd",
  .type = Modifier_kv3_v1_roundint,
  .width = 3,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_roundint_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 3, 0, 8 },  }
};

static struct kvx_reloc *kv3_v1_saturate_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_saturate_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_saturate_opnd",
  .type = Modifier_kv3_v1_saturate,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_saturate_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 7 },  }
};

static struct kvx_reloc *kv3_v1_scalarcond_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_scalarcond_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_scalarcond_opnd",
  .type = Modifier_kv3_v1_scalarcond,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_scalarcond_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 4, 0, 24 },  }
};

static struct kvx_reloc *kv3_v1_signed10_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_signed10_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_signed10_opnd",
  .type = Immediate_kv3_v1_signed10,
  .width = 10,
  .shift = 0,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_signed10_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 10, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_signed16_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_pcrel_signed16_reloc,
  &kv3_v1_signed16_reloc,
  0
};
static struct kvx_operand kv3_v1_signed16_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_signed16_opnd",
  .type = Immediate_kv3_v1_signed16,
  .width = 16,
  .shift = 0,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 2,
  .relocs = kv3_v1_signed16_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 16, 0, 0 },  }
};

static struct kvx_reloc *kv3_v1_silent_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_silent_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_silent_opnd",
  .type = Modifier_kv3_v1_silent,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_silent_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 15 },  }
};

static struct kvx_reloc *kv3_v1_silent2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_silent2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_silent2_opnd",
  .type = Modifier_kv3_v1_silent,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_silent2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 11 },  }
};

static struct kvx_reloc *kv3_v1_simdcond_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_simdcond_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_simdcond_opnd",
  .type = Modifier_kv3_v1_simplecond,
  .width = 3,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_simdcond_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 3, 0, 24 },  }
};

static struct kvx_reloc *kv3_v1_speculate_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_speculate_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_speculate_opnd",
  .type = Modifier_kv3_v1_speculate,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_speculate_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 24 },  }
};

static struct kvx_reloc *kv3_v1_splat32_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_splat32_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_splat32_opnd",
  .type = Modifier_kv3_v1_splat32,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_splat32_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 1, 0, 11 },  }
};

static struct kvx_reloc *kv3_v1_startbit_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_startbit_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_startbit_opnd",
  .type = Immediate_kv3_v1_unsigned6,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_startbit_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_stopbit2_stopbit4_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_stopbit2_stopbit4_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_stopbit2_stopbit4_opnd",
  .type = Immediate_kv3_v1_unsigned6,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_stopbit2_stopbit4_opnd_relocs,
  .bitfields = 2,
  .bfield = { { 2, 4, 24 }, { 4, 0, 12 },  }
};

static struct kvx_reloc *kv3_v1_sysnumber_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_sysnumber_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_sysnumber_opnd",
  .type = Immediate_kv3_v1_sysnumber,
  .width = 12,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_sysnumber_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 12, 0, 0 },  }
};

static int kv3_v1_systemalone_opnd_regs[] = {
      0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_systemalone_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systemalone_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systemalone_opnd",
  .type = RegClass_kv3_v1_aloneReg,
  .width = 4,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systemalone_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systemalone_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systemra_opnd_regs[] = {
      0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_systemra_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systemra_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systemra_opnd",
  .type = RegClass_kv3_v1_onlyraReg,
  .width = 1,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systemra_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systemra_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systems2_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_systems2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systems2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systems2_opnd",
  .type = RegClass_kv3_v1_onlygetReg,
  .width = 9,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systems2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systems2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systems3_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_systems3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systems3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systems3_opnd",
  .type = RegClass_kv3_v1_systemReg,
  .width = 9,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systems3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systems3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systems4_opnd_regs[] = {
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_systems4_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systems4_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systems4_opnd",
  .type = RegClass_kv3_v1_onlyswapReg,
  .width = 9,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systems4_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systems4_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systemt2_opnd_regs[] = {
      0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 
      0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, };
static struct kvx_reloc *kv3_v1_systemt2_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systemt2_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systemt2_opnd",
  .type = RegClass_kv3_v1_onlyfxReg,
  .width = 5,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systemt2_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systemt2_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systemt3_opnd_regs[] = {
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_systemt3_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systemt3_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systemt3_opnd",
  .type = RegClass_kv3_v1_onlysetReg,
  .width = 9,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systemt3_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systemt3_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static int kv3_v1_systemt4_opnd_regs[] = {
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, };
static struct kvx_reloc *kv3_v1_systemt4_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_systemt4_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_systemt4_opnd",
  .type = RegClass_kv3_v1_systemReg,
  .width = 9,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 512,
  .regs = kv3_v1_systemt4_opnd_regs,
  .reloc_nb = 0,
  .relocs = kv3_v1_systemt4_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 9, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_unsigned6_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_unsigned6_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_unsigned6_opnd",
  .type = Immediate_kv3_v1_unsigned6,
  .width = 6,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_unsigned6_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 6, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_upper27_lower10_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_pcrel_signed37_reloc,
  &kv3_v1_signed37_reloc,
  &kv3_v1_gotoff_signed37_reloc,
  &kv3_v1_got_signed37_reloc,
  &kv3_v1_gotaddr_signed37_reloc,
  &kv3_v1_dtpoff_signed37_reloc,
  &kv3_v1_tlsgd_signed37_reloc,
  &kv3_v1_tlsld_signed37_reloc,
  &kv3_v1_tlsie_signed37_reloc,
  &kv3_v1_tlsle_signed37_reloc,
  0
};
static struct kvx_operand kv3_v1_upper27_lower10_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_upper27_lower10_opnd",
  .type = Immediate_kv3_v1_signed37,
  .width = 37,
  .shift = 0,
  .bias = 0,
  .flags = kvxSIGNED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 10,
  .relocs = kv3_v1_upper27_lower10_opnd_relocs,
  .bitfields = 2,
  .bfield = { { 27, 10, 32 }, { 10, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_upper27_lower5_opnd_relocs[] __attribute__((unused)) = {
  &kv3_v1_signed32_reloc,
  0
};
static struct kvx_operand kv3_v1_upper27_lower5_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_upper27_lower5_opnd",
  .type = Immediate_kv3_v1_wrapped32,
  .width = 32,
  .shift = 0,
  .bias = 0,
  .flags = kvxWRAPPED,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 1,
  .relocs = kv3_v1_upper27_lower5_opnd_relocs,
  .bitfields = 2,
  .bfield = { { 27, 5, 32 }, { 5, 0, 6 },  }
};

static struct kvx_reloc *kv3_v1_variant_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_variant_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_variant_opnd",
  .type = Modifier_kv3_v1_variant,
  .width = 2,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_variant_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 2, 0, 24 },  }
};

static struct kvx_reloc *kv3_v1_xrounding_opnd_relocs[] __attribute__((unused)) = {
  0
};
static struct kvx_operand kv3_v1_xrounding_opnd  __attribute__((unused)) = {
  .tname = "kv3_v1_xrounding_opnd",
  .type = Modifier_kv3_v1_rounding,
  .width = 3,
  .shift = 0,
  .bias = 0,
  .flags = 0,
  .reg_nb = 0,
  .regs = 0,
  .reloc_nb = 0,
  .relocs = kv3_v1_xrounding_opnd_relocs,
  .bitfields = 1,
  .bfield = { { 3, 0, 8 },  }
};



const char *kvx_kv3_v1_resource_names[kvx_kv3_v1_RESOURCE_MAX] = {
  "ISSUE",
  "TINY",
  "LITE",
  "FULL",
  "LSU",
  "MAU",
  "BCU",
  "TCA",
  "AUXR",
  "AUXW",
  "CRRP",
  "CRWL",
  "CRWH",
  "NOP"
};

const int kvx_kv3_v1_resources[kvx_kv3_v1_RESOURCE_MAX] = { 8,4,2,1,1,1,1,1,1,1,1,1,1,4};



#define kvx_kv3_v1_RESERVATION_TABLE_LINES 1
const int kvx_kv3_v1_reservation_table_lines = kvx_kv3_v1_RESERVATION_TABLE_LINES;

static const int Reservation_kv3_v1_ALL_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  8 /* cyc.0 Resource-kv3_v1-ISSUE */,
  0 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_FULL_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  1 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_FULL_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  1 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_FULL_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  1 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_LITE_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_LITE_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_LITE_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_LITE_CRWH_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  1 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_LITE_CRWL_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  1 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  1 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_NOP_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  0 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  1 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_TINY_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_TINY_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_ALU_TINY_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_BCU_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  0 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  1 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  0 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  1 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  1 /* cyc.0 Resource-kv3_v1-CRRP */,
  1 /* cyc.0 Resource-kv3_v1-CRWL */,
  1 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_BCU_TINY_AUXW_CRRP_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  1 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  1 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  2 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  1 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  4 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXR_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXR_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXR_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXR_AUXW_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXR_AUXW_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXR_AUXW_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXW_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXW_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_AUXW_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  1 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_CRRP_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  1 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_CRRP_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  1 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_LSU_CRRP_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  1 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  1 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_MAU_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_MAU_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_MAU_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_MAU_AUXR_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_MAU_AUXR_X_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  2 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_MAU_AUXR_Y_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  3 /* cyc.0 Resource-kv3_v1-ISSUE */,
  1 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  1 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  0 /* cyc.0 Resource-kv3_v1-TCA */,
  1 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

static const int Reservation_kv3_v1_TCA_table[kvx_kv3_v1_RESERVATION_TABLE_LINES * kvx_kv3_v1_RESOURCE_MAX] = {
  1 /* cyc.0 Resource-kv3_v1-ISSUE */,
  0 /* cyc.0 Resource-kv3_v1-TINY */,
  0 /* cyc.0 Resource-kv3_v1-LITE */,
  0 /* cyc.0 Resource-kv3_v1-FULL */,
  0 /* cyc.0 Resource-kv3_v1-LSU */,
  0 /* cyc.0 Resource-kv3_v1-MAU */,
  0 /* cyc.0 Resource-kv3_v1-BCU */,
  1 /* cyc.0 Resource-kv3_v1-TCA */,
  0 /* cyc.0 Resource-kv3_v1-AUXR */,
  0 /* cyc.0 Resource-kv3_v1-AUXW */,
  0 /* cyc.0 Resource-kv3_v1-CRRP */,
  0 /* cyc.0 Resource-kv3_v1-CRWL */,
  0 /* cyc.0 Resource-kv3_v1-CRWH */,
  0 /* cyc.0 Resource-kv3_v1-NOP */
};

const int *kvx_kv3_v1_reservation_table_table[] ={
  Reservation_kv3_v1_ALL_table,
  Reservation_kv3_v1_ALU_NOP_table,
  Reservation_kv3_v1_ALU_TINY_table,
  Reservation_kv3_v1_ALU_TINY_X_table,
  Reservation_kv3_v1_ALU_TINY_Y_table,
  Reservation_kv3_v1_ALU_LITE_table,
  Reservation_kv3_v1_ALU_LITE_X_table,
  Reservation_kv3_v1_ALU_LITE_Y_table,
  Reservation_kv3_v1_ALU_LITE_CRWL_table,
  Reservation_kv3_v1_ALU_LITE_CRWH_table,
  Reservation_kv3_v1_ALU_FULL_table,
  Reservation_kv3_v1_ALU_FULL_X_table,
  Reservation_kv3_v1_ALU_FULL_Y_table,
  Reservation_kv3_v1_BCU_table,
  Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH_table,
  Reservation_kv3_v1_BCU_TINY_AUXW_CRRP_table,
  Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP_table,
  Reservation_kv3_v1_TCA_table,
  Reservation_kv3_v1_LSU_table,
  Reservation_kv3_v1_LSU_X_table,
  Reservation_kv3_v1_LSU_Y_table,
  Reservation_kv3_v1_LSU_CRRP_table,
  Reservation_kv3_v1_LSU_CRRP_X_table,
  Reservation_kv3_v1_LSU_CRRP_Y_table,
  Reservation_kv3_v1_LSU_AUXR_table,
  Reservation_kv3_v1_LSU_AUXR_X_table,
  Reservation_kv3_v1_LSU_AUXR_Y_table,
  Reservation_kv3_v1_LSU_AUXW_table,
  Reservation_kv3_v1_LSU_AUXW_X_table,
  Reservation_kv3_v1_LSU_AUXW_Y_table,
  Reservation_kv3_v1_LSU_AUXR_AUXW_table,
  Reservation_kv3_v1_LSU_AUXR_AUXW_X_table,
  Reservation_kv3_v1_LSU_AUXR_AUXW_Y_table,
  Reservation_kv3_v1_MAU_table,
  Reservation_kv3_v1_MAU_X_table,
  Reservation_kv3_v1_MAU_Y_table,
  Reservation_kv3_v1_MAU_AUXR_table,
  Reservation_kv3_v1_MAU_AUXR_X_table,
  Reservation_kv3_v1_MAU_AUXR_Y_table
};

const struct kvx_core_info kvx_kv3_v1_core_info = { kvx_kv3_v1_optab, "kv3-1", kvx_kv3_v1_resources, ELF_KVX_CORE_KV3_1, kvx_kv3_v1_pseudo_func, 26, (int **) kvx_kv3_v1_reservation_table_table, kvx_kv3_v1_RESERVATION_TABLE_LINES, kvx_kv3_v1_RESOURCE_MAX, (char **) kvx_kv3_v1_resource_names };

struct kvxopc kvx_kv3_v1_optab[] = {
  { /* A_Opcode-kv3_v1-ABSD_registerW_registerZ_simple */
    .as_op = "absd",
    .codewords = {
      {
        .opcode = 0x64000000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-ABSHQ_registerW_registerZ_double */
    .as_op = "abshq",
    .codewords = {
      {
        .opcode = 0xf4013000,
        .mask = 0xff03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x67ffffff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-ABSWP_registerW_registerZ_double */
    .as_op = "abswp",
    .codewords = {
      {
        .opcode = 0xf4012000,
        .mask = 0xff03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x67ffffff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-ABSW_registerW_registerZ_simple */
    .as_op = "absw",
    .codewords = {
      {
        .opcode = 0x74000000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-COPYD_registerW_registerZ_simple */
    .as_op = "copyd",
    .codewords = {
      {
        .opcode = 0x6a000000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-COPYW_registerW_registerZ_simple */
    .as_op = "copyw",
    .codewords = {
      {
        .opcode = 0x7a000000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-NEGD_registerW_registerZ_simple */
    .as_op = "negd",
    .codewords = {
      {
        .opcode = 0x65000000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-NEGHQ_registerW_registerZ_double */
    .as_op = "neghq",
    .codewords = {
      {
        .opcode = 0xf5013000,
        .mask = 0xff03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x67ffffff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-NEGWP_registerW_registerZ_double */
    .as_op = "negwp",
    .codewords = {
      {
        .opcode = 0xf5012000,
        .mask = 0xff03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x67ffffff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-NEGW_registerW_registerZ_simple */
    .as_op = "negw",
    .codewords = {
      {
        .opcode = 0x75000000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-NOTD_registerW_registerZ_simple */
    .as_op = "notd",
    .codewords = {
      {
        .opcode = 0x6c00ffc0,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-NOTW_registerW_registerZ_simple */
    .as_op = "notw",
    .codewords = {
      {
        .opcode = 0x7c00ffc0,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-SATDH_registerW_registerZ_simple */
    .as_op = "satdh",
    .codewords = {
      {
        .opcode = 0x7e022400,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-SATDW_registerW_registerZ_simple */
    .as_op = "satdw",
    .codewords = {
      {
        .opcode = 0x7e022800,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-SXBD_registerW_registerZ_simple */
    .as_op = "sxbd",
    .codewords = {
      {
        .opcode = 0x68037000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-SXHD_registerW_registerZ_simple */
    .as_op = "sxhd",
    .codewords = {
      {
        .opcode = 0x6803f000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-SXWD_registerW_registerZ_simple */
    .as_op = "sxwd",
    .codewords = {
      {
        .opcode = 0x6903f000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-XCOPYO_registerA_registerBe_simple */
    .as_op = "xcopyo",
    .codewords = {
      {
        .opcode = 0x01000f80,
        .mask = 0x7f001fff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH,
    .format = {
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbe_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-XCOPYO_registerA_registerBo_simple */
    .as_op = "xcopyo",
    .codewords = {
      {
        .opcode = 0x01001f80,
        .mask = 0x7f001fff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH,
    .format = {
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbo_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-XMOVEFO_registerN_registerBe_simple */
    .as_op = "xmovefo",
    .codewords = {
      {
        .opcode = 0x00081f80,
        .mask = 0x7f0c1fff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_AUXW_CRRP,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerbe_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-XMOVEFO_registerN_registerBo_simple */
    .as_op = "xmovefo",
    .codewords = {
      {
        .opcode = 0x000c1f80,
        .mask = 0x7f0c1fff,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_AUXW_CRRP,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerbo_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-ZXBD_registerW_registerZ_simple */
    .as_op = "zxbd",
    .codewords = {
      {
        .opcode = 0x78003fc0,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-ZXHD_registerW_registerZ_simple */
    .as_op = "zxhd",
    .codewords = {
      {
        .opcode = 0x6403f000,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* A_Opcode-kv3_v1-ZXWD_registerW_registerZ_simple */
    .as_op = "zxwd",
    .codewords = {
      {
        .opcode = 0x7800ffc0,
        .mask = 0x7f03ffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-ABDD_registerW_registerZ_registerY_simple */
    .as_op = "abdd",
    .codewords = {
      {
        .opcode = 0x74010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDD_registerW_registerZ_s010_simple */
    .as_op = "abdd",
    .codewords = {
      {
        .opcode = 0x64000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDD_registerW_registerZ_s037_double */
    .as_op = "abdd",
    .codewords = {
      {
        .opcode = 0xe4000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDD_registerW_registerZ_w032_splat32_double */
    .as_op = "abdd",
    .codewords = {
      {
        .opcode = 0xf4010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ABDD_registerW_registerZ_w064_triple */
    .as_op = "abdd",
    .codewords = {
      {
        .opcode = 0xe4000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDHQ_registerW_registerZ_registerY_simple */
    .as_op = "abdhq",
    .codewords = {
      {
        .opcode = 0x74013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "abdhq",
    .codewords = {
      {
        .opcode = 0xf4013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ABDWP_registerW_registerZ_registerY_simple */
    .as_op = "abdwp",
    .codewords = {
      {
        .opcode = 0x74012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDWP_registerW_registerZ_w032_splat32_double */
    .as_op = "abdwp",
    .codewords = {
      {
        .opcode = 0xf4012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ABDW_registerW_registerZ_registerY_simple */
    .as_op = "abdw",
    .codewords = {
      {
        .opcode = 0x74011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDW_registerW_registerZ_s010_simple */
    .as_op = "abdw",
    .codewords = {
      {
        .opcode = 0x74000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ABDW_registerW_registerZ_s037_double */
    .as_op = "abdw",
    .codewords = {
      {
        .opcode = 0xf4000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_doscale_registerY_registerZ_registerU_simple */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0x3f03e000,
        .mask = 0x7f07e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_lsucond_registerY_registerZ_registerU_simple */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0x3f030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_lsucond_registerY_s027_registerZ_registerU_double */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0xbf030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_lsucond_registerY_s054_registerZ_registerU_triple */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0xbf030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_s010_registerZ_registerU_simple */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0x3f010000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_s037_registerZ_registerU_double */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0xbf010000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPD_w064_registerZ_registerU_triple */
    .as_op = "acswapd",
    .codewords = {
      {
        .opcode = 0xbf010000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_doscale_registerY_registerZ_registerU_simple */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0x3e03e000,
        .mask = 0x7f07e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_lsucond_registerY_registerZ_registerU_simple */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0x3e030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_lsucond_registerY_s027_registerZ_registerU_double */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0xbe030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_lsucond_registerY_s054_registerZ_registerU_triple */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0xbe030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_s010_registerZ_registerU_simple */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0x3e010000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_s037_registerZ_registerU_double */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0xbe010000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ACSWAPW_w064_registerZ_registerU_triple */
    .as_op = "acswapw",
    .codewords = {
      {
        .opcode = 0xbe010000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registeru_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ADDCD.I_registerW_registerZ_registerY_simple */
    .as_op = "addcd.i",
    .codewords = {
      {
        .opcode = 0x7e01d000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDCD.I_registerW_registerZ_w032_double */
    .as_op = "addcd.i",
    .codewords = {
      {
        .opcode = 0xfe01d000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDCD_registerW_registerZ_registerY_simple */
    .as_op = "addcd",
    .codewords = {
      {
        .opcode = 0x7e01c000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDCD_registerW_registerZ_w032_double */
    .as_op = "addcd",
    .codewords = {
      {
        .opcode = 0xfe01c000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDD_registerW_registerZ_registerY_simple */
    .as_op = "addd",
    .codewords = {
      {
        .opcode = 0x71010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDD_registerW_registerZ_s010_simple */
    .as_op = "addd",
    .codewords = {
      {
        .opcode = 0x61000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDD_registerW_registerZ_s037_double */
    .as_op = "addd",
    .codewords = {
      {
        .opcode = 0xe1000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDD_registerW_registerZ_w032_splat32_double */
    .as_op = "addd",
    .codewords = {
      {
        .opcode = 0xf1010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDD_registerW_registerZ_w064_triple */
    .as_op = "addd",
    .codewords = {
      {
        .opcode = 0xe1000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDHCP.C_registerW_registerZ_registerY_simple */
    .as_op = "addhcp.c",
    .codewords = {
      {
        .opcode = 0x7c013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDHCP.C_registerW_registerZ_w032_splat32_double */
    .as_op = "addhcp.c",
    .codewords = {
      {
        .opcode = 0xfc013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDHQ_registerW_registerZ_registerY_simple */
    .as_op = "addhq",
    .codewords = {
      {
        .opcode = 0x71013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "addhq",
    .codewords = {
      {
        .opcode = 0xf1013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDSD_registerW_registerZ_registerY_simple */
    .as_op = "addsd",
    .codewords = {
      {
        .opcode = 0x7e01a000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSD_registerW_registerZ_s010_simple */
    .as_op = "addsd",
    .codewords = {
      {
        .opcode = 0x6e010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSD_registerW_registerZ_s037_double */
    .as_op = "addsd",
    .codewords = {
      {
        .opcode = 0xee010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSD_registerW_registerZ_w064_triple */
    .as_op = "addsd",
    .codewords = {
      {
        .opcode = 0xee010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSHQ_registerW_registerZ_registerY_simple */
    .as_op = "addshq",
    .codewords = {
      {
        .opcode = 0x7e01f000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "addshq",
    .codewords = {
      {
        .opcode = 0xfe01f000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDSWP_registerW_registerZ_registerY_simple */
    .as_op = "addswp",
    .codewords = {
      {
        .opcode = 0x7e01e000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSWP_registerW_registerZ_w032_splat32_double */
    .as_op = "addswp",
    .codewords = {
      {
        .opcode = 0xfe01e000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDSW_registerW_registerZ_registerY_simple */
    .as_op = "addsw",
    .codewords = {
      {
        .opcode = 0x7e01b000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDSW_registerW_registerZ_w032_double */
    .as_op = "addsw",
    .codewords = {
      {
        .opcode = 0xfe01b000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDUWD_registerW_registerZ_registerY_simple */
    .as_op = "adduwd",
    .codewords = {
      {
        .opcode = 0x7a014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDUWD_registerW_registerZ_w032_splat32_double */
    .as_op = "adduwd",
    .codewords = {
      {
        .opcode = 0xfa014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDWC.C_registerW_registerZ_registerY_simple */
    .as_op = "addwc.c",
    .codewords = {
      {
        .opcode = 0x7c012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDWC.C_registerW_registerZ_w032_splat32_double */
    .as_op = "addwc.c",
    .codewords = {
      {
        .opcode = 0xfc012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDWD_registerW_registerZ_registerY_simple */
    .as_op = "addwd",
    .codewords = {
      {
        .opcode = 0x78014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDWD_registerW_registerZ_w032_splat32_double */
    .as_op = "addwd",
    .codewords = {
      {
        .opcode = 0xf8014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDWP_registerW_registerZ_registerY_simple */
    .as_op = "addwp",
    .codewords = {
      {
        .opcode = 0x71012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDWP_registerW_registerZ_w032_splat32_double */
    .as_op = "addwp",
    .codewords = {
      {
        .opcode = 0xf1012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDW_registerW_registerZ_registerY_simple */
    .as_op = "addw",
    .codewords = {
      {
        .opcode = 0x71011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDW_registerW_registerZ_s010_simple */
    .as_op = "addw",
    .codewords = {
      {
        .opcode = 0x71000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDW_registerW_registerZ_s037_double */
    .as_op = "addw",
    .codewords = {
      {
        .opcode = 0xf1000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16D_registerW_registerZ_registerY_simple */
    .as_op = "addx16d",
    .codewords = {
      {
        .opcode = 0x76014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16D_registerW_registerZ_w032_splat32_double */
    .as_op = "addx16d",
    .codewords = {
      {
        .opcode = 0xf6014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDX16HQ_registerW_registerZ_registerY_simple */
    .as_op = "addx16hq",
    .codewords = {
      {
        .opcode = 0x76017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16HQ_registerW_registerZ_w032_splat32_double */
    .as_op = "addx16hq",
    .codewords = {
      {
        .opcode = 0xf6017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDX16UWD_registerW_registerZ_registerY_simple */
    .as_op = "addx16uwd",
    .codewords = {
      {
        .opcode = 0x7e018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16UWD_registerW_registerZ_w032_double */
    .as_op = "addx16uwd",
    .codewords = {
      {
        .opcode = 0xfe018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16WD_registerW_registerZ_registerY_simple */
    .as_op = "addx16wd",
    .codewords = {
      {
        .opcode = 0x76018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16WD_registerW_registerZ_w032_double */
    .as_op = "addx16wd",
    .codewords = {
      {
        .opcode = 0xf6018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16WP_registerW_registerZ_registerY_simple */
    .as_op = "addx16wp",
    .codewords = {
      {
        .opcode = 0x76016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16WP_registerW_registerZ_w032_splat32_double */
    .as_op = "addx16wp",
    .codewords = {
      {
        .opcode = 0xf6016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDX16W_registerW_registerZ_registerY_simple */
    .as_op = "addx16w",
    .codewords = {
      {
        .opcode = 0x76015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX16W_registerW_registerZ_w032_double */
    .as_op = "addx16w",
    .codewords = {
      {
        .opcode = 0xf6015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2D_registerW_registerZ_registerY_simple */
    .as_op = "addx2d",
    .codewords = {
      {
        .opcode = 0x70014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2D_registerW_registerZ_w032_splat32_double */
    .as_op = "addx2d",
    .codewords = {
      {
        .opcode = 0xf0014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDX2HQ_registerW_registerZ_registerY_simple */
    .as_op = "addx2hq",
    .codewords = {
      {
        .opcode = 0x70017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2HQ_registerW_registerZ_w032_splat32_double */
    .as_op = "addx2hq",
    .codewords = {
      {
        .opcode = 0xf0017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDX2UWD_registerW_registerZ_registerY_simple */
    .as_op = "addx2uwd",
    .codewords = {
      {
        .opcode = 0x78018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2UWD_registerW_registerZ_w032_double */
    .as_op = "addx2uwd",
    .codewords = {
      {
        .opcode = 0xf8018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2WD_registerW_registerZ_registerY_simple */
    .as_op = "addx2wd",
    .codewords = {
      {
        .opcode = 0x70018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2WD_registerW_registerZ_w032_double */
    .as_op = "addx2wd",
    .codewords = {
      {
        .opcode = 0xf0018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2WP_registerW_registerZ_registerY_simple */
    .as_op = "addx2wp",
    .codewords = {
      {
        .opcode = 0x70016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2WP_registerW_registerZ_w032_splat32_double */
    .as_op = "addx2wp",
    .codewords = {
      {
        .opcode = 0xf0016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDX2W_registerW_registerZ_registerY_simple */
    .as_op = "addx2w",
    .codewords = {
      {
        .opcode = 0x70015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX2W_registerW_registerZ_w032_double */
    .as_op = "addx2w",
    .codewords = {
      {
        .opcode = 0xf0015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4D_registerW_registerZ_registerY_simple */
    .as_op = "addx4d",
    .codewords = {
      {
        .opcode = 0x72014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4D_registerW_registerZ_w032_splat32_double */
    .as_op = "addx4d",
    .codewords = {
      {
        .opcode = 0xf2014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDX4HQ_registerW_registerZ_registerY_simple */
    .as_op = "addx4hq",
    .codewords = {
      {
        .opcode = 0x72017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4HQ_registerW_registerZ_w032_splat32_double */
    .as_op = "addx4hq",
    .codewords = {
      {
        .opcode = 0xf2017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDX4UWD_registerW_registerZ_registerY_simple */
    .as_op = "addx4uwd",
    .codewords = {
      {
        .opcode = 0x7a018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4UWD_registerW_registerZ_w032_double */
    .as_op = "addx4uwd",
    .codewords = {
      {
        .opcode = 0xfa018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4WD_registerW_registerZ_registerY_simple */
    .as_op = "addx4wd",
    .codewords = {
      {
        .opcode = 0x72018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4WD_registerW_registerZ_w032_double */
    .as_op = "addx4wd",
    .codewords = {
      {
        .opcode = 0xf2018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4WP_registerW_registerZ_registerY_simple */
    .as_op = "addx4wp",
    .codewords = {
      {
        .opcode = 0x72016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4WP_registerW_registerZ_w032_splat32_double */
    .as_op = "addx4wp",
    .codewords = {
      {
        .opcode = 0xf2016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDX4W_registerW_registerZ_registerY_simple */
    .as_op = "addx4w",
    .codewords = {
      {
        .opcode = 0x72015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX4W_registerW_registerZ_w032_double */
    .as_op = "addx4w",
    .codewords = {
      {
        .opcode = 0xf2015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8D_registerW_registerZ_registerY_simple */
    .as_op = "addx8d",
    .codewords = {
      {
        .opcode = 0x74014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8D_registerW_registerZ_w032_splat32_double */
    .as_op = "addx8d",
    .codewords = {
      {
        .opcode = 0xf4014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDX8HQ_registerW_registerZ_registerY_simple */
    .as_op = "addx8hq",
    .codewords = {
      {
        .opcode = 0x74017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8HQ_registerW_registerZ_w032_splat32_double */
    .as_op = "addx8hq",
    .codewords = {
      {
        .opcode = 0xf4017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDX8UWD_registerW_registerZ_registerY_simple */
    .as_op = "addx8uwd",
    .codewords = {
      {
        .opcode = 0x7c018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8UWD_registerW_registerZ_w032_double */
    .as_op = "addx8uwd",
    .codewords = {
      {
        .opcode = 0xfc018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8WD_registerW_registerZ_registerY_simple */
    .as_op = "addx8wd",
    .codewords = {
      {
        .opcode = 0x74018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8WD_registerW_registerZ_w032_double */
    .as_op = "addx8wd",
    .codewords = {
      {
        .opcode = 0xf4018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8WP_registerW_registerZ_registerY_simple */
    .as_op = "addx8wp",
    .codewords = {
      {
        .opcode = 0x74016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8WP_registerW_registerZ_w032_splat32_double */
    .as_op = "addx8wp",
    .codewords = {
      {
        .opcode = 0xf4016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ADDX8W_registerW_registerZ_registerY_simple */
    .as_op = "addx8w",
    .codewords = {
      {
        .opcode = 0x74015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ADDX8W_registerW_registerZ_w032_double */
    .as_op = "addx8w",
    .codewords = {
      {
        .opcode = 0xf4015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ALADDD_doscale_registerY_registerZ_registerT_simple */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0x2f03e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDD_lsucond_registerY_registerZ_registerT_simple */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0x2f030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDD_lsucond_registerY_s027_registerZ_registerT_double */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0xaf030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDD_lsucond_registerY_s054_registerZ_registerT_triple */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0xaf030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDD_s010_registerZ_registerT_simple */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0x2f010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDD_s037_registerZ_registerT_double */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0xaf010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDD_w064_registerZ_registerT_triple */
    .as_op = "aladdd",
    .codewords = {
      {
        .opcode = 0xaf010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_doscale_registerY_registerZ_registerT_simple */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0x2e03e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_lsucond_registerY_registerZ_registerT_simple */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0x2e030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_lsucond_registerY_s027_registerZ_registerT_double */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0xae030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_lsucond_registerY_s054_registerZ_registerT_triple */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0xae030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_s010_registerZ_registerT_simple */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0x2e010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_s037_registerZ_registerT_double */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0xae010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALADDW_w064_registerZ_registerT_triple */
    .as_op = "aladdw",
    .codewords = {
      {
        .opcode = 0xae010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-ALCLRD_doscale_registerW_registerY_registerZ_simple */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0x2b03e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRD_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0x2b030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-ALCLRD_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0xab030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRD_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0xab030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRD_registerW_s010_registerZ_simple */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0x2b010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRD_registerW_s037_registerZ_double */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0xab010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRD_registerW_w064_registerZ_triple */
    .as_op = "alclrd",
    .codewords = {
      {
        .opcode = 0xab010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_doscale_registerW_registerY_registerZ_simple */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0x2a03e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0x2a030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0xaa030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0xaa030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_registerW_s010_registerZ_simple */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0x2a010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_registerW_s037_registerZ_double */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0xaa010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALCLRW_registerW_w064_registerZ_triple */
    .as_op = "alclrw",
    .codewords = {
      {
        .opcode = 0xaa010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-ALIGNO_registerN_registerBe_registerCo_registerZ_simple */
    .as_op = "aligno",
    .codewords = {
      {
        .opcode = 0x00081040,
        .mask = 0x7f0c1040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_AUXW_CRRP,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerbe_opnd,
      &kv3_v1_registerco_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNO_registerN_registerBe_registerCo_u006_simple */
    .as_op = "aligno",
    .codewords = {
      {
        .opcode = 0x00081000,
        .mask = 0x7f0c1040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_AUXW_CRRP,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerbe_opnd,
      &kv3_v1_registerco_opnd,
      &kv3_v1_byteshift_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNO_registerN_registerBo_registerCe_registerZ_simple */
    .as_op = "aligno",
    .codewords = {
      {
        .opcode = 0x000c1040,
        .mask = 0x7f0c1040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_AUXW_CRRP,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerbo_opnd,
      &kv3_v1_registerce_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNO_registerN_registerBo_registerCe_u006_simple */
    .as_op = "aligno",
    .codewords = {
      {
        .opcode = 0x000c1000,
        .mask = 0x7f0c1040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_AUXW_CRRP,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerbo_opnd,
      &kv3_v1_registerce_opnd,
      &kv3_v1_byteshift_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNV_registerA_registerBe_registerCo_registerZ_simple */
    .as_op = "alignv",
    .codewords = {
      {
        .opcode = 0x01000040,
        .mask = 0x7f001040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH,
    .format = {
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbe_opnd,
      &kv3_v1_registerco_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNV_registerA_registerBe_registerCo_u006_simple */
    .as_op = "alignv",
    .codewords = {
      {
        .opcode = 0x01000000,
        .mask = 0x7f001040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH,
    .format = {
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbe_opnd,
      &kv3_v1_registerco_opnd,
      &kv3_v1_byteshift_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNV_registerA_registerBo_registerCe_registerZ_simple */
    .as_op = "alignv",
    .codewords = {
      {
        .opcode = 0x01001040,
        .mask = 0x7f001040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH,
    .format = {
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbo_opnd,
      &kv3_v1_registerce_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ALIGNV_registerA_registerBo_registerCe_u006_simple */
    .as_op = "alignv",
    .codewords = {
      {
        .opcode = 0x01001000,
        .mask = 0x7f001040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_CRRP_CRWL_CRWH,
    .format = {
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbo_opnd,
      &kv3_v1_registerce_opnd,
      &kv3_v1_byteshift_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-ANDD_registerW_registerZ_registerY_simple */
    .as_op = "andd",
    .codewords = {
      {
        .opcode = 0x78010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDD_registerW_registerZ_s010_simple */
    .as_op = "andd",
    .codewords = {
      {
        .opcode = 0x68000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDD_registerW_registerZ_s037_double */
    .as_op = "andd",
    .codewords = {
      {
        .opcode = 0xe8000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDD_registerW_registerZ_w032_splat32_double */
    .as_op = "andd",
    .codewords = {
      {
        .opcode = 0xf8010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ANDD_registerW_registerZ_w064_triple */
    .as_op = "andd",
    .codewords = {
      {
        .opcode = 0xe8000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDND_registerW_registerZ_registerY_simple */
    .as_op = "andnd",
    .codewords = {
      {
        .opcode = 0x7e010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDND_registerW_registerZ_s010_simple */
    .as_op = "andnd",
    .codewords = {
      {
        .opcode = 0x6e000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDND_registerW_registerZ_s037_double */
    .as_op = "andnd",
    .codewords = {
      {
        .opcode = 0xee000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDND_registerW_registerZ_w032_splat32_double */
    .as_op = "andnd",
    .codewords = {
      {
        .opcode = 0xfe010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-ANDND_registerW_registerZ_w064_triple */
    .as_op = "andnd",
    .codewords = {
      {
        .opcode = 0xee000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDNW_registerW_registerZ_registerY_simple */
    .as_op = "andnw",
    .codewords = {
      {
        .opcode = 0x7e011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDNW_registerW_registerZ_s010_simple */
    .as_op = "andnw",
    .codewords = {
      {
        .opcode = 0x7e000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDNW_registerW_registerZ_s037_double */
    .as_op = "andnw",
    .codewords = {
      {
        .opcode = 0xfe000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDW_registerW_registerZ_registerY_simple */
    .as_op = "andw",
    .codewords = {
      {
        .opcode = 0x78011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDW_registerW_registerZ_s010_simple */
    .as_op = "andw",
    .codewords = {
      {
        .opcode = 0x78000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ANDW_registerW_registerZ_s037_double */
    .as_op = "andw",
    .codewords = {
      {
        .opcode = 0xf8000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGHQ_registerW_registerZ_registerY_simple */
    .as_op = "avghq",
    .codewords = {
      {
        .opcode = 0x78017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "avghq",
    .codewords = {
      {
        .opcode = 0xf8017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-AVGRHQ_registerW_registerZ_registerY_simple */
    .as_op = "avgrhq",
    .codewords = {
      {
        .opcode = 0x7a017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "avgrhq",
    .codewords = {
      {
        .opcode = 0xfa017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-AVGRUHQ_registerW_registerZ_registerY_simple */
    .as_op = "avgruhq",
    .codewords = {
      {
        .opcode = 0x7b017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRUHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "avgruhq",
    .codewords = {
      {
        .opcode = 0xfb017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-AVGRUWP_registerW_registerZ_registerY_simple */
    .as_op = "avgruwp",
    .codewords = {
      {
        .opcode = 0x7b016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRUWP_registerW_registerZ_w032_splat32_double */
    .as_op = "avgruwp",
    .codewords = {
      {
        .opcode = 0xfb016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-AVGRUW_registerW_registerZ_registerY_simple */
    .as_op = "avgruw",
    .codewords = {
      {
        .opcode = 0x7b015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRUW_registerW_registerZ_w032_double */
    .as_op = "avgruw",
    .codewords = {
      {
        .opcode = 0xfb015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRWP_registerW_registerZ_registerY_simple */
    .as_op = "avgrwp",
    .codewords = {
      {
        .opcode = 0x7a016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRWP_registerW_registerZ_w032_splat32_double */
    .as_op = "avgrwp",
    .codewords = {
      {
        .opcode = 0xfa016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-AVGRW_registerW_registerZ_registerY_simple */
    .as_op = "avgrw",
    .codewords = {
      {
        .opcode = 0x7a015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGRW_registerW_registerZ_w032_double */
    .as_op = "avgrw",
    .codewords = {
      {
        .opcode = 0xfa015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGUHQ_registerW_registerZ_registerY_simple */
    .as_op = "avguhq",
    .codewords = {
      {
        .opcode = 0x79017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGUHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "avguhq",
    .codewords = {
      {
        .opcode = 0xf9017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-AVGUWP_registerW_registerZ_registerY_simple */
    .as_op = "avguwp",
    .codewords = {
      {
        .opcode = 0x79016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGUWP_registerW_registerZ_w032_splat32_double */
    .as_op = "avguwp",
    .codewords = {
      {
        .opcode = 0xf9016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-AVGUW_registerW_registerZ_registerY_simple */
    .as_op = "avguw",
    .codewords = {
      {
        .opcode = 0x79015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGUW_registerW_registerZ_w032_double */
    .as_op = "avguw",
    .codewords = {
      {
        .opcode = 0xf9015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGWP_registerW_registerZ_registerY_simple */
    .as_op = "avgwp",
    .codewords = {
      {
        .opcode = 0x78016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGWP_registerW_registerZ_w032_splat32_double */
    .as_op = "avgwp",
    .codewords = {
      {
        .opcode = 0xf8016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-AVGW_registerW_registerZ_registerY_simple */
    .as_op = "avgw",
    .codewords = {
      {
        .opcode = 0x78015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AVGW_registerW_registerZ_w032_double */
    .as_op = "avgw",
    .codewords = {
      {
        .opcode = 0xf8015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-AWAIT_simple */
    .as_op = "await",
    .codewords = {
      {
        .opcode = 0x0fa00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-BARRIER_simple */
    .as_op = "barrier",
    .codewords = {
      {
        .opcode = 0x0fac0000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-CALL_s027_simple */
    .as_op = "call",
    .codewords = {
      {
        .opcode = 0x18000000,
        .mask = 0x78000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_pcrel27_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-CBSD_registerW_registerZ_simple */
    .as_op = "cbsd",
    .codewords = {
      {
        .opcode = 0x72022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CBSWP_registerW_registerZ_simple */
    .as_op = "cbswp",
    .codewords = {
      {
        .opcode = 0x72024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CBSW_registerW_registerZ_simple */
    .as_op = "cbsw",
    .codewords = {
      {
        .opcode = 0x72023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CB_branchcond_registerZ_s017_simple */
    .as_op = "cb",
    .codewords = {
      {
        .opcode = 0x08000000,
        .mask = 0x78000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_branchcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_pcrel17_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s",
  },
  { /* Opcode-kv3_v1-CLRF_registerW_registerZ_u006_u006_simple */
    .as_op = "clrf",
    .codewords = {
      {
        .opcode = 0x6c030000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_stopbit2_stopbit4_opnd,
      &kv3_v1_startbit_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-CLSD_registerW_registerZ_simple */
    .as_op = "clsd",
    .codewords = {
      {
        .opcode = 0x71022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CLSWP_registerW_registerZ_simple */
    .as_op = "clswp",
    .codewords = {
      {
        .opcode = 0x71024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CLSW_registerW_registerZ_simple */
    .as_op = "clsw",
    .codewords = {
      {
        .opcode = 0x71023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CLZD_registerW_registerZ_simple */
    .as_op = "clzd",
    .codewords = {
      {
        .opcode = 0x70022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CLZWP_registerW_registerZ_simple */
    .as_op = "clzwp",
    .codewords = {
      {
        .opcode = 0x70024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CLZW_registerW_registerZ_simple */
    .as_op = "clzw",
    .codewords = {
      {
        .opcode = 0x70023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CMOVED_scalarcond_registerZ_registerW_registerY_simple */
    .as_op = "cmoved",
    .codewords = {
      {
        .opcode = 0x70020000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_scalarcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s",
  },
  { /* Opcode-kv3_v1-CMOVED_scalarcond_registerZ_registerW_s010_simple */
    .as_op = "cmoved",
    .codewords = {
      {
        .opcode = 0x60020000,
        .mask = 0x70030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_scalarcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s",
  },
  { /* Opcode-kv3_v1-CMOVED_scalarcond_registerZ_registerW_s037_double */
    .as_op = "cmoved",
    .codewords = {
      {
        .opcode = 0xe0020000,
        .mask = 0xf0030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_scalarcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s",
  },
  { /* Opcode-kv3_v1-CMOVED_scalarcond_registerZ_registerW_w064_triple */
    .as_op = "cmoved",
    .codewords = {
      {
        .opcode = 0xe0020000,
        .mask = 0xf0030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_Y,
    .format = {
      &kv3_v1_scalarcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s",
  },
  { /* Opcode-kv3_v1-CMOVEHQ_simdcond_registerZ_registerW_registerY_simple */
    .as_op = "cmovehq",
    .codewords = {
      {
        .opcode = 0x78021000,
        .mask = 0x7803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_simdcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s",
  },
  { /* Opcode-kv3_v1-CMOVEHQ_simdcond_registerZ_registerW_w032_splat32_double */
    .as_op = "cmovehq",
    .codewords = {
      {
        .opcode = 0xf8021000,
        .mask = 0xf803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_simdcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s%s",
  },
  { /* Opcode-kv3_v1-CMOVEWP_simdcond_registerZ_registerW_registerY_simple */
    .as_op = "cmovewp",
    .codewords = {
      {
        .opcode = 0x70021000,
        .mask = 0x7803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_simdcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s",
  },
  { /* Opcode-kv3_v1-CMOVEWP_simdcond_registerZ_registerW_w032_splat32_double */
    .as_op = "cmovewp",
    .codewords = {
      {
        .opcode = 0xf0021000,
        .mask = 0xf803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_simdcond_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s = %s%s",
  },
  { /* Opcode-kv3_v1-CMULDT_registerM_registerZ_registerY_simple */
    .as_op = "cmuldt",
    .codewords = {
      {
        .opcode = 0x5b041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULDT_registerM_registerZ_s010_simple */
    .as_op = "cmuldt",
    .codewords = {
      {
        .opcode = 0x4b040000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULDT_registerM_registerZ_s037_double */
    .as_op = "cmuldt",
    .codewords = {
      {
        .opcode = 0xcb040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULDT_registerM_registerZ_w064_triple */
    .as_op = "cmuldt",
    .codewords = {
      {
        .opcode = 0xcb040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULGHXDT_registerM_registerZ_registerY_simple */
    .as_op = "cmulghxdt",
    .codewords = {
      {
        .opcode = 0x5f041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULGLXDT_registerM_registerZ_registerY_simple */
    .as_op = "cmulglxdt",
    .codewords = {
      {
        .opcode = 0x5d041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULGMXDT_registerM_registerZ_registerY_simple */
    .as_op = "cmulgmxdt",
    .codewords = {
      {
        .opcode = 0x5e041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CMULXDT_registerM_registerZ_registerY_simple */
    .as_op = "cmulxdt",
    .codewords = {
      {
        .opcode = 0x5c041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPD_comparison_registerW_registerZ_registerY_simple */
    .as_op = "compd",
    .codewords = {
      {
        .opcode = 0x7001a000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPD_comparison_registerW_registerZ_s010_simple */
    .as_op = "compd",
    .codewords = {
      {
        .opcode = 0x60010000,
        .mask = 0x70030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPD_comparison_registerW_registerZ_s037_double */
    .as_op = "compd",
    .codewords = {
      {
        .opcode = 0xe0010000,
        .mask = 0xf0030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPD_comparison_registerW_registerZ_w064_triple */
    .as_op = "compd",
    .codewords = {
      {
        .opcode = 0xe0010000,
        .mask = 0xf0030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPNHQ_comparison_registerW_registerZ_registerY_simple */
    .as_op = "compnhq",
    .codewords = {
      {
        .opcode = 0x7001f000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPNHQ_comparison_registerW_registerZ_w032_splat32_double */
    .as_op = "compnhq",
    .codewords = {
      {
        .opcode = 0xf001f000,
        .mask = 0xf003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-COMPNWP_comparison_registerW_registerZ_registerY_simple */
    .as_op = "compnwp",
    .codewords = {
      {
        .opcode = 0x7001e000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPNWP_comparison_registerW_registerZ_w032_splat32_double */
    .as_op = "compnwp",
    .codewords = {
      {
        .opcode = 0xf001e000,
        .mask = 0xf003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-COMPUWD_comparison_registerW_registerZ_registerY_simple */
    .as_op = "compuwd",
    .codewords = {
      {
        .opcode = 0x7001d000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPUWD_comparison_registerW_registerZ_w032_double */
    .as_op = "compuwd",
    .codewords = {
      {
        .opcode = 0xf001d000,
        .mask = 0xf003f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPWD_comparison_registerW_registerZ_registerY_simple */
    .as_op = "compwd",
    .codewords = {
      {
        .opcode = 0x7001c000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPWD_comparison_registerW_registerZ_w032_double */
    .as_op = "compwd",
    .codewords = {
      {
        .opcode = 0xf001c000,
        .mask = 0xf003f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPW_comparison_registerW_registerZ_registerY_simple */
    .as_op = "compw",
    .codewords = {
      {
        .opcode = 0x7001b000,
        .mask = 0x7003f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-COMPW_comparison_registerW_registerZ_w032_double */
    .as_op = "compw",
    .codewords = {
      {
        .opcode = 0xf001b000,
        .mask = 0xf003f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_comparison_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CONVDHV0_roundint_saturate_registerAE_registerBq_simple */
    .as_op = "convdhv0",
    .codewords = {
      {
        .opcode = 0x05000000,
        .mask = 0x7f003040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_roundint_opnd,
      &kv3_v1_saturate_opnd,
      &kv3_v1_registerae_opnd,
      &kv3_v1_registerbq_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-CONVDHV1_roundint_saturate_registerAO_registerBq_simple */
    .as_op = "convdhv1",
    .codewords = {
      {
        .opcode = 0x05001000,
        .mask = 0x7f003040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_roundint_opnd,
      &kv3_v1_saturate_opnd,
      &kv3_v1_registerao_opnd,
      &kv3_v1_registerbq_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-CONVWBV0_roundint_saturate_registerAx_registerBq_simple */
    .as_op = "convwbv0",
    .codewords = {
      {
        .opcode = 0x06000000,
        .mask = 0x7f003040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_roundint_opnd,
      &kv3_v1_saturate_opnd,
      &kv3_v1_registerax_opnd,
      &kv3_v1_registerbq_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-CONVWBV1_roundint_saturate_registerAy_registerBq_simple */
    .as_op = "convwbv1",
    .codewords = {
      {
        .opcode = 0x06001000,
        .mask = 0x7f003040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_roundint_opnd,
      &kv3_v1_saturate_opnd,
      &kv3_v1_registeray_opnd,
      &kv3_v1_registerbq_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-CONVWBV2_roundint_saturate_registerAz_registerBq_simple */
    .as_op = "convwbv2",
    .codewords = {
      {
        .opcode = 0x06002000,
        .mask = 0x7f003040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_roundint_opnd,
      &kv3_v1_saturate_opnd,
      &kv3_v1_registeraz_opnd,
      &kv3_v1_registerbq_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-CONVWBV3_roundint_saturate_registerAt_registerBq_simple */
    .as_op = "convwbv3",
    .codewords = {
      {
        .opcode = 0x06003000,
        .mask = 0x7f003040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_roundint_opnd,
      &kv3_v1_saturate_opnd,
      &kv3_v1_registerat_opnd,
      &kv3_v1_registerbq_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-COPYO_registerN_registerR_simple */
    .as_op = "copyo",
    .codewords = {
      {
        .opcode = 0x3e050000,
        .mask = 0x7f0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_AUXW,
    .format = {
      &kv3_v1_registern_opnd,
      &kv3_v1_registerr_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-COPYQ_registerM_registerZ_registerY_simple */
    .as_op = "copyq",
    .codewords = {
      {
        .opcode = 0x5f00f000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCBELLW_registerW_registerZ_registerY_simple */
    .as_op = "crcbellw",
    .codewords = {
      {
        .opcode = 0x59002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCBELLW_registerW_registerZ_w032_double */
    .as_op = "crcbellw",
    .codewords = {
      {
        .opcode = 0xd9002000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCBELMW_registerW_registerZ_registerY_simple */
    .as_op = "crcbelmw",
    .codewords = {
      {
        .opcode = 0x58002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCBELMW_registerW_registerZ_w032_double */
    .as_op = "crcbelmw",
    .codewords = {
      {
        .opcode = 0xd8002000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCLELLW_registerW_registerZ_registerY_simple */
    .as_op = "crclellw",
    .codewords = {
      {
        .opcode = 0x5b002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCLELLW_registerW_registerZ_w032_double */
    .as_op = "crclellw",
    .codewords = {
      {
        .opcode = 0xdb002000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCLELMW_registerW_registerZ_registerY_simple */
    .as_op = "crclelmw",
    .codewords = {
      {
        .opcode = 0x5a002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CRCLELMW_registerW_registerZ_w032_double */
    .as_op = "crclelmw",
    .codewords = {
      {
        .opcode = 0xda002000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-CTZD_registerW_registerZ_simple */
    .as_op = "ctzd",
    .codewords = {
      {
        .opcode = 0x73022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CTZWP_registerW_registerZ_simple */
    .as_op = "ctzwp",
    .codewords = {
      {
        .opcode = 0x73024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-CTZW_registerW_registerZ_simple */
    .as_op = "ctzw",
    .codewords = {
      {
        .opcode = 0x73023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-D1INVAL_simple */
    .as_op = "d1inval",
    .codewords = {
      {
        .opcode = 0x3f8d0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-DINVALL_lsucond_registerY_registerZ_simple */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0x3c1e0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s]",
  },
  { /* Opcode-kv3_v1-DINVALL_lsucond_registerY_s027_registerZ_double */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0xbc1e0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-DINVALL_lsucond_registerY_s054_registerZ_triple */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0xbc1e0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-DINVALL_registerY_registerZ_simple */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0x3c1ee000,
        .mask = 0x7ffff000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DINVALL_s010_registerZ_simple */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0x3c1c0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DINVALL_s037_registerZ_double */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0xbc1c0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DINVALL_w064_registerZ_triple */
    .as_op = "dinvall",
    .codewords = {
      {
        .opcode = 0xbc1c0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DOT2SUWDP_registerM_registerP_registerO_simple */
    .as_op = "dot2suwdp",
    .codewords = {
      {
        .opcode = 0x52002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2SUWD_registerW_registerZ_registerY_simple */
    .as_op = "dot2suwd",
    .codewords = {
      {
        .opcode = 0x5e002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2SUWD_registerW_registerZ_s010_simple */
    .as_op = "dot2suwd",
    .codewords = {
      {
        .opcode = 0x4e000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2SUWD_registerW_registerZ_s037_double */
    .as_op = "dot2suwd",
    .codewords = {
      {
        .opcode = 0xce000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2SUWD_registerW_registerZ_w064_triple */
    .as_op = "dot2suwd",
    .codewords = {
      {
        .opcode = 0xce000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2UWDP_registerM_registerP_registerO_simple */
    .as_op = "dot2uwdp",
    .codewords = {
      {
        .opcode = 0x51002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2UWD_registerW_registerZ_registerY_simple */
    .as_op = "dot2uwd",
    .codewords = {
      {
        .opcode = 0x5d002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2UWD_registerW_registerZ_s010_simple */
    .as_op = "dot2uwd",
    .codewords = {
      {
        .opcode = 0x4d000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2UWD_registerW_registerZ_s037_double */
    .as_op = "dot2uwd",
    .codewords = {
      {
        .opcode = 0xcd000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2UWD_registerW_registerZ_w064_triple */
    .as_op = "dot2uwd",
    .codewords = {
      {
        .opcode = 0xcd000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2WDP_registerM_registerP_registerO_simple */
    .as_op = "dot2wdp",
    .codewords = {
      {
        .opcode = 0x50002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2WD_registerW_registerZ_registerY_simple */
    .as_op = "dot2wd",
    .codewords = {
      {
        .opcode = 0x5c002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2WD_registerW_registerZ_s010_simple */
    .as_op = "dot2wd",
    .codewords = {
      {
        .opcode = 0x4c000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2WD_registerW_registerZ_s037_double */
    .as_op = "dot2wd",
    .codewords = {
      {
        .opcode = 0xcc000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2WD_registerW_registerZ_w064_triple */
    .as_op = "dot2wd",
    .codewords = {
      {
        .opcode = 0xcc000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2WZP_registerM_registerP_registerO_simple */
    .as_op = "dot2wzp",
    .codewords = {
      {
        .opcode = 0x53002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2W_registerW_registerZ_registerY_simple */
    .as_op = "dot2w",
    .codewords = {
      {
        .opcode = 0x5f002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2W_registerW_registerZ_s010_simple */
    .as_op = "dot2w",
    .codewords = {
      {
        .opcode = 0x4f000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2W_registerW_registerZ_s037_double */
    .as_op = "dot2w",
    .codewords = {
      {
        .opcode = 0xcf000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DOT2W_registerW_registerZ_w064_triple */
    .as_op = "dot2w",
    .codewords = {
      {
        .opcode = 0xcf000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-DTOUCHL_lsucond_registerY_registerZ_simple */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0x3c0e0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s]",
  },
  { /* Opcode-kv3_v1-DTOUCHL_lsucond_registerY_s027_registerZ_double */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0xbc0e0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-DTOUCHL_lsucond_registerY_s054_registerZ_triple */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0xbc0e0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-DTOUCHL_registerY_registerZ_simple */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0x3c0ee000,
        .mask = 0x7ffff000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DTOUCHL_s010_registerZ_simple */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0x3c0c0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DTOUCHL_s037_registerZ_double */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0xbc0c0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DTOUCHL_w064_registerZ_triple */
    .as_op = "dtouchl",
    .codewords = {
      {
        .opcode = 0xbc0c0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_lsucond_registerY_registerZ_simple */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0x280f0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_lsucond_registerY_s027_registerZ_double */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0xa80f0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_lsucond_registerY_s054_registerZ_triple */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0xa80f0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_registerY_registerZ_simple */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0x280fe000,
        .mask = 0x7ffff000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_s010_registerZ_simple */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0x280d0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_s037_registerZ_double */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0xa80d0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-DZEROL_w064_registerZ_triple */
    .as_op = "dzerol",
    .codewords = {
      {
        .opcode = 0xa80d0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-EORD_registerW_registerZ_registerY_simple */
    .as_op = "eord",
    .codewords = {
      {
        .opcode = 0x7c010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-EORD_registerW_registerZ_s010_simple */
    .as_op = "eord",
    .codewords = {
      {
        .opcode = 0x6c000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-EORD_registerW_registerZ_s037_double */
    .as_op = "eord",
    .codewords = {
      {
        .opcode = 0xec000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-EORD_registerW_registerZ_w032_splat32_double */
    .as_op = "eord",
    .codewords = {
      {
        .opcode = 0xfc010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-EORD_registerW_registerZ_w064_triple */
    .as_op = "eord",
    .codewords = {
      {
        .opcode = 0xec000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-EORW_registerW_registerZ_registerY_simple */
    .as_op = "eorw",
    .codewords = {
      {
        .opcode = 0x7c011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-EORW_registerW_registerZ_s010_simple */
    .as_op = "eorw",
    .codewords = {
      {
        .opcode = 0x7c000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-EORW_registerW_registerZ_s037_double */
    .as_op = "eorw",
    .codewords = {
      {
        .opcode = 0xfc000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ERROP_simple */
    .as_op = "errop",
    .codewords = {
      {
        .opcode = 0x00000000,
        .mask = 0x7fffffc0,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-EXTFS_registerW_registerZ_u006_u006_simple */
    .as_op = "extfs",
    .codewords = {
      {
        .opcode = 0x68030000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_stopbit2_stopbit4_opnd,
      &kv3_v1_startbit_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-EXTFZ_registerW_registerZ_u006_u006_simple */
    .as_op = "extfz",
    .codewords = {
      {
        .opcode = 0x64030000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_stopbit2_stopbit4_opnd,
      &kv3_v1_startbit_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-FABSD_registerW_registerZ_simple */
    .as_op = "fabsd",
    .codewords = {
      {
        .opcode = 0x71032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FABSHQ_registerW_registerZ_simple */
    .as_op = "fabshq",
    .codewords = {
      {
        .opcode = 0x77032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FABSWP_registerW_registerZ_simple */
    .as_op = "fabswp",
    .codewords = {
      {
        .opcode = 0x75032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FABSW_registerW_registerZ_simple */
    .as_op = "fabsw",
    .codewords = {
      {
        .opcode = 0x73032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FADDDC.C_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fadddc.c",
    .codewords = {
      {
        .opcode = 0x5d030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDDP_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fadddp",
    .codewords = {
      {
        .opcode = 0x5c030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDD_registerW_registerZ_s010_simple */
    .as_op = "faddd",
    .codewords = {
      {
        .opcode = 0x40020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDD_registerW_registerZ_s037_double */
    .as_op = "faddd",
    .codewords = {
      {
        .opcode = 0xc0020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDD_registerW_registerZ_w064_triple */
    .as_op = "faddd",
    .codewords = {
      {
        .opcode = 0xc0020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "faddd",
    .codewords = {
      {
        .opcode = 0x50020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDHQ_registerW_registerZ_s010_simple */
    .as_op = "faddhq",
    .codewords = {
      {
        .opcode = 0x42020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDHQ_registerW_registerZ_s037_double */
    .as_op = "faddhq",
    .codewords = {
      {
        .opcode = 0xc2020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDHQ_registerW_registerZ_w064_triple */
    .as_op = "faddhq",
    .codewords = {
      {
        .opcode = 0xc2020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDHQ_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "faddhq",
    .codewords = {
      {
        .opcode = 0x52020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWC.C_registerW_registerZ_s010_simple */
    .as_op = "faddwc.c",
    .codewords = {
      {
        .opcode = 0x43020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWC.C_registerW_registerZ_s037_double */
    .as_op = "faddwc.c",
    .codewords = {
      {
        .opcode = 0xc3020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWC.C_registerW_registerZ_w064_triple */
    .as_op = "faddwc.c",
    .codewords = {
      {
        .opcode = 0xc3020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWC.C_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "faddwc.c",
    .codewords = {
      {
        .opcode = 0x53020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWCP.C_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "faddwcp.c",
    .codewords = {
      {
        .opcode = 0x59070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWP_registerW_registerZ_s010_simple */
    .as_op = "faddwp",
    .codewords = {
      {
        .opcode = 0x41020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWP_registerW_registerZ_s037_double */
    .as_op = "faddwp",
    .codewords = {
      {
        .opcode = 0xc1020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWP_registerW_registerZ_w064_triple */
    .as_op = "faddwp",
    .codewords = {
      {
        .opcode = 0xc1020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWP_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "faddwp",
    .codewords = {
      {
        .opcode = 0x51020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDWQ_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "faddwq",
    .codewords = {
      {
        .opcode = 0x58070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDW_registerW_registerZ_s010_simple */
    .as_op = "faddw",
    .codewords = {
      {
        .opcode = 0x4c020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDW_registerW_registerZ_s037_double */
    .as_op = "faddw",
    .codewords = {
      {
        .opcode = 0xcc020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDW_registerW_registerZ_w064_triple */
    .as_op = "faddw",
    .codewords = {
      {
        .opcode = 0xcc020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FADDW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "faddw",
    .codewords = {
      {
        .opcode = 0x5c020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCDIVD_silent2_registerW_registerP_simple */
    .as_op = "fcdivd",
    .codewords = {
      {
        .opcode = 0x71035000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FCDIVWP_silent2_registerW_registerP_simple */
    .as_op = "fcdivwp",
    .codewords = {
      {
        .opcode = 0x75035000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FCDIVW_silent2_registerW_registerP_simple */
    .as_op = "fcdivw",
    .codewords = {
      {
        .opcode = 0x73035000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FCOMPD_floatcomp_registerW_registerZ_registerY_simple */
    .as_op = "fcompd",
    .codewords = {
      {
        .opcode = 0x78030000,
        .mask = 0x7803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCOMPD_floatcomp_registerW_registerZ_w032_double */
    .as_op = "fcompd",
    .codewords = {
      {
        .opcode = 0xf8030000,
        .mask = 0xf803f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCOMPNHQ_floatcomp_registerW_registerZ_registerY_simple */
    .as_op = "fcompnhq",
    .codewords = {
      {
        .opcode = 0x78031000,
        .mask = 0x7803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCOMPNHQ_floatcomp_registerW_registerZ_w032_splat32_double */
    .as_op = "fcompnhq",
    .codewords = {
      {
        .opcode = 0xf8031000,
        .mask = 0xf803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-FCOMPNWP_floatcomp_registerW_registerZ_registerY_simple */
    .as_op = "fcompnwp",
    .codewords = {
      {
        .opcode = 0x70031000,
        .mask = 0x7803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCOMPNWP_floatcomp_registerW_registerZ_w032_splat32_double */
    .as_op = "fcompnwp",
    .codewords = {
      {
        .opcode = 0xf0031000,
        .mask = 0xf803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-FCOMPW_floatcomp_registerW_registerZ_registerY_simple */
    .as_op = "fcompw",
    .codewords = {
      {
        .opcode = 0x70030000,
        .mask = 0x7803f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FCOMPW_floatcomp_registerW_registerZ_w032_double */
    .as_op = "fcompw",
    .codewords = {
      {
        .opcode = 0xf0030000,
        .mask = 0xf803f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_floatcomp_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2WDP_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fdot2wdp",
    .codewords = {
      {
        .opcode = 0x5c070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2WD_registerW_registerZ_s010_simple */
    .as_op = "fdot2wd",
    .codewords = {
      {
        .opcode = 0x4d010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2WD_registerW_registerZ_s037_double */
    .as_op = "fdot2wd",
    .codewords = {
      {
        .opcode = 0xcd010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2WD_registerW_registerZ_w064_triple */
    .as_op = "fdot2wd",
    .codewords = {
      {
        .opcode = 0xcd010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2WD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fdot2wd",
    .codewords = {
      {
        .opcode = 0x5d010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2WZP_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fdot2wzp",
    .codewords = {
      {
        .opcode = 0x5d070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2W_registerW_registerZ_s010_simple */
    .as_op = "fdot2w",
    .codewords = {
      {
        .opcode = 0x4c010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2W_registerW_registerZ_s037_double */
    .as_op = "fdot2w",
    .codewords = {
      {
        .opcode = 0xcc010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2W_registerW_registerZ_w064_triple */
    .as_op = "fdot2w",
    .codewords = {
      {
        .opcode = 0xcc010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FDOT2W_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fdot2w",
    .codewords = {
      {
        .opcode = 0x5c010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FENCE_simple */
    .as_op = "fence",
    .codewords = {
      {
        .opcode = 0x3fcd0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-FFMAD_registerW_registerZ_s010_simple */
    .as_op = "ffmad",
    .codewords = {
      {
        .opcode = 0x40010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAD_registerW_registerZ_s037_double */
    .as_op = "ffmad",
    .codewords = {
      {
        .opcode = 0xc0010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAD_registerW_registerZ_w064_triple */
    .as_op = "ffmad",
    .codewords = {
      {
        .opcode = 0xc0010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmad",
    .codewords = {
      {
        .opcode = 0x50010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHQ_registerW_registerZ_s010_simple */
    .as_op = "ffmahq",
    .codewords = {
      {
        .opcode = 0x43010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHQ_registerW_registerZ_s037_double */
    .as_op = "ffmahq",
    .codewords = {
      {
        .opcode = 0xc3010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHQ_registerW_registerZ_w064_triple */
    .as_op = "ffmahq",
    .codewords = {
      {
        .opcode = 0xc3010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHQ_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmahq",
    .codewords = {
      {
        .opcode = 0x53010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHWQ_registerM_registerZ_s010_simple */
    .as_op = "ffmahwq",
    .codewords = {
      {
        .opcode = 0x41030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHWQ_registerM_registerZ_s037_double */
    .as_op = "ffmahwq",
    .codewords = {
      {
        .opcode = 0xc1030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHWQ_registerM_registerZ_w064_triple */
    .as_op = "ffmahwq",
    .codewords = {
      {
        .opcode = 0xc1030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHWQ_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "ffmahwq",
    .codewords = {
      {
        .opcode = 0x51030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHW_registerW_registerZ_s010_simple */
    .as_op = "ffmahw",
    .codewords = {
      {
        .opcode = 0x48020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHW_registerW_registerZ_s037_double */
    .as_op = "ffmahw",
    .codewords = {
      {
        .opcode = 0xc8020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHW_registerW_registerZ_w064_triple */
    .as_op = "ffmahw",
    .codewords = {
      {
        .opcode = 0xc8020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAHW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmahw",
    .codewords = {
      {
        .opcode = 0x58020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWDP_registerM_registerZ_s010_simple */
    .as_op = "ffmawdp",
    .codewords = {
      {
        .opcode = 0x40030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWDP_registerM_registerZ_s037_double */
    .as_op = "ffmawdp",
    .codewords = {
      {
        .opcode = 0xc0030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWDP_registerM_registerZ_w064_triple */
    .as_op = "ffmawdp",
    .codewords = {
      {
        .opcode = 0xc0030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWDP_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "ffmawdp",
    .codewords = {
      {
        .opcode = 0x50030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWD_registerW_registerZ_s010_simple */
    .as_op = "ffmawd",
    .codewords = {
      {
        .opcode = 0x41010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWD_registerW_registerZ_s037_double */
    .as_op = "ffmawd",
    .codewords = {
      {
        .opcode = 0xc1010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWD_registerW_registerZ_w064_triple */
    .as_op = "ffmawd",
    .codewords = {
      {
        .opcode = 0xc1010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmawd",
    .codewords = {
      {
        .opcode = 0x51010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWP_registerW_registerZ_s010_simple */
    .as_op = "ffmawp",
    .codewords = {
      {
        .opcode = 0x42010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWP_registerW_registerZ_s037_double */
    .as_op = "ffmawp",
    .codewords = {
      {
        .opcode = 0xc2010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWP_registerW_registerZ_w064_triple */
    .as_op = "ffmawp",
    .codewords = {
      {
        .opcode = 0xc2010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAWP_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmawp",
    .codewords = {
      {
        .opcode = 0x52010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAW_registerW_registerZ_s010_simple */
    .as_op = "ffmaw",
    .codewords = {
      {
        .opcode = 0x49020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAW_registerW_registerZ_s037_double */
    .as_op = "ffmaw",
    .codewords = {
      {
        .opcode = 0xc9020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAW_registerW_registerZ_w064_triple */
    .as_op = "ffmaw",
    .codewords = {
      {
        .opcode = 0xc9020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMAW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmaw",
    .codewords = {
      {
        .opcode = 0x59020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSD_registerW_registerZ_s010_simple */
    .as_op = "ffmsd",
    .codewords = {
      {
        .opcode = 0x44010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSD_registerW_registerZ_s037_double */
    .as_op = "ffmsd",
    .codewords = {
      {
        .opcode = 0xc4010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSD_registerW_registerZ_w064_triple */
    .as_op = "ffmsd",
    .codewords = {
      {
        .opcode = 0xc4010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmsd",
    .codewords = {
      {
        .opcode = 0x54010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHQ_registerW_registerZ_s010_simple */
    .as_op = "ffmshq",
    .codewords = {
      {
        .opcode = 0x47010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHQ_registerW_registerZ_s037_double */
    .as_op = "ffmshq",
    .codewords = {
      {
        .opcode = 0xc7010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHQ_registerW_registerZ_w064_triple */
    .as_op = "ffmshq",
    .codewords = {
      {
        .opcode = 0xc7010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHQ_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmshq",
    .codewords = {
      {
        .opcode = 0x57010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHWQ_registerM_registerZ_s010_simple */
    .as_op = "ffmshwq",
    .codewords = {
      {
        .opcode = 0x43030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHWQ_registerM_registerZ_s037_double */
    .as_op = "ffmshwq",
    .codewords = {
      {
        .opcode = 0xc3030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHWQ_registerM_registerZ_w064_triple */
    .as_op = "ffmshwq",
    .codewords = {
      {
        .opcode = 0xc3030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHWQ_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "ffmshwq",
    .codewords = {
      {
        .opcode = 0x53030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHW_registerW_registerZ_s010_simple */
    .as_op = "ffmshw",
    .codewords = {
      {
        .opcode = 0x4a020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHW_registerW_registerZ_s037_double */
    .as_op = "ffmshw",
    .codewords = {
      {
        .opcode = 0xca020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHW_registerW_registerZ_w064_triple */
    .as_op = "ffmshw",
    .codewords = {
      {
        .opcode = 0xca020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSHW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmshw",
    .codewords = {
      {
        .opcode = 0x5a020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWDP_registerM_registerZ_s010_simple */
    .as_op = "ffmswdp",
    .codewords = {
      {
        .opcode = 0x42030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWDP_registerM_registerZ_s037_double */
    .as_op = "ffmswdp",
    .codewords = {
      {
        .opcode = 0xc2030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWDP_registerM_registerZ_w064_triple */
    .as_op = "ffmswdp",
    .codewords = {
      {
        .opcode = 0xc2030000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWDP_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "ffmswdp",
    .codewords = {
      {
        .opcode = 0x52030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWD_registerW_registerZ_s010_simple */
    .as_op = "ffmswd",
    .codewords = {
      {
        .opcode = 0x45010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWD_registerW_registerZ_s037_double */
    .as_op = "ffmswd",
    .codewords = {
      {
        .opcode = 0xc5010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWD_registerW_registerZ_w064_triple */
    .as_op = "ffmswd",
    .codewords = {
      {
        .opcode = 0xc5010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmswd",
    .codewords = {
      {
        .opcode = 0x55010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWP_registerW_registerZ_s010_simple */
    .as_op = "ffmswp",
    .codewords = {
      {
        .opcode = 0x46010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWP_registerW_registerZ_s037_double */
    .as_op = "ffmswp",
    .codewords = {
      {
        .opcode = 0xc6010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWP_registerW_registerZ_w064_triple */
    .as_op = "ffmswp",
    .codewords = {
      {
        .opcode = 0xc6010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSWP_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmswp",
    .codewords = {
      {
        .opcode = 0x56010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSW_registerW_registerZ_s010_simple */
    .as_op = "ffmsw",
    .codewords = {
      {
        .opcode = 0x4b020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSW_registerW_registerZ_s037_double */
    .as_op = "ffmsw",
    .codewords = {
      {
        .opcode = 0xcb020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSW_registerW_registerZ_w064_triple */
    .as_op = "ffmsw",
    .codewords = {
      {
        .opcode = 0xcb020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FFMSW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "ffmsw",
    .codewords = {
      {
        .opcode = 0x5b020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FIXEDD_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "fixedd",
    .codewords = {
      {
        .opcode = 0x46030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FIXEDUD_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "fixedud",
    .codewords = {
      {
        .opcode = 0x47030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FIXEDUWP_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "fixeduwp",
    .codewords = {
      {
        .opcode = 0x4f030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FIXEDUW_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "fixeduw",
    .codewords = {
      {
        .opcode = 0x4b030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FIXEDWP_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "fixedwp",
    .codewords = {
      {
        .opcode = 0x4e030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FIXEDW_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "fixedw",
    .codewords = {
      {
        .opcode = 0x4a030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FLOATD_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "floatd",
    .codewords = {
      {
        .opcode = 0x44030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FLOATUD_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "floatud",
    .codewords = {
      {
        .opcode = 0x45030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FLOATUWP_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "floatuwp",
    .codewords = {
      {
        .opcode = 0x4d030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FLOATUW_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "floatuw",
    .codewords = {
      {
        .opcode = 0x49030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FLOATWP_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "floatwp",
    .codewords = {
      {
        .opcode = 0x4c030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FLOATW_rounding_silent_registerW_registerZ_u006_simple */
    .as_op = "floatw",
    .codewords = {
      {
        .opcode = 0x48030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMAXD_registerW_registerZ_registerY_simple */
    .as_op = "fmaxd",
    .codewords = {
      {
        .opcode = 0x71038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMAXHQ_registerW_registerZ_registerY_simple */
    .as_op = "fmaxhq",
    .codewords = {
      {
        .opcode = 0x77038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMAXWP_registerW_registerZ_registerY_simple */
    .as_op = "fmaxwp",
    .codewords = {
      {
        .opcode = 0x75038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMAXW_registerW_registerZ_registerY_simple */
    .as_op = "fmaxw",
    .codewords = {
      {
        .opcode = 0x73038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMIND_registerW_registerZ_registerY_simple */
    .as_op = "fmind",
    .codewords = {
      {
        .opcode = 0x70038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMINHQ_registerW_registerZ_registerY_simple */
    .as_op = "fminhq",
    .codewords = {
      {
        .opcode = 0x76038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMINWP_registerW_registerZ_registerY_simple */
    .as_op = "fminwp",
    .codewords = {
      {
        .opcode = 0x74038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMINW_registerW_registerZ_registerY_simple */
    .as_op = "fminw",
    .codewords = {
      {
        .opcode = 0x72038000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMM212W_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmm212w",
    .codewords = {
      {
        .opcode = 0x54070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMMA212W_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmma212w",
    .codewords = {
      {
        .opcode = 0x54030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMMA242HW0_registerA0_registerBp_registerC_registerD_simple */
    .as_op = "fmma242hw0",
    .codewords = {
      {
        .opcode = 0x03000000,
        .mask = 0x7f041000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registera0_opnd,
      &kv3_v1_registerbp_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-FMMA242HW1_registerA1_registerBp_registerC_registerD_simple */
    .as_op = "fmma242hw1",
    .codewords = {
      {
        .opcode = 0x03001000,
        .mask = 0x7f041000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registera1_opnd,
      &kv3_v1_registerbp_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-FMMA242HW2_registerA2_registerBp_registerC_registerD_simple */
    .as_op = "fmma242hw2",
    .codewords = {
      {
        .opcode = 0x03040000,
        .mask = 0x7f041000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registera2_opnd,
      &kv3_v1_registerbp_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-FMMA242HW3_registerA3_registerBp_registerC_registerD_simple */
    .as_op = "fmma242hw3",
    .codewords = {
      {
        .opcode = 0x03041000,
        .mask = 0x7f041000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registera3_opnd,
      &kv3_v1_registerbp_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-FMMS212W_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmms212w",
    .codewords = {
      {
        .opcode = 0x56030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULD_registerW_registerZ_s010_simple */
    .as_op = "fmuld",
    .codewords = {
      {
        .opcode = 0x48010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULD_registerW_registerZ_s037_double */
    .as_op = "fmuld",
    .codewords = {
      {
        .opcode = 0xc8010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULD_registerW_registerZ_w064_triple */
    .as_op = "fmuld",
    .codewords = {
      {
        .opcode = 0xc8010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmuld",
    .codewords = {
      {
        .opcode = 0x58010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHQ_registerW_registerZ_s010_simple */
    .as_op = "fmulhq",
    .codewords = {
      {
        .opcode = 0x4b010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHQ_registerW_registerZ_s037_double */
    .as_op = "fmulhq",
    .codewords = {
      {
        .opcode = 0xcb010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHQ_registerW_registerZ_w064_triple */
    .as_op = "fmulhq",
    .codewords = {
      {
        .opcode = 0xcb010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHQ_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulhq",
    .codewords = {
      {
        .opcode = 0x5b010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHWQ_registerM_registerZ_s010_simple */
    .as_op = "fmulhwq",
    .codewords = {
      {
        .opcode = 0x41070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHWQ_registerM_registerZ_s037_double */
    .as_op = "fmulhwq",
    .codewords = {
      {
        .opcode = 0xc1070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHWQ_registerM_registerZ_w064_triple */
    .as_op = "fmulhwq",
    .codewords = {
      {
        .opcode = 0xc1070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHWQ_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmulhwq",
    .codewords = {
      {
        .opcode = 0x51070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHW_registerW_registerZ_s010_simple */
    .as_op = "fmulhw",
    .codewords = {
      {
        .opcode = 0x4f020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHW_registerW_registerZ_s037_double */
    .as_op = "fmulhw",
    .codewords = {
      {
        .opcode = 0xcf020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHW_registerW_registerZ_w064_triple */
    .as_op = "fmulhw",
    .codewords = {
      {
        .opcode = 0xcf020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULHW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulhw",
    .codewords = {
      {
        .opcode = 0x5f020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC.C_registerW_registerZ_s010_simple */
    .as_op = "fmulwc.c",
    .codewords = {
      {
        .opcode = 0x4f010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC.C_registerW_registerZ_s037_double */
    .as_op = "fmulwc.c",
    .codewords = {
      {
        .opcode = 0xcf010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC.C_registerW_registerZ_w064_triple */
    .as_op = "fmulwc.c",
    .codewords = {
      {
        .opcode = 0xcf010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC.C_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulwc.c",
    .codewords = {
      {
        .opcode = 0x5f010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC_registerW_registerZ_s010_simple */
    .as_op = "fmulwc",
    .codewords = {
      {
        .opcode = 0x4e010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC_registerW_registerZ_s037_double */
    .as_op = "fmulwc",
    .codewords = {
      {
        .opcode = 0xce010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC_registerW_registerZ_w064_triple */
    .as_op = "fmulwc",
    .codewords = {
      {
        .opcode = 0xce010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWC_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulwc",
    .codewords = {
      {
        .opcode = 0x5e010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC.C_registerM_registerZ_s010_simple */
    .as_op = "fmulwdc.c",
    .codewords = {
      {
        .opcode = 0x43070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC.C_registerM_registerZ_s037_double */
    .as_op = "fmulwdc.c",
    .codewords = {
      {
        .opcode = 0xc3070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC.C_registerM_registerZ_w064_triple */
    .as_op = "fmulwdc.c",
    .codewords = {
      {
        .opcode = 0xc3070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC.C_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmulwdc.c",
    .codewords = {
      {
        .opcode = 0x53070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC_registerM_registerZ_s010_simple */
    .as_op = "fmulwdc",
    .codewords = {
      {
        .opcode = 0x42070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC_registerM_registerZ_s037_double */
    .as_op = "fmulwdc",
    .codewords = {
      {
        .opcode = 0xc2070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC_registerM_registerZ_w064_triple */
    .as_op = "fmulwdc",
    .codewords = {
      {
        .opcode = 0xc2070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDC_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmulwdc",
    .codewords = {
      {
        .opcode = 0x52070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDP_registerM_registerZ_s010_simple */
    .as_op = "fmulwdp",
    .codewords = {
      {
        .opcode = 0x40070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDP_registerM_registerZ_s037_double */
    .as_op = "fmulwdp",
    .codewords = {
      {
        .opcode = 0xc0070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDP_registerM_registerZ_w064_triple */
    .as_op = "fmulwdp",
    .codewords = {
      {
        .opcode = 0xc0070000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWDP_rounding_silent_registerM_registerZ_registerY_simple */
    .as_op = "fmulwdp",
    .codewords = {
      {
        .opcode = 0x50070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWD_registerW_registerZ_s010_simple */
    .as_op = "fmulwd",
    .codewords = {
      {
        .opcode = 0x49010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWD_registerW_registerZ_s037_double */
    .as_op = "fmulwd",
    .codewords = {
      {
        .opcode = 0xc9010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWD_registerW_registerZ_w064_triple */
    .as_op = "fmulwd",
    .codewords = {
      {
        .opcode = 0xc9010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulwd",
    .codewords = {
      {
        .opcode = 0x59010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWP_registerW_registerZ_s010_simple */
    .as_op = "fmulwp",
    .codewords = {
      {
        .opcode = 0x4a010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWP_registerW_registerZ_s037_double */
    .as_op = "fmulwp",
    .codewords = {
      {
        .opcode = 0xca010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWP_registerW_registerZ_w064_triple */
    .as_op = "fmulwp",
    .codewords = {
      {
        .opcode = 0xca010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWP_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulwp",
    .codewords = {
      {
        .opcode = 0x5a010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULWQ_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fmulwq",
    .codewords = {
      {
        .opcode = 0x5e070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULW_registerW_registerZ_s010_simple */
    .as_op = "fmulw",
    .codewords = {
      {
        .opcode = 0x4e020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULW_registerW_registerZ_s037_double */
    .as_op = "fmulw",
    .codewords = {
      {
        .opcode = 0xce020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULW_registerW_registerZ_w064_triple */
    .as_op = "fmulw",
    .codewords = {
      {
        .opcode = 0xce020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FMULW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fmulw",
    .codewords = {
      {
        .opcode = 0x5e020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FNARROW44WH_xrounding_silent2_registerA_registerBp_simple */
    .as_op = "fnarrow44wh",
    .codewords = {
      {
        .opcode = 0x07000040,
        .mask = 0x7f001040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_xrounding_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registera_opnd,
      &kv3_v1_registerbp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FNARROWDWP_rounding2_silent2_registerW_registerP_simple */
    .as_op = "fnarrowdwp",
    .codewords = {
      {
        .opcode = 0x7c036000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_rounding2_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FNARROWDW_rounding2_silent2_registerW_registerZ_simple */
    .as_op = "fnarrowdw",
    .codewords = {
      {
        .opcode = 0x78036000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_rounding2_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FNARROWWHQ_rounding2_silent2_registerW_registerP_simple */
    .as_op = "fnarrowwhq",
    .codewords = {
      {
        .opcode = 0x7e036000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_rounding2_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FNARROWWH_rounding2_silent2_registerW_registerZ_simple */
    .as_op = "fnarrowwh",
    .codewords = {
      {
        .opcode = 0x7a036000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_rounding2_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FNEGD_registerW_registerZ_simple */
    .as_op = "fnegd",
    .codewords = {
      {
        .opcode = 0x70032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FNEGHQ_registerW_registerZ_simple */
    .as_op = "fneghq",
    .codewords = {
      {
        .opcode = 0x76032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FNEGWP_registerW_registerZ_simple */
    .as_op = "fnegwp",
    .codewords = {
      {
        .opcode = 0x74032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FNEGW_registerW_registerZ_simple */
    .as_op = "fnegw",
    .codewords = {
      {
        .opcode = 0x72032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FRECW_rounding2_silent2_registerW_registerZ_simple */
    .as_op = "frecw",
    .codewords = {
      {
        .opcode = 0x72036000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_rounding2_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FRSRW_rounding2_silent2_registerW_registerZ_simple */
    .as_op = "frsrw",
    .codewords = {
      {
        .opcode = 0x73036000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_rounding2_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSBFDC.C_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fsbfdc.c",
    .codewords = {
      {
        .opcode = 0x5f030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFDP_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fsbfdp",
    .codewords = {
      {
        .opcode = 0x5e030000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFD_registerW_registerZ_s010_simple */
    .as_op = "fsbfd",
    .codewords = {
      {
        .opcode = 0x44020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFD_registerW_registerZ_s037_double */
    .as_op = "fsbfd",
    .codewords = {
      {
        .opcode = 0xc4020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFD_registerW_registerZ_w064_triple */
    .as_op = "fsbfd",
    .codewords = {
      {
        .opcode = 0xc4020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFD_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fsbfd",
    .codewords = {
      {
        .opcode = 0x54020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFHQ_registerW_registerZ_s010_simple */
    .as_op = "fsbfhq",
    .codewords = {
      {
        .opcode = 0x46020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFHQ_registerW_registerZ_s037_double */
    .as_op = "fsbfhq",
    .codewords = {
      {
        .opcode = 0xc6020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFHQ_registerW_registerZ_w064_triple */
    .as_op = "fsbfhq",
    .codewords = {
      {
        .opcode = 0xc6020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFHQ_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fsbfhq",
    .codewords = {
      {
        .opcode = 0x56020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWC.C_registerW_registerZ_s010_simple */
    .as_op = "fsbfwc.c",
    .codewords = {
      {
        .opcode = 0x47020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWC.C_registerW_registerZ_s037_double */
    .as_op = "fsbfwc.c",
    .codewords = {
      {
        .opcode = 0xc7020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWC.C_registerW_registerZ_w064_triple */
    .as_op = "fsbfwc.c",
    .codewords = {
      {
        .opcode = 0xc7020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWC.C_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fsbfwc.c",
    .codewords = {
      {
        .opcode = 0x57020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWCP.C_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fsbfwcp.c",
    .codewords = {
      {
        .opcode = 0x5b070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWP_registerW_registerZ_s010_simple */
    .as_op = "fsbfwp",
    .codewords = {
      {
        .opcode = 0x45020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWP_registerW_registerZ_s037_double */
    .as_op = "fsbfwp",
    .codewords = {
      {
        .opcode = 0xc5020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWP_registerW_registerZ_w064_triple */
    .as_op = "fsbfwp",
    .codewords = {
      {
        .opcode = 0xc5020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWP_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fsbfwp",
    .codewords = {
      {
        .opcode = 0x55020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFWQ_rounding_silent_registerM_registerP_registerO_simple */
    .as_op = "fsbfwq",
    .codewords = {
      {
        .opcode = 0x5a070000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFW_registerW_registerZ_s010_simple */
    .as_op = "fsbfw",
    .codewords = {
      {
        .opcode = 0x4d020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFW_registerW_registerZ_s037_double */
    .as_op = "fsbfw",
    .codewords = {
      {
        .opcode = 0xcd020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFW_registerW_registerZ_w064_triple */
    .as_op = "fsbfw",
    .codewords = {
      {
        .opcode = 0xcd020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSBFW_rounding_silent_registerW_registerZ_registerY_simple */
    .as_op = "fsbfw",
    .codewords = {
      {
        .opcode = 0x5d020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_rounding_opnd,
      &kv3_v1_silent_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s, %s",
  },
  { /* Opcode-kv3_v1-FSCALEWV_xrounding_silent2_rectify_registerA_registerB_simple */
    .as_op = "fscalewv",
    .codewords = {
      {
        .opcode = 0x07000000,
        .mask = 0x7f000040,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_xrounding_opnd,
      &kv3_v1_silent2_opnd,
      &kv3_v1_rectify_opnd,
      &kv3_v1_registera_opnd,
      &kv3_v1_registerb_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSDIVD_silent2_registerW_registerP_simple */
    .as_op = "fsdivd",
    .codewords = {
      {
        .opcode = 0x70035000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSDIVWP_silent2_registerW_registerP_simple */
    .as_op = "fsdivwp",
    .codewords = {
      {
        .opcode = 0x74035000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSDIVW_silent2_registerW_registerP_simple */
    .as_op = "fsdivw",
    .codewords = {
      {
        .opcode = 0x72035000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerp_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSRECD_silent2_registerW_registerZ_simple */
    .as_op = "fsrecd",
    .codewords = {
      {
        .opcode = 0x70034000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSRECWP_silent2_registerW_registerZ_simple */
    .as_op = "fsrecwp",
    .codewords = {
      {
        .opcode = 0x74034000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSRECW_silent2_registerW_registerZ_simple */
    .as_op = "fsrecw",
    .codewords = {
      {
        .opcode = 0x72034000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FSRSRD_registerW_registerZ_simple */
    .as_op = "fsrsrd",
    .codewords = {
      {
        .opcode = 0x78032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FSRSRWP_registerW_registerZ_simple */
    .as_op = "fsrsrwp",
    .codewords = {
      {
        .opcode = 0x7c032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FSRSRW_registerW_registerZ_simple */
    .as_op = "fsrsrw",
    .codewords = {
      {
        .opcode = 0x7a032000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-FWIDENLHWP_silent2_registerW_registerZ_simple */
    .as_op = "fwidenlhwp",
    .codewords = {
      {
        .opcode = 0x7c033000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FWIDENLHW_silent2_registerW_registerZ_simple */
    .as_op = "fwidenlhw",
    .codewords = {
      {
        .opcode = 0x7a033000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FWIDENLWD_silent2_registerW_registerZ_simple */
    .as_op = "fwidenlwd",
    .codewords = {
      {
        .opcode = 0x78033000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FWIDENMHWP_silent2_registerW_registerZ_simple */
    .as_op = "fwidenmhwp",
    .codewords = {
      {
        .opcode = 0x7d033000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FWIDENMHW_silent2_registerW_registerZ_simple */
    .as_op = "fwidenmhw",
    .codewords = {
      {
        .opcode = 0x7b033000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-FWIDENMWD_silent2_registerW_registerZ_simple */
    .as_op = "fwidenmwd",
    .codewords = {
      {
        .opcode = 0x79033000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_silent2_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s",
  },
  { /* Opcode-kv3_v1-GET_registerZ_systemS2_simple */
    .as_op = "get",
    .codewords = {
      {
        .opcode = 0x0fc40000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP,
    .format = {
      &kv3_v1_registerz_opnd,
      &kv3_v1_systems2_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-GET_registerZ_systemS3_simple */
    .as_op = "get",
    .codewords = {
      {
        .opcode = 0x0fc40000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP,
    .format = {
      &kv3_v1_registerz_opnd,
      &kv3_v1_systems3_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-GOTO_s027_simple */
    .as_op = "goto",
    .codewords = {
      {
        .opcode = 0x10000000,
        .mask = 0x78000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_pcrel27_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-I1INVALS_lsucond_registerY_registerZ_simple */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0x3c5e0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s]",
  },
  { /* Opcode-kv3_v1-I1INVALS_lsucond_registerY_s027_registerZ_double */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0xbc5e0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-I1INVALS_lsucond_registerY_s054_registerZ_triple */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0xbc5e0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s]",
  },
  { /* Opcode-kv3_v1-I1INVALS_registerY_registerZ_simple */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0x3c5ee000,
        .mask = 0x7ffff000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-I1INVALS_s010_registerZ_simple */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0x3c5c0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-I1INVALS_s037_registerZ_double */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0xbc5c0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-I1INVALS_w064_registerZ_triple */
    .as_op = "i1invals",
    .codewords = {
      {
        .opcode = 0xbc5c0000,
        .mask = 0xffff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s]",
  },
  { /* Opcode-kv3_v1-I1INVAL_simple */
    .as_op = "i1inval",
    .codewords = {
      {
        .opcode = 0x3f9d0000,
        .mask = 0x7fff0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-ICALL_registerZ_simple */
    .as_op = "icall",
    .codewords = {
      {
        .opcode = 0x0fdc0000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-IGET_registerZ_simple */
    .as_op = "iget",
    .codewords = {
      {
        .opcode = 0x0fcc0000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP,
    .format = {
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-IGOTO_registerZ_simple */
    .as_op = "igoto",
    .codewords = {
      {
        .opcode = 0x0fd80000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-INSF_registerW_registerZ_u006_u006_simple */
    .as_op = "insf",
    .codewords = {
      {
        .opcode = 0x60030000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_stopbit2_stopbit4_opnd,
      &kv3_v1_startbit_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-IORD_registerW_registerZ_registerY_simple */
    .as_op = "iord",
    .codewords = {
      {
        .opcode = 0x7a010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-IORD_registerW_registerZ_s010_simple */
    .as_op = "iord",
    .codewords = {
      {
        .opcode = 0x6a000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-IORD_registerW_registerZ_s037_double */
    .as_op = "iord",
    .codewords = {
      {
        .opcode = 0xea000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-IORD_registerW_registerZ_w032_splat32_double */
    .as_op = "iord",
    .codewords = {
      {
        .opcode = 0xfa010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-IORD_registerW_registerZ_w064_triple */
    .as_op = "iord",
    .codewords = {
      {
        .opcode = 0xea000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-IORND_registerW_registerZ_registerY_simple */
    .as_op = "iornd",
    .codewords = {
      {
        .opcode = 0x7f010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-IORND_registerW_registerZ_s010_simple */
    .as_op = "iornd",
    .codewords = {
      {
        .opcode = 0x6f000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-IORND_registerW_registerZ_s037_double */
    .as_op = "iornd",
    .codewords = {
      {
        .opcode = 0xef000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-IORND_registerW_registerZ_w032_splat32_double */
    .as_op = "iornd",
    .codewords = {
      {
        .opcode = 0xff010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-IORND_registerW_registerZ_w064_triple */
    .as_op = "iornd",
    .codewords = {
      {
        .opcode = 0xef000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-IORNW_registerW_registerZ_registerY_simple */
    .as_op = "iornw",
    .codewords = {
      {
        .opcode = 0x7f011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-IORNW_registerW_registerZ_s010_simple */
    .as_op = "iornw",
    .codewords = {
      {
        .opcode = 0x7f000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-IORNW_registerW_registerZ_s037_double */
    .as_op = "iornw",
    .codewords = {
      {
        .opcode = 0xff000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-IORW_registerW_registerZ_registerY_simple */
    .as_op = "iorw",
    .codewords = {
      {
        .opcode = 0x7a011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-IORW_registerW_registerZ_s010_simple */
    .as_op = "iorw",
    .codewords = {
      {
        .opcode = 0x7a000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-IORW_registerW_registerZ_s037_double */
    .as_op = "iorw",
    .codewords = {
      {
        .opcode = 0xfa000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LANDD_registerW_registerZ_registerY_simple */
    .as_op = "landd",
    .codewords = {
      {
        .opcode = 0x7c014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LANDD_registerW_registerZ_w032_splat32_double */
    .as_op = "landd",
    .codewords = {
      {
        .opcode = 0xfc014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-LANDHQ_registerW_registerZ_registerY_simple */
    .as_op = "landhq",
    .codewords = {
      {
        .opcode = 0x7c017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LANDHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "landhq",
    .codewords = {
      {
        .opcode = 0xfc017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-LANDWP_registerW_registerZ_registerY_simple */
    .as_op = "landwp",
    .codewords = {
      {
        .opcode = 0x7c016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LANDWP_registerW_registerZ_w032_splat32_double */
    .as_op = "landwp",
    .codewords = {
      {
        .opcode = 0xfc016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-LANDW_registerW_registerZ_registerY_simple */
    .as_op = "landw",
    .codewords = {
      {
        .opcode = 0x7c015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LANDW_registerW_registerZ_w032_double */
    .as_op = "landw",
    .codewords = {
      {
        .opcode = 0xfc015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LBS_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0x2402e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBS_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0x24020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LBS_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0xa4020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBS_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0xa4020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBS_variant_registerW_s010_registerZ_simple */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0x24000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBS_variant_registerW_s037_registerZ_double */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0xa4000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBS_variant_registerW_w064_registerZ_triple */
    .as_op = "lbs",
    .codewords = {
      {
        .opcode = 0xa4000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0x2002e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0x20020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0xa0020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0xa0020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_registerW_s010_registerZ_simple */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0x20000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_registerW_s037_registerZ_double */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0xa0000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LBZ_variant_registerW_w064_registerZ_triple */
    .as_op = "lbz",
    .codewords = {
      {
        .opcode = 0xa0000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0x3802e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0x38020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0xb8020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0xb8020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_registerW_s010_registerZ_simple */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0x38000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_registerW_s037_registerZ_double */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0xb8000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LD_variant_registerW_w064_registerZ_triple */
    .as_op = "ld",
    .codewords = {
      {
        .opcode = 0xb8000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0x2c02e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0x2c020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0xac020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0xac020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_registerW_s010_registerZ_simple */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0x2c000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_registerW_s037_registerZ_double */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0xac000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHS_variant_registerW_w064_registerZ_triple */
    .as_op = "lhs",
    .codewords = {
      {
        .opcode = 0xac000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0x2802e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0x28020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0xa8020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0xa8020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_registerW_s010_registerZ_simple */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0x28000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_registerW_s037_registerZ_double */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0xa8000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LHZ_variant_registerW_w064_registerZ_triple */
    .as_op = "lhz",
    .codewords = {
      {
        .opcode = 0xa8000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LIORD_registerW_registerZ_registerY_simple */
    .as_op = "liord",
    .codewords = {
      {
        .opcode = 0x7e014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LIORD_registerW_registerZ_w032_splat32_double */
    .as_op = "liord",
    .codewords = {
      {
        .opcode = 0xfe014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-LIORHQ_registerW_registerZ_registerY_simple */
    .as_op = "liorhq",
    .codewords = {
      {
        .opcode = 0x7e017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LIORHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "liorhq",
    .codewords = {
      {
        .opcode = 0xfe017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-LIORWP_registerW_registerZ_registerY_simple */
    .as_op = "liorwp",
    .codewords = {
      {
        .opcode = 0x7e016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LIORWP_registerW_registerZ_w032_splat32_double */
    .as_op = "liorwp",
    .codewords = {
      {
        .opcode = 0xfe016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-LIORW_registerW_registerZ_registerY_simple */
    .as_op = "liorw",
    .codewords = {
      {
        .opcode = 0x7e015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LIORW_registerW_registerZ_w032_double */
    .as_op = "liorw",
    .codewords = {
      {
        .opcode = 0xfe015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNANDD_registerW_registerZ_registerY_simple */
    .as_op = "lnandd",
    .codewords = {
      {
        .opcode = 0x7d014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNANDD_registerW_registerZ_w032_splat32_double */
    .as_op = "lnandd",
    .codewords = {
      {
        .opcode = 0xfd014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-LNANDHQ_registerW_registerZ_registerY_simple */
    .as_op = "lnandhq",
    .codewords = {
      {
        .opcode = 0x7d017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNANDHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "lnandhq",
    .codewords = {
      {
        .opcode = 0xfd017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-LNANDWP_registerW_registerZ_registerY_simple */
    .as_op = "lnandwp",
    .codewords = {
      {
        .opcode = 0x7d016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNANDWP_registerW_registerZ_w032_splat32_double */
    .as_op = "lnandwp",
    .codewords = {
      {
        .opcode = 0xfd016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-LNANDW_registerW_registerZ_registerY_simple */
    .as_op = "lnandw",
    .codewords = {
      {
        .opcode = 0x7d015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNANDW_registerW_registerZ_w032_double */
    .as_op = "lnandw",
    .codewords = {
      {
        .opcode = 0xfd015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNIORD_registerW_registerZ_registerY_simple */
    .as_op = "lniord",
    .codewords = {
      {
        .opcode = 0x7f014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNIORD_registerW_registerZ_w032_splat32_double */
    .as_op = "lniord",
    .codewords = {
      {
        .opcode = 0xff014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-LNIORHQ_registerW_registerZ_registerY_simple */
    .as_op = "lniorhq",
    .codewords = {
      {
        .opcode = 0x7f017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNIORHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "lniorhq",
    .codewords = {
      {
        .opcode = 0xff017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-LNIORWP_registerW_registerZ_registerY_simple */
    .as_op = "lniorwp",
    .codewords = {
      {
        .opcode = 0x7f016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNIORWP_registerW_registerZ_w032_splat32_double */
    .as_op = "lniorwp",
    .codewords = {
      {
        .opcode = 0xff016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-LNIORW_registerW_registerZ_registerY_simple */
    .as_op = "lniorw",
    .codewords = {
      {
        .opcode = 0x7f015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LNIORW_registerW_registerZ_w032_double */
    .as_op = "lniorw",
    .codewords = {
      {
        .opcode = 0xff015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-LOOPDO_registerZ_s017_simple */
    .as_op = "loopdo",
    .codewords = {
      {
        .opcode = 0x0f000000,
        .mask = 0x7f800000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      &kv3_v1_registerz_opnd,
      &kv3_v1_pcrel17_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s, %s",
  },
  { /* Opcode-kv3_v1-LO_variant_doscale_registerN_registerY_registerZ_simple */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0x3c06e000,
        .mask = 0x7c0fe000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LO_variant_lsucond_registerY_registerN_registerZ_simple */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0x3c060000,
        .mask = 0x7c0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LO_variant_lsucond_registerY_registerN_s027_registerZ_double */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0xbc060000,
        .mask = 0xfc0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LO_variant_lsucond_registerY_registerN_s054_registerZ_triple */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0xbc060000,
        .mask = 0xfc0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LO_variant_registerN_s010_registerZ_simple */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0x3c040000,
        .mask = 0x7c0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LO_variant_registerN_s037_registerZ_double */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0xbc040000,
        .mask = 0xfc0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LO_variant_registerN_w064_registerZ_triple */
    .as_op = "lo",
    .codewords = {
      {
        .opcode = 0xbc040000,
        .mask = 0xfc0f0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registern_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_doscale_registerM_registerY_registerZ_simple */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0x3c02e000,
        .mask = 0x7c07e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_lsucond_registerY_registerM_registerZ_simple */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0x3c020000,
        .mask = 0x7c070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_lsucond_registerY_registerM_s027_registerZ_double */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0xbc020000,
        .mask = 0xfc070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_lsucond_registerY_registerM_s054_registerZ_triple */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0xbc020000,
        .mask = 0xfc070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_registerM_s010_registerZ_simple */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0x3c000000,
        .mask = 0x7c070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_registerM_s037_registerZ_double */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0xbc000000,
        .mask = 0xfc070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LQ_variant_registerM_w064_registerZ_triple */
    .as_op = "lq",
    .codewords = {
      {
        .opcode = 0xbc000000,
        .mask = 0xfc070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerm_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0x3402e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0x34020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0xb4020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0xb4020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_registerW_s010_registerZ_simple */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0x34000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_registerW_s037_registerZ_double */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0xb4000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWS_variant_registerW_w064_registerZ_triple */
    .as_op = "lws",
    .codewords = {
      {
        .opcode = 0xb4000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_doscale_registerW_registerY_registerZ_simple */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0x3002e000,
        .mask = 0x7c03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_doscale_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_lsucond_registerY_registerW_registerZ_simple */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0x30020000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = [%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_lsucond_registerY_registerW_s027_registerZ_double */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0xb0020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_lsucond_registerY_registerW_s054_registerZ_triple */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0xb0020000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s%s %s? %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_registerW_s010_registerZ_simple */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0x30000000,
        .mask = 0x7c030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_registerW_s037_registerZ_double */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0xb0000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_X,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-LWZ_variant_registerW_w064_registerZ_triple */
    .as_op = "lwz",
    .codewords = {
      {
        .opcode = 0xb0000000,
        .mask = 0xfc030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXW_Y,
    .format = {
      &kv3_v1_variant_opnd,
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s = %s[%s]",
  },
  { /* Opcode-kv3_v1-MADDDT_registerM_registerZ_registerY_simple */
    .as_op = "madddt",
    .codewords = {
      {
        .opcode = 0x58001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDDT_registerM_registerZ_s010_simple */
    .as_op = "madddt",
    .codewords = {
      {
        .opcode = 0x48000000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDDT_registerM_registerZ_s037_double */
    .as_op = "madddt",
    .codewords = {
      {
        .opcode = 0xc8000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDDT_registerM_registerZ_w064_triple */
    .as_op = "madddt",
    .codewords = {
      {
        .opcode = 0xc8000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDD_registerW_registerZ_registerY_simple */
    .as_op = "maddd",
    .codewords = {
      {
        .opcode = 0x50000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDD_registerW_registerZ_s010_simple */
    .as_op = "maddd",
    .codewords = {
      {
        .opcode = 0x40000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDD_registerW_registerZ_s037_double */
    .as_op = "maddd",
    .codewords = {
      {
        .opcode = 0xc0000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDD_registerW_registerZ_w064_triple */
    .as_op = "maddd",
    .codewords = {
      {
        .opcode = 0xc0000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDHQ_registerW_registerZ_registerY_simple */
    .as_op = "maddhq",
    .codewords = {
      {
        .opcode = 0x52000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDHQ_registerW_registerZ_s010_simple */
    .as_op = "maddhq",
    .codewords = {
      {
        .opcode = 0x42000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDHQ_registerW_registerZ_s037_double */
    .as_op = "maddhq",
    .codewords = {
      {
        .opcode = 0xc2000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDHQ_registerW_registerZ_w064_triple */
    .as_op = "maddhq",
    .codewords = {
      {
        .opcode = 0xc2000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDHWQ_registerM_registerZ_registerY_simple */
    .as_op = "maddhwq",
    .codewords = {
      {
        .opcode = 0x50004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUDT_registerM_registerZ_registerY_simple */
    .as_op = "maddsudt",
    .codewords = {
      {
        .opcode = 0x5a001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUDT_registerM_registerZ_s010_simple */
    .as_op = "maddsudt",
    .codewords = {
      {
        .opcode = 0x4a000000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUDT_registerM_registerZ_s037_double */
    .as_op = "maddsudt",
    .codewords = {
      {
        .opcode = 0xca000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUDT_registerM_registerZ_w064_triple */
    .as_op = "maddsudt",
    .codewords = {
      {
        .opcode = 0xca000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUHWQ_registerM_registerZ_registerY_simple */
    .as_op = "maddsuhwq",
    .codewords = {
      {
        .opcode = 0x52004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUWDP_registerM_registerZ_registerY_simple */
    .as_op = "maddsuwdp",
    .codewords = {
      {
        .opcode = 0x5a000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUWDP_registerM_registerZ_w032_splat32_double */
    .as_op = "maddsuwdp",
    .codewords = {
      {
        .opcode = 0xda000000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MADDSUWD_registerW_registerZ_registerY_simple */
    .as_op = "maddsuwd",
    .codewords = {
      {
        .opcode = 0x52003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDSUWD_registerW_registerZ_w032_double */
    .as_op = "maddsuwd",
    .codewords = {
      {
        .opcode = 0xd2003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUDT_registerM_registerZ_registerY_simple */
    .as_op = "maddudt",
    .codewords = {
      {
        .opcode = 0x59001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUDT_registerM_registerZ_s010_simple */
    .as_op = "maddudt",
    .codewords = {
      {
        .opcode = 0x49000000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUDT_registerM_registerZ_s037_double */
    .as_op = "maddudt",
    .codewords = {
      {
        .opcode = 0xc9000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUDT_registerM_registerZ_w064_triple */
    .as_op = "maddudt",
    .codewords = {
      {
        .opcode = 0xc9000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUHWQ_registerM_registerZ_registerY_simple */
    .as_op = "madduhwq",
    .codewords = {
      {
        .opcode = 0x51004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUWDP_registerM_registerZ_registerY_simple */
    .as_op = "madduwdp",
    .codewords = {
      {
        .opcode = 0x59000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUWDP_registerM_registerZ_w032_splat32_double */
    .as_op = "madduwdp",
    .codewords = {
      {
        .opcode = 0xd9000000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MADDUWD_registerW_registerZ_registerY_simple */
    .as_op = "madduwd",
    .codewords = {
      {
        .opcode = 0x51003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUWD_registerW_registerZ_w032_double */
    .as_op = "madduwd",
    .codewords = {
      {
        .opcode = 0xd1003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUZDT_registerM_registerZ_registerY_simple */
    .as_op = "madduzdt",
    .codewords = {
      {
        .opcode = 0x5b001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUZDT_registerM_registerZ_s010_simple */
    .as_op = "madduzdt",
    .codewords = {
      {
        .opcode = 0x4b000000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUZDT_registerM_registerZ_s037_double */
    .as_op = "madduzdt",
    .codewords = {
      {
        .opcode = 0xcb000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDUZDT_registerM_registerZ_w064_triple */
    .as_op = "madduzdt",
    .codewords = {
      {
        .opcode = 0xcb000000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWDP_registerM_registerZ_registerY_simple */
    .as_op = "maddwdp",
    .codewords = {
      {
        .opcode = 0x58000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWDP_registerM_registerZ_w032_splat32_double */
    .as_op = "maddwdp",
    .codewords = {
      {
        .opcode = 0xd8000000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MADDWD_registerW_registerZ_registerY_simple */
    .as_op = "maddwd",
    .codewords = {
      {
        .opcode = 0x50003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWD_registerW_registerZ_w032_double */
    .as_op = "maddwd",
    .codewords = {
      {
        .opcode = 0xd0003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWP_registerW_registerZ_registerY_simple */
    .as_op = "maddwp",
    .codewords = {
      {
        .opcode = 0x51000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWP_registerW_registerZ_s010_simple */
    .as_op = "maddwp",
    .codewords = {
      {
        .opcode = 0x41000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWP_registerW_registerZ_s037_double */
    .as_op = "maddwp",
    .codewords = {
      {
        .opcode = 0xc1000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDWP_registerW_registerZ_w064_triple */
    .as_op = "maddwp",
    .codewords = {
      {
        .opcode = 0xc1000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDW_registerW_registerZ_registerY_simple */
    .as_op = "maddw",
    .codewords = {
      {
        .opcode = 0x53003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MADDW_registerW_registerZ_w032_double */
    .as_op = "maddw",
    .codewords = {
      {
        .opcode = 0xd3003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAKE_registerW_s016_simple */
    .as_op = "make",
    .codewords = {
      {
        .opcode = 0x60000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed16_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-MAKE_registerW_s043_double */
    .as_op = "make",
    .codewords = {
      {
        .opcode = 0xe0000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend6_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-MAKE_registerW_w064_triple */
    .as_op = "make",
    .codewords = {
      {
        .opcode = 0xe0000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-MAXD_registerW_registerZ_registerY_simple */
    .as_op = "maxd",
    .codewords = {
      {
        .opcode = 0x73010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXD_registerW_registerZ_s010_simple */
    .as_op = "maxd",
    .codewords = {
      {
        .opcode = 0x63000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXD_registerW_registerZ_s037_double */
    .as_op = "maxd",
    .codewords = {
      {
        .opcode = 0xe3000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXD_registerW_registerZ_w032_splat32_double */
    .as_op = "maxd",
    .codewords = {
      {
        .opcode = 0xf3010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MAXD_registerW_registerZ_w064_triple */
    .as_op = "maxd",
    .codewords = {
      {
        .opcode = 0xe3000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXHQ_registerW_registerZ_registerY_simple */
    .as_op = "maxhq",
    .codewords = {
      {
        .opcode = 0x73013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "maxhq",
    .codewords = {
      {
        .opcode = 0xf3013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MAXUD_registerW_registerZ_registerY_simple */
    .as_op = "maxud",
    .codewords = {
      {
        .opcode = 0x77010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUD_registerW_registerZ_s010_simple */
    .as_op = "maxud",
    .codewords = {
      {
        .opcode = 0x67000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUD_registerW_registerZ_s037_double */
    .as_op = "maxud",
    .codewords = {
      {
        .opcode = 0xe7000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUD_registerW_registerZ_w032_splat32_double */
    .as_op = "maxud",
    .codewords = {
      {
        .opcode = 0xf7010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MAXUD_registerW_registerZ_w064_triple */
    .as_op = "maxud",
    .codewords = {
      {
        .opcode = 0xe7000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUHQ_registerW_registerZ_registerY_simple */
    .as_op = "maxuhq",
    .codewords = {
      {
        .opcode = 0x77013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "maxuhq",
    .codewords = {
      {
        .opcode = 0xf7013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MAXUWP_registerW_registerZ_registerY_simple */
    .as_op = "maxuwp",
    .codewords = {
      {
        .opcode = 0x77012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUWP_registerW_registerZ_w032_splat32_double */
    .as_op = "maxuwp",
    .codewords = {
      {
        .opcode = 0xf7012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MAXUW_registerW_registerZ_registerY_simple */
    .as_op = "maxuw",
    .codewords = {
      {
        .opcode = 0x77011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUW_registerW_registerZ_s010_simple */
    .as_op = "maxuw",
    .codewords = {
      {
        .opcode = 0x77000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXUW_registerW_registerZ_s037_double */
    .as_op = "maxuw",
    .codewords = {
      {
        .opcode = 0xf7000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXWP_registerW_registerZ_registerY_simple */
    .as_op = "maxwp",
    .codewords = {
      {
        .opcode = 0x73012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXWP_registerW_registerZ_w032_splat32_double */
    .as_op = "maxwp",
    .codewords = {
      {
        .opcode = 0xf3012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MAXW_registerW_registerZ_registerY_simple */
    .as_op = "maxw",
    .codewords = {
      {
        .opcode = 0x73011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXW_registerW_registerZ_s010_simple */
    .as_op = "maxw",
    .codewords = {
      {
        .opcode = 0x73000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MAXW_registerW_registerZ_s037_double */
    .as_op = "maxw",
    .codewords = {
      {
        .opcode = 0xf3000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MIND_registerW_registerZ_registerY_simple */
    .as_op = "mind",
    .codewords = {
      {
        .opcode = 0x72010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MIND_registerW_registerZ_s010_simple */
    .as_op = "mind",
    .codewords = {
      {
        .opcode = 0x62000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MIND_registerW_registerZ_s037_double */
    .as_op = "mind",
    .codewords = {
      {
        .opcode = 0xe2000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MIND_registerW_registerZ_w032_splat32_double */
    .as_op = "mind",
    .codewords = {
      {
        .opcode = 0xf2010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MIND_registerW_registerZ_w064_triple */
    .as_op = "mind",
    .codewords = {
      {
        .opcode = 0xe2000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINHQ_registerW_registerZ_registerY_simple */
    .as_op = "minhq",
    .codewords = {
      {
        .opcode = 0x72013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "minhq",
    .codewords = {
      {
        .opcode = 0xf2013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MINUD_registerW_registerZ_registerY_simple */
    .as_op = "minud",
    .codewords = {
      {
        .opcode = 0x76010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUD_registerW_registerZ_s010_simple */
    .as_op = "minud",
    .codewords = {
      {
        .opcode = 0x66000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUD_registerW_registerZ_s037_double */
    .as_op = "minud",
    .codewords = {
      {
        .opcode = 0xe6000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUD_registerW_registerZ_w032_splat32_double */
    .as_op = "minud",
    .codewords = {
      {
        .opcode = 0xf6010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MINUD_registerW_registerZ_w064_triple */
    .as_op = "minud",
    .codewords = {
      {
        .opcode = 0xe6000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUHQ_registerW_registerZ_registerY_simple */
    .as_op = "minuhq",
    .codewords = {
      {
        .opcode = 0x76013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "minuhq",
    .codewords = {
      {
        .opcode = 0xf6013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MINUWP_registerW_registerZ_registerY_simple */
    .as_op = "minuwp",
    .codewords = {
      {
        .opcode = 0x76012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUWP_registerW_registerZ_w032_splat32_double */
    .as_op = "minuwp",
    .codewords = {
      {
        .opcode = 0xf6012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MINUW_registerW_registerZ_registerY_simple */
    .as_op = "minuw",
    .codewords = {
      {
        .opcode = 0x76011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUW_registerW_registerZ_s010_simple */
    .as_op = "minuw",
    .codewords = {
      {
        .opcode = 0x76000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINUW_registerW_registerZ_s037_double */
    .as_op = "minuw",
    .codewords = {
      {
        .opcode = 0xf6000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINWP_registerW_registerZ_registerY_simple */
    .as_op = "minwp",
    .codewords = {
      {
        .opcode = 0x72012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINWP_registerW_registerZ_w032_splat32_double */
    .as_op = "minwp",
    .codewords = {
      {
        .opcode = 0xf2012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MINW_registerW_registerZ_registerY_simple */
    .as_op = "minw",
    .codewords = {
      {
        .opcode = 0x72011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINW_registerW_registerZ_s010_simple */
    .as_op = "minw",
    .codewords = {
      {
        .opcode = 0x72000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MINW_registerW_registerZ_s037_double */
    .as_op = "minw",
    .codewords = {
      {
        .opcode = 0xf2000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MM212W_registerM_registerZ_registerY_simple */
    .as_op = "mm212w",
    .codewords = {
      {
        .opcode = 0x53001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MM212W_registerM_registerZ_w032_splat32_double */
    .as_op = "mm212w",
    .codewords = {
      {
        .opcode = 0xd3001000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MMA212W_registerM_registerZ_registerY_simple */
    .as_op = "mma212w",
    .codewords = {
      {
        .opcode = 0x5b000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MMA212W_registerM_registerZ_w032_splat32_double */
    .as_op = "mma212w",
    .codewords = {
      {
        .opcode = 0xdb000000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MMA444HBD0_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444hbd0",
    .codewords = {
      {
        .opcode = 0x04000000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444HBD1_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444hbd1",
    .codewords = {
      {
        .opcode = 0x04040000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444HD_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444hd",
    .codewords = {
      {
        .opcode = 0x04080000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444SUHBD0_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444suhbd0",
    .codewords = {
      {
        .opcode = 0x04002000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444SUHBD1_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444suhbd1",
    .codewords = {
      {
        .opcode = 0x04042000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444SUHD_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444suhd",
    .codewords = {
      {
        .opcode = 0x04082000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444UHBD0_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444uhbd0",
    .codewords = {
      {
        .opcode = 0x04001000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444UHBD1_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444uhbd1",
    .codewords = {
      {
        .opcode = 0x04041000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444UHD_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444uhd",
    .codewords = {
      {
        .opcode = 0x04081000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444USHBD0_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444ushbd0",
    .codewords = {
      {
        .opcode = 0x04003000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444USHBD1_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444ushbd1",
    .codewords = {
      {
        .opcode = 0x04043000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMA444USHD_registerAq_registerBq_registerC_registerD_simple */
    .as_op = "mma444ushd",
    .codewords = {
      {
        .opcode = 0x04083000,
        .mask = 0x7f0c3000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TCA, ((int)0 << 8) | (int)Reservation_kv3_v1_TCA,
    .format = {
      &kv3_v1_registeraq_opnd,
      &kv3_v1_registerbq_opnd,
      &kv3_v1_registerc_opnd,
      &kv3_v1_registerd_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s, %s",
  },
  { /* Opcode-kv3_v1-MMS212W_registerM_registerZ_registerY_simple */
    .as_op = "mms212w",
    .codewords = {
      {
        .opcode = 0x5f000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MMS212W_registerM_registerZ_w032_splat32_double */
    .as_op = "mms212w",
    .codewords = {
      {
        .opcode = 0xdf000000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MOVETQ_registerAE_registerZ_registerY_simple */
    .as_op = "movetq",
    .codewords = {
      {
        .opcode = 0x7f02e000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_CRWL,
    .format = {
      &kv3_v1_registerae_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MOVETQ_registerAO_registerZ_registerY_simple */
    .as_op = "movetq",
    .codewords = {
      {
        .opcode = 0x7f02f000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_CRWH,
    .format = {
      &kv3_v1_registerao_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFDT_registerM_registerZ_registerY_simple */
    .as_op = "msbfdt",
    .codewords = {
      {
        .opcode = 0x5c001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFD_registerW_registerZ_registerY_simple */
    .as_op = "msbfd",
    .codewords = {
      {
        .opcode = 0x54000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFD_registerW_registerZ_w032_splat32_double */
    .as_op = "msbfd",
    .codewords = {
      {
        .opcode = 0xd4000000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MSBFHQ_registerW_registerZ_registerY_simple */
    .as_op = "msbfhq",
    .codewords = {
      {
        .opcode = 0x56000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "msbfhq",
    .codewords = {
      {
        .opcode = 0xd6000000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MSBFHWQ_registerM_registerZ_registerY_simple */
    .as_op = "msbfhwq",
    .codewords = {
      {
        .opcode = 0x54004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFSUDT_registerM_registerZ_registerY_simple */
    .as_op = "msbfsudt",
    .codewords = {
      {
        .opcode = 0x5e001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFSUHWQ_registerM_registerZ_registerY_simple */
    .as_op = "msbfsuhwq",
    .codewords = {
      {
        .opcode = 0x56004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFSUWDP_registerM_registerZ_registerY_simple */
    .as_op = "msbfsuwdp",
    .codewords = {
      {
        .opcode = 0x5e000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFSUWDP_registerM_registerZ_w032_splat32_double */
    .as_op = "msbfsuwdp",
    .codewords = {
      {
        .opcode = 0xde000000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MSBFSUWD_registerW_registerZ_registerY_simple */
    .as_op = "msbfsuwd",
    .codewords = {
      {
        .opcode = 0x56003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFSUWD_registerW_registerZ_w032_double */
    .as_op = "msbfsuwd",
    .codewords = {
      {
        .opcode = 0xd6003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFUDT_registerM_registerZ_registerY_simple */
    .as_op = "msbfudt",
    .codewords = {
      {
        .opcode = 0x5d001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFUHWQ_registerM_registerZ_registerY_simple */
    .as_op = "msbfuhwq",
    .codewords = {
      {
        .opcode = 0x55004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFUWDP_registerM_registerZ_registerY_simple */
    .as_op = "msbfuwdp",
    .codewords = {
      {
        .opcode = 0x5d000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFUWDP_registerM_registerZ_w032_splat32_double */
    .as_op = "msbfuwdp",
    .codewords = {
      {
        .opcode = 0xdd000000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MSBFUWD_registerW_registerZ_registerY_simple */
    .as_op = "msbfuwd",
    .codewords = {
      {
        .opcode = 0x55003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFUWD_registerW_registerZ_w032_double */
    .as_op = "msbfuwd",
    .codewords = {
      {
        .opcode = 0xd5003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFUZDT_registerM_registerZ_registerY_simple */
    .as_op = "msbfuzdt",
    .codewords = {
      {
        .opcode = 0x5f001000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFWDP_registerM_registerZ_registerY_simple */
    .as_op = "msbfwdp",
    .codewords = {
      {
        .opcode = 0x5c000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFWDP_registerM_registerZ_w032_splat32_double */
    .as_op = "msbfwdp",
    .codewords = {
      {
        .opcode = 0xdc000000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MSBFWD_registerW_registerZ_registerY_simple */
    .as_op = "msbfwd",
    .codewords = {
      {
        .opcode = 0x54003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFWD_registerW_registerZ_w032_double */
    .as_op = "msbfwd",
    .codewords = {
      {
        .opcode = 0xd4003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFWP_registerW_registerZ_registerY_simple */
    .as_op = "msbfwp",
    .codewords = {
      {
        .opcode = 0x55000000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFWP_registerW_registerZ_w032_splat32_double */
    .as_op = "msbfwp",
    .codewords = {
      {
        .opcode = 0xd5000000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MSBFW_registerW_registerZ_registerY_simple */
    .as_op = "msbfw",
    .codewords = {
      {
        .opcode = 0x57003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MSBFW_registerW_registerZ_w032_double */
    .as_op = "msbfw",
    .codewords = {
      {
        .opcode = 0xd7003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULDT_registerM_registerZ_registerY_simple */
    .as_op = "muldt",
    .codewords = {
      {
        .opcode = 0x58041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULDT_registerM_registerZ_s010_simple */
    .as_op = "muldt",
    .codewords = {
      {
        .opcode = 0x48040000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULDT_registerM_registerZ_s037_double */
    .as_op = "muldt",
    .codewords = {
      {
        .opcode = 0xc8040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULDT_registerM_registerZ_w064_triple */
    .as_op = "muldt",
    .codewords = {
      {
        .opcode = 0xc8040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULD_registerW_registerZ_registerY_simple */
    .as_op = "muld",
    .codewords = {
      {
        .opcode = 0x54001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULD_registerW_registerZ_s010_simple */
    .as_op = "muld",
    .codewords = {
      {
        .opcode = 0x44000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULD_registerW_registerZ_s037_double */
    .as_op = "muld",
    .codewords = {
      {
        .opcode = 0xc4000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULD_registerW_registerZ_w064_triple */
    .as_op = "muld",
    .codewords = {
      {
        .opcode = 0xc4000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULHQ_registerW_registerZ_registerY_simple */
    .as_op = "mulhq",
    .codewords = {
      {
        .opcode = 0x56001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULHQ_registerW_registerZ_s010_simple */
    .as_op = "mulhq",
    .codewords = {
      {
        .opcode = 0x46000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULHQ_registerW_registerZ_s037_double */
    .as_op = "mulhq",
    .codewords = {
      {
        .opcode = 0xc6000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULHQ_registerW_registerZ_w064_triple */
    .as_op = "mulhq",
    .codewords = {
      {
        .opcode = 0xc6000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULHWQ_registerM_registerZ_registerY_simple */
    .as_op = "mulhwq",
    .codewords = {
      {
        .opcode = 0x58004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUDT_registerM_registerZ_registerY_simple */
    .as_op = "mulsudt",
    .codewords = {
      {
        .opcode = 0x5a041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUDT_registerM_registerZ_s010_simple */
    .as_op = "mulsudt",
    .codewords = {
      {
        .opcode = 0x4a040000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUDT_registerM_registerZ_s037_double */
    .as_op = "mulsudt",
    .codewords = {
      {
        .opcode = 0xca040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUDT_registerM_registerZ_w064_triple */
    .as_op = "mulsudt",
    .codewords = {
      {
        .opcode = 0xca040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUHWQ_registerM_registerZ_registerY_simple */
    .as_op = "mulsuhwq",
    .codewords = {
      {
        .opcode = 0x5a004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUWDP_registerM_registerZ_registerY_simple */
    .as_op = "mulsuwdp",
    .codewords = {
      {
        .opcode = 0x52001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUWDP_registerM_registerZ_w032_splat32_double */
    .as_op = "mulsuwdp",
    .codewords = {
      {
        .opcode = 0xd2001000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MULSUWD_registerW_registerZ_registerY_simple */
    .as_op = "mulsuwd",
    .codewords = {
      {
        .opcode = 0x5a003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULSUWD_registerW_registerZ_w032_double */
    .as_op = "mulsuwd",
    .codewords = {
      {
        .opcode = 0xda003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUDT_registerM_registerZ_registerY_simple */
    .as_op = "muludt",
    .codewords = {
      {
        .opcode = 0x59041000,
        .mask = 0x7f07f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUDT_registerM_registerZ_s010_simple */
    .as_op = "muludt",
    .codewords = {
      {
        .opcode = 0x49040000,
        .mask = 0x7f070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUDT_registerM_registerZ_s037_double */
    .as_op = "muludt",
    .codewords = {
      {
        .opcode = 0xc9040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUDT_registerM_registerZ_w064_triple */
    .as_op = "muludt",
    .codewords = {
      {
        .opcode = 0xc9040000,
        .mask = 0xff070000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUHWQ_registerM_registerZ_registerY_simple */
    .as_op = "muluhwq",
    .codewords = {
      {
        .opcode = 0x59004000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUWDP_registerM_registerZ_registerY_simple */
    .as_op = "muluwdp",
    .codewords = {
      {
        .opcode = 0x51001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUWDP_registerM_registerZ_w032_splat32_double */
    .as_op = "muluwdp",
    .codewords = {
      {
        .opcode = 0xd1001000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MULUWD_registerW_registerZ_registerY_simple */
    .as_op = "muluwd",
    .codewords = {
      {
        .opcode = 0x59003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULUWD_registerW_registerZ_w032_double */
    .as_op = "muluwd",
    .codewords = {
      {
        .opcode = 0xd9003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWC.C_registerW_registerZ_registerY_simple */
    .as_op = "mulwc.c",
    .codewords = {
      {
        .opcode = 0x55002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWC_registerW_registerZ_registerY_simple */
    .as_op = "mulwc",
    .codewords = {
      {
        .opcode = 0x57001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWC_registerW_registerZ_s010_simple */
    .as_op = "mulwc",
    .codewords = {
      {
        .opcode = 0x47000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWC_registerW_registerZ_s037_double */
    .as_op = "mulwc",
    .codewords = {
      {
        .opcode = 0xc7000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWC_registerW_registerZ_w064_triple */
    .as_op = "mulwc",
    .codewords = {
      {
        .opcode = 0xc7000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWDC.C_registerM_registerZ_registerY_simple */
    .as_op = "mulwdc.c",
    .codewords = {
      {
        .opcode = 0x57002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWDC_registerM_registerZ_registerY_simple */
    .as_op = "mulwdc",
    .codewords = {
      {
        .opcode = 0x56002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWDP_registerM_registerZ_registerY_simple */
    .as_op = "mulwdp",
    .codewords = {
      {
        .opcode = 0x50001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWDP_registerM_registerZ_w032_splat32_double */
    .as_op = "mulwdp",
    .codewords = {
      {
        .opcode = 0xd0001000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-MULWD_registerW_registerZ_registerY_simple */
    .as_op = "mulwd",
    .codewords = {
      {
        .opcode = 0x58003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWD_registerW_registerZ_w032_double */
    .as_op = "mulwd",
    .codewords = {
      {
        .opcode = 0xd8003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWP_registerW_registerZ_registerY_simple */
    .as_op = "mulwp",
    .codewords = {
      {
        .opcode = 0x55001000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWP_registerW_registerZ_s010_simple */
    .as_op = "mulwp",
    .codewords = {
      {
        .opcode = 0x45000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWP_registerW_registerZ_s037_double */
    .as_op = "mulwp",
    .codewords = {
      {
        .opcode = 0xc5000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWP_registerW_registerZ_w064_triple */
    .as_op = "mulwp",
    .codewords = {
      {
        .opcode = 0xc5000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULWQ_registerM_registerP_registerO_simple */
    .as_op = "mulwq",
    .codewords = {
      {
        .opcode = 0x54002000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_AUXR,
    .format = {
      &kv3_v1_registerm_opnd,
      &kv3_v1_registerp_opnd,
      &kv3_v1_registero_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULW_registerW_registerZ_registerY_simple */
    .as_op = "mulw",
    .codewords = {
      {
        .opcode = 0x5b003000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-MULW_registerW_registerZ_w032_double */
    .as_op = "mulw",
    .codewords = {
      {
        .opcode = 0xdb003000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_MAU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_MAU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_MAU_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDD_registerW_registerZ_registerY_simple */
    .as_op = "nandd",
    .codewords = {
      {
        .opcode = 0x79010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDD_registerW_registerZ_s010_simple */
    .as_op = "nandd",
    .codewords = {
      {
        .opcode = 0x69000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDD_registerW_registerZ_s037_double */
    .as_op = "nandd",
    .codewords = {
      {
        .opcode = 0xe9000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDD_registerW_registerZ_w032_splat32_double */
    .as_op = "nandd",
    .codewords = {
      {
        .opcode = 0xf9010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-NANDD_registerW_registerZ_w064_triple */
    .as_op = "nandd",
    .codewords = {
      {
        .opcode = 0xe9000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDW_registerW_registerZ_registerY_simple */
    .as_op = "nandw",
    .codewords = {
      {
        .opcode = 0x79011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDW_registerW_registerZ_s010_simple */
    .as_op = "nandw",
    .codewords = {
      {
        .opcode = 0x79000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NANDW_registerW_registerZ_s037_double */
    .as_op = "nandw",
    .codewords = {
      {
        .opcode = 0xf9000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NEORD_registerW_registerZ_registerY_simple */
    .as_op = "neord",
    .codewords = {
      {
        .opcode = 0x7d010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NEORD_registerW_registerZ_s010_simple */
    .as_op = "neord",
    .codewords = {
      {
        .opcode = 0x6d000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NEORD_registerW_registerZ_s037_double */
    .as_op = "neord",
    .codewords = {
      {
        .opcode = 0xed000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NEORD_registerW_registerZ_w032_splat32_double */
    .as_op = "neord",
    .codewords = {
      {
        .opcode = 0xfd010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-NEORD_registerW_registerZ_w064_triple */
    .as_op = "neord",
    .codewords = {
      {
        .opcode = 0xed000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NEORW_registerW_registerZ_registerY_simple */
    .as_op = "neorw",
    .codewords = {
      {
        .opcode = 0x7d011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NEORW_registerW_registerZ_s010_simple */
    .as_op = "neorw",
    .codewords = {
      {
        .opcode = 0x7d000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NEORW_registerW_registerZ_s037_double */
    .as_op = "neorw",
    .codewords = {
      {
        .opcode = 0xfd000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NIORD_registerW_registerZ_registerY_simple */
    .as_op = "niord",
    .codewords = {
      {
        .opcode = 0x7b010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NIORD_registerW_registerZ_s010_simple */
    .as_op = "niord",
    .codewords = {
      {
        .opcode = 0x6b000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NIORD_registerW_registerZ_s037_double */
    .as_op = "niord",
    .codewords = {
      {
        .opcode = 0xeb000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NIORD_registerW_registerZ_w032_splat32_double */
    .as_op = "niord",
    .codewords = {
      {
        .opcode = 0xfb010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-NIORD_registerW_registerZ_w064_triple */
    .as_op = "niord",
    .codewords = {
      {
        .opcode = 0xeb000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NIORW_registerW_registerZ_registerY_simple */
    .as_op = "niorw",
    .codewords = {
      {
        .opcode = 0x7b011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NIORW_registerW_registerZ_s010_simple */
    .as_op = "niorw",
    .codewords = {
      {
        .opcode = 0x7b000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NIORW_registerW_registerZ_s037_double */
    .as_op = "niorw",
    .codewords = {
      {
        .opcode = 0xfb000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-NOP_simple */
    .as_op = "nop",
    .codewords = {
      {
        .opcode = 0x7f03f000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_NOP, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_NOP,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-PCREL_registerW_s016_simple */
    .as_op = "pcrel",
    .codewords = {
      {
        .opcode = 0x70000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_signed16_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-PCREL_registerW_s043_double */
    .as_op = "pcrel",
    .codewords = {
      {
        .opcode = 0xf0000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend6_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-PCREL_registerW_w064_triple */
    .as_op = "pcrel",
    .codewords = {
      {
        .opcode = 0xf0000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-RET_simple */
    .as_op = "ret",
    .codewords = {
      {
        .opcode = 0x0fd00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-RFE_simple */
    .as_op = "rfe",
    .codewords = {
      {
        .opcode = 0x0fd40000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-ROLWPS_registerW_registerZ_registerY_simple */
    .as_op = "rolwps",
    .codewords = {
      {
        .opcode = 0x7e028000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ROLWPS_registerW_registerZ_u006_simple */
    .as_op = "rolwps",
    .codewords = {
      {
        .opcode = 0x7e024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ROLW_registerW_registerZ_registerY_simple */
    .as_op = "rolw",
    .codewords = {
      {
        .opcode = 0x7e027000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-ROLW_registerW_registerZ_u006_simple */
    .as_op = "rolw",
    .codewords = {
      {
        .opcode = 0x7e023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-RORWPS_registerW_registerZ_registerY_simple */
    .as_op = "rorwps",
    .codewords = {
      {
        .opcode = 0x7f028000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-RORWPS_registerW_registerZ_u006_simple */
    .as_op = "rorwps",
    .codewords = {
      {
        .opcode = 0x7f024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-RORW_registerW_registerZ_registerY_simple */
    .as_op = "rorw",
    .codewords = {
      {
        .opcode = 0x7f027000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-RORW_registerW_registerZ_u006_simple */
    .as_op = "rorw",
    .codewords = {
      {
        .opcode = 0x7f023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-RSWAP_registerZ_systemAlone_simple */
    .as_op = "rswap",
    .codewords = {
      {
        .opcode = 0x0fc80000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      &kv3_v1_registerz_opnd,
      &kv3_v1_systemalone_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-RSWAP_registerZ_systemS3_simple */
    .as_op = "rswap",
    .codewords = {
      {
        .opcode = 0x0fc80000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP,
    .format = {
      &kv3_v1_registerz_opnd,
      &kv3_v1_systems3_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-RSWAP_registerZ_systemS4_simple */
    .as_op = "rswap",
    .codewords = {
      {
        .opcode = 0x0fc80000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU_TINY_TINY_MAU_XNOP,
    .format = {
      &kv3_v1_registerz_opnd,
      &kv3_v1_systems4_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-SATD_registerW_registerZ_registerY_simple */
    .as_op = "satd",
    .codewords = {
      {
        .opcode = 0x7e026000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SATD_registerW_registerZ_u006_simple */
    .as_op = "satd",
    .codewords = {
      {
        .opcode = 0x7e022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFCD.I_registerW_registerZ_registerY_simple */
    .as_op = "sbfcd.i",
    .codewords = {
      {
        .opcode = 0x7f01d000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFCD.I_registerW_registerZ_w032_double */
    .as_op = "sbfcd.i",
    .codewords = {
      {
        .opcode = 0xff01d000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFCD_registerW_registerZ_registerY_simple */
    .as_op = "sbfcd",
    .codewords = {
      {
        .opcode = 0x7f01c000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFCD_registerW_registerZ_w032_double */
    .as_op = "sbfcd",
    .codewords = {
      {
        .opcode = 0xff01c000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_FULL_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_FULL_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFD_registerW_registerZ_registerY_simple */
    .as_op = "sbfd",
    .codewords = {
      {
        .opcode = 0x75010000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFD_registerW_registerZ_s010_simple */
    .as_op = "sbfd",
    .codewords = {
      {
        .opcode = 0x65000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFD_registerW_registerZ_s037_double */
    .as_op = "sbfd",
    .codewords = {
      {
        .opcode = 0xe5000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFD_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfd",
    .codewords = {
      {
        .opcode = 0xf5010000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFD_registerW_registerZ_w064_triple */
    .as_op = "sbfd",
    .codewords = {
      {
        .opcode = 0xe5000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFHCP.C_registerW_registerZ_registerY_simple */
    .as_op = "sbfhcp.c",
    .codewords = {
      {
        .opcode = 0x7d013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFHCP.C_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfhcp.c",
    .codewords = {
      {
        .opcode = 0xfd013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFHQ_registerW_registerZ_registerY_simple */
    .as_op = "sbfhq",
    .codewords = {
      {
        .opcode = 0x75013000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfhq",
    .codewords = {
      {
        .opcode = 0xf5013000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFSD_registerW_registerZ_registerY_simple */
    .as_op = "sbfsd",
    .codewords = {
      {
        .opcode = 0x7f01a000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSD_registerW_registerZ_s010_simple */
    .as_op = "sbfsd",
    .codewords = {
      {
        .opcode = 0x6f010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSD_registerW_registerZ_s037_double */
    .as_op = "sbfsd",
    .codewords = {
      {
        .opcode = 0xef010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSD_registerW_registerZ_w064_triple */
    .as_op = "sbfsd",
    .codewords = {
      {
        .opcode = 0xef010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSHQ_registerW_registerZ_registerY_simple */
    .as_op = "sbfshq",
    .codewords = {
      {
        .opcode = 0x7f01f000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSHQ_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfshq",
    .codewords = {
      {
        .opcode = 0xff01f000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFSWP_registerW_registerZ_registerY_simple */
    .as_op = "sbfswp",
    .codewords = {
      {
        .opcode = 0x7f01e000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSWP_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfswp",
    .codewords = {
      {
        .opcode = 0xff01e000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFSW_registerW_registerZ_registerY_simple */
    .as_op = "sbfsw",
    .codewords = {
      {
        .opcode = 0x7f01b000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFSW_registerW_registerZ_w032_double */
    .as_op = "sbfsw",
    .codewords = {
      {
        .opcode = 0xff01b000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFUWD_registerW_registerZ_registerY_simple */
    .as_op = "sbfuwd",
    .codewords = {
      {
        .opcode = 0x7b014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFUWD_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfuwd",
    .codewords = {
      {
        .opcode = 0xfb014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFWC.C_registerW_registerZ_registerY_simple */
    .as_op = "sbfwc.c",
    .codewords = {
      {
        .opcode = 0x7d012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFWC.C_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfwc.c",
    .codewords = {
      {
        .opcode = 0xfd012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFWD_registerW_registerZ_registerY_simple */
    .as_op = "sbfwd",
    .codewords = {
      {
        .opcode = 0x79014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFWD_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfwd",
    .codewords = {
      {
        .opcode = 0xf9014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFWP_registerW_registerZ_registerY_simple */
    .as_op = "sbfwp",
    .codewords = {
      {
        .opcode = 0x75012000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFWP_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfwp",
    .codewords = {
      {
        .opcode = 0xf5012000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFW_registerW_registerZ_registerY_simple */
    .as_op = "sbfw",
    .codewords = {
      {
        .opcode = 0x75011000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFW_registerW_registerZ_s010_simple */
    .as_op = "sbfw",
    .codewords = {
      {
        .opcode = 0x75000000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFW_registerW_registerZ_s037_double */
    .as_op = "sbfw",
    .codewords = {
      {
        .opcode = 0xf5000000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16D_registerW_registerZ_registerY_simple */
    .as_op = "sbfx16d",
    .codewords = {
      {
        .opcode = 0x77014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16D_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfx16d",
    .codewords = {
      {
        .opcode = 0xf7014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFX16HQ_registerW_registerZ_registerY_simple */
    .as_op = "sbfx16hq",
    .codewords = {
      {
        .opcode = 0x77017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16HQ_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfx16hq",
    .codewords = {
      {
        .opcode = 0xf7017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFX16UWD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx16uwd",
    .codewords = {
      {
        .opcode = 0x7f018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16UWD_registerW_registerZ_w032_double */
    .as_op = "sbfx16uwd",
    .codewords = {
      {
        .opcode = 0xff018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16WD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx16wd",
    .codewords = {
      {
        .opcode = 0x77018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16WD_registerW_registerZ_w032_double */
    .as_op = "sbfx16wd",
    .codewords = {
      {
        .opcode = 0xf7018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16WP_registerW_registerZ_registerY_simple */
    .as_op = "sbfx16wp",
    .codewords = {
      {
        .opcode = 0x77016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16WP_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfx16wp",
    .codewords = {
      {
        .opcode = 0xf7016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFX16W_registerW_registerZ_registerY_simple */
    .as_op = "sbfx16w",
    .codewords = {
      {
        .opcode = 0x77015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX16W_registerW_registerZ_w032_double */
    .as_op = "sbfx16w",
    .codewords = {
      {
        .opcode = 0xf7015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2D_registerW_registerZ_registerY_simple */
    .as_op = "sbfx2d",
    .codewords = {
      {
        .opcode = 0x71014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2D_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfx2d",
    .codewords = {
      {
        .opcode = 0xf1014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFX2HQ_registerW_registerZ_registerY_simple */
    .as_op = "sbfx2hq",
    .codewords = {
      {
        .opcode = 0x71017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2HQ_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfx2hq",
    .codewords = {
      {
        .opcode = 0xf1017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFX2UWD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx2uwd",
    .codewords = {
      {
        .opcode = 0x79018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2UWD_registerW_registerZ_w032_double */
    .as_op = "sbfx2uwd",
    .codewords = {
      {
        .opcode = 0xf9018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2WD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx2wd",
    .codewords = {
      {
        .opcode = 0x71018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2WD_registerW_registerZ_w032_double */
    .as_op = "sbfx2wd",
    .codewords = {
      {
        .opcode = 0xf1018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2WP_registerW_registerZ_registerY_simple */
    .as_op = "sbfx2wp",
    .codewords = {
      {
        .opcode = 0x71016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2WP_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfx2wp",
    .codewords = {
      {
        .opcode = 0xf1016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFX2W_registerW_registerZ_registerY_simple */
    .as_op = "sbfx2w",
    .codewords = {
      {
        .opcode = 0x71015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX2W_registerW_registerZ_w032_double */
    .as_op = "sbfx2w",
    .codewords = {
      {
        .opcode = 0xf1015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4D_registerW_registerZ_registerY_simple */
    .as_op = "sbfx4d",
    .codewords = {
      {
        .opcode = 0x73014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4D_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfx4d",
    .codewords = {
      {
        .opcode = 0xf3014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFX4HQ_registerW_registerZ_registerY_simple */
    .as_op = "sbfx4hq",
    .codewords = {
      {
        .opcode = 0x73017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4HQ_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfx4hq",
    .codewords = {
      {
        .opcode = 0xf3017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFX4UWD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx4uwd",
    .codewords = {
      {
        .opcode = 0x7b018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4UWD_registerW_registerZ_w032_double */
    .as_op = "sbfx4uwd",
    .codewords = {
      {
        .opcode = 0xfb018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4WD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx4wd",
    .codewords = {
      {
        .opcode = 0x73018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4WD_registerW_registerZ_w032_double */
    .as_op = "sbfx4wd",
    .codewords = {
      {
        .opcode = 0xf3018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4WP_registerW_registerZ_registerY_simple */
    .as_op = "sbfx4wp",
    .codewords = {
      {
        .opcode = 0x73016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4WP_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfx4wp",
    .codewords = {
      {
        .opcode = 0xf3016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFX4W_registerW_registerZ_registerY_simple */
    .as_op = "sbfx4w",
    .codewords = {
      {
        .opcode = 0x73015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX4W_registerW_registerZ_w032_double */
    .as_op = "sbfx4w",
    .codewords = {
      {
        .opcode = 0xf3015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8D_registerW_registerZ_registerY_simple */
    .as_op = "sbfx8d",
    .codewords = {
      {
        .opcode = 0x75014000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8D_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfx8d",
    .codewords = {
      {
        .opcode = 0xf5014000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFX8HQ_registerW_registerZ_registerY_simple */
    .as_op = "sbfx8hq",
    .codewords = {
      {
        .opcode = 0x75017000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8HQ_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfx8hq",
    .codewords = {
      {
        .opcode = 0xf5017000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFX8UWD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx8uwd",
    .codewords = {
      {
        .opcode = 0x7d018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8UWD_registerW_registerZ_w032_double */
    .as_op = "sbfx8uwd",
    .codewords = {
      {
        .opcode = 0xfd018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8WD_registerW_registerZ_registerY_simple */
    .as_op = "sbfx8wd",
    .codewords = {
      {
        .opcode = 0x75018000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8WD_registerW_registerZ_w032_double */
    .as_op = "sbfx8wd",
    .codewords = {
      {
        .opcode = 0xf5018000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8WP_registerW_registerZ_registerY_simple */
    .as_op = "sbfx8wp",
    .codewords = {
      {
        .opcode = 0x75016000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8WP_registerW_registerZ_w032_splat32_double */
    .as_op = "sbfx8wp",
    .codewords = {
      {
        .opcode = 0xf5016000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBFX8W_registerW_registerZ_registerY_simple */
    .as_op = "sbfx8w",
    .codewords = {
      {
        .opcode = 0x75015000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBFX8W_registerW_registerZ_w032_double */
    .as_op = "sbfx8w",
    .codewords = {
      {
        .opcode = 0xf5015000,
        .mask = 0xff03f800,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMM8_registerW_registerZ_registerY_simple */
    .as_op = "sbmm8",
    .codewords = {
      {
        .opcode = 0x7e020000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMM8_registerW_registerZ_s010_simple */
    .as_op = "sbmm8",
    .codewords = {
      {
        .opcode = 0x6e020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMM8_registerW_registerZ_s037_double */
    .as_op = "sbmm8",
    .codewords = {
      {
        .opcode = 0xee020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMM8_registerW_registerZ_w032_splat32_double */
    .as_op = "sbmm8",
    .codewords = {
      {
        .opcode = 0xfe020000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBMM8_registerW_registerZ_w064_triple */
    .as_op = "sbmm8",
    .codewords = {
      {
        .opcode = 0xee020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMMT8_registerW_registerZ_registerY_simple */
    .as_op = "sbmmt8",
    .codewords = {
      {
        .opcode = 0x7f020000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMMT8_registerW_registerZ_s010_simple */
    .as_op = "sbmmt8",
    .codewords = {
      {
        .opcode = 0x6f020000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_signed10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMMT8_registerW_registerZ_s037_double */
    .as_op = "sbmmt8",
    .codewords = {
      {
        .opcode = 0xef020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SBMMT8_registerW_registerZ_w032_splat32_double */
    .as_op = "sbmmt8",
    .codewords = {
      {
        .opcode = 0xff020000,
        .mask = 0xff03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_X, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_X,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_upper27_lower5_opnd,
      &kv3_v1_splat32_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s%s",
  },
  { /* Opcode-kv3_v1-SBMMT8_registerW_registerZ_w064_triple */
    .as_op = "sbmmt8",
    .codewords = {
      {
        .opcode = 0xef020000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_ALU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_ALU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE_Y,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_extend27_upper27_lower10_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SB_doscale_registerY_registerZ_registerT_simple */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0x2403e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SB_lsucond_registerY_registerZ_registerT_simple */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0x24030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-SB_lsucond_registerY_s027_registerZ_registerT_double */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0xa4030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SB_lsucond_registerY_s054_registerZ_registerT_triple */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0xa4030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SB_s010_registerZ_registerT_simple */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0x24010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SB_s037_registerZ_registerT_double */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0xa4010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SB_w064_registerZ_registerT_triple */
    .as_op = "sb",
    .codewords = {
      {
        .opcode = 0xa4010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SCALL_registerZ_simple */
    .as_op = "scall",
    .codewords = {
      {
        .opcode = 0x0fe40000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-SCALL_u012_simple */
    .as_op = "scall",
    .codewords = {
      {
        .opcode = 0x0fe00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      &kv3_v1_sysnumber_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s",
  },
  { /* Opcode-kv3_v1-SD_doscale_registerY_registerZ_registerT_simple */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0x2703e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SD_lsucond_registerY_registerZ_registerT_simple */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0x27030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-SD_lsucond_registerY_s027_registerZ_registerT_double */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0xa7030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SD_lsucond_registerY_s054_registerZ_registerT_triple */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0xa7030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SD_s010_registerZ_registerT_simple */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0x27010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SD_s037_registerZ_registerT_double */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0xa7010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SD_w064_registerZ_registerT_triple */
    .as_op = "sd",
    .codewords = {
      {
        .opcode = 0xa7010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SET_systemAlone_registerZ_simple */
    .as_op = "set",
    .codewords = {
      {
        .opcode = 0x0fc00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      &kv3_v1_systemalone_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-SET_systemRA_registerZ_simple */
    .as_op = "set",
    .codewords = {
      {
        .opcode = 0x0fc00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_systemra_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-SET_systemT3_registerZ_simple */
    .as_op = "set",
    .codewords = {
      {
        .opcode = 0x0fc00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_systemt3_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-SET_systemT4_registerZ_simple */
    .as_op = "set",
    .codewords = {
      {
        .opcode = 0x0fc00000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_BCU, ((int)0 << 8) | (int)Reservation_kv3_v1_BCU,
    .format = {
      &kv3_v1_systemt4_opnd,
      &kv3_v1_registerz_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s",
  },
  { /* Opcode-kv3_v1-SH_doscale_registerY_registerZ_registerT_simple */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0x2503e000,
        .mask = 0x7f03e000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_doscale_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SH_lsucond_registerY_registerZ_registerT_simple */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0x25030000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? [%s] = %s",
  },
  { /* Opcode-kv3_v1-SH_lsucond_registerY_s027_registerZ_registerT_double */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0xa5030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SH_lsucond_registerY_s054_registerZ_registerT_triple */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0xa5030000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_lsucond_opnd,
      &kv3_v1_registery_opnd,
      &kv3_v1_extend27_offset27_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = "%s %s? %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SH_s010_registerZ_registerT_simple */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0x25010000,
        .mask = 0x7f030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR,
    .format = {
      &kv3_v1_signed10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SH_s037_registerZ_registerT_double */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0xa5010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 2,
    .coding_size = 64,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_X, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_X,
    .format = {
      &kv3_v1_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SH_w064_registerZ_registerT_triple */
    .as_op = "sh",
    .codewords = {
      {
        .opcode = 0xa5010000,
        .mask = 0xff030000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
      {
        .opcode = 0x80000000,
        .mask = 0xe0000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX0|kvxOPCODE_FLAG_LSU
      },
      {
        .opcode = 0x00000000,
        .mask = 0x60000000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32|kvxOPCODE_FLAG_IMMX1|kvxOPCODE_FLAG_LSU
      },
    },
    .wordcount = 3,
    .coding_size = 96,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LSU_Y, ((int)0 << 8) | (int)Reservation_kv3_v1_LSU_AUXR_Y,
    .format = {
      &kv3_v1_extend27_upper27_lower10_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registert_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s[%s] = %s",
  },
  { /* Opcode-kv3_v1-SLEEP_simple */
    .as_op = "sleep",
    .codewords = {
      {
        .opcode = 0x0fa40000,
        .mask = 0x7ffc0000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_ALL, ((int)0 << 8) | (int)Reservation_kv3_v1_ALL,
    .format = {
      NULL
    },
    .rclass = "",
    .fmtstring = "",
  },
  { /* Opcode-kv3_v1-SLLD_registerW_registerZ_registerY_simple */
    .as_op = "slld",
    .codewords = {
      {
        .opcode = 0x79026000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLD_registerW_registerZ_u006_simple */
    .as_op = "slld",
    .codewords = {
      {
        .opcode = 0x79022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLHQS_registerW_registerZ_registerY_simple */
    .as_op = "sllhqs",
    .codewords = {
      {
        .opcode = 0x79029000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLHQS_registerW_registerZ_u006_simple */
    .as_op = "sllhqs",
    .codewords = {
      {
        .opcode = 0x79025000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLWPS_registerW_registerZ_registerY_simple */
    .as_op = "sllwps",
    .codewords = {
      {
        .opcode = 0x79028000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLWPS_registerW_registerZ_u006_simple */
    .as_op = "sllwps",
    .codewords = {
      {
        .opcode = 0x79024000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLW_registerW_registerZ_registerY_simple */
    .as_op = "sllw",
    .codewords = {
      {
        .opcode = 0x79027000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLLW_registerW_registerZ_u006_simple */
    .as_op = "sllw",
    .codewords = {
      {
        .opcode = 0x79023000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_TINY, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_TINY,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSD_registerW_registerZ_registerY_simple */
    .as_op = "slsd",
    .codewords = {
      {
        .opcode = 0x7c026000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSD_registerW_registerZ_u006_simple */
    .as_op = "slsd",
    .codewords = {
      {
        .opcode = 0x7c022000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSHQS_registerW_registerZ_registerY_simple */
    .as_op = "slshqs",
    .codewords = {
      {
        .opcode = 0x7c029000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSHQS_registerW_registerZ_u006_simple */
    .as_op = "slshqs",
    .codewords = {
      {
        .opcode = 0x7c025000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_unsigned6_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSWPS_registerW_registerZ_registerY_simple */
    .as_op = "slswps",
    .codewords = {
      {
        .opcode = 0x7c028000,
        .mask = 0x7f03f000,
        .flags = kvxOPCODE_FLAG_MODE64|kvxOPCODE_FLAG_MODE32
      },
    },
    .wordcount = 1,
    .coding_size = 32,
    .bundling = ((int)0 << 8) | (int)Bundling_kv3_v1_LITE, ((int)0 << 8) | (int)Reservation_kv3_v1_ALU_LITE,
    .format = {
      &kv3_v1_registerw_opnd,
      &kv3_v1_registerz_opnd,
      &kv3_v1_registery_opnd,
      NULL
    },
    .rclass = "",
    .fmtstring = " %s = %s, %s",
  },
  { /* Opcode-kv3_v1-SLSWPS_registerW_registerZ_u006_simple */
   