/******************************************************************************
/* S3M sample ripper by Patch/Avalanche (hamell@cs.pdx.edu)
/* November 10th, 1993
/*
/* This program is meant only as an exercise.
/******************************************************************************

#include <stdio.h>
#include <malloc.h>

typedef struct s3mform
               {
                   char             name[28];
                   char             sig1;
                   char             type;
                   char             sig2[2];
                   int              ordernum;
                   int              insnum;
                   int              patnum;
                   int              flags;
                   int              cwtv;
                   int              ffv;
                   char             s3msig[4];
                   unsigned char    mastervol;
                   unsigned char    initialspeed;
                   unsigned char    initialtempo;
                   unsigned char    mastermul;
                   char             sig3[12];
                   unsigned char    chanset[32];
                   unsigned char    *orders;
                   unsigned int     *parapins;
                   unsigned int     *parappat;
                   struct s3minsform       *insdata;
               } s3mform;

typedef struct s3minsform
               {
                   unsigned char    instype;
                   unsigned char    insdosname[12];
                   unsigned char    inssig1;
                   unsigned int     insmemseg;
                   unsigned long    inslength;
                   unsigned long    insloopbeg;
                   unsigned long    insloopend;
                   unsigned char    insvol;
                   unsigned char    insdsk;
                   unsigned char    inspack;
                   unsigned char    insflags;
                   unsigned int     insloc2spd;
                   unsigned int     inshic2spd;
                   unsigned char    inssig2[4];
                   unsigned int     insgvspos;
                   unsigned int     insint512;
                   unsigned long    insintlastused;
                   unsigned char    insname[28];
                   unsigned char    inssig[4];
               } s3minsform;

s3mform s3minfo;
FILE *infile, *outfile;
int i, outfnamelen, i2;
char outfname[15];
unsigned long templen;
unsigned char tempbuf[4096];

void main(int argc, char *argv[])
{
    printf("           S3M sample ripper          \n");
    printf("by Patch/Avalanche (hamell@cs.pdx.edu)\n");
    printf("\n");

    if (argc < 2)
    {
        printf("Usage: s3mrip FILENAME.S3M\n");
        exit(-1);
    }

    infile = fopen(argv[1],"rb");
    if (infile == NULL)
    {
        printf("file %s not found!\n",argv[1]);
        exit(-1);
    }
    fread(& s3minfo,1,96,infile);

    s3minfo.orders = (unsigned char *) malloc(s3minfo.ordernum);
    fread(s3minfo.orders,1,s3minfo.ordernum,infile);

    s3minfo.parapins = (unsigned int *) malloc(s3minfo.insnum*2);
    fread(s3minfo.parapins,2,s3minfo.insnum,infile);

    s3minfo.parappat = (unsigned int *) malloc(s3minfo.patnum*2);
    fread(s3minfo.parappat,2,s3minfo.patnum,infile);

    s3minfo.insdata = (s3minsform *) malloc(sizeof(s3minsform)*s3minfo.insnum);

    printf("s3mname              = %s\n",s3minfo.name);

    if (s3minfo.type == 16)
        printf("s3mtype              = module\n");
    else if (s3minfo.type == 17)
        printf("s3mtype              = song\n");
    else
        printf("s3mtype              = unknown\n");

    printf("# orders             = %d\n",s3minfo.ordernum);
    printf("# instruments        = %d\n",s3minfo.insnum);
    printf("# patterns           = %d\n",s3minfo.patnum);

    printf("flags                = %d -> ",s3minfo.flags);
    if (s3minfo.flags == 1)
        printf("st2vibrato\n");
    else if (s3minfo.flags == 2)
        printf("st2tempo\n");
    else if (s3minfo.flags == 4)
        printf("amigaslides\n");
    else if (s3minfo.flags == 8)
        printf("0vol optimizations\n");
    else if (s3minfo.flags == 16)
        printf("amiga limits\n");
    else if (s3minfo.flags == 32)
        printf("enable filter/sfx\n");
    else
        printf("unknown\n");

    printf("created with tracker = %d\n",s3minfo.cwtv >> 12);
    printf("             version = %d\n",s3minfo.cwtv & 0xfff);

    printf("file format version  = %d -> ",s3minfo.ffv);
    if (s3minfo.ffv == 1)
        printf("original\n");
    else if (s3minfo.ffv == 2)
        printf("original BUT samples unsigned\n");
    else
        printf("unknown\n");

    printf("S3M sig              = %c%c%c%c\n",s3minfo.s3msig[0],
           s3minfo.s3msig[1],s3minfo.s3msig[2],s3minfo.s3msig[3]);
    printf("master volume        = %d\n",s3minfo.mastervol);
    printf("initial speed        = %d\n",s3minfo.initialspeed);
    printf("initial tempo        = %d\n",s3minfo.initialtempo);
    printf("master multiplier    = %d\n",s3minfo.mastermul);
    printf("\n");

    printf("Input a 6 letter sample filename.  Numbers ranging from 00 to\n");
    printf("99 will be added as the last 2 letters of the filename: ");
    scanf("%s",outfname);
    outfname[6] = outfname[7] = outfname[8] = 0;
    outfnamelen = strlen(outfname);

    for (i = 0, i2 = 0; i < s3minfo.insnum; i++)
    {
        fseek(infile,s3minfo.parapins[i]*16,0);
        fread(& s3minfo.insdata[i],1,sizeof(s3minsform),infile);

        if (s3minfo.insdata[i].instype == 1)
        {
            fseek(infile,(unsigned long) s3minfo.insdata[i].insmemseg*16,0);
            outfname[outfnamelen + 0] = (char) (i2 / 10) + 48;
            outfname[outfnamelen + 1] = (char) (i2 % 10) + 48;
            i2++;

            outfile = fopen(outfname,"wb");
            templen = s3minfo.insdata[i].inslength;
            while (templen > 0)
            {
                if (templen >= 4096)
                {
                    fread(& tempbuf,1,4096,infile);
                    fwrite(& tempbuf,1,4096,outfile);
                    templen -= 4096;
                }
                else
                {
                    fread(& tempbuf,1,(unsigned int) templen,infile);
                    fwrite(& tempbuf,1,(unsigned int) templen,outfile);
                    templen = 0;
                }
            }
            fclose(outfile);
        }

/*
        if (s3minfo.insdata[i].instype == 1)
            printf("ins type = sample\n");
        else
            printf("ins type = unknown\n");

        printf("ins dosname = %s\n",s3minfo.insdata[i].insdosname);
        printf("insname     = [%s]\n",s3minfo.insdata[i].insname);
        printf("insmemseg   = %d\n",s3minfo.insdata[i].insmemseg);
        printf("ins length  = %lu\n",s3minfo.insdata[i].inslength);
        printf("ins loopbeg = %lu\n",s3minfo.insdata[i].insloopbeg);
        printf("ins loopend = %lu\n",s3minfo.insdata[i].insloopend);
        printf("\n");
*/
    }

    fclose(infile);
    free(s3minfo.orders);
    free(s3minfo.parapins);
    free(s3minfo.parappat);
    free(s3minfo.insdata);

    printf("\n");
    printf("Done ripping samples.  Greets to:\n");
    printf("    KnightOrc - for supplying the S3M format text file\n");
    printf("    Zax, Trug, Jake, Guildmaster, and Barfman for being drunk\n");
    printf("    MC Leinad - babe man DJ Lassio rapping stud!  Kosmisk i parken\n");
}
