	; Utilise MATRIX10.LOD	:  2650 < < 2900 avec couleur

prec=1
nb_points=2500	; DOIT ETRE UN MULTIPLE DE [MULTIPLE]
MULTIPLE=10

INIT_DOTS:	bsr init_dsp
	tst d7
	bmi.s .erreur

	MXALLOC #RAM_TT_ST,#3*nb_points*4
	tst.l d0
	ble.s .plus_de_memoire1
	move.l d0,ptr_table_send

	MXALLOC #RAM_TT_ST,#2*nb_points*4
	tst.l d0
	ble.s .plus_de_memoire2
	move.l d0,ptr_table_receive

	SUPEXEC send_vectors

	clr angles
	clr angles+2
	clr angles+4

	SUPEXEC send_cos_sin
	clr.w d7
.erreur:	rts

.plus_de_memoire2:
	MFREE ptr_table_send
.plus_de_memoire1:
	bsr restore_dsp

	move.w #ALERT_NO_MEMORY,d0
	move #1,d1
	bsr RSC_ALERT_BOX
	moveq #-1,d7
	rts

ROTATION_DOTS:
	bsr efface_scr2
	
	SUPEXEC receive_vectors2

	SUPEXEC send_cos_sin	; rouge

	sub #1*prec,angles
	add #2*prec,angles+2
	add #1*prec,angles+4

	bsr verif_angles

	rts

FIN_DOTS:	bsr restore_dsp
	MFREE ptr_table_send
	MFREE ptr_table_receive
	rts
*************************************************************************3

efface_scr2:
	lea objet_fenetre2,a0
	move.l GWVA_WIND_OBJ_SPEC_PTR(a0),a1

	lea GWVA_APP_MFDB_DEST,a2
	move.l GWVA_WBITM_OBJ_DATA_PTR(a1),(a2)+	; pointeur image
	move.l GWVA_WBITM_OBJ_IMG_WIDTH(a1),(a2)+	; largeur image pixel

	move.w GWVA_WBITM_OBJ_IMG_WIDTH(a1),d5
	add.w #15,d5
	ext.l d5
	divu #16,d5
	move.w d5,(a2)+			; largeur image en mots

	move.w #0,(a2)+			; device dependent

	move.w GWVA_WBITM_OBJ_NBR_BITPLANES(a1),(a2)+
	clr.w (a2)+				; reservs
	clr.w (a2)+
	clr.w (a2)+

	clr.l GWVA_APP_MFDB_SRC

	move.w #0,d0
	move.w #0,d1
	move.w GWVA_WBITM_OBJ_IMG_WIDTH(a1),d2
	sub.w #1,d2
	move.w GWVA_WBITM_OBJ_IMG_HEIGHT(a1),d3
	sub.w #1,d3
	movem.w d0-d3,ptsin
	movem.w d0-d3,ptsin+8

	vro_cpyfm #0,#GWVA_APP_MFDB_SRC,#GWVA_APP_MFDB_DEST	; All zeros mode

	rts

*************************************************************************
init_dsp:
	MXALLOC #RAM_TT_ST,#10*1024
	tst.l d0
	ble .plus_de_memoire

	save.l d0
	appel xbios,104,2	; dsp_lock
	load.l a0
	tst.w d0
	bne .it_s_locked

	save.l a0
	appel xbios,113,2	; Dsp_RequestUniqueAbility
	move d0,ability
	load.l a0

	ifnd OPT_FULL_PATHNAMES
	lea GWVA_APP_OBJ_STARTED_PATH,a1
	lea file_lod,a2
	COPY_STRING_0 a1,a2
	lea -1(a2),a2
	lea file_lod_base,a1
	COPY_STRING_0 a1,a2
	endc

	save.l a0
	pea (a0)
	pea file_lod
	appel xbios,111,10	; Dsp_Lod2Binary
	load.l a0

	tst.l d0
	bmi .err_file

	save.l a0
	move.w ability,-(sp)
	move.l d0,-(sp)	; taille
	pea (a0)
	appel xbios,109,12	; Dsp_ExecProg
	load.l a0

	MFREE a0

	clr.w d7
	rts
.it_s_locked:
	MFREE a0

	appel xbios,114,2	; GetProgAbility
	cmp.w ability,d0
	beq.s .its_my_dsp_prog

	move #ALERT_DSP_LOCKED,d0
	move #2,d1
	bsr RSC_ALERT_BOX
	cmp.w #2,d0
	beq.s .pas_de_deblocage

.its_my_dsp_prog:
	bsr restore_dsp
	bra init_dsp

.pas_de_deblocage:
	move.w #-1,d7
	rts

.plus_de_memoire:
	move.w #ALERT_NO_MEMORY,d0
	move #1,d1
	bsr RSC_ALERT_BOX
	move.w #-1,d7
	rts

.err_file:
	MFREE a0

	bsr restore_dsp

	move.w #ALERT_FILE,d0
	move #1,d1
	bsr RSC_ALERT_BOX
	move.w #-1,d7
	rts

restore_dsp:
	appel xbios,105,2	; dsp_unlock
	clr.w ability
	rts
*************************************************************************
send_vectors:
	lea table_pts_sph,a0
	cmp.w #FCHX_RBTON_SPH,choix_objet_dots
	beq.s .choix_sphere
	lea table_pts_tore,a0
.choix_sphere:

	move.l ptr_table_send,a1

	move.w #nb_points*3-1,d1
transf_vect:move.w (a0)+,d0
	lsl.l #8,d0
	move.l d0,(a1)+
	dbf d1,transf_vect
	
	moveq #0,d1
	move.l ptr_table_receive,a1
	move.l #nb_points*3,d0
	move.l ptr_table_send,a0
	bsr dsp_send_receive
	rts
*************************************************************************
; A0/D0.L : mission
; A1/D1.L : rception

dsp_send_receive:
	TST.L D0
	BEQ.S .rien_emettre
	SUBQ.W #1,D0 
.pas_libre:	BTST #1,dsp_host_isr.W 
	BEQ.S .pas_libre
.send_data:	MOVE.L (A0)+,dsp_host.W
*	DBF D0,.send_data
	DBF D0,.pas_libre
.rien_emettre:
	TST.L D1
	BEQ.S .rien_recevoir
	SUBQ.W #1,D1 
.pas_libre2:
	BTST #0,dsp_host_isr.W 
	BEQ.S .pas_libre2
.receive_data:
*	MOVE.L dsp_host.W,(A1)+
	MOVE.W (dsp_host+2).W,(A1)+
*	DBF D1,.receive_data
	DBF D1,.pas_libre2
.rien_recevoir:
	RTS 
*************************************************************************
send_cos_sin:
	lea table_sin,a0
	move.l ptr_table_send,a1
	lea angles,a2

	moveq #3-1,d1
.cos_sin:	move.w (a2)+,d0
	move.l (90*prec*4,a0,d0.w*4),(a1)+	; cosinus en 1er
	move.l (a0,d0.w*4),(a1)+	; sinus
	dbf d1,.cos_sin

	moveq #0,d1
	move.l ptr_table_receive,a1
	move.l #3*2,d0
	move.l ptr_table_send,a0
	bsr dsp_send_receive
	rts
*************************************************************************
receive_vectors:

	move.l #nb_points*2,d1
	move.l ptr_table_receive,a1
	moveq #0,d0
	move.l ptr_table_send,a0
	bsr dsp_send_receive

	rts
*************************************************************************
tst_dsp:	macro
.\@pas_libre	BTST #0,dsp_host_isr.W 
	BEQ.S .\@pas_libre
	endm

receive_vectors2:
	move.l #nb_points/MULTIPLE-1,d1
	lea objet_fenetre2,a0
	move.l GWVA_WIND_OBJ_SPEC_PTR(a0),a1
	move.l GWVA_WBITM_OBJ_DATA_PTR(a1),a2

.receive_data:
	rept MULTIPLE
	tst_dsp
	add.w (dsp_host+2).W,a2
	tst_dsp
	move.w (dsp_host+2).W,d0
	or.w d0,(a2)
	endr
	dbf d1,.receive_data

	rts


*************************************************************************
verif_angles:
	lea angles,a0
	move.w #3-1,d1

.all_a:	move.w (a0),d0
.redo1:	bpl.s .cool1
	add.w #360*prec,d0
	bra.s .redo1
.cool1:	cmp.w #360*prec,d0
	blt.s .cool2
	sub.w #360*prec,d0
	bra.s .cool1
.cool2:	move.w d0,(a0)+
	dbf d1,.all_a
	rts

*************************************************************************
 DATA
 even

colors:	dc.l $00000000,$00FCFCFC,$00DCDCDC,$00FCFCFC,$00BCBCBC
	dc.l $00FCFCFC,$007C7C7C,$00FCFCFC,$009C9C9C,$00FCFCFC
	dc.l $007C7C7C,$00FCFCFC,$003C3C3C,$00FCFCFC,$007C7C7C
	dc.l $00FCFCFC

	ifd OPT_FULL_PATHNAMES
file_lod:	dc.b 'd:\assemble\sources.v41\dots\matrix10.lod',0
	else
file_lod_base:	dc.b 'matrix10.lod',0
	endc
 even
table_sin:	incbin sin_dsp.tab
table_pts_sph:
	incbin boule.pts
table_pts_tore:
	incbin tore.pts

*************************************************************************
 BSS
 even
ability:	ds.w 1
size_bin:	ds.l 1

angles:	ds.w 3

	ifnd OPT_FULL_PATHNAMES
file_lod:	ds.b GWVA_MAX_PATH_LENGTH
	endc

*table_convert:
ptr_table_send:	ds.l 1

ptr_table_receive:	ds.l 1

 TEXT
