.TH Euler 1 "" ""

.SH NAME
Euler - A numerical laboratory.

.SH SYNTAX
euler [-f font] [-g font] [-s KB] [-geom geometry]
 [-d display] [-0..15 color] [ files ]

.SH OPTIONS
.TP 8
-f font
Specifies the font name for text output.
.TP 8
-g font
Specifies the font name for graphic text.
.TP 8
-s number
Specifies the number of KBytes for the user area of Euler.
.TP 8
-geom geometry
geometry is the geometry of the euler window in standard form.
.TP 8
-number color
Sets the color number to a color name.
.TP 8
files
Specifies input files for Euler. Default extension is ".e".

.SH PURPOSE
Euler is a Matlab(R) style numerical laboratory. It is capable of
numerical mathematics with real or complex scalars, vectors or
matrices. It can produce graphics in 2D or 3D. The built in programming
language can be used to define functions, which can be loaded from
external files. Many useful numerical algorithms are contained in the
code. Others are contained in the setup file and written in the Euler
language.

.SH USAGE
This version of Euler has a single window. The user can switch between
the text and graphics output with the TAB key. Old text output may be
accessed by the page up and pyge down key. Pointer usage is restricted
to the mouse function.

For details on the use of euler see the file euler.doc.

.SH FILES
.TP 12
euler
The program.
.TP 12
euler.cfg
The configuration file, which in turn loads "util.e".
.TP 12
*.e
Euler language files. Important examples are "util.e" and
"demo.e"
.TP 12
euler.doc
The documentation.

.P
On this system, euler is a shell script, which envokes the euler program
and sets the directory to $HOME/euler/progs. Scan this directory for
the "*.e" and "*.doc" files.

