/*
 * utility to adjust _stksize in gcc-cc1.ttp
 *
 *	Usage: fixstk size [<filename>]
 *	  size:	specified as # of bytes 		nnn
 *		specified as # of Kilo Bytes		nnnK
 *		specified as # of Mega Bytes		nnnM
 *	  filename:
 *		optional, defaults to \.gcc-cc1.ttp
 *
 *	++jrb
 *
 *      modified to allow fixing applications for which size of a stack
 *      is defined via _initial_stack -- mj
 */

#include <stdio.h>
#include <stdlib.h>
#ifndef __MINT__
#include <unixlib.h>
#else
#include <unistd.h>
#endif				/* __MINT__ */
#include <string.h>
#include <st-out.h>

long lseek(int, long, int);
static char *sym_names[] = { "__stksize", "__initial_stack" };

long find_offset (fd, fn, what)
int fd;
char *fn;
int *what;
{
    struct aexec head;
    struct asym  sym;
    int found;
    int	all = 0;
    int index = 1;
    
    if(read(fd, &head, sizeof(head)) != sizeof(head))
    {
	perror(fn);
	exit(2);
    }
    if(head.a_magic != CMAGIC)
    {
	fprintf(stderr,"Invalid magic number %x\n", head.a_magic);
	exit(3);
    }
    if(head.a_syms == 0)
    {
	fprintf(stderr,"%s: no symbol table\n", fn);
	exit(4);
    }
    if(lseek(fd, head.a_text+head.a_data, 1) != 
       (head.a_text+head.a_data+sizeof(head)))
    {
	perror(fn);
	exit(5);
    }
    for(;;)
    {
	if(index && (read(fd, &sym, sizeof(sym)) != sizeof(sym)))
	{
	    fprintf(stderr, "symbol _stksize not found\n");
	    exit(6);
	}
	/* after symbol read check first for _stksize */
	index ^= 1;
	if (strncmp(sym_names[index], sym.a_name, 8) == 0)
	{
	    if ((found = (sym.a_type & A_DATA)) || all++)
		break;
	}
    }
    
    if(!found)
    {
	fprintf(stderr, "symbol _stksize is undefined\n");
	exit(9);
    }
    *what = index;
    return sym.a_value + sizeof(head);
}

long calc_newsize(s)
char *s;
{
    size_t len = strlen(s) - 1;
    long mul = 1;
    long atol(const char *);

    switch(s[len])
    {
      case 'k': case 'K':
	mul = 1L << 10;
	break;
      case 'm': case 'M':
	mul = 1L << 20;
	break;
      default:
	len += 1;
    }
    
    s[len] = '\0';
    return mul * atol(s);
}

int main(argc, argv)
int argc;
char **argv;
{
    int fd;
    int what;
    long newstksize, stksize, offset;
    char sizestr[16], fn[FILENAME_MAX];
    
    if(argc < 2)
    {
	fprintf(stderr, "usage: fixstk size [<filename>]\n");
	exit(1);
    }

    strcpy(sizestr, *++argv);

    if(argc > 2)
	(void) strcpy(fn, *++argv);
    else
	(void) strcpy(fn, "gcc-cc1.ttp");

    if((fd = open(fn, 2)) < 0)
    {
	perror(fn);
	exit(1);
    }
    
    newstksize = calc_newsize(sizestr);
    offset = find_offset(fd, fn, &what);
    if(lseek(fd, offset, 0) != offset)
    {
	perror(fn);
	close(fd);
	exit(7);
    }
    read(fd, &stksize, sizeof(long));
    printf("%s: %s was %ld (%dK)\n",
    	 fn, sym_names[what] + 1, stksize, (int)(stksize/1024));
    
    lseek(fd, -((long)sizeof(long)), 1);
    
    if(write(fd, &newstksize, sizeof(long)) != sizeof(long))
    {
	perror(fn);
	close(fd);
	exit(8);
    }
    
    lseek(fd, -((long)sizeof(long)), 1);
    
    read(fd, &stksize, sizeof(long));
    printf("%s: %s now is %ld (%dK)\n",
    	 fn, sym_names[what] + 1, stksize, (int)(stksize/1024));
    return close(fd);
}

