


CTAGS(1)                                                 CTAGS(1)


NNAAMMEE
       ctags - Generate C language tag files for use with vvii(1)

SSYYNNOOPPSSIISS
       ccttaaggss [ --aaBBddFFnnssSSttTTuuwwWWxx ] [ --ff _t_a_g_f_i_l_e ] [ --hh _l_i_s_t ]
             [ --ii _t_y_p_e_s ] [ --LL _l_i_s_t_f_i_l_e ] [ --oo _t_a_g_f_i_l_e ]
             [ ----hheellpp ] [ _f_i_l_e_(_s_) ]

DDEESSCCRRIIPPTTIIOONN
       CCttaaggss  generates  an  index  (or "tag") file of C language
       objects found in _f_i_l_e_(_s_) that allows  these  items  to  be
       quickly and easily located by a text editor or other util-
       ity. A "tag" signifies a C language object  for  which  an
       index  entry  is  available  (or, alternatively, the index
       entry created for that object).

       Alternatively, ccttaaggss can generate a cross  reference  file
       which lists, in human readable form, information about the
       various objects found in a set of C language files.

       Tag index files are supported by the vvii(1) editor and  its
       derivatives  (such as vviimm, eellvviiss, sstteevviiee, and xxvvii) through
       the use of the ":ta" command,  which  locates  the  object
       associated  with  a  name  appearing  in a source file and
       jumps to the file and line which  defines  the  name.  The
       following types of tags are supported by ccttaaggss::

           macro definitions (i.e. names created by #define)
           enumerated values (i.e. the values inside enum{...})
           function definitions
           function prototypes or declarations (optional)
           class, enum, struct and union tags
           typedefs
           variables

       With  the  exception  of  macro  definitions, only objects
       defined outside of function, class,  structure  and  union
       blocks  are  candidates  for  a  tag. For every one of the
       selected objects listed above which are discovered in  the
       source  files  supplied to ccttaaggss, a separate line is added
       to the tags file in the following format:

           1.  tag name (a C language identifier)
           2.  a single tab character
           3.  the name of the file in which the  object  associ-
               ated with the tag is located
           4.  a single tab character
           5.  a  search  pattern (either /pattern/ or ?pattern?)
               or line number with which to locate the tag within
               the file

       Note  that,  unless  changed  via --nn, line number are only
       used for tags for macro definitions,  while  patterns  are
       used for all other tags.



Darren Hiebert             16 June 1996                         1





CTAGS(1)                                                 CTAGS(1)


       Note that the name of each source file will be recorded in
       the tag file exactly as it appears on  the  command  line.
       Therefore,  if  the path you specified on the command line
       was relative to some directory, then it will  be  recorded
       in that same manner in the tag file.

       This  version of ccttaaggss imposes no formatting requirements.
       Other versions of ctags tended to rely upon  certain  for-
       matting  assumptions  in  order  to help it resolve coding
       dilemmas caused by preprocessor conditionals.

       In general, ccttaaggss tries to be smart about conditional pre-
       processor  directives.  If  a  preprocessor conditional is
       encountered within a statement which defines a tag,  ccttaaggss
       follows  only the first branch of that conditional (except
       in the special case of "#if 0", in which case  it  follows
       only the last branch). The reason for this is that failing
       to pursue only one branch can result in ambiguous  syntax,
       as in the following example:

              #ifdef STORE_SEPARATELY
              struct {
              #else
              union {
              #endif
                  short a;
                  long b;
              }

       Both  branches cannot be followed, or braces become unbal-
       anced and ccttaaggss would be unable to make sense of the  syn-
       tax.

       If  the  application  of  this heuristic fails to properly
       parse a file, generally due to complicated  and  inconsis-
       tent pairing within the conditionals, ccttaaggss will retry the
       file using a different heuristic  which  does  not  selec-
       tively   follow  conditional  preprocessor  branches,  but
       instead falls back to relying upon a closing  brace  ("}")
       in  column  1  as  indicating  the end of a block once any
       brace imbalance is detected within a #if conditional.

       CCttaaggss will also try to specially  handle  arguments  lists
       enclosed  in double sets of parentheses in order to accept
       the following conditional construct:

              extern void (*fptr) __ARGS((int one, char two));

       Any name immediately preceding the "((" will be  discarded
       and the previous name will be used.

       After  creating or appending to the tag file, it is sorted
       by the tag name, removing identical tag lines.




Darren Hiebert             16 June 1996                         2





CTAGS(1)                                                 CTAGS(1)


OOPPTTIIOONNSS
       Note that spaces separating options from their  parameters
       are optional.

       --aa   Append the tags to an existing tag file.

       --BB   Use backward searching patterns (?...?).

       --dd   Include macro definitions in the output file. This is
            equivalent to --ii_+_d and is supported  only  for  back-
            wards compatibility with other versions of ctags. Use
            of --ii is preferred.

       --ff _t_a_g_f_i_l_e
            Output  tags  to  the  specified  file  (default   is
            "tags"). If _t_a_g_f_i_l_e is specified as "-", then the tag
            file is written to standard  output  instead.   CCttaaggss
            will  stubbornly  refuse  to  take  orders if _t_a_g_f_i_l_e
            exists and its first line  contains  something  other
            than  a valid tags line.  This will save your neck if
            you mistakenly type "ctags -o *.c", which would  oth-
            erwise overwrite your first C file with the tags gen-
            erated by the rest!

       --FF   Use forward searching patterns (/.../) (default).

       --hh _l_i_s_t
            Specifies a list of file extensions used for headers,
            separated  by  either  periods or commas. The default
            list is ".h.H.hpp.hxx.h++".

       --ii _t_y_p_e_s
            Specifies the list of tag types  to  include  in  the
            output file.  TTyyppeess is a group of letters designating
            the types of tags affected. Each letter or  group  of
            letters   may  be  preceded  by  either  a  '+'  sign
            (default, if omitted) to  add  it  to  those  already
            included,  a  '-'  sign  to  exclude it from the list
            (e.g.  to exclude a default tag type), or an '=' sign
            to  include  its corresponding tag type at the exclu-
            sion of those not listed. The following tag types are
            supported:
               dd   macro definitions
               ee   enumerated values (values inside enum{...})
               ff   function and method definitions
               gg   enum/struct/union tags (or new C++ types)
               pp   external function prototypes
               tt   typedefs
               vv   variable declarations
            In   addition,   the   following  two  modifiers  are
            accepted:
               PP   Prefix static tags (if included)  in  the  tag
                   file  with  the filename in which they appear,
                   followed by a colon (Elvis style;  not  widely



Darren Hiebert             16 June 1996                         3





CTAGS(1)                                                 CTAGS(1)


                   supported).
               SS   Include static tags (those not visible outside
                   of a single source file).  Function and  vari-
                   able  definitions  are  considered static only
                   when their definitions are preceded  with  the
                   "static"  keyword. All other types of tags are
                   considered static when they appear in  a  non-
                   header file (see the -h option).
            The  default value of _l_i_s_t is "=defgtvS" (i.e all tag
            types except for function prototypes; include  static
            tags but do not prefix them).

       --LL _l_i_s_t_f_i_l_e
            Read the names of files for which tags tags should be
            generated from _l_i_s_t_f_i_l_e.  If _l_i_s_t_f_i_l_e is specified as
            "-", then file names are read from standard input.

       --nn   Places  places  the  line  numbers in the source file
            where tags are located rather  than  patterns  to  be
            searched for. This has two advantages:
            1.  Significantly  reduces  the size of the resulting
                tag file.
            2.  Eliminates failures to find tags because the line
                defining the tag has changed, causing the pattern
                match to fail (note that some  editors,  such  as
                vviimm, are able to recover in many such instances).
            3.  Eliminates finding identical matching, but incor-
                rect, source lines (see BBUUGGSS, below).
            However,  this  option  has one significant drawback:
            changes to the source files can cause the  line  num-
            bers recorded in the tag file to no longer correspond
            to the lines in the source  file,  causing  jumps  to
            some  tags  to  miss  the target definition by one or
            more lines. Selecting this option causes the  follow-
            ing options to be ignored: --FF and --BB.

       --oo _t_a_g_f_i_l_e
            Alternative for --ff.

       --ss   Include static tags in the output file, each prefixed
            with the name of the file in which  it  appears  fol-
            lowed  by a colon. This is equivalent to --ii_+_S_P and is
            supported only for backwards compatibility with other
            versions of ctags. Use of --ii is preferred.

       --SS   Include  static  tags  in the output file, but do not
            prefix them, thereby making them appear the  same  as
            global tags. This is equivalent to --ii_+_S_-_P and is sup-
            ported only for backwards  compatibility  with  other
            versions of ctags. Use of --ii is preferred.

       --tt   Include  typedefs in the output file. This is equiva-
            lent to --ii_+_t and is supported only for backwards com-
            patibility with other versions of ctags. Use of --ii is



Darren Hiebert             16 June 1996                         4





CTAGS(1)                                                 CTAGS(1)


            preferred.

       --TT   Include typedefs and class/enum/struct/union tags  in
            the  output file.  This is equivalent to --ii_+_t_g and is
            supported only for backwards compatibility with other
            versions of ctags. Use of --ii is preferred.

       --uu   Unsorted; do not sort the tags. Please note that this
            disables the warning messages normally enabled by _-_W,
            because  sorted  tags  are  used  to detect duplicate
            tags. Note also that vvii(1) requires sorted tags.

       --ww   Exclude warnings about duplicate tags (default).

       --WW   Generate warnings about duplicate tags.

       --xx   Print  a  tabular,  human-readable  cross   reference
            (xref)  file to standard output. The information con-
            tained in the output includes: the tag name; the  tag
            type;  the  line  number,  file name, and source line
            (with extra white space condensed) of the file  which
            defines  the tag. No tag file is written and the fol-
            lowing options will be ignored: --aa, --ff, --ii++PP, --nn, --oo,
            --BB and --FF.  Example applications for this feature are
            generating a  listing  of  all  functions  (including
            statics) located in a source file (e.g.  ccttaaggss --xxii==ffSS
            _f_i_l_e), or generating a list of all externally visible
            global  variables  located  in  a  source  file (e.g.
            ccttaaggss --xxii==vv _f_i_l_e).

       ----hheellpp
            Prints to standard output a detailed  usage  descrip-
            tion.

EENNVVIIRROONNMMEENNTT VVAARRIIAABBLLEESS
       CCTTAAGGSS   If found, this variable will be assumed to contain
               a set of custom default  options  which  are  read
               when  ccttaaggss  starts,  but  before any command line
               options are read. Options in this variable  should
               be  in the same form as those on the command line.
               Command line options will override options  speci-
               fied  in this variable. Only options may be speci-
               fied with this variable; no source file names  are
               read from its value.

HHOOWW TTOO UUSSEE WWIITTHH VVII
       Vi  will, by default, expect a tag file by the name "tags"
       in the current directory. Once the tag file is build,  the
       following  vi commands take exercise the tag indexing fea-
       ture:

       vi -t tag   Start vi and position the cursor at  the  file
                   and line where "tag" is defined.




Darren Hiebert             16 June 1996                         5





CTAGS(1)                                                 CTAGS(1)


       Control-]   Find the tag under the cursor.

       :ta tag     Find a tag.

       Control-T   Return to previous location before jump to tag
                   (not widely implemented).

BBUUGGSS
       Support for C++ features is quite limited.

       Because  ccttaaggss  does  not  presently  look  inside   brace
       enclosed      blocks,      nested     declarations     for
       class/enum/struct/union tags and enumeration values  (i.e.
       declared  within  another  class, structure or union) will
       not have tags generated for them.

       Note that because ccttaaggss generates search patterns for non-
       macro  tags,  it  is entirely possible that the wrong line
       may be found by your editor if there exists another, iden-
       tical,  line  (whose context prevents it from generating a
       tag) which is identical to the line  containing  the  tag.
       The following example demonstrates this condition:

              int variable;

              /* ... */
              void foo(variable)
              int variable;
              {
                  /* ... */
              }

       Depending  upon which editor you use and where in the code
       you happen to be, it is possible that the  search  pattern
       may locate the local parameter declaration in foo() before
       it finds the actual global variable definition, since  the
       lines (and therefore their search patterns are identical).

       Because ccttaaggss is neither a preprocessor  nor  a  compiler,
       some  complex  or  obscure  constructs can fool ccttaaggss into
       either missing a tag or improperly generating an  inappro-
       priate  tag.  In  particular, the use of preprocessor con-
       structs which alter the  textual  syntax  of  C  can  fool
       ccttaaggss, as demonstrated by the following example:

              #ifdef GLOBAL
              #define EXTERN
              #define INIT(assign)     assign
              #else
              #define EXTERN extern
              #define INIT(assign)
              #endif

              EXTERN BUF *firstbuf INIT(= NULL);



Darren Hiebert             16 June 1996                         6





CTAGS(1)                                                 CTAGS(1)


       This  looks  too  much  like  a declaration for a function
       called "INIT",  which  returns  a  pointer  to  a  typedef
       "firstbuf",  rather  than  the  actual variable definition
       that it is, since this distinction can only be resolved by
       the preprocessor. The moral of the story: don't do this if
       you want a tag generated for it.

FFIILLEESS
       _t_a_g_s      The default tag file created by ccttaaggss.

SSEEEE AALLSSOO
       The official Exuberant Ctags web site at:

           http://fly.hiwaay.net/~darren/ctags.html

       Also eexx(1), vvii(1), eellvviiss, or, better yet, vviimm,  the  offi-
       cial  editor  of  ccttaaggss.  For more information on vviimm, see
       the VIM Pages web site at:

           http://www.math.fu-berlin.de/~guckes/vim/

AAUUTTHHOORR
       Darren  Hiebert,   (darren@sirsi.com,   darren@hiwaay.net,
       http://fly.hiwaay.net/~darren)

MMOOTTIIVVAATTIIOONN
       "Think  ye at all times of rendering some service to every
       member of the human race."

       "All effort and exertion put forth by man from  the  full-
       ness  of  his  heart  is worship, if it is prompted by the
       highest motives and the will to do service to humanity."

                 -- From the Baha'i Writings

CCRREEDDIITTSS
       This version of ccttaaggss is derived from and inspired by  the
       ctags  program  by  Steve Kirkendall (kirkenda@cs.pdx.edu)
       that comes with the Elvis vi clone (though almost none  of
       the original code remains).

       Credit  is also due Bram Moolenaar, the author of vviimm, who
       has devoted so much of his time and energy both to  devel-
       oping  the  editor  as a service to others, and to helping
       the orphans of Uganda.












Darren Hiebert             16 June 1996                         7


