;/********************************************************************/
;/*																	*/
;/*	Packet driver for D-LINK ethernet controller					*/
;/*																	*/
;/*	Copyleft by P. Mayer, 1992 TU-Vienna IAEE						*/
;/*	All rights reserved												*/
;/*																	*/
;/********************************************************************/


	.text
	.super
	
	export	dlink_interrupt
	export	dlink_interrupt
	export	nic_install
	export	vbl_loop
	export	old_intr
    export  clock
    export  dclock
    export  enablirq
    export  disablirq
    export  quitirq
    export	fastread
	export	nic_locked
        
	import	ihandler
	import	rcv_pkt
	import	rcv_check

MFP_FLANK	equ $fffa03
MFP_IENB	equ $fffa09
MFP_ISRB	equ $fffa11
MFP_IMASKB	equ $fffa15

IRQ_LAT		equ	100

*note: for IRQs set assembler option IRQVERSION=1

enablirq:
        if	IRQVERSION
		 bset	#0,MFP_IMASKB
		 bset	#0,MFP_IENB
		endif
		rts

nic_install:
        if	IRQVERSION
 		 bclr	#0,MFP_IENB
		 bclr	#0,MFP_IMASKB
		 bset	#0,MFP_FLANK	* low to high edge
		endif
		rts

disablirq:
        if	IRQVERSION
		 bclr	#0,MFP_IMASKB
		endif
		rts
		
		dc.l		'XBRADLNK'
old_intr:	dc.l	0

dlink_interrupt:
		bclr	#0,MFP_ISRB		* ack this irq
		move.l	$4ba,lastirq
		tst.b	nic_locked
		bne		exirq

        bset	#7,nic_locked
		bclr	#0,MFP_IMASKB	* disable this irq
        tst.l	old_stack
        beq 	okstack
        jmp		$1				* error catch
okstack:
        move	(a7),status
		move.l	a7,old_stack
		lea		new_stack,a7
		movem.l	d0-a6,-(a7)
        move	status,d0		* restore imask before irq
        or		#$2000,d0		* stay in supervisor mode
        move	d0,sr
		move.l	ihandler,d0		* other irqs possible
		beq		nohandler
		move.l	d0,a0
		jsr		(a0)
nohandler:
		movem.l	(a7)+,d0-a6
		movea.l	old_stack,a7
        clr.l	old_stack
		bclr	#7,nic_locked
		bset	#0,MFP_IMASKB
exirq:
		rte
		
vbl_loop:
		tst.b	nic_locked
		bne		exloop
		if	IRQVERSION
		 move.l	$4ba,d0
		 move.l	lastirq,d1
		 add.l	#IRQ_LAT,d1
         cmp.l	d1,d0
		 bmi		exloop
         move.l	d0,lastirq
        endif
		bset	#7,nic_locked
		if	IRQVERSION
         jsr	disablirq
        endif
		jsr		rcv_check
		if	IRQVERSION
		 jsr 	enablirq
		endif
		bclr	#7,nic_locked
exloop:
		rts

fastread:
fastloop:
		move.b	2(a2),d4
		or.b	d3,d4
		move.b	$12(a2),d3
		lsr.b	#4,d3
		move.b	d4,(a0)+
		dbra	d0,fastloop
		rts				
		
clock:      move.l $4ba,d0				; 
            rts

dclock:     move.l $4ba,d0				; 
            asl.l	#8,d0
            move.b	$fffa23,d0
            neg.b	d0
            rts

savepc:		dc.l 0
savesr:		dc.l 0
lastirq:	dc.l 0
nic_locked:	dc.w 0

	.bss
	.even

status:		ds.w	1
old_stack:	
OLD_STACK:	ds.l	1

			DS.W	512
new_stack:			
NEW_STACK:
			DS.W	10
