#include <tos.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "inetcust.h"
#include "cookie.h"
#define _cookiejar	*(long *)0x5A0L

long set_cookiejar(COOKIE *);

extern char Start;
extern INETCUST inetcust;
extern COOKIE   cookiejar[];
#define MAXCOOKIES 11

char buffer[200];
INETCUST   cust;		/* temporary custom struct */

int atoet(char *a,char *et)
{
  int etbuf[6];
  if(sscanf(a,"%2x:%2x:%2x:%2x:%2x:%2x",&etbuf[0],&etbuf[1],&etbuf[2],&etbuf[3],&etbuf[4],&etbuf[5]) == 6)
  {
    et[0] = (char)etbuf[0];
    et[1] = (char)etbuf[1];
    et[2] = (char)etbuf[2];
    et[3] = (char)etbuf[3];
    et[4] = (char)etbuf[4];
    et[5] = (char)etbuf[5];
    return(6);
  }	
  return(0);
}

long atoin(char *a)
{
unsigned  n1,n2,n3,n4;

  if(sscanf(a,"%u.%u.%u.%u",&n1,&n2,&n3,&n4) == 4)
    return(((unsigned long)n1<<24) + ((unsigned long)n2<<16) + ((unsigned long)n3<<8) +(unsigned long)n4);
  return(0L);
}


int loadinf(INETCUST *cust)
{
FILE *p_inf;
FILE *p_hosts;
char *p_tok;
char *p_arg;
int ntimeserv = 0;
int nnameserv = 0;

	p_inf=fopen("\\inetcust.inf","r");
	if(!p_inf) return(0);
	cust->magic = sizeof(INETCUST);
	while(fgets(buffer,(int)sizeof(buffer)-1,p_inf) != NULL)
	{
		p_tok = strtok(buffer,"= \n");
		if(!p_tok || !strlen(p_tok)) continue;
		p_arg = strtok(NULL," \n");
		
		if(!stricmp(p_tok,"HADDR"))
		{
			if(!atoet(p_arg,cust->haddr))
			{
				printf("invalid hardware address 'p_arg'\n");
				fclose(p_inf);
				return(0);
			}
		}
		else if(!stricmp(p_tok,"HOSTIP"))
		{
			cust->inaddr = atoin(p_arg);
			if(!cust->inaddr)
			{
				printf("invalid internet address 'p_arg'\n");
				fclose(p_inf);
				return(0);
			}
		}
		else if(!stricmp(p_tok,"SUBNETBITS"))
		{
			cust->subnetbits = atoi(p_arg);
		}
		else if(!stricmp(p_tok,"TCPWINDOW"))
		{
			cust->tcpwnd = atoi(p_arg);
			if(!cust->tcplowater)
				cust->tcplowater = cust->tcpwnd/2;
		}
		else if(!stricmp(p_tok,"TCPLOWATER"))
		{
			cust->tcplowater = atoi(p_arg);
		}
		else if(!stricmp(p_tok,"NETMEM"))
		{
			cust->netmem = atol(p_arg);
		}
		else if(!stricmp(p_tok,"USER"))
		{
			strncpy(cust->username,p_arg,MAXUSERNAME-1);
		}
		else if(!stricmp(p_tok,"HOSTS"))
		{
			if((p_hosts = fopen(p_arg,"r")) == NULL)
			{
				printf("cannot find '%s'\n",p_arg);
				fclose(p_inf);
				return(0);
			}
			fclose(p_hosts);
			strncpy(cust->hosts,p_arg,sizeof(cust->hosts)-1);
		}
		else if(!stricmp(p_tok,"PASSWD"))
		{
			strncpy(cust->passwd,p_arg,sizeof(cust->passwd)-1);
		}
		else if(!stricmp(p_tok,"TZOFFS"))
		{
			cust->gmtoffs = atoi(p_arg);
		}
		else if(!stricmp(p_tok,"TZ"))
		{
			strncpy(cust->tzname,p_arg,sizeof(cust->tzname-1));
		}
		else if(!stricmp(p_tok,"TIMESERVER"))
		{
			if(ntimeserv > 1)
			{
				printf("no room for additional timeserver\n");
				fclose(p_inf);
				return(0);
			}
			if(!ntimeserv) cust->timeserver[1] = 0L;
			cust->timeserver[ntimeserv] = atoin(p_arg);
		    ntimeserv++;
		}
		else if(!stricmp(p_tok,"NAMESERVER"))
		{
			if(nnameserv > 2)
			{
				printf("no room for additional nameserver\n");
				fclose(p_inf);
				return(0);
			}
			if(!nnameserv) 
			{
				cust->nameserver[1] = 0L;
				cust->nameserver[2] = 0L;
			}
			cust->nameserver[nnameserv] = atoin(p_arg);
		    nnameserv++;
		}
		else if(!stricmp(p_tok,"GATEWAY"))
		{
			cust->gateway = atoin(p_arg);
		}
		else if(!stricmp(p_tok,"HOSTNAME"))
		{
			strncpy(cust->hostname,p_arg,MAXHOSTNAME-1);
		}
		else if(!stricmp(p_tok,"DOMAIN"))
		{
			strncpy(cust->domainname,p_arg,MAXNAME-1);
		}
		else if(!stricmp(p_tok,"MAILHOST"))
		{
			strncpy(cust->mailhost,p_arg,MAXNAME-1);
		}
		else if(!stricmp(p_tok,"PRINTHOST"))
		{
			strncpy(cust->printhost,p_arg,MAXNAME-1);
		}
		else if(!stricmp(p_tok,"LOGINHOST"))
		{
			strncpy(cust->loginhost,p_arg,MAXNAME-1);
		}
		else if(!stricmp(p_tok,"PRINTER"))
		{
			strncpy(cust->printdev,p_arg,MAXHOSTNAME-1);
		}
		else if(!stricmp(p_tok,"FTPWIN"))
		{
			cust->ftpwin = atol(p_arg);
		}
		else
		{
			printf(" unknown keyword '%s'\n",p_tok);
		}
	}
	fclose(p_inf);
	return(1);
}


COOKIE *get_cookiejar(void)
{
  register long superstack;
  register COOKIE *jar;

  superstack = Super((void *)0);
  jar = (COOKIE *)_cookiejar;  /* return address of cookiejar */
  Super((void*)superstack);
  return(jar);
}


COOKIE *add_cookie(long id,long val)
{
  register COOKIE *jar;
  jar = get_cookiejar();
  while(jar->id != ENDCOOKIE) jar++;  /* search end of cookiejar */
  jar->id = id;
  (jar+1)->val = jar->val;  /* keep size of jar */
  jar->val = val;
  (jar+1)->id = ENDCOOKIE;
  return(jar);
}


COOKIE *get_cookie(long id)
{
  register COOKIE *jar;
  if((jar = get_cookiejar()) == NULL) return(NULL);
  while(jar->id)
  {
    if(jar->id == id) return(jar);  /* find cookie */
    jar++;
  }
  return(NULL);
}


long set_cookiejar(COOKIE *newjar)
{
long superstack;
register COOKIE *jar;
register long i,c;

  jar = get_cookiejar();
  i=0;
  if(jar) for(; jar[i].id != ENDCOOKIE; i++);  /* get size of old jar */
  if(jar && jar[i].val > i) return(-jar[i].val); /* we have room */
  if(jar && jar[i].val >= MAXCOOKIES) return(0); /* occupied jar bigger than my pool */
  
  if(jar && newjar) for(c=0; c<i; c++)
  {  /* copy old jar */
    newjar[c].id = jar[c].id;
    newjar[c].val = jar[c].val;
  }
  newjar[i].id = ENDCOOKIE;  /* terminate new jar */
  newjar[i].val = MAXCOOKIES;

  superstack = Super((void *)0);
  _cookiejar = (long)newjar;  /* install new jar */
  Super((void*)superstack);
  return(MAXCOOKIES);
}





long main()
{
COOKIE *jar;
COOKIE *cookie;
long len = (char *)cookiejar - &Start + sizeof(BASPAG);
long jlen;
char str[10];

	jar = get_cookiejar();
	if(jar)
	{
		cookie = get_cookie(INETCUSTCOOKIE);
		if(cookie) 
		{
			memcpy(&cust,(void *)(cookie->val),sizeof(INETCUST));
			if(!loadinf(&cust))
				Cconws("INETCUST: cannot load INETCUST.INF!\a\r\n");
			else
			{
				memcpy((void *)(cookie->val),&cust,sizeof(INETCUST));
				Cconws("INETCUST updated !\r\n");
			}
			Pterm(1);
		}
	}
	jlen = set_cookiejar(cookiejar);
	if(!jlen) 
	{
		Cconws("INETCUST: cannot add cookie!\r\n");
		Pterm(1);
	}
	if(jlen > 0) 
	{
		len += MAXCOOKIES*sizeof(COOKIE);
		Cconws("created new cookie jar\r\n");
	}
	memset(&inetcust,0,sizeof(INETCUST));
	if(!loadinf(&inetcust))
	{
		Cconws("INETCUST: cannot load INETCUST.INF!\a\r\n");
		Pterm(1);
	}
	
	add_cookie(INETCUSTCOOKIE,(long)&inetcust);
	
	Cconws("INETCUST network environment installed\r\nusing ");
	Cconws(ltoa(len,str,10));
	Cconws(" bytes\r\n");
	return(len);
}

