/************************************************************************/
/*                                                                      */
/*    HPspd.c                                                           */
/*                                                                      */
/*    Durch bloes ndern der Extension im Dateinamen, lt sich Pro-   */
/*    gramm als normale GEM-Anwendung oder aber als Accessory betrei-   */
/*    ben.                                                              */
/*    Das Programm lenkt Druckerausgaben auf den Netzwerkdrucker um.    */
/*                                                                      */
/*    Copyright (c)  FORTEC/pm 1993                                     */
/*                                                                      */
/************************************************************************/

/* -------------------------------------------------------------------- */
/*    Headerdateien einbinden.                                          */
/* -------------------------------------------------------------------- */

#include <aes.h>
#include <stdio.h>
#include <tos.h>
#include <vdi.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include "tcpdef.h"

#define noDEBUG

#define LINESIZE 70L
#define NUMLINES 8

#define WINW     500
#define WINH     200
#define ZH 6

#define TRUE 1
#define FALSE 0
#define mmin(a,b) (((a) < (b)) ? (a) : (b))

#define INBUFSIZE     1024
#define FILE_BUF_SIZE 4096
#define BUFS          4096L

#define SYSBASE ((SYSHDR*)0x4f2L)

static DESTI desti;
static TCPSTAT tstat;

char *myid = "@(#)ANS-HPSPD 1.0 pm93";

static BASPAG **oldpd;

static char *term;
static int tcp_buff = 2048;
static char data[INBUFSIZE];

static char file_buffer[FILE_BUF_SIZE];
static char filename[50];
static long number,timev;
static int tcp_ok;
static char *printer;
static char *printhost;
static char *hostname;
static char *user;
static long lendata;
static long lensent;
static int tcp;
static char response;
static long filelength;
static char * file_to_print;
static int fin;
static int
 ex, ey,
 kstate,
 key,
 clicks,
 event,
 state;
int pipe[8];
static int quit;

static char log_text[NUMLINES][LINESIZE+1];
char text[2*LINESIZE];
static int  line_tab[NUMLINES];
static int  actline = 0;

#define LPR_PORT    515

int flag = 0;
static long ix = 0;
static int fh = 0;
static int closeflag = 0;
static int escflag = 0;
static int printflag = 0;
static int or = 0;
static long ox = 0;
static char spfilename[] = "hpprnd00.pco";
static char path[128];
static char bf[BUFS];

/* -------------------------------------------------------------------- */
/*    Extern definierte globale Variablen.                              */
/* -------------------------------------------------------------------- */
extern int _app;
extern long oldgem;
extern long oldbios;
extern long grpgem;
extern long grpbios;

/* -------------------------------------------------------------------- */
/*    Globale Variablen.                                                */
/* -------------------------------------------------------------------- */
int get_response(void);
long set_pd(void);
long restore_pd(void);
void output1(int o_len, char *o_str);
void output(char *o_str);
void printfile(int fin);
void spoolfile(void);
int connect(char * host, int port);
void redraw_window( int all );
int handle_message(int *pipe);
void multi( void );
void event_loop( void );
void spool(void);

static int  whandle;  		/* Handle fr geffnetes Fenster.   */
static char title[] = "HP-Printer Dmon";  /* Titelzeile des Fensters.         */
static int  gl_wchar;		/* Gre und Breite eines Buchsta-  */
static int gl_hchar;		/* ben (wichtig falls mit unter-    */
static int gl_wbox;		/* schiedlichen Bildschirmaufl-    */
static int gl_hbox;  		/* sungen gearbeitet wird) bzw.     */
					/* einer Box.                       */
static int  phys_handle;	/* Handles fr GEM und VDI.         */
static int handle;
static int  max_x;			/* Maximale Gre der Arbeitsflche */
static int max_y;
int  appl_id;		/* Identifikationsnummer des Prog.  */
int menu_id;  			/* Id.-nummer im Men 'Desk'.       */

static int line_height = 8;
static int cell_width = 8;

static int dum;
static int x,y,w,h;
static int attrib[10];

int scroll_log(int actline)
{  /* rotate log lines */
  int i;
  int line;

  if(actline < NUMLINES-1) return(actline+1);
  line = line_tab[0];
  for(i=0; i<NUMLINES-1; i++)
  {
    line_tab[i] = line_tab[i+1];
  }
  line_tab[NUMLINES-1] = line;
  return(NUMLINES-1);
}

int log(char *str)
{
  int i;
  char *s;
  int len,inline;

  if(!str) return(0);
  len = (int)strlen(str);
  if(str[len-1] == '\r')
  {
    str[len-1] = 0;
    inline = 1;
    len--;
  }
  else inline = 0;
  
  log_text[line_tab[actline]][0] = 0;
  if(!len)
    actline = scroll_log(actline);
  s = log_text[line_tab[actline]];
  while(len)
  {
    for(i=0; i <= LINESIZE; i++)
    {
      *s++ = str[i];
      if(!str[i]) break;
      len--;
    }
    *s=0;
    if(!inline) actline = scroll_log(actline);
    if(!inline) s = log_text[line_tab[actline]];
  }
  *s = 0;
  redraw_window(1);
  return(1);
}

void open_window( void )
{
  if(whandle <= 0)
  {
    whandle = wind_create(NAME|CLOSER|MOVER, 0, 0, max_x + 1, max_y + 1 );
    if( whandle <= 0 )
      return;

    wind_set(whandle, WF_NAME, title);
    vst_font(handle, 1);  /* auswhlen       */
    vst_height(handle, ZH, &dum,&dum,&cell_width,&line_height);  /* set small font   */
    vqt_attributes( handle, attrib );
    vst_alignment(handle, 0, 4, &dum, &dum);
    wind_calc(WC_BORDER, NAME|CLOSER|MOVER , 80, 80, cell_width*LINESIZE, line_height*NUMLINES, &x, &y, &w, &h);
    wind_open(whandle, x,y,w,h+15);
  }
  else
    wind_set( whandle, WF_TOP );
}

/* -------------------------------------------------------------------- */
/*    min()                                                             */
/*                                                                      */
/*    Minimum zweier Zahlen berechnen.                                  */
/* -------------------------------------------------------------------- */

int min( int a, int b)
{
  if( a > b )
    return( b );
  else
    return( a );
}

/* -------------------------------------------------------------------- */
/*    max()                                                             */
/*                                                                      */
/*    Maximum zweier Zahlen bestimmen.                                  */
/* -------------------------------------------------------------------- */

int max( int a, int b)
{
  if( a < b )
    return( b );
  else
    return( a );
}

/* -------------------------------------------------------------------- */
/*    rc_intersect()                                                    */
/*                                                                      */
/*    Schnittflche zweier Rechtecke berechnen.                         */
/* -------------------------------------------------------------------- */

int rc_intersect(GRECT *r1, GRECT *r2)
{
  int xl, yu, xr, yd;  /* left, upper, right, down */

  xl      = max( r1->g_x, r2->g_x );
  yu      = max( r1->g_y, r2->g_y );
  xr      = min( r1->g_x + r1->g_w, r2->g_x + r2->g_w );
  yd      = min( r1->g_y + r1->g_h, r2->g_y + r2->g_h );

  r2->g_x = xl;
  r2->g_y = yu;
  r2->g_w = xr - xl;
  r2->g_h = yd - yu;

  return( r2->g_w > 0 && r2->g_h > 0 );
}

/* -------------------------------------------------------------------- */
/*    mouse_on()                                                        */
/*                                                                      */
/*    Mauszeiger anschalten.                                            */
/* -------------------------------------------------------------------- */

void mouse_on(void)

{
  graf_mouse( M_ON, (void *)0 );
}

/* -------------------------------------------------------------------- */
/*    mouse_off()                                                       */
/*                                                                      */
/*    Mauszeiger ausschalten.                                           */
/* -------------------------------------------------------------------- */

void mouse_off(void)
{
  graf_mouse( M_OFF, (void *)0 );
}
/* -------------------------------------------------------------------- */
/*    redraw_window()                                                   */
/*                                                                      */
/*    Fensterinhalt neu zeichnen, nachdem er zuvor aus irgendeinem      */
/*    Grunde zerstrt wurde, oder weil das Fenster neu geffnet wurde.  */
/* -------------------------------------------------------------------- */

void redraw_window( int all )
{
  GRECT   box,
  work;
  int     clip[4];
  int     line,dum;
  int 		height;

  if( whandle <= 0 )  /* Wenn kein Fenster auf ist,    */
    return;  /* braucht auch nicht gezeichnet */
  /* zu werden.                    */

  if(all)
  {

    mouse_off();

    vsf_color( handle, 0 );  /* set white fill   */
    vswr_mode( handle, 1 );  /* set replace mode */
    vst_height( handle, 6, &dum,&dum,&dum,&height);  /* set small font   */

    wind_get( whandle, WF_WORKXYWH, &work.g_x, &work.g_y, &work.g_w,
    &work.g_h );
    wind_get( whandle, WF_FIRSTXYWH, &box.g_x, &box.g_y, &box.g_w,
    &box.g_h );
    work.g_w = min( work.g_w, max_x - work.g_x + 1 );
    work.g_h = min( work.g_h, max_y - work.g_y + 1 );

    while ( box.g_w > 0 && box.g_h > 0 )
    {
      if( rc_intersect( &work, &box ) )
      {
        clip[0] = box.g_x;
        clip[1] = box.g_y;
        clip[2] = box.g_x + box.g_w - 1;
        clip[3] = box.g_y + box.g_h - 1;

        vs_clip( handle, 1, clip );
        if( all )
          vr_recfl( handle, clip );
        /* fill rectangle */
        for(line=0;line < NUMLINES; line++)
        {
          v_gtext( handle, work.g_x, work.g_y + 15 + (line*height),log_text[line_tab[line]]);
        }

      }
      wind_get( whandle, WF_NEXTXYWH, &box.g_x, &box.g_y, &box.g_w,
      &box.g_h );
    }
    mouse_on();
  }
}

/* -------------------------------------------------------------------- */
/*    handle_message()                                                  */
/*                                                                      */
/*    Auswertung der Ereignisse des Multi-Events bezglich des Message- */
/*    buffers.                                                          */
/* -------------------------------------------------------------------- */

int handle_message(int *pipe)
{
  switch ( pipe[0] )
  {
  case WM_REDRAW:
    redraw_window(1);
    break;

  case WM_TOPPED:
    wind_set( whandle, WF_TOP );
    break;

  case WM_CLOSED:
    if( pipe[3] == whandle )
    {
      wind_close( whandle );
      wind_delete( whandle );
      whandle = 0;
    }
    if( _app )
      return(1);
    break;

  case WM_MOVED:
  case WM_SIZED:
    if( pipe[3] == whandle )
      wind_set( whandle, WF_CURRXYWH,  pipe[4], pipe[5],
      pipe[6], pipe[7] );
    break;

  case AC_OPEN:
    if( pipe[4] == menu_id )
    {
        sprintf(text,"file %s (%ld wr) %d ov-%ld bf/cl %d",path,ox,or,ix,closeflag);
        log(text);
        open_window();
    }
    break;

  case AC_CLOSE:
    if( pipe[3] == menu_id )
      whandle = 0;
    break;
  }
  return(0);
}

/* -------------------------------------------------------------------- */
/*    event_loop()                                                      */
/*                                                                      */
/*    Die Multi-Event-Schleife.                                         */
/* -------------------------------------------------------------------- */

void event_loop( void )
{
  quit = 0;
  do
  {
    event = evnt_multi( MU_MESAG | MU_TIMER,
    2, 0x1, 1,
    0, 0, 0, 0, 0,
    0, 0, 0, 0, 0,
    pipe,
    100, 0,
    &ex, &ey, &state, &kstate, &key, &clicks );

    wind_update(BEG_UPDATE);

    if( event & MU_MESAG)
      quit = handle_message( pipe );
    wind_update(END_UPDATE);

    if( event & MU_TIMER)
    {
      spool();
      if(printflag)
      {
        open_window();
        log(text);
        sprintf(text,"file %s (%ld wr) %d ov-%ld bf/cl %d",path,ox,or,ix,closeflag);
        sprintf(text,"attempt to print file %s ...",path);
        log(text);
        file_to_print = path;
        spoolfile();
        if(tcp_ok)
        {
         sprintf(text,"File %s printed.",&path);
         log(text);
        }
        /*wind_close( whandle );
        wind_delete( whandle );
        whandle = 0;*/
        printflag = 0;
      }
    }
  }
  while (!quit);
}

void multi( void )
{
  do
  {
    event = evnt_multi( MU_MESAG | MU_TIMER,
    2, 0x1, 1,
    0, 0, 0, 0, 0,
    0, 0, 0, 0, 0,
    pipe,
    10, 0,
    &ex, &ey, &state, &kstate, &key, &clicks );

    wind_update(BEG_UPDATE);

    if( event & MU_MESAG) quit = handle_message( pipe );
    wind_update(END_UPDATE);
    if(quit)
    {
      tcp_close(tcp);
      break;
    }
    if( event & MU_TIMER) break;
  }
  while (1);
}

/* -------------------------------------------------------------------- */
/*    main()                                                            */
/*                                                                      */
/*    Kernstck des Programms.                                          */
/* -------------------------------------------------------------------- */

int main( void )
{
  int i;
  int work_in[11];
  int work_out[57];

  /* ----------------------------------------------------------------- */
  /* Initialization                                                    */
  /* ----------------------------------------------------------------- */

  appl_id = appl_init();
  if( appl_id != -1 )
  {
    for (i = 0; i < 10; i++)
      work_in[i]  = 1;
    work_in[10] = 2;
    phys_handle = graf_handle( &gl_wchar, &gl_hchar, &gl_wbox,
    &gl_hbox );
    whandle = 0;
    handle = phys_handle;
    v_opnvwk( work_in, &handle, work_out );
	for(i=0; i< NUMLINES; i++)		/* init log table */
	{
		line_tab[i] = i;
		log_text[i][0] = 0;
	}
	actline = 0;
    if( handle != 0 )
    {
      max_x = work_out[0];
      max_y = work_out[1];
      oldbios = (long)Setexc(45, (void (*)())&grpbios);
      oldgem = (long)Setexc(33, (void (*)())&grpgem);

      term = (char *)getenv("FSTEMP");
      if(!term)   strcpy(path,"C:\\tmp");
      else   strcpy(path,term);
      if(path[strlen(path)-1] != '\\') strcat(path,"\\");
if(_app)
{
      strcpy(path,"C:\\environ.dat");
      printflag = 1;
}
      printer = (char *)getenv("PRINTER");
      if(!printer)   printer = "lp";
      user = (char *)getenv("USER");
      if(!user)   user = "ST-HPspd";
      hostname = (char *)getenv("HOSTNAME");
      if(!hostname)   hostname = "SOME-ST";
      printhost = (char *)getenv("PRINTHOST");
      if(!printhost)  printhost = "fortec";

      if( !_app )
      {
        menu_id = menu_register( appl_id, "  HPSpoold" );
        /*open_window();*/
      }
      else
      {
        graf_mouse( 0, (void*)0 );
        open_window();
      }
      /* ----------------------------------------------------------------- */
      /* Event Loop                                                        */
      /* ----------------------------------------------------------------- */

      sprintf(text,"No file active...");
      log(text);
      event_loop();

      /* ----------------------------------------------------------------- */
      /* Deinitialization                                                  */
      /* ----------------------------------------------------------------- */

      oldgem = (long)Setexc(33, (void (*)())oldgem);
      oldbios = (long)Setexc(45, (void (*)())oldbios);
      v_clsvwk( handle );
    }
    appl_exit();
  }
  return(0);
}

/* -------------------------------------------------------------------- */
/*    End of SPOOLD.C                                                     */
/* -------------------------------------------------------------------- */

void spoolfile(void)
{
  tcp_ok = FALSE;
  sprintf(text,"Trying 4.3 bsd print server %s, device %s ...",printhost,printer);
  log(text);
  Supexec(set_pd);
  fin = Fopen(file_to_print, 0);
  Supexec(restore_pd);

  if(fin < 0) 
  {
    sprintf(text,"<Error: can't open file '%s'>", file_to_print);
    log(text);
    tcp_ok = FALSE;
  }
  else
  {
    timev = clock();
    number = (((timev >> 24) & 0xff) + ((timev >> 16) & 0xff))*15 +
        ((timev >> 10) );
    Supexec(set_pd);
    filelength = Fseek(0L, fin, SEEK_END);
    Fseek(0L, fin, SEEK_SET);
    Supexec(restore_pd);
    lensent = 0;    
    if((tcp = connect(printhost,LPR_PORT)) > 0)
    {
      tcp_ok = TRUE;
      printfile(fin); 
      tcp_close(tcp);
    }
    else
    {
      sprintf(text,"<Error: no response from %s>",printhost);
      log(text);
      tcp_ok = FALSE;
    }
    Supexec(set_pd);
    Fclose(fin);
    if(!_app) Fdelete(file_to_print);
    Supexec(restore_pd);
  }
}
/* open a connection and return tcp handle, 0 if error */

int connect(char * host, int port)
{
  int tcp_id, state;

  term = (char *)getenv("TCPWND");
  if(term) tcp_buff = atoi(term);

  desti.Port = port;
  if(GetIPAddr(host,desti.IPAddr))
  {
    unsigned int tmp1,tmp2,tmp3,tmp4;

    if(sscanf(host,"%d.%d.%d.%d",&tmp1,&tmp2,&tmp3,&tmp4) != 4)
    {
      sprintf(text,"<Error: unknown host.>");
      log(text);
      return 0;
    }
    desti.IPAddr[0] = tmp1;
    desti.IPAddr[1] = tmp2;
    desti.IPAddr[2] = tmp3;
    desti.IPAddr[3] = tmp4;
  }
  tcp_id = (unsigned)tcp_open(721+(int)(Random() % 10),&desti,AKTIV,60,(long)tcp_buff);

  if(tcp_id == 0)
  {
    sprintf(text,"<Error: could not open connection.>");
    log(text);
    return 0;
  }
  do
  {
    state = (int)tcp_stat(tcp_id,&tstat);
    if((state > ESTABLISHED) || (state <= CLOSED)) break;
    multi();
  }
  while(state < ESTABLISHED);

  if(state != ESTABLISHED)
  {
    sprintf(text,"<Error: connection refused.>");
    log(text);
    return 0;
  }
  return(tcp_id);
}

void printfile(int fin)
{
  /* connection is open, start the lprd protocol */
  sprintf(data, "\2%s\n",printer);
  output(data);
  if(get_response() > 1)
  {
    sprintf(text,"%s",data);
    log(text);
  }
  if(response == '\1') 
  {
    sprintf(text,"<Error: printer server didn't accept printer>");
    log(text);
    tcp_ok = FALSE;
    return;
  }
  else if(response != '\0') 
  {
    tcp_ok = FALSE;
    return;
  }
  sprintf(filename, "fA%03ld%s",(number++) % 999,hostname);
  /* get file length */
  sprintf(data, "\3%ld d%s\n", filelength, filename);
  output(data);
  if(get_response() > 1)
  {
    sprintf(text,"%s",data);
    log(text);
  }
  if(response == '\1') 
  {
    sprintf(text,"<Error: connection messed up, try again>");
    log(text);
    tcp_ok = FALSE;
    return;
  }
  else if(response == '\2') 
  {
    sprintf(text,"<Error: server out of storage space>");
    log(text);
    tcp_ok = FALSE;
    return;
  }
  else if(response != '\0') 
  {
    tcp_ok = FALSE;
    return;
  }

  do
  {
    Supexec(set_pd);
    lendata = Fread(fin,mmin((long)FILE_BUF_SIZE,filelength),file_buffer);
    Supexec(restore_pd);
#ifdef DEBUG
    printf("read %ld bytes\n",lendata);
#endif
    if(lendata <= 0)
    {
      file_buffer[0] = 0;
      output1(1,file_buffer);
    }
    if(lendata < 0)
    {
      return;
    }
    lensent += lendata;
    sprintf(text,"%ld %%\r",(lensent * 100) / filelength);
    log(text);
    output1((int)lendata,file_buffer);
    multi();
  }
  while(lendata > 0);      

  if(get_response() > 1)
  {
    sprintf(text,"%s",data);
    log(text);
  }
  if(response != '\0') 
  {
    sprintf(text,"<Error: data file not properly transferred, aborting>");
    log(text);
    tcp_ok = FALSE;
    return;
  }
#ifdef DEBUG
  printf("file closed\n");
#endif
  /* build the control file */
  sprintf(file_buffer, "H%s\n",hostname);
  sprintf(file_buffer+strlen(file_buffer), "P%s\n", user);
  sprintf(file_buffer+strlen(file_buffer), "J%s\n", file_to_print);
  sprintf(file_buffer+strlen(file_buffer), "C%s\n", hostname);
  sprintf(file_buffer+strlen(file_buffer), "L%s\n", user);
  sprintf(file_buffer+strlen(file_buffer), "fd%s\n", filename);
  sprintf(file_buffer+strlen(file_buffer), "Ud%s\n", filename);
  sprintf(file_buffer+strlen(file_buffer), "N%s\n", file_to_print);
  sprintf(data, "\2%ld c%s\n", strlen(file_buffer), filename);
  output(data);
  if(get_response() > 1)
  {
    sprintf(text,"%s",data);
    log(text);
  }
  if(response == '\1') 
  {
    sprintf(text,"<Error: connection messed up, try again>");
    log(text);
    tcp_ok = FALSE;
    return;
  }
  else if(response == '\2') 
  {
    sprintf(text,"<Error: server out of storage space>");
    log(text);
    tcp_ok = FALSE;
    return;
  }
  else if(response != '\0') 
  {
    tcp_ok = FALSE;
    return;
  }
  output1((int)strlen(file_buffer)+1,file_buffer);
  if(get_response() > 1)
  {
    sprintf(text,"%s",data);
    log(text);
  }
  if(response != '\0') 
  {
    sprintf(text,"<Error: control file not properly transferred, aborting>");
    log(text);
    tcp_ok = FALSE;
    return;
  }
}

void output(char *o_str)
{
  int o_len;

  o_len = (int)strlen(o_str);
  output1(o_len, o_str);
}

void output1(int o_len, char *o_str)
{
  int i,j;

  for(i=0; i < o_len;)
  {
    j = (int)tcp_write(tcp,o_str+i,o_len-i,PUSH,NO_URGENT);
    if(j>=0) i += j;
    else
    {
      sprintf(text,"connection broken");
      log(text);
      tcp_ok = FALSE;
      break;
    }
    multi();
#ifdef DEBUG
    printf("send %d bytes\n",j);
#endif
  }
}

int get_response(void)
{
  int length;

  do
  {
    multi();
    length = (int)tcp_read(tcp,data,INBUFSIZE);
  } 
  while(!length);
  if(length < 0) return length;
  response = data[0];
  return length;
}

long gemclose(void)
{
  flag = 1;
  if(fh) Fclose(fh);
  fh = 0;
  flag = 0;
  printflag = 1;
  return 0;
}

long gembuffer(long count,char *tbuf)
{
  flag = 1;

  if(fh <= 0)
  {
   spfilename[7]++;
   spfilename[7] &= 0x07;
   spfilename[7] |= '0';
   strcpy(strrchr(path,'\\')+1,spfilename);
   Supexec(set_pd);
   fh = Fcreate(path,0);
   Supexec(restore_pd);
   ox = 0;
  }
  Supexec(set_pd);
  if(Fwrite(fh,count,tbuf) < 0) fh = 0;
  Supexec(restore_pd);
  ox += count;
  flag = 0;
  return count;
}

int biosbuffer(int zeichen)
{
 if(ix < BUFS) bf[ix++] = zeichen & 0xff;
 else
 {
  ix = 0;
  or++;
 }
 
 if(escflag)
 {
  if(zeichen == 'E')
  {
   closeflag = ix;
  }
  escflag = 0;
 }
 if(zeichen == 0x1b) escflag = 1;
 spool();
 return -1;
}

void spool(void)
{
 flag = 1;
 if(ix >= BUFS/2 || closeflag)
 {
  if(fh <= 0)
  {
   spfilename[7]++;
   spfilename[7] &= 0x07;
   spfilename[7] |= '0';
   strcpy(strrchr(path,'\\')+1,spfilename);
   Supexec(set_pd);
   fh = Fcreate(path,0);
   Supexec(restore_pd);
   ox = 0;
   if(fh < 0)
   {
    flag = 0;
    return;
   }
  }
  
  if(closeflag && ((ix > 2) || ox))
  {
   Supexec(set_pd);
   Fwrite(fh,closeflag,bf);
   Fclose(fh);
   Supexec(restore_pd);
   ox += closeflag;
   fh = 0;
   or = 0;
   printflag = 1;
   memcpy(bf,&bf[closeflag],ix-closeflag);
   ix = ix-closeflag;
   closeflag = 0;
  }
  else
  {
   Supexec(set_pd);
   if(Fwrite(fh,ix,bf) < 0) fh = 0;
   Supexec(restore_pd);
   ox += ix;
   ix = 0;
   closeflag = 0;
  }
 }
 flag = 0;
} 


long set_pd(void)
{
  oldpd = SYSBASE->_run;
  SYSBASE->_run = &_BasPag;
  return 0;
}

long restore_pd(void)
{
  SYSBASE->_run = oldpd;
  return 0;
}
