/* queue definitions */

#ifndef _INET_QUEUE
#define _INET_QUEUE

#ifndef _INET_PKT
#include "pktdrv.h"
#endif

typedef struct
{
	int		q_get;
	int		q_put;
	int		q_nbuf;
	struct	q_table
	{
		int		q_occupied;
		PACKET	*q_pkt;
	}q_tab[1];
} PKTQUEUE;


typedef struct
{
	long	wr;
	long 	rd;
	long	size;
	unsigned char	*data;
	int		flags;
} TCP_QUEUE;

#define q_used(q) (((q)->rd <= (q)->wr) ? ((q)->wr - (q)->rd) : ((q)->size - (q)->rd + (q)->wr))
#define q_free(q) (((q)->rd <= (q)->wr) ? ((q)->size - (q)->wr + (q)->rd - 1) : ((q)->rd - (q)->wr - 1))
TCP_QUEUE *q_init(TCP_QUEUE *,char *,long);
int q_del(TCP_QUEUE *);
long q_get(TCP_QUEUE *,unsigned char *,long,long);
long q_put(TCP_QUEUE *,unsigned char *,long);
long q_rem(TCP_QUEUE *,long);
long q_look(TCP_QUEUE *,int);

PACKET *q_getpkt(PKTQUEUE *);			/* dequeue packet */
int q_putpkt(PKTQUEUE *,PACKET *);		/* enqueue packet */
PACKET *aq_getpkt(PKTQUEUE *);			/* dequeue packet atomic */
int aq_putpkt(PKTQUEUE *,PACKET *);		/* enqueue packet atomic */
PKTQUEUE *q_create(int,int);			/* create queue */
int	q_delete(PKTQUEUE *);				/* delete queue */

#endif