#include "cookie.h"
#include "pktdrv.h"
#include <tos.h>
#define noDEBUG
#define noVDEBUG

#ifdef DEBUG
#include <stdio.h>

#include "nettrace.h"
static char str[200];
#endif

HADDR	bcst_haddr = { -1,-1,-1,-1,-1,-1 };		/* broadcast address */
static int demux_cnt = 0;

static demux_handler demux_tab[MAXPROTOCOLS+1] = { NULL };

int (*n_reset)(void) = NULL;
int (*n_info)(int,char *) = NULL;
int (*n_open)(int,pkt_hndl) = NULL;
int (*n_release)(int) = NULL;
int (*n_send)(int,char *) = NULL;
int (*n_getadr)(int,char *) = NULL;
int (*n_pktfree)(char *) = NULL;
char *(*n_pktalloc)(u_short) = NULL;

int net_link(void)
{
COOKIE *cookie;
char **tmp;

		cookie = get_cookie(PKTCOOKIE);
		if(!cookie || !cookie->val) return(ENOTINST);
		tmp = (char **)(cookie->val);

		(char *)n_info = tmp[NETINFO];
		(char *)n_open = tmp[NETOPEN];
		(char *)n_release = tmp[NETRELEASE];
		(char *)n_send = tmp[NETSEND];
		(char *)n_getadr = tmp[NETGETADR];
		(char *)n_pktalloc = tmp[NETPKTALLOC];
		(char *)n_pktfree = tmp[NETPKTFREE];

		if(!n_info || !n_open || !n_release ||
			!n_send || !n_getadr || !n_pktalloc || !n_pktfree)
			return(ENOTINST);
		return(0);

}

int net_info(int len, char *buf)
{
/*	net_link(); */
	return(n_info(len,buf));
}

int net_open(int type, pkt_hndl handler)
{
/*	net_link(); */
	return(n_open(type,handler));
}

int net_release(int handle)
{
/*	net_link(); */
	return(n_release(handle));
}

int net_send(int len, char *buf)
{
/*	net_link(); */
	return(n_send(len,buf));
}

int	net_getadr(int len,HADDR buf)
{
/*	net_link(); */
	return(n_getadr(len,buf));
}

int net_reset(void)
{
/*	net_link(); */
	return(n_reset());
}

char *net_pktalloc(u_short prot)
{
/* 	net_link(); */
	return(n_pktalloc(prot));
}

int net_pktfree(char *pkt)
{
/*	net_link(); */
	return(n_pktfree(pkt));
}

int net_mux(int mod_handler_flag, demux_handler mux)
{
  ip_demux();
  return 0;
}
 
int net_demux(int mod_handler_flag, demux_handler mux)
{
register int i,loop;
register int ret = 0;

	if(!mux)
	{
#ifdef VDEBUG
sprintf(str,"> ###do demux cnt = %d\n",demux_cnt);
TRACE(str);
#endif
		if(!demux_cnt) return(FALSE);
        for(loop = 0;loop < 1; loop++)
		for(i=0; i<demux_cnt; i++)
		{
			if(demux_tab[i])
			{
			 ret = demux_tab[i]();
			}
			if(ret < 0) break;		/* network error */
		}
#ifdef DEBUG
TRACE("< ###demux \n");
#endif
		return(ret);
	}
	else
	{
	  if(mod_handler_flag)
	  {
#ifdef DEBUG
TRACE("> demux install\n");
#endif
		if(demux_cnt > MAXPROTOCOLS) return(FALSE);
		demux_tab[demux_cnt] = mux;
		demux_cnt++;
#ifdef DEBUG
TRACE("< demux \n");
#endif
		return(TRUE);
	  }
	  else
	  {
#ifdef DEBUG
TRACE("> demux remove\n");
#endif
		if(!demux_cnt) return(FALSE);
		for(i=0; i<demux_cnt && demux_tab[i]==mux ;i++); /* find entry */
		if(i==demux_cnt)
		{
#ifdef DEBUG
TRACE("< demux \n");
#endif
          return(FALSE);
        }
		for(;i<demux_cnt-1;i++)
			demux_tab[i] = demux_tab[i+1];	/* shift mux table */
		demux_cnt--;
#ifdef DEBUG
TRACE("< demux \n");
#endif
		return(TRUE);
	  }
	}
}

/*
 * Do a one's complement checksum
 */
u_short chksum(u_short *dp, u_short length, u_short csum)
{
  int len;
  u_long sum;

  len = length >> 1;
  sum = (u_long)csum;
  while ( len-- > 0 ) sum += *dp++;
  if ( length & 1 ) sum += (*dp & 0xFF00);
  sum = (sum & 0xFFFF) + ((sum >> 16) & 0xFFFF);
  sum = (sum & 0xFFFF) + ((sum >> 16) & 0xFFFF);

  return ( ~(u_short)(sum & 0xffffL));
}

