#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <tos.h>
#include "queue.h"
#include "mbuf.h"
#include "cookie.h"

#include "nettrace.h"

#define noDEBUG
#ifndef FALSE
#define FALSE 0
#define TRUE !FALSE
#endif
#ifdef DEBUG
static char str[100];
#endif
extern long q_disint(void);
extern long q_enabint(void);
extern long p_disint(void);
extern long p_enabint(void);

TCP_QUEUE *q_init(TCP_QUEUE *q,char *buf,long s)
{
	if(!q)
	{
		q = (TCP_QUEUE *)getmem(sizeof(TCP_QUEUE));
	}
	if(q)
	{
		q->wr = 0;
		q->rd = 0;
		q->size = s;
		if(!buf)
		{
			q->data = (unsigned char *)getmem(s);
			q->flags = TRUE;
		}
		else
		{
			q->data =(unsigned char *)buf;
			q->flags = FALSE;
		}
	}
	return(q);
}

long q_look(TCP_QUEUE *q,int c)
{
  register long i,ret;

  if(!q_used(q)) return(-1);

  q_disint();

  if(q->wr > q->rd)
  {
    for(i=q->rd; i<q->wr; i++)
      if(q->data[i] == c)
      {
       ret = (i-q->rd);
       q_enabint();
       return ret;
      }
  }
  else
  {
    for(i=q->rd; i<q->size; i++)
      if(q->data[i] == c)
      {
       ret = (i-q->rd);
       q_enabint();
       return ret;
      }
    for(i=0; i<q->wr; i++)
      if(q->data[i] == c)
      {
       ret = (i+q->size-q->rd);
       q_enabint();
       return ret;
      }
  }
  q_enabint();
  return(-1);
}

long q_get(TCP_QUEUE *q,unsigned char *p,long len, long offs)
{
  register long l;
  if(!len) return(0);

  q_disint();
  
  offs = (offs + q->rd) % q->size;		/* wrap around */
#ifdef DEBUG
sprintf(str," qget: at %lx offs %ld %ld bytes [%02x]\n",&q->data[offs],offs,len,*(char*)&q->data[offs]);
TRACE(str);
#endif
  if(offs < q->wr)
  {
    if((q->wr - offs) < len) len = q->wr - offs;
    if(len)
    {
      memcpy((char *)p,(char *)&q->data[offs],(size_t)len);
    }
  }
  else
  {
    l= q->size - offs;
    if((l + q->wr) < len) len = l + q->wr;
    if(len < l) l=len;
    if(l)		memcpy((char *)p,(char *)&q->data[offs],(size_t)l);
    if(len - l > 0)	memcpy((char *)p+l,(char *)q->data,(size_t)(len-l));
  }
  q_enabint();
  return(len);
}

long q_put(TCP_QUEUE *q,unsigned char *p,long len)
{
  register long l;
  q_disint();

  if(!len || ((q->wr+1) % q->size == q->rd) )
  {
    q_enabint();
    return(0);
  }
#ifdef DEBUG
sprintf(str," qput: at %lx %ld bytes [%02x]\n",&q->data[q->wr],len,*(char*)p);
TRACE(str);
#endif
  if(q->wr < q->rd-1)
  {
    if((q->rd - q->wr - 1) < len) len = q->rd - q->wr - 1;
    if(len)
    {
      memcpy((char *)&q->data[q->wr],(char *)p,(size_t)len);
      q->wr += len;
    }
  }
  else
  {
    l= q->size - q->wr;
    if((l + q->rd - 1) < len) len = l + q->rd - 1;
    if(len < l) l=len;
    if(l)		memcpy((char *)&q->data[q->wr],(char *)p,(size_t)l);
    if(len - l > 0)	memcpy((char *)q->data,(char *)p+l,(size_t)(len-l));
    q->wr += len;
    if(q->wr >= q->size) q->wr -= q->size;
  }
  q_enabint();
  return(len);
}

long q_rem(TCP_QUEUE *q,long len)
{
  register long l;

  if(!len) return(0);
  q_disint();

  if(q->rd < q->wr)
  {
    if((q->wr - q->rd) < len) len = q->wr - q->rd;
    q->rd += len;
  }
  else
  {
    l= q->size - q->rd;
    if((l + q->wr) < len) len = l + q->wr;
    q->rd += len;
    if(q->rd >= q->size) q->rd -= q->size;  /* wrap around */
  }
  q_enabint();
  return(len);
}

/* IP-packet-queue routines */

int ip_q_del(TCP_QUEUE *q)
{
	if(!q) return(TRUE);
    p_disint();
	if(q->data && q->flags)
	{
		freemem(q->data);
		q->data = NULL;
		q->size = 0;
		q->rd=0;
		q->wr=0;
		p_enabint();
		return(TRUE);
	}
	p_enabint();
	return(FALSE);
}

PKTQUEUE *ip_q_create(int nbuf,int bufsize)
{
PKTQUEUE *q;
int 	 i;

	q = (PKTQUEUE *)getmem(sizeof(PKTQUEUE)+(nbuf-1)*sizeof(struct q_table));
	if(!q) return(NULL);
	q->q_get = q->q_put = 0;
	q->q_nbuf = nbuf;
	for(i=0; i<nbuf; i++)
	{
		if(bufsize)
		{
			q->q_tab[i].q_occupied = TRUE;
			q->q_tab[i].q_pkt = (PACKET *)getmem((size_t)bufsize);
			if(!q->q_tab[i].q_pkt)
			{
				ip_q_delete(q);
				return(NULL);
			}
		}
		else
			q->q_tab[i].q_occupied = FALSE;
	}
	return(q);
}

int ip_q_delete(PKTQUEUE *q)
{
int		i;
	if(!q) return(FALSE);
	for(i=0; i< q->q_nbuf; i++)
	{
		if(q->q_tab[i].q_occupied && q->q_tab[i].q_pkt)
			free(q->q_tab[i].q_pkt); 
	}	
	free(q);
	return(TRUE);
}


PACKET *ip_aq_getpkt(PKTQUEUE *q)
{
PACKET *pkt;
	p_disint();
	pkt=ip_q_getpkt(q);
	p_enabint();
	return(pkt);
}


PACKET *ip_q_getpkt(PKTQUEUE *q)
{
register int i;

	if(!q) return(NULL);
	i = q->q_get;
	if(!q->q_tab[i].q_occupied) return(NULL);
	q->q_get++;
	if(q->q_get >= q->q_nbuf) q->q_get = 0;
	q->q_tab[i].q_occupied = FALSE;
	return(q->q_tab[i].q_pkt);
}

int ip_aq_putpkt(PKTQUEUE *q,PACKET *pkt)
{
int r;
	p_disint();
	r=ip_q_putpkt(q,pkt);
	p_enabint();
	return(r);
}


int ip_q_putpkt(PKTQUEUE *q,PACKET *pkt)
{
register int i;

	if(!q) return(FALSE);
	i = q->q_put;
	
#ifdef DEBUG
Bconout(2,'Q');
#endif

	if(q->q_tab[i].q_occupied)
	{
#ifdef DEBUG
printf("put_queue: occupied\n");
#endif
		return(FALSE);
	}
	q->q_put++;
	if(q->q_put >= q->q_nbuf) q->q_put = 0;
	q->q_tab[i].q_pkt = pkt;
	q->q_tab[i].q_occupied = TRUE;
	return(TRUE);
}
