/*
 *	Vdi attribute funcs library interface
 *
 *		vswr_mode	set writing mode
 *		vs_color	set color index to rgb
 *		vsl_type	set polyline type
 *		vsl_udsty	set user defined line style
 *		vsl_width	set polyline width
 *		vsl_color	set polyline color index
 *		vsl_ends	set polyline end styles
 *		vsm_type	set polymarker type
 *		vsm_height	set polymarker height (in y coord units)
 *		vsm_color	set polymarker color index
 *		vst_height	set text height (baseline to top of char cell)
 *		vst_point	set char cell point size
 *		vst_rotation	set char baseline rot
 *		vst_font	set text face
 *		vst_color	set text color
 *		vst_effects	set text atribs
 *		vst_alignment	set text alignment
 *		vsf_interior	set fill interior style
 *		vsf_fill	set fill style (alias vsf_style)
 *		vsf_color	set fill color
 *		vsf_perimeter	set fill perimeter visibility
 *		vsf_udpat	set user defied fill pattern
 *
 *		    ++jrb	bammi@cadence.com
 *		    modified: mj -- ntomczak@vm.ucs.ualberta.ca
 *
 * 92/03/10 mmn -- Markus_Nick@mz.maus.de
 *		changed return type of vst_height from void to int
 *		because vst_height returns the selected height
 *	
 * 950313 cg (d2cg@dtek.chalmers,se)
 *		modified for Pure C
 */
#include "common.h"

#ifdef __DEF_ALL__

#define L_vswr_mod
#define L_vs_color
#define L_vsl_type
#define L_vsl_udst
#define L_vsl_widt
#define L_vsl_colo
#define L_vsl_ends
#define L_vsm_type
#define L_vsm_heig
#define L_vsm_colo
#define L_vst_heig
#define L_vst_poin
#define L_vst_rota
#define L_vst_font
#define L_vst_colo
#define L_vst_effe
#define L_vst_alig
#define L_vsf_inte
#define L_vsf_fill 	/* synonymous to vsf_style */
#define L_vsf_colo
#define L_vsf_peri
#define L_vsf_udpa

#endif /* __DEF_ALL__ */


#ifdef L_vswr_mod

/* vswr_mode	set writing mode
 * returns writing mode
 */
int vswr_mode(int handle, int mode)
{
    _intin[0] = mode;
    __vdi__(VDI_CONTRL_ENCODE(32, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif /* L_vswr_mod */

#ifdef L_vs_color

/* vs_color	set color index to rgb
 * returns void
 */
void vs_color(int handle, int index, int rgb[])
{
    _intin[0] = index;
    _intin[1] = rgb[0];
    _intin[2] = rgb[1];
    _intin[3] = rgb[2];

    __vdi__(VDI_CONTRL_ENCODE(14, 0, 4, 0), handle);
}
#endif /* L_vs_color */

#ifdef L_vsl_type

/* vsl_type	set polyline type
 * returns type selected
 */
int vsl_type(int handle, int style)
{
    _intin[0] = style;
    __vdi__(VDI_CONTRL_ENCODE(15, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif /* L_vsl_type */

#ifdef L_vsl_udst

/* vsl_udsty	set user defined line style
 * returns void
 */
void vsl_udsty(int handle, int pat)
{
    _intin[0] = pat;
    __vdi__(VDI_CONTRL_ENCODE(113, 0, 1, 0), handle);
}
#endif /* L_vsl_udst */

#ifdef L_vsl_widt

/* vsl_width	set polyline width
 * returns selected width in x-axis units
 */
int vsl_width(int handle, int width)
{
    _ptsin[0] = width;
    _ptsin[1] = 0;
    __vdi__(VDI_CONTRL_ENCODE(16, 1, 0, 0), handle);
    return (int)_ptsout[0];
}
#endif /* L_vsl_widt */

#ifdef L_vsl_colo

/* vsl_color	set polyline color index
 * returns setting
 */
int vsl_color(int handle, int index)
{
    _intin[0] = index;
    __vdi__(VDI_CONTRL_ENCODE(17, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif /* L_vsl_colo */

#ifdef L_vsl_ends

/* vsl_ends	set polyline end styles
 * returns void
 */
void vsl_ends(int handle, int begstyle, int endstyle)
{
    _intin[0] = begstyle;
    _intin[1] = endstyle;
    __vdi__(VDI_CONTRL_ENCODE(108, 0, 2, 0), handle);
}
#endif /* L_vsl_ends */

#ifdef L_vsm_type

/* vsm_type	set polymarker type
 * returns type selected
 */
int vsm_type(int handle, int symbol)
{
    _intin[0] = symbol;
    __vdi__(VDI_CONTRL_ENCODE(18, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif /* L_vsm_type */

#ifdef L_vsm_heig

/* vsm_height	set polymarker height (in y coord units)
 * returns void (height in _ptsout [0][1])
 */
void vsm_height(int handle, int height)
{
    _ptsin[0] = 0;
    _ptsin[1] = height;
    __vdi__(VDI_CONTRL_ENCODE(19, 1, 0, 0), handle);
}
#endif /* L_vsm_heig */

#ifdef L_vsm_colo

/* vsm_color	set polymarker color index
 * returns selected color
 */
int vsm_color(int handle, int index)
{
    _intin[0] = index;
    __vdi__(VDI_CONTRL_ENCODE(20, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif /* L_vsm_colo */

#ifdef L_vst_heig

/* vst_height	set text height (baseline to top of char cell)
 * returns void (char info args)
 */
int vst_height(int handle, int height,
		int *charw, int *charh, int *cellw, int *cellh)
{
    _ptsin[0] = 0;
    _ptsin[1] = height;
    __vdi__(VDI_CONTRL_ENCODE(12, 1, 0, 0), handle);
    
    *charw = _ptsout[0];
    *charh = _ptsout[1];
    *cellw = _ptsout[2];
    *cellh = _ptsout[3];

    return (int)_intout[0];		/* mmn */
}    
#endif /* L_vst_heig */

#ifdef L_vst_poin

/* vst_point	set char cell point size
 * returns selected cell height in points (and info in args)
 */
int vst_point(int handle, int point,
		int *charw, int *charh, int *cellw, int *cellh)
{
    _intin[0] = point;
    __vdi__(VDI_CONTRL_ENCODE(107, 0, 1, 0), handle);
    
    *charw = _ptsout[0];
    *charh = _ptsout[1];
    *cellw = _ptsout[2];
    *cellh = _ptsout[3];

    return (int)_intout[0];
}    
#endif /* L_vst_poin */

#ifdef L_vst_rota

/* vst_rotation	set char baseline rot
 * returns angle selected
 */
int vst_rotation(int handle, int ang)
{
    _intin[0] = ang;
    __vdi__(VDI_CONTRL_ENCODE(13, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif /* L_vst_rota */

#ifdef L_vst_font

/* vst_font	set text face
 * returns face selected
 */
int vst_font(int handle, int font)
{
    _intin[0] = font;
    __vdi__(VDI_CONTRL_ENCODE(21, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif /* L_vst_font */

#ifdef L_vst_colo

/* vst_color	set text color
 * returns selected color
 */
int vst_color(int handle, int index)
{
    _intin[0] = index;
    __vdi__(VDI_CONTRL_ENCODE(22, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif /* L_vst_colo */

#ifdef L_vst_effe

/* vst_effects	set text atribs
 * returns style actually selected
 */
int vst_effects(int handle, int effects)
{
    _intin[0] = effects;
    __vdi__(VDI_CONTRL_ENCODE(106, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif /* L_vst_effe */


#ifdef L_vst_alig

/* vst_alignment	set text alignment
 * returns void (results in args)
 */
void vst_alignment(int handle, int hin, int vin,
		   int *hout, int *vout)
{
    _intin[0] = hin;
    _intin[1] = vin;
    __vdi__(VDI_CONTRL_ENCODE(39, 0, 2, 0), handle);
    
    *hout = _intout[0];
    *vout = _intout[1];
}
#endif /* L_vst_alig */

#ifdef L_vsf_inte

/* vsf_interior	set fill interior style
 * returns style selected
 */
int vsf_interior(int handle, int style)
{
    _intin[0] = style;
    __vdi__(VDI_CONTRL_ENCODE(23, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif /* L_vsf_inte */

#ifdef L_vsf_fill

/* vsf_fill	set fill style
 * returns style selected
 */

#ifndef	PURE_C
__asm__(".stabs \"_vsf_style\",5,0,0,_vsf_fill"); /* dept of clean tricks */
#else	PURE_C
int vsf_style(int handle, int style)
{
    _intin[0] = style;
    __vdi__(VDI_CONTRL_ENCODE(24, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif

int vsf_fill(int handle, int style)
{
    _intin[0] = style;
    __vdi__(VDI_CONTRL_ENCODE(24, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif /* L_vsf_fill */

#ifdef L_vsf_colo

/* vsf_color	set fill color
 * returns color index selected
 */
int vsf_color(int handle, int index)
{
    _intin[0] = index;
    __vdi__(VDI_CONTRL_ENCODE(25, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif /* L_vsf_colo */

#ifdef L_vsf_peri

/* vsf_perimeter	set fill perimeter visibility
 * returns visibility
 */
int vsf_perimeter(int handle, int vis)
{
    _intin[0] = vis;
    __vdi__(VDI_CONTRL_ENCODE(104, 0, 1, 0), handle);
    return (int)_intout[0];
}
#endif /* L_vsf_peri */

#ifdef L_vsf_udpa

/* vsf_udpat	set user defined fill pattern
 * returns void
 */
void vsf_udpat(int handle, int pat[], int planes)
{
#ifndef __MSHORT__

    register int i, j;
    
    j = planes << 4;
    for(i = 0; i < j; i++)
	_intin[i] = pat[i];
    __vdi__(VDI_CONTRL_ENCODE(112, 0, j, 0), handle);
#else
    _vdiparams[1] = &pat[0];
    __vdi__(VDI_CONTRL_ENCODE(112, 0, (planes << 4), 0), handle);
    _vdiparams[1] = (void *)&_intin[0];
#endif
}
#endif /* L_vsf_udpa */

/* -eof- */
