/*
 *	Vdi contrl functions library interface (part 1)
 *
 *	v_opnwk		open workstation
 *	v_clswk		close workstation
 *	v_opnvwk	open virtual
 *	v_clsvwk	close virtual
 *
 *		++jrb	bammi@cadence.com
 *		modified: mj -- ntomczak@vm.ucs.ualberta.ca
 */
#include "common.h"

#ifdef __DEF_ALL__

#define L_v_opnwk
#define L_v_clswk
#define L_v_opnvwk
#define L_v_clsvwk

#endif /* __DEF_ALL__ */


#ifdef L_v_opnwk

/* open workstation	-- kinda redundant
 *	returns	void
 */
void v_opnwk(int work_in[], int *handle, int work_out[])
{
#ifndef __MSHORT__
    short *iptr;
    int   *wptr, *end;

    iptr = _intin;
    end = &work_in[11];
    do {
	*iptr++ = *work_in++;
    } while (work_in < end);

    __vdi__(VDI_CONTRL_ENCODE(1, 0, 11, 0), 0);

    wptr = work_out;
    end = wptr + 45;
    iptr = _intout;
    do {
	*wptr++ = *iptr++;
    } while (wptr < end);
    end += 12;
    iptr = _ptsout;
    do {
	*wptr++ = *iptr++;
    } while (wptr < end);
#else
    _vdiparams[1] = &work_in[0];
    _vdiparams[3] = &work_out[0];
    _vdiparams[4] = &work_out[45];
    __vdi__(VDI_CONTRL_ENCODE(1, 0, 11, 0), 0);
    _vdiparams[1] = (void *)&_intin[0];
    _vdiparams[3] = (void *)&_intout[0];
    _vdiparams[4] = (void *)&_ptsout[0];
#endif
    *handle = _contrl[6];
    
}
#endif /* L_v_opnwk */

#ifdef L_v_clswk

/* close workstation
 *	returns void
 */
void v_clswk(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(2, 0, 0, 0), handle);
}
#endif /* L_v_clswk */

#ifdef L_v_opnvwk

/* open virtual workstation
 *	returns void
 */
void v_opnvwk(int work_in[], int *handle, int work_out[])
{
#ifndef __MSHORT__
    short *iptr;
    int   *wptr, *end;

    iptr = _intin;
    end = &work_in[11];
    do {
	*iptr++ = *work_in++;
    } while (work_in < end);

    __vdi__(VDI_CONTRL_ENCODE(100, 0, 11, 0), *handle);

    wptr = work_out;
    end = wptr + 45;
    iptr = _intout;
    do {
	*wptr++ = *iptr++;
    } while (wptr < end);
    end += 12;
    iptr = _ptsout;
    do {
	*wptr++ = *iptr++;
    } while (wptr < end);
#else
    _vdiparams[1] = &work_in[0];
    _vdiparams[3] = &work_out[0];
    _vdiparams[4] = &work_out[45];
    __vdi__(VDI_CONTRL_ENCODE(100, 0, 11, 0), *handle);
    _vdiparams[1] = (void *)&_intin[0];
    _vdiparams[3] = (void *)&_intout[0];
    _vdiparams[4] = (void *)&_ptsout[0];
#endif
    *handle = _contrl[6];
}
#endif /* L_v_opnvwk */

#ifdef L_v_clsvwk

/* close virtual workstation
 *	returns void
 */
void v_clsvwk(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(101, 0, 0, 0), handle);
}
#endif /* L_v_clsvwk */

/* -eof- */
