/*
 *	Vdi inquiry funcs library interface
 *
 *		vq_extnd	extended inquire
 *		vq_color	inquire color rep.
 *		vql_attribute	inquire polyline attribute
 *		vqm_attributes	inquire polymarker atribs
 *		vqf_attributes	inquire fill area atribs
 *		vqt_attributes	inquire text atribs
 *		vqt_extent	inquire text extent
 *		vqt_width	inquire char cell width
 *		vqt_name	inquire face name
 *		vq_cellarray	inquire cell array
 *		vqin_mode	inquire input mode
 *		vqt_fontinfo	get font info
 *
 *		    ++jrb	bammi@cadence.com
 *		    modified: mj -- ntomczak@vm.ucs.ualberta.ca
 *
 */
/*
 *	Note that at this moment (Sept. 91) Atari modified vqt_name()
 *	interface and a string returned from it has a length 33 with
 *	the 33rd byte serving as a flag.  This should not matter if
 *	your program was allocating this extra byte anyway for a
 *	terminating null, but it may kill you if this space was tight!
 *	THIS IS NOT OFFICIAL yet and it may change!!!
 *
 *******
 *
 *      This is official now (jan 93 SpeedoGDOS docs from atari).
 *      To quote the doc "A new parameter has been added to this function.
 *      It is a flag that indicates whether or not the font in question is
 *      an outline font or bitmap font.  The flag will be contained in
 *      intin[33]; 0 will signify a bitmap font, and 1 will indicate an 
 *      outline font."
 */

#include "common.h"

#ifdef __DEF_ALL__

#define L_vq_extnd
#define L_vq_color
#define L_vql_attr
#define L_vqm_attr
#define L_vqf_attr
#define L_vqt_attr
#define L_vqt_exte
#define L_vqt_widt
#define L_vqt_name
#define L_vq_cella
#define L_vqin_mod
#define L_vqt_font

#endif /* __DEF_ALL__ */


#ifdef L_vq_extnd

/* vq_extnd	extended inquire
 * returns void (results in args)
 */
void vq_extnd(int handle, int flag, int work_out[])
{
#ifndef __MSHORT__
    short *iptr;
    int   *wptr, *end;
    
    _intin[0] = flag;
    
    __vdi__(VDI_CONTRL_ENCODE(102, 0, 1, 0), handle);
    
    wptr = work_out;
    end = wptr + 45;
    iptr = _intout;
    do {
	*wptr++ = *iptr++;
    } while (wptr < end);
    end += 12;
    iptr = _ptsout;
    do {
	*wptr++ = *iptr++;
    } while (wptr < end);
#else
    _intin[0] = flag;
    
    _vdiparams[3] = &work_out[0];
    _vdiparams[4] = &work_out[45];
    __vdi__(VDI_CONTRL_ENCODE(102, 0, 1, 0), handle);
    _vdiparams[3] = &_intout[0];
    _vdiparams[4] = &_ptsout[0];
    
#endif	/* __MSHORT__ */
}
#endif /* L_vq_extnd */

#ifdef L_vq_color

/* vq_color	inquire color rep.
 * returns index or -1 if index out of range
 */
int vq_color(int handle, int index, int flag, int rgb[])
{
    short *wptr;
    
    _intin[0] = index;
    _intin[1] = flag;
    
    __vdi__(VDI_CONTRL_ENCODE(26, 0, 2, 0), handle);
    
    wptr = &_intout[1];
    *rgb++ = *wptr++;
    *rgb++ = *wptr++;
    *rgb   = *wptr;

    return (int)_intout[0];
}
#endif /* L_vq_color */


#ifdef L_vql_attr

/* vql_attribute	inquire polyline attribute
 * returns void (results in arg)
 */
void vql_attribute(int handle, int atrib[])
{
    short *wptr;
    
    __vdi__(VDI_CONTRL_ENCODE(35, 0, 0, 0), handle);
    
    wptr = &_intout[0];
    *atrib++ = *wptr++;
    *atrib++ = *wptr++;
    *atrib++ = *wptr;
    *atrib = _ptsout[0];
}
#endif /* L_vql_attr */

#ifdef L_vqm_attr

/* vqm_attributes	inquire polymarker atribs
 * returns void (result in arg)
 */
void vqm_attributes(int handle, int atrib[])
{
    short *wptr;
    
    __vdi__(VDI_CONTRL_ENCODE(36, 0, 0, 0), handle);
    
    wptr = &_intout[0];
    *atrib++ = *wptr++;
    *atrib++ = *wptr++;
    *atrib++ = *wptr;
    *atrib = _ptsout[1];
}
#endif /* L_vqm_attr */

#ifdef L_vqf_attr

/* vqf_attributes	inquire fill area atribs
 * returns void (result in arg)
 */
void vqf_attributes(int handle, int atrib[])
{
    short *wptr;
    
    __vdi__(VDI_CONTRL_ENCODE(37, 0, 0, 0), handle);
    
    wptr = &_intout[0];
    *atrib++ = *wptr++;
    *atrib++ = *wptr++;
    *atrib++ = *wptr++;
    *atrib++ = *wptr;
}
#endif /* L_vqf_attr */

#ifdef L_vqt_attr

/* vqt_attributes	inquire text atribs
 * reurns void (results in arg)
 */
void vqt_attributes(int handle, int atrib[])
{
#ifndef __MSHORT__
    short *wptr;
    int   *end;
    
    __vdi__(VDI_CONTRL_ENCODE(38, 0, 0, 0), handle);
    
    wptr = &_intout[0];
    end  = &atrib[6];
    do {
	*atrib++ = *wptr++;
    } while (atrib < end);
    wptr = &_ptsout[0];
    end += 4;
    do {
	*atrib++ = *wptr++;
    } while (atrib < end);
#else
    _vdiparams[3] = &atrib[0];
    _vdiparams[4] = &atrib[6];
    __vdi__(VDI_CONTRL_ENCODE(38, 0, 0, 0), handle);
    _vdiparams[3] = &_intout[0];
    _vdiparams[4] = &_ptsout[0];
#endif /* __MSHORT__ */
}
#endif /* L_vqt_attr */

#ifdef L_vqt_exte

/* vqt_extent	inquire text extent
 * returns void (result in arg)
 */
void vqt_extent(int handle, char *str, int extent[])
{
    unsigned char ch;
    short *ptr;
    int   *ept, *end;
    
    ptr = _intin;
    while ((ch = *str++))
	*ptr++ = ch;
    
    __vdi__(VDI_CONTRL_ENCODE(116, 0, (int)(ptr - _intin), 0), handle);
    
    ptr = _ptsout;
    ept = extent;
    end = ept + 8;
    do {
	*ept++ = *ptr++;
    } while (ept < end);
}
#endif /* L_vqt_exte */

#ifdef L_vqt_widt

/* vqt_width	inquire char cell width
 * returns status (and results in args)
 */
int vqt_width(int handle, int chr,
	      int *cw, int *ldelta, int *rdelta)
{
    _intin[0] = chr;
    
    __vdi__(VDI_CONTRL_ENCODE(117, 0, 1, 0), handle);
    
    *cw = _ptsout[0];
    *ldelta = _ptsout[2];
    *rdelta = _ptsout[4];
    
    return (int)_intout[0];
}
#endif /* L_vqt_widt */

#ifdef L_vqt_name

/* vqt_name	inquire face name
 * returns index (name in arg)
 */
int vqt_name(int handle, int element, char *name)
{
    short *wptr, *end;
    
    _intin[0] = element;
    
    __vdi__(VDI_CONTRL_ENCODE(130, 0, 1, 0), handle);
    
    wptr = &_intout[1];
    end  = wptr + 33;		/* 32 string elements + flag */
    do {
	*name++ = *wptr++;
    } while (wptr < end);
    return (int)_intout[0];
}
#endif /* L_vqt_name */

#ifdef L_vq_cella

/* vq_cellarray		inquire cell array
 * returns void (results in args)
 */
void vq_cellarray(int handle, int pxyarray[], int row_len, int nrows,
		  int *el_used, int *rows_used, int *status, int color[])
{
    short *end, *wptr = _ptsin;
    
    end = wptr + 4;
    do {
	*wptr++ = *pxyarray++;
    } while (wptr < end);
    _contrl[7] = row_len;
    _contrl[8] = nrows;
    
    __vdi__(VDI_CONTRL_ENCODE(27, 2, 0, 0), handle);
    
    wptr = _intout;
    end = wptr + (short) nrows * (short) row_len;
    while (wptr < end)
	*color++ = *wptr++;
    *el_used = _contrl[9];
    *rows_used = _contrl[10];
    *status    = _contrl[11];
}
#endif /* L_vq_cella */

#ifdef L_vqin_mod

/* vqin_mode	inquire input mode
 * returns void (desult in arg)
 */
void vqin_mode(int handle, int dev, int *mode)
{
    _intin[0] = dev;
    
    __vdi__(VDI_CONTRL_ENCODE(115, 0, 1, 0), handle);
    
    *mode = _intout[0];
}
#endif /* L_vqin_mod */

/* vqt_fontinfo (alias vqt_font_info)	get font info
 * returns void (results in args)
 */

#ifdef L_vqt_font

#ifndef	PURE_C
__asm__(".stabs \"_vqt_font_info\",5,0,0,_vqt_fontinfo");
					/* dept of clean tricks */
#else	PURE_C
void vqt_font_info(int handle, int *minade, int *maxade, int distances[],
		  int *maxwidth, int effects[])
{
    short *wptr, *end;
    
    __vdi__(VDI_CONTRL_ENCODE(131, 0, 0, 0), handle);
    
    *minade = _intout[0];
    *maxade = _intout[1];
    
    wptr = _ptsout;
    *maxwidth = *wptr++;
    end = wptr + 6;
    do {
	*distances++ = *wptr++;
	*effects++   = *wptr++;
    } while (wptr < end);
    *distances++ = *wptr;
    *distances   = wptr[2];
}
#endif

void vqt_fontinfo(int handle, int *minade, int *maxade, int distances[],
		  int *maxwidth, int effects[])
{
    short *wptr, *end;
    
    __vdi__(VDI_CONTRL_ENCODE(131, 0, 0, 0), handle);
    
    *minade = _intout[0];
    *maxade = _intout[1];
    
    wptr = _ptsout;
    *maxwidth = *wptr++;
    end = wptr + 6;
    do {
	*distances++ = *wptr++;
	*effects++   = *wptr++;
    } while (wptr < end);
    *distances++ = *wptr;
    *distances   = wptr[2];
}
#endif /* L_vqt_font */

/* -eof- */
