/*
 *	Vdi output functions library interface
 *
 * 		v_pline		polyline
 * 		v_pmarker	draw markers
 * 		v_gtext		draw text
 * 		v_fillarea	filled area
 * 		v_cellarray	draw array of rectangles
 * 		v_contourfill 	flood fill
 * 		vr_recfl	fill rect
 *
 *		    ++jrb	bammi@cadence.com
 *		    modified: mj -- ntomczak@vm.ucs.ualberta.ca
 */
#include "common.h"


#ifdef __DEF_ALL__

#define L_v_pline
#define L_v_pmarke
#define L_v_gtext
#define L_v_fillar
#define L_v_cellar
#define L_v_contou
#define L_vr_recfl

#endif /* __DEF_ALL__ */


#ifdef L_v_pline

/* v_pline	polyline
 *	returns void
 */
void v_pline(int handle, int count, int pxyarray[])
{
#ifdef __MSHORT__       /* we have 16 bit ints, just change vdi params */
    _vdiparams[2] = (void *) &pxyarray[0];
#else                   /* 32 bit ints - let's copy */
    register short i;
    register short *pts = &_ptsin[0];
    register int   *pxy = &pxyarray[0];

    for(i = count; i != 0; i-- )
    {
        *pts++ = *pxy++;
        *pts++ = *pxy++;
    }
#endif

    __vdi__(VDI_CONTRL_ENCODE(6, count, 0, 0), handle);

#ifdef __MSHORT__
    _vdiparams[2] = (void *)&_ptsin[0]; /* restore vdi parameters */
#endif
}
#endif /* L_v_pline */


#ifdef L_v_pmarke

/* v_pmarker	draw markers
 * 	returns void
 */
void v_pmarker(int handle, int count, int pxyarray[])
{
#ifdef __MSHORT__       /* we have 16 bit ints, just change vdi params */
    _vdiparams[2] = (void *) &pxyarray[0];
#else                   /* 32 bit ints - let's copy */
    register short i;
    register short *pts = &_ptsin[0];
    register int   *pxy = &pxyarray[0];

    for(i = count; i != 0; i-- )
    {
        *pts++ = *pxy++;
        *pts++ = *pxy++;
    }
#endif

    __vdi__(VDI_CONTRL_ENCODE(7, count, 0, 0), handle);

#ifdef __MSHORT__
    _vdiparams[2] = (void *)&_ptsin[0]; /* restore vdi parameters */
#endif
}
#endif /* L_v_pmarke */


#ifdef L_v_gtext
	
/* v_gtext	draw text	(extra super slow -- don't ask me why)
 * returns void
 */
void v_gtext(int handle, int x, int y, char *str) {
    unsigned char   ch;
    short *ptr = _intin;
    
    _ptsin[0] = x;
    _ptsin[1] = y;
    while ((ch  = (unsigned char) *str++))
	*ptr++ = ch;
    
    __vdi__(VDI_CONTRL_ENCODE(8, 1, (int)(ptr - _intin), 0), handle);
}
#endif /* L_v_gtext */


#ifdef L_v_fillar

/* v_fillarea	filled area
 *	returns void
 */
void v_fillarea(int handle, int count, int pxyarray[])
{
#ifdef __MSHORT__       /* we have 16 bit ints, just change vdi params */
    _vdiparams[2] = (void *) &pxyarray[0];
#else                   /* 32 bit ints - let's copy */
    register short i;
    register short *pts = &_ptsin[0];
    register int   *pxy = &pxyarray[0];

    for(i = count; i != 0; i-- )
    {
        *pts++ = *pxy++;
        *pts++ = *pxy++;
    }
#endif

    __vdi__(VDI_CONTRL_ENCODE(9, count, 0, 0), handle);

#ifdef __MSHORT__
    _vdiparams[2] = (void *)&_ptsin[0]; /* restore vdi parameters */
#endif
}
#endif /* L_v_fillar */


#ifdef L_v_cellar

/* v_cellarray	draw array of rectangles
 * returns void
 */
void v_cellarray(int handle, int pxyarray[], int row_length,
		 int elements, int nrows, int write_mode, int colarray[])
{
    short *wptr, *end;
    
    wptr = _ptsin;
    end  = wptr + 4;
    do {
	*wptr++ = *pxyarray++;
    } while (wptr < end);
    wptr = (short *)&_contrl[7];
    *wptr++ = row_length;
    *wptr++ = elements;
    *wptr++ = nrows;
    *wptr   = write_mode;
    
    wptr = _intin;
    end = wptr + (short)nrows * (short)elements;
    while (wptr < end)
	*wptr++ = *colarray++;
    
    __vdi__(VDI_CONTRL_ENCODE(10, 2, (int)(wptr - _intin), 0), handle);
}
#endif /* L_v_cellar */


#ifdef L_v_contou

/* v_contourfill flood fill from seed point to either dsp.edge or colr index
 * returns void
 */
void v_contourfill(int handle, int x, int y, int index)
{
    _ptsin[0] = x;
    _ptsin[1] = y;
    _intin[0] = index;
    __vdi__(VDI_CONTRL_ENCODE(103, 1, 1, 0), handle);
}
#endif /* L_v_contou */


#ifdef L_vr_recfl

/* vr_recfl	fill rect
 * returns void
 */
void vr_recfl(int handle, int pxyarray[])
{
#ifdef __MSHORT__       /* we have 16 bit ints, just change vdi params */
    _vdiparams[2] = (void *) &pxyarray[0];
#else                   /* 32 bit ints - let's copy */
    short *wptr = _ptsin;
    
    *wptr++ = *pxyarray++;
    *wptr++ = *pxyarray++;
    *wptr++ = *pxyarray++;
    *wptr =   *pxyarray;
#endif

    __vdi__(VDI_CONTRL_ENCODE(114, 2, 0, 0), handle);

#ifdef __MSHORT__
    _vdiparams[2] = (void *)&_ptsin[0]; /* restore vdi parameters */
#endif
}
#endif /* L_vr_recfl */

/* -eof- */
