/*
 *	vqgdos - enquire if GDOS is loaded or not
 *		 (The source I got it from says, that this is the
 *		  Atari official method)
 *
 *			++fgth	ridderbusch.pad@nixdorf.com
 */


#ifdef __DEF_ALL__

#define L_vq_gdos
#define L_vq_vgdos

#endif /* __DEF_ALL__ */


#ifdef L_vq_gdos

int
vq_gdos(void)
{
  register int retvalue __asm__("d0");

#ifdef __MSHORT__
  __asm__ volatile
    ("	movw	#-2,d0
	trap	#2
	cmpw	#-2,d0
	sne	d0
	extw	d0"
     : "=r"(retvalue)		/* output */
     :				/* no input */
     : "d0", "d1", "d2", "a0", "a1", "a2"    /* clobbered regs */
     );
#else
  __asm__ volatile
    ("	movw	#-2,d0
	trap	#2
	cmpw	#-2,d0
	sne	d0
	extw	d0
	extl	d0"
     : "=r"(retvalue)		/* output */
     :				/* no input */
     : "d0", "d1", "d2", "a0", "a1", "a2"    /* clobbered regs */
     );
#endif

  return retvalue;
}
#endif /* L_vq_gdos */

#ifdef L_vq_vgdos

/*
 * return type of GDOS
 * -2L	 no GDOS installed
 *  0x5F46534DL	 '_FSM' gdos
 *  0x5F464E54L	 '_FNT' gdos
 */
unsigned long vq_vgdos(void)
{
    register unsigned long ret __asm__("d0");
    __asm__ volatile ("
 	movq	#-2,d0
 	trap    #2"
	  : "=r"(ret)
          :
          : "d0", "d1", "d2", "a0", "a1", "a2" );
    return ret;
}
#endif /* L_vq_vgdos */
