/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.test.BaseTest;
import cryptix.util.math.BigRegister;
import cryptix.util.math.TrinomialLFSR;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

class Test3LFSR
extends BaseTest {
    public static void main(String[] stringArray) {
        new Test3LFSR().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        Object object;
        Object object2;
        TrinomialLFSR trinomialLFSR;
        Object object3;
        Object object4;
        TrinomialLFSR trinomialLFSR2 = new TrinomialLFSR(4, 1);
        trinomialLFSR2.resetX(1);
        this.out.println(" before shift left: " + trinomialLFSR2);
        trinomialLFSR2.shiftLeft(1);
        this.out.println(" after shift left (1): " + trinomialLFSR2);
        trinomialLFSR2.resetX(1);
        trinomialLFSR2.shiftLeft(2);
        this.out.println(" after shift left (2): " + trinomialLFSR2);
        trinomialLFSR2.resetX(1);
        trinomialLFSR2.shiftLeft(3);
        this.out.println(" after shift left (3): " + trinomialLFSR2);
        trinomialLFSR2.resetX(1);
        trinomialLFSR2.shiftLeft(4);
        this.out.println(" after shift left (4): " + trinomialLFSR2);
        trinomialLFSR2.resetX(1);
        trinomialLFSR2.shiftLeft(5);
        this.out.println(" after shift left (5): " + trinomialLFSR2);
        trinomialLFSR2.resetX(0);
        this.out.println(" before shift right: " + trinomialLFSR2);
        trinomialLFSR2.shiftRight(1);
        this.out.println(" after shift right (1): " + trinomialLFSR2);
        trinomialLFSR2.resetX(0);
        trinomialLFSR2.shiftRight(2);
        this.out.println(" after shift right (2): " + trinomialLFSR2);
        trinomialLFSR2.resetX(0);
        trinomialLFSR2.shiftRight(3);
        this.out.println(" after shift right (3): " + trinomialLFSR2);
        trinomialLFSR2.resetX(0);
        trinomialLFSR2.shiftRight(4);
        this.out.println(" after shift right (4): " + trinomialLFSR2);
        trinomialLFSR2.resetX(0);
        trinomialLFSR2.shiftRight(5);
        this.out.println(" after shift right (5): " + trinomialLFSR2);
        TrinomialLFSR trinomialLFSR3 = new TrinomialLFSR(4, 3);
        this.out.println(trinomialLFSR3);
        trinomialLFSR3.setX(2);
        trinomialLFSR3.setX(3);
        this.out.println("Initialising to (1001) x3 + x2: " + trinomialLFSR3);
        String string = "";
        int n = 0;
        while (n < 15) {
            string = String.valueOf(string) + "" + trinomialLFSR3.next(1) + ", ";
            this.out.println("LFSR state @" + (n + 1) + ": " + trinomialLFSR3);
            ++n;
        }
        this.out.println("Output sequence is = " + string + "...\n");
        this.passIf(string.equals("1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, "), "LFSR state test");
        trinomialLFSR3 = new TrinomialLFSR(4, 1);
        trinomialLFSR3.resetX(0);
        TrinomialLFSR trinomialLFSR4 = (TrinomialLFSR)trinomialLFSR3.clone();
        trinomialLFSR4.setX(0);
        trinomialLFSR4.setX(1);
        this.out.println("Generating powers of x (mod(f(x))...");
        int n2 = 0;
        while (n2 < 15) {
            trinomialLFSR3.clock(1);
            this.out.print(" State @" + (n2 + 1) + ": " + trinomialLFSR3.toPolynomial());
            int n3 = trinomialLFSR3.compareTo(trinomialLFSR4);
            this.out.println(String.valueOf(n3 == -1 ? "<" : (n3 == 0 ? "==" : ">")) + trinomialLFSR4.toPolynomial());
            ++n2;
        }
        TrinomialLFSR trinomialLFSR5 = trinomialLFSR3.trinomialX();
        this.out.println("\nSame using pow()...");
        int n4 = 0;
        while (n4 < 15) {
            trinomialLFSR5 = trinomialLFSR3.trinomialX();
            this.out.print(String.valueOf(trinomialLFSR5.toPolynomial()) + "** " + n4 + " =");
            trinomialLFSR5.pow(trinomialLFSR5.valueOf(n4));
            this.out.println(trinomialLFSR5.toPolynomial());
            ++n4;
        }
        TrinomialLFSR trinomialLFSR6 = (TrinomialLFSR)trinomialLFSR3.clone();
        trinomialLFSR4.resetX(3);
        trinomialLFSR4.setX(2);
        trinomialLFSR4.setX(0);
        trinomialLFSR6.resetX(3);
        trinomialLFSR6.setX(0);
        this.out.println("\nNow working in GF[2**4] with f(x) = x4 + x + 1 ...");
        this.out.println("Defining 'a' set to (0111) x3 + x2 + 1: " + trinomialLFSR4.toPolynomial());
        this.out.println("Defining 'b' set to (0011) x3 + 1: " + trinomialLFSR6.toPolynomial());
        trinomialLFSR4.multiply(trinomialLFSR6);
        this.out.println("Computing a * b (mod(f(x)): " + trinomialLFSR4.toPolynomial());
        TrinomialLFSR trinomialLFSR7 = (TrinomialLFSR)trinomialLFSR3.clone();
        TrinomialLFSR trinomialLFSR8 = (TrinomialLFSR)trinomialLFSR3.clone();
        trinomialLFSR7.resetX(3);
        trinomialLFSR7.setX(2);
        trinomialLFSR7.setX(0);
        trinomialLFSR8.resetX(3);
        trinomialLFSR8.setX(0);
        this.out.println("\nDefining 'aa' set to (0111) x3 + x2 + 1: " + trinomialLFSR7.toPolynomial());
        this.out.println("Defining 'bb' set to (0011) x3 + 1: " + trinomialLFSR8.toPolynomial());
        trinomialLFSR8.multiply(trinomialLFSR7);
        this.out.println("Computing bb * aa (mod(f(x)): " + trinomialLFSR8.toPolynomial());
        this.passIf(trinomialLFSR4.isSameValue(trinomialLFSR8), "a * b == bb * aa?");
        try {
            trinomialLFSR3.atRandom();
            this.out.println("\nAbout to serialize R to './t.tmp'...");
            this.out.println("R: " + trinomialLFSR3);
            object4 = new FileOutputStream("t.tmp");
            object3 = new ObjectOutputStream((OutputStream)object4);
            ((ObjectOutputStream)object3).writeObject(trinomialLFSR3);
            ((ObjectOutputStream)object3).flush();
            ((FileOutputStream)object4).close();
            this.out.println("Finished serialization. Now resetting R...");
            trinomialLFSR = (TrinomialLFSR)trinomialLFSR3.clone();
            trinomialLFSR.reset();
            this.out.println("R: " + trinomialLFSR);
            this.out.println("About to deserialize R from './t.tmp'...");
            object2 = new FileInputStream("t.tmp");
            object = new ObjectInputStream((InputStream)object2);
            trinomialLFSR = (TrinomialLFSR)((ObjectInputStream)object).readObject();
            ((FileInputStream)object2).close();
            this.out.println("R: " + trinomialLFSR);
            this.passIf(trinomialLFSR3.isSameValue(trinomialLFSR), "Serialization test");
        }
        catch (Exception exception) {
            this.fail("Exception during serialization test");
            exception.printStackTrace();
        }
        object4 = new int[]{89, 127, 521, 607, 1279, 2281, 3217};
        object3 = new int[][]{{38}, {63, 30, 15, 7}, {168, 158, 48, 32}, {273, 147, 105}, {418, 216}, {1029, 915, 715}, {576, 67}};
        this.out.println("Testing few monic primitive trinomials as Galois counters...");
        int n5 = 0;
        while (n5 < 2) {
            reference var21_22 = object4[n5];
            object = new BigRegister((int)var21_22);
            int n6 = 0;
            while (n6 < ((Object)object3[n5]).length) {
                Object object5 = object3[n5][n6];
                trinomialLFSR = new TrinomialLFSR((int)var21_22, (int)object5);
                trinomialLFSR.resetX(1);
                object2 = (TrinomialLFSR)trinomialLFSR.clone();
                reference var18_20 = var21_22;
                int n7 = 1;
                this.out.println(" ...testing: x" + (int)var21_22 + " + x" + (int)object5 + " + 1...");
                while (var18_20 >= 0) {
                    ((TrinomialLFSR)object2).resetX(1);
                    ((TrinomialLFSR)object2).pow(((BigRegister)object).valueOf(n7));
                    if (!trinomialLFSR.isSameValue((TrinomialLFSR)object2)) {
                        this.fail("LFSR is out of sync...");
                        break;
                    }
                    trinomialLFSR.clock(1);
                    ++n7;
                    --var18_20;
                }
                ++n6;
            }
            ++n5;
        }
    }

    Test3LFSR() {
    }
}

