/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security;

import cryptix.security.BlockCipher;
import cryptix.security.CryptoError;
import java.security.Cipher;

public class SPEED
extends BlockCipher {
    private static final int KEY_LEN_MAX = 32;
    private static final int KEY_LEN_MIN = 6;
    private static byte[][] keys = new byte[][]{new byte[8], {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96}};
    private static byte[][] plains;
    private static byte[][] ciphers;
    private static int[][] params;

    public static final int blockLengthMax() {
        return 32;
    }

    public static final int blockLengthMin() {
        return 8;
    }

    public static final int blockLengthMod() {
        return 8;
    }

    public static final int keyLengthMax() {
        return 32;
    }

    public static final int keyLengthMin() {
        return 6;
    }

    public static final int keyLengthMod() {
        return 2;
    }

    public static final int numRoundsMax() {
        return -1879048196;
    }

    public static final int numRoundsMin() {
        return 32;
    }

    public static final int numRoundsMod() {
        return 4;
    }

    public final int numRounds() {
        return ((cryptix.provider.cipher.SPEED)this.cipher).getRounds();
    }

    public SPEED(byte[] byArray) {
        super(SPEED.getCipherImpl(8, 64), byArray);
    }

    public SPEED(byte[] byArray, int n, int n2) {
        super(SPEED.getCipherImpl(n, n2), byArray);
    }

    private static Cipher getCipherImpl(int n, int n2) {
        try {
            cryptix.provider.cipher.SPEED sPEED = (cryptix.provider.cipher.SPEED)Cipher.getInstance((String)"SPEED", (String)"Cryptix");
            sPEED.setBlockSize(n);
            sPEED.setRounds(n2);
            return sPEED;
        }
        catch (Exception exception) {
            throw new CryptoError(exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        try {
            SPEED.self_test();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    public static void self_test() throws CryptoError {
        int n = 0;
        while (n < keys.length) {
            SPEED sPEED = new SPEED(keys[n], params[n][0], params[n][1]);
            byte[] byArray = new byte[plains[n].length];
            sPEED.encrypt(plains[n], byArray);
            if (SPEED.notEquals(ciphers[n], byArray)) {
                throw new CryptoError("encrypt #" + n + " failed");
            }
            sPEED.decrypt(ciphers[n], byArray);
            if (SPEED.notEquals(plains[n], byArray)) {
                throw new CryptoError("decrypt #" + n + " failed");
            }
            ++n;
        }
    }

    private static boolean notEquals(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static {
        byte[][] byArrayArray = new byte[3][];
        byArrayArray[0] = new byte[8];
        byArrayArray[1] = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        byte[] byArray = new byte[32];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArray[16] = 16;
        byArray[17] = 17;
        byArray[18] = 18;
        byArray[19] = 19;
        byArray[20] = 20;
        byArray[21] = 21;
        byArray[22] = 22;
        byArray[23] = 23;
        byArray[24] = 24;
        byArray[25] = 25;
        byArray[26] = 26;
        byArray[27] = 27;
        byArray[28] = 28;
        byArray[29] = 29;
        byArray[30] = 30;
        byArray[31] = 31;
        byArrayArray[2] = byArray;
        plains = byArrayArray;
        byte[][] byArrayArray2 = new byte[3][];
        byte[] byArray2 = new byte[8];
        byArray2[0] = 109;
        byArray2[1] = -123;
        byArray2[2] = 38;
        byArray2[3] = -68;
        byArray2[4] = 25;
        byArray2[5] = -128;
        byArray2[7] = 46;
        byArrayArray2[0] = byArray2;
        byArrayArray2[1] = new byte[]{-24, -60, 91, -111, 22, -40, 84, -85, 113, 21, 23, -61, -71, -28, 19, 108};
        byArrayArray2[2] = new byte[]{104, 16, 49, -70, -52, 49, -79, 8, -41, 97, 107, 41, -118, 85, -86, 63, 27, -20, 63, 105, 116, 21, 78, 67, 71, 104, 98, -102, -6, 108, -31, 61};
        ciphers = byArrayArray2;
        params = new int[][]{{8, 64}, {16, 128}, {32, 256}};
    }
}

