/* $Id: saol.lex,v 1.5 1997/11/20 16:34:50 eds Exp $ */
/* $Log: saol.lex,v $
# Revision 1.5  1997/11/20  16:34:50  eds
# Changed 'sfsynth' to 'sbsynth'.
#
# Revision 1.4  1997/11/05  20:11:55  eds
# Added tablemaps.
#
# Revision 1.3  1997/10/03  15:10:35  eds
# Added SFSYNTH keyword.
#
# Revision 1.2  1997/09/17  14:10:06  eds
# Added spatialize keyword.
# */
/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

STRCONST	\"(\\.|[^\\"])*\"
IDENT		[a-zA-Z_][a-zA-Z0-9_]*
INTGR		[0-9]+
NUMBER		[0-9]+(\.[0-9]*)?(e[-+]?[0-9]+)?|-?\.[0-9]*(e-+?[0-9]+)?

%{
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
  
void count(void),comment(void),dumpline(int i);
int yyline=1,yycol=0;
char thisline[1000],**all_lines = NULL;

%}


%%

"//"		{ comment(); }
"aopcode"	{ count(); return(AOPCODE) ; }
"asig"		{ count(); return(ASIG) ; }
"else"          { count(); return(ELSE) ; }
"exports"       { count(); return(EXPORTS) ; }
"extend"        { count(); return(EXTEND) ; }
"global"        { count(); return(GLOBAL) ; }
"if"            { count(); return(IF) ; }
"imports"       { count(); return(IMPORTS); }
"inchannels"    { count(); return(INCHANNELS) ; }
"inputmod"      { count(); return(INPUTMOD) ; }
"instr"         { count(); return(INSTR); }
"iopcode"	{ count(); return(IOPCODE); }
"ivar"		{ count(); return(IVAR) ; }
"kopcode"	{ count(); return(KOPCODE); }
"krate"         { count(); return(KRATE) ; }
"ksig"		{ count(); return(KSIG) ; }
"map"	        { count(); return(MAP) ; }
"oparray"       { count(); return(OPARRAY) ; }
"opcode"	{ count(); return(OPCODE) ; }
"outbus"	{ count(); return(OUTBUS) ; }
"outchannels"   { count(); return(OUTCHANNELS) ; }
"output"	{ count(); return(OUTPUT) ; }
"return"	{ count(); return(RETURN) ; }
"route"         { count(); return(ROUTE) ; }
"send"          { count(); return(SEND) ; }
"sequence"      { count(); return(SEQUENCE) ; }
"sbsynth"       { count(); return(SFSYNTH) ; }
"spatialize"    { count(); return(SPATIALIZE) ; }
"srate"		{ count(); return(SRATE); }
"table"		{ count(); return(TABLE); }
"tablemap"      { count(); return(TABLEMAP); }
"template"	{ count(); return(TEMPLATE); }
"turnoff"       { count(); return(TURNOFF); }
"while"		{ count(); return(WHILE); }
"with"          { count(); return(WITH); }
"xsig"		{ count(); return(XSIG) ; }
"&&"		{ count(); return(AND); }
"||"		{ count(); return(OR); }
">="		{ count(); return(GEQ); }
"<="		{ count(); return(LEQ); }
"!="		{ count(); return(NEQ); }
"=="		{ count(); return(EQEQ); }
"-"		{ count(); return(MINUS); }
"*"		{ count(); return(STAR); }
"/"		{ count(); return(SLASH); }
"+"		{ count(); return(PLUS); }
">"		{ count(); return(GT); }
"<"		{ count(); return(LT); }
"?"		{ count(); return(Q); }
":"		{ count(); return(COL); }
"("		{ count(); return(LP); }
")"		{ count(); return(RP); }
"{"		{ count(); return(LC); }
"}"		{ count(); return(RC); }
"["		{ count(); return(LB); }
"]"		{ count(); return(RB); }
";"		{ count(); return(SEM); }
","		{ count(); return(COM); }
"="		{ count(); return(EQ); }
"!"             { count(); return(NOT); }

{STRCONST}	{ count(); yytext[strlen(yytext)-1] = 0; /* strip quotes */
                           yylval = add_ptr_index(strdup(&yytext[1]));
                           return(STRCONST); }
{IDENT}		{ count(); yylval = add_ptr_index(strdup(yytext));
                           return(IDENT) ; }
{INTGR}		{ count(); yylval = add_ptr_index(strdup(yytext));
                           return(INTGR) ; }
{NUMBER}	{ count(); yylval = add_ptr_index(strdup(yytext));
                           return(NUMBER) ; }
[ \t\n]		{ count(); }
.		{ count();
                  printf("Line %d: Unknown character: '%s'\n",yyline,yytext); }

%%

void comment() {
  char c;

  while ((c = input()) != '\n'); /* skip */
  yyline++;
  thisline[0] = 0;
  yycol = 0;
  }
              

void count() {
  char *nl;
  
  if (strcmp(yytext,"\n")) {
    yycol += strlen(yytext);
    strcat(thisline,yytext);
    }
  else {
    int i=0;

    while (thisline[i] == ' ' || thisline[i] == '\t') i++;
    nl = strdup(&thisline[i]);
   
    yycol = 0;
    if (all_lines)
      all_lines = (char **)realloc(all_lines,(yyline +2) * sizeof(char *));
    else
      all_lines = (char **)malloc(2 * sizeof(char *));
    all_lines[yyline-1] = nl; /* since yyline starts from 1 */
    yyline++;
    thisline[0] = 0;
    all_lines[yyline-1] = thisline;
    }
  }

void dumpline(int i) {
 
  printf("%s\n",all_lines[i]);
}
