/*

This software module was originally developed by 

Mike Guzewicz (E-mu Systems)


in the course of development of the MPEG-4 Audio (ISO/IEC 14496-3) standard. 
This software module is an implementation of a part of one or more 
MPEG-4 Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio 
(ISO/IEC 14496-3). ISO/IEC gives users of the MPEG-4 Audio (ISO/IEC 14496-3) 
free license to this software module or modifications thereof for use 
in hardware or software products claiming conformance to the MPEG-4 Audio 
(ISO/IEC 14496-3). Those intending to use this software module in hardware 
or software products are advised that its use may infringe existing patents. 
The original developer of this software module and his/her company, the 
subsequent editors and their companies, and ISO/IEC have no liability for 
use of this software module or modifications thereof in an implementation. 
Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3) conforming 
products. E-mu Systems retains full right to use the code for his/her own 
purpose, assign or donate the code to a third party and to inhibit third 
parties from using the code for non MPEG-4 Audio (ISO/IEC 14496-3) 
conforming products. This copyright notice must be included in all copies 
or derivative works. 

Copyright (C) 1997 E-mu Systems, Inc.

*/
     /*********************************************************************
     
     sfe_omega.h
     
          
     *********************************************************************/

#ifndef __OMEGA_H
#define __OMEGA_H

//*******************************************************************
// @(#)omega.h	1.1 12:06:31 3/15/95 12:06:36
//
//  File:           OMEGA.H
//
//  Description: 
//
//  The error class to be included in other classes to keep track of
//  their instance error-states.
//
//*******************************************************************


#include "sfe_datatype.h"

#define SUCCESS 0

///////////////////////////
//   Class Declarations  //
///////////////////////////

typedef CHAR *ErrVec;

class OmegaClass
{
  public:
    OmegaClass(ErrVec *EVec); 
    OmegaClass(void); 

    ~OmegaClass(void) {}

    void     SetError(SHORT shError)  { shOmega = shError;            }
    SHORT    GetError(void) const     { return (shOmega);             }
    CHAR*   GetErrorStr(void)         { return ErrorArray[shOmega];   } 
    BOOL    IsBad(void)               { return (shOmega != SUCCESS);  }
    BOOL    IsOK(void)                { return (shOmega == SUCCESS);  }
    void    SetErrors(ErrVec *EVec)   { ErrorArray = EVec;            }
    void    ReportError(void);
  private:

    SHORT    shOmega;   // this will be updated to a DWORD for v2.0 of omega
    ErrVec  *ErrorArray;
};


#endif // __OMEGA_H
////////////////////////// End of OMEGA.H ///////////////////////////
