/* LAT's Gabriel network probe (e.g., SATAN) detector.
 * Copyright 1995 by Los Altos Technologies, Inc.
 * All rights reserved.
 *
 * Module: Database of info on host records.
 * Author: Bob Baldwin.
 */


/* Information about probes from a host.
 * For each source host track the most recent event
 * of any kind and track the most recent event of each kind.
 */
struct hostrec 
{
	char	*host_name;	/* Numeric or symbolic. */
	time_t	last_probe_time; /* When last packet recorded. */
	time_t	last_low_report_time; /* When last report logged by gabriel. */
	time_t	last_high_report_time; /* When last report logged by gabriel. */
	void	*service_list;	/* Hide details. */
};
typedef struct hostrec hostrec;



/* Allocate a host record from the heap
 * and initialize it.
 */
extern hostrec * hostrec_create();


/* Deallocate a hostrec.
 */
extern void hostrec_free();


/* Return the count of different probe classes.
 */
extern int hostrec_num_probes();


/* Update a host record that is already in the database.
 */
extern void hostrec_update();


/* Find a the hostrec for the given host
 * or return NULL.
 */
extern hostrec * hostrec_lookup();


/* Add a host record to the database of host records.
 */
extern void hostrec_add();


/* Remove and deallocate a host record.
 */
extern void hostrec_remove();


/* Remove service probe records older than the given time.
 */
extern void hostrec_remove_probes_older_than();


/* Traverse the list of hostrecs invoking the
 * given function on each one with the given
 * state information.
 */
void hostrec_traverse();
