
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

main :- unify([a(X,Y)], [Z,T]).

unify(Left, Left) :- !.				% Try standard unify first
unify(Left, g) :-				% else, is it special case
	atomic(Left), !,			
	not(Left=[]).
unify(g, Right) :-				
	atomic(Right), !,
	not(Right=[]).
unify([LeftHead|LeftTail], [RightHead|RightTail]) :-	% or list
	!, unify(LeftHead, RightHead),
	unify(LeftTail, RightTail).
unify(Left, Right) :-					% or structure
	Left =.. [Functor|LeftArgs],
	Right =.. [Functor|RightArgs],
	unify(LeftArgs, RightArgs).
