
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

main :- print_results([rule(2,[m,i,i]),rule(2,[m,i,i,i,i])],0).

print_results([], _).
print_results([rule(N,G)|T], M) :-
	M1 is M + 1,
	implode(A, G),
	write(M1), write('  '), print_rule(N), write(A), nl,
	print_results(T, M1).

print_rule(0) :- write('axiom    ').
print_rule(N) :- N =\= 0, write('rule '), write(N), write('   ').

% Break atom A into list of characters L.
explode(A, L) :-
	name(A, Ascii),
	name_list(L, Ascii).

% Combine list of characters L into atom A.
implode(A, L) :-
	name_list(L, Ascii),
	name(A, Ascii).

name_list([], []).
name_list([H1|T1], [H2|T2]) :-
	name(H1, [H2]),
	name_list(T1, T2).

