#charset "us-ascii"

/*
 *   MegaTADS. Additions and modifications to the travel.t file.
 *
 *   Copyright 2007, Krister Fundin.
 */

#include <adv3.h>

#include "mega.h"

/* ---------------------------------------------------------------------- */
/*
 *   Modify the Passage class so that, when both sides are in scope, only
 *   the one in the actors location is kept. This makes it possible to join
 *   two rooms using a SenseConnector when a door is open. Without the
 *   patch, a command involving the door might be applied to the wrong side.
 */

#ifdef MEGA_PASSAGE_ON

modify Passage
    /* after deciding the scope, come back here to do some more work */
    clearSenseInfo()
    {
        inherited();
        senseTmp.notifyList.append(self);
    }

    /* remove facets in other rooms visible though SenseConnectors */
    finishSensePath(objs, sense)
    {
        /* get the outermost location of the point of view */
        local outer = senseTmp.pointOfView.getOutermostRoom();

        /*
         *   if we are in this location, then remove all of our facets that
         *   that are not in the same location
         */
        if (isIn(outer))
        {
            /* repeat through our facets */
            foreach (local cur in getFacets())
            {
                /*
                 *   if this one is in a different location, then remove it
                 *   from the list of objects
                 */
                if (!cur.isIn(outer))
                    objs.removeElement(cur);
            }
        }
    }
;

#endif

/* ---------------------------------------------------------------------- */
/*
 *   Add remapping for the USE command to a few classes.
 */

#ifdef MEGA_USE_ON

modify Bed
    /* using a bed usually means lying on it */
    dobjFor(Use) remapTo(LieOn, self)
;

modify Chair
    /* using a chair usually means sitting on it */
    dobjFor(Use) remapTo(SitOn, self)
;

modify Door
    /* using a door usually means going though it */
    dobjFor(Use) remapTo(GoThrough, self)
;

#endif

