/*
 * tester - tester tcp header compression code.
 *
 * Copyright (c) 1989 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	Van Jacobson (van@helios.ee.lbl.gov), Dec 31, 1989:
 *	- Initial distribution.
 */
#ifndef lint
static char rcsid[] = "$Header: tester.c,v 1.8 89/12/31 08:53:08 van Exp $";
#endif


#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/mbuf.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <stdio.h>
#include <sys/timeb.h>
#include <ctype.h>
#include <netdb.h>
#include "slcompress.h"

static char *ip_proto_name();
static char buf1[2048 + sizeof(struct mbuf)];
static char buf2[2048 + sizeof(struct mbuf)];
static char buf3[2048 + sizeof(struct mbuf)];

static void printcflags();
static void printpack();

int vflag;
FILE *oflag;

struct tcpip {
	struct ip ip;
	struct tcphdr tcp;
};

char *usage = "usage: %s [-v] [-o ofile] file\n";

main (argc, argv)
	int argc;
	char **argv;
{
	int i, s, cc, fd;
	u_long iaddr;
	u_char type;
	register u_char *cp;
	register struct ip *ip;
	struct mbuf *m1, *m2, *m3;
	struct tcpip *th1;
	struct tcpip *th3;
	int compressed;
	struct slcompress slc;
	u_char *bufp;

	if (argc <= 1) {
		fprintf(stderr, usage, *argv);
		exit(1);
	}
	if (strcmp(argv[1], "-v") == 0) {
		++vflag;
		if (argc <= 2) {
			fprintf(stderr, usage, *argv);
			exit(1);
		}
		++argv; --argc;
	}
	if (strcmp(argv[1], "-o") == 0) {
		++argv; --argc;
		if (argc <= 2) {
			fprintf(stderr, usage, *argv);
			exit(1);
		}
		if ((oflag = fopen(argv[1], "w")) == NULL) {
			perror(argv[1]);
			exit(1);
		}
		++argv; --argc;
	}
	setlinebuf(stdout);
	if ((fd = open(argv[1], O_RDONLY, 0777)) < 0) {
		perror(argv[1]);
		exit(2);
	}
	sl_compress_init(&slc);

	while (read(fd, &cc, sizeof(cc)) == sizeof(cc)) {
		cc = ntohl(cc);
		m1 = (struct mbuf *) buf1;
		m2 = (struct mbuf *) buf2;
		m3 = (struct mbuf *) buf3;
		bzero(buf1, sizeof(buf1));
		m1->m_off = 128 + MMINOFF;
		m1->m_len = cc;
		if (read(fd, mtod(m1, char *), cc) < cc) {
			perror( "read 2" );
			exit(1);
		}
		ip = mtod(m1, struct ip *);
		printf("%s.%u > %s.%u: %s %4d",
			inet_ntoa(ip->ip_src), ntohs(*(u_short *)(ip + 1)),
			inet_ntoa(ip->ip_dst), ntohs(((u_short *)(ip + 1))[1]),
			ip_proto_name(ip->ip_p), cc);
		fflush(stdout);
		printf(" -> ");
		bcopy(buf1, buf2, sizeof(buf1));
		type = sl_compress_tcp(m2, mtod(m2, struct ip *), &slc, 1);
		switch (type) {
		case TYPE_IP:
			printf("I");
			compressed = 0;
			break;
		case TYPE_UNCOMPRESSED_TCP:
			printf("U %d", mtod(m2, struct ip *)->ip_p);
			compressed = 0;
			break;
		case TYPE_COMPRESSED_TCP:
			cp = mtod(m2, u_char *);
			i = *cp;
			if (i & NEW_C)
				printf("C %d ", cp[1]);
			else
				printf("C * ");
			printcflags(i);
			compressed = 1;
			break;
		default:
			printf("??");
			compressed = 1;
			break;
		}
		printf(" %d (%d)", m2->m_len, m2->m_len - (cc - 40));
		if (compressed && vflag)
			printpack(cp, m2->m_len - (cc - 40));

		if (oflag) {
			cp = mtod(m2, u_char *);
			fwrite(cp, m2->m_len, 1, oflag);
		}
		bcopy(buf2, buf3, sizeof(buf3));
		bufp = mtod(m3, u_char *);
		if (type != TYPE_IP)
			i = sl_uncompress_tcp(&bufp, m3->m_len, type, &slc);
		else
			i = m3->m_len;
		if (i != m1->m_len || bcmp(mtod(m1, char *), bufp, i)) {
			th1 = mtod(m1, struct tcpip *);
			th3 = (struct tcpip *)bufp;
			printf(" -- uncompress botch", &th1, &th3);
		}
		printf("\n");

	}
	close(fd);
	if (oflag)
		fclose(oflag);
}

static void
printcflags(flags)
	u_int flags;
{
	printf("%c%c%c",
		flags & NEW_C ? 'C':'-',
		flags & NEW_I ? 'I':'-',
		flags & TCP_PUSH_BIT ? 'P':'-');

	switch (flags & SPECIALS_MASK) {
	case SPECIAL_I:
		printf("SA..");
		break;
	case SPECIAL_D:
		printf("S...");
		break;
	default:
		printf("%c%c%c%c",
			flags & NEW_S ? 'S':'-',
			flags & NEW_A ? 'A':'-',
			flags & NEW_W ? 'W':'-',
			flags & NEW_U ? 'U':'-');
		break;
	}
}

static void
printpack(cp, len)
	u_char *cp;
	int len;
{
	printf("\t");
	++cp; --len;
	while (--len >= 0)
		printf(" %02x", *cp++);
}

static char *
ip_proto_name(p)
{
	static char buf[32];

	switch (p) {
	case IPPROTO_TCP:
		return ("tcp");
	case IPPROTO_UDP:
		return ("udp");
	case IPPROTO_ICMP:
		return ("icmp");
	}
	sprintf(buf, "p#%u", p);
	return (buf);
}
