/* gw_screen.h								*/

/*
 *               Copyright 1989, 1990 Digital Equipment Corporation
 *                          All Rights Reserved
 * 
 * 
 * Permission to use, copy, and modify this software and its documentation
 * is hereby granted only under the following terms and conditions.  Both
 * the above copyright notice and this permission notice must appear in
 * all copies of the software, derivative works or modified versions, and
 * any portions threof, and both notices must appear in supporting
 * documentation.
 * 
 * Users of this software agree to the terms and conditions set forth herein,
 * and hereby grant back to Digital a non-exclusive, unrestricted, royalty-free
 * right and license under any changes, enhancements or extensions made to the
 * core functions of the software, including but not limited to those affording
 * compatibility with other hardware or software environments, but excluding
 * applications which incorporate this software.  Users further agree to use
 * their best efforts to return to Digital any such changes, enhancements or
 * extensions that they make and inform Digital of noteworthy uses of this
 * software.  Correspondence should be provided to Digital at:
 * 
 *                       Director of Licensing
 *                       Western Research Laboratory
 *                       Digital Equipment Corporation
 *                       100 Hamilton Avenue
 *                       Palo Alto, California  94301  
 * 
 * Comments and bug reports may also be sent using electronic mail to:
 * 			screend-reports@decwrl.dec.com
 * 
 * 	>> This software may NOT be distributed to third parties. <<
 *   
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL
 * EQUIPMENT CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/************************************************************************
 *			Modification History				*
 *									*
 *	16 December 1988	Jeffrey Mogul/DECWRL			*
 *		Created.						*
 *									*
 ************************************************************************/

/*
 * Definitions for Gateway Screening mechanism
 */

/*
 * Access to this facility should be by a new system call, but
 * to keep things simple, we use several new ioctls instead.
 */

#define	SIOCSCREENON	_IOWR(i, 90, int)
		/*
		 * Turns screening on/off (based on arg)
		 * and returns previous setting (value-result arg)
		 */
#define	SCREENMODE_OFF		0
#define	SCREENMODE_ON		1
#define	SCREENMODE_NOCHANGE	2
		/* any other value == NOCHANGE as well */

#define	SIOCSCREEN	_IOWR(i, 91, struct screen_data)
		/*
		 * Transmits from user to kernel an screen_data
		 * struct, and then copies the next one from kernel
		 * to user into the same buffer (value-result arg).
		 * This allows us to do each transaction with
		 * only one system call.
		 *
		 * This ioctl blocks until the next transaction
		 * is available.
		 */

#define	SIOCSCREENSTATS	_IOR(i, 92, struct screen_stats)
		/*
		 * Provides current statistics block
		 */

/*
 * For each packet, a transaction occurs where the kernel
 * passes the packet header out to the user process, which
 * checks the values and then tells the kernel whether or
 * not to allow the packet.
 *
 * We stick this header struct before the packet itself.
 * Some fields of this struct are "output" fields (kernel write,
 * user read), and some are "input" (user write, kernel read).
 */

struct screen_data_hdr {
	short	sdh_count;	/* length of entire record */	/* OUT */
	short	sdh_dlen;	/* bytes of packet header */	/* OUT */
	u_long	sdh_xid;	/* transaction ID */		/* OUT */
	struct timeval sdh_arrival;				/* OUT */
				/* time at which this packet arrived */
	short	sdh_family;	/* address family */		/* OUT */

	int	sdh_action;	/* disposition for this pkt */	/* IN */
				/*	see defs below      */

	/* Other fields: incoming i/f name? */
};

/*
 * Possible dispositions of the packet
 */
#define	SCREEN_ACCEPT	0x0001	/* Accept this packet */
#define	SCREEN_DROP	0x0000	/* Don't accept this packet */
#define	SCREEN_NOTIFY	0x0002	/* Notify the sender of failure */
#define	SCREEN_NONOTIFY	0x0000	/* Don't notify the sender */

/*
 * Screening information + the actual packet
 */

#define	SCREEN_MAXLEN	120	/* length of struct screen_data */
#if	SCREEN_MAXLEN > IOCPARM_MASK
THIS IS TOO BIG TO BE USED WITH IOCTL!
#endif	SCREEN_MAXLEN > IOCPARM_MASK

struct screen_data {
	struct screen_data_hdr sd_hdr;				/* IN/OUT */

#define	SCREEN_DATALEN	(SCREEN_MAXLEN - sizeof(struct screen_data_hdr))
	char	sd_data[SCREEN_DATALEN];
				/* sd_dlen bytes of pkt hdr */	/* OUT */
};

#define	sd_count	sd_hdr.sdh_count
#define	sd_dlen		sd_hdr.sdh_dlen
#define	sd_xid		sd_hdr.sdh_xid
#define	sd_action	sd_hdr.sdh_action
#define	sd_arrival	sd_hdr.sdh_arrival
#define	sd_family	sd_hdr.sdh_family

struct screen_stats {
	u_long	ss_packets;	/* total packets screened */
	u_long	ss_nobuffer;	/* dropped because buffer was full */
	u_long	ss_accept;	/* total accepted */
	u_long	ss_reject;	/* total rejected */
	u_long	ss_badsync;	/* dropped because user was out of sync */
	u_long	ss_stale;	/* dropped because too old */
};
