/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * drivers/media/i2c/smiapp/smiapp-reg-defs.h
 *
 * Generic driver for MIPI CCS/SMIA/SMIA++ compliant camera sensors
 *
 * Copyright (C) 2020 Intel Corporation
 * Copyright (C) 2011--2012 Nokia Corporation
 * Contact: Sakari Ailus <sakari.ailus@iki.fi>
 */

#ifndef __SMIAPP_REG_DEFS_H__
#define __SMIAPP_REG_DEFS_H__

/* Register addresses */
#define SMIAPP_REG_U16_MODEL_ID					(0x0000 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_REVISION_NUMBER_MAJOR			0x0002
#define SMIAPP_REG_U8_MANUFACTURER_ID				0x0003
#define SMIAPP_REG_U8_SMIA_VERSION				0x0004
#define SMIAPP_REG_U8_FRAME_COUNT				0x0005
#define SMIAPP_REG_U8_PIXEL_ORDER				0x0006
#define SMIAPP_REG_U16_DATA_PEDESTAL				(0x0008 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_PIXEL_DEPTH				0x000c
#define SMIAPP_REG_U8_REVISION_NUMBER_MINOR			0x0010
#define SMIAPP_REG_U8_SMIAPP_VERSION				0x0011
#define SMIAPP_REG_U8_MODULE_DATE_YEAR				0x0012
#define SMIAPP_REG_U8_MODULE_DATE_MONTH				0x0013
#define SMIAPP_REG_U8_MODULE_DATE_DAY				0x0014
#define SMIAPP_REG_U8_MODULE_DATE_PHASE				0x0015
#define SMIAPP_REG_U16_SENSOR_MODEL_ID				(0x0016 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_SENSOR_REVISION_NUMBER			0x0018
#define SMIAPP_REG_U8_SENSOR_MANUFACTURER_ID			0x0019
#define SMIAPP_REG_U8_SENSOR_FIRMWARE_VERSION			0x001a
#define SMIAPP_REG_U32_SERIAL_NUMBER				(0x001c | CCS_FL_32BIT)
#define SMIAPP_REG_U8_FRAME_FORMAT_MODEL_TYPE			0x0040
#define SMIAPP_REG_U8_FRAME_FORMAT_MODEL_SUBTYPE		0x0041
#define SMIAPP_REG_U16_FRAME_FORMAT_DESCRIPTOR_2(n)		((0x0042 + ((n) << 1)) | CCS_FL_16BIT) /* 0 <= n <= 14 */
#define SMIAPP_REG_U32_FRAME_FORMAT_DESCRIPTOR_4(n)		((0x0060 + ((n) << 2)) | CCS_FL_32BIT) /* 0 <= n <= 7 */
#define SMIAPP_REG_U16_ANALOGUE_GAIN_CAPABILITY			(0x0080 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ANALOGUE_GAIN_CODE_MIN			(0x0084 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ANALOGUE_GAIN_CODE_MAX			(0x0086 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ANALOGUE_GAIN_CODE_STEP			(0x0088 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ANALOGUE_GAIN_TYPE			(0x008a | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ANALOGUE_GAIN_M0				(0x008c | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ANALOGUE_GAIN_C0				(0x008e | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ANALOGUE_GAIN_M1				(0x0090 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ANALOGUE_GAIN_C1				(0x0092 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_DATA_FORMAT_MODEL_TYPE			0x00c0
#define SMIAPP_REG_U8_DATA_FORMAT_MODEL_SUBTYPE			0x00c1
#define SMIAPP_REG_U16_DATA_FORMAT_DESCRIPTOR(n)		((0x00c2 + ((n) << 1)) | CCS_FL_16BIT)
#define SMIAPP_REG_U8_MODE_SELECT				0x0100
#define SMIAPP_REG_U8_IMAGE_ORIENTATION				0x0101
#define SMIAPP_REG_U8_SOFTWARE_RESET				0x0103
#define SMIAPP_REG_U8_GROUPED_PARAMETER_HOLD			0x0104
#define SMIAPP_REG_U8_MASK_CORRUPTED_FRAMES			0x0105
#define SMIAPP_REG_U8_FAST_STANDBY_CTRL				0x0106
#define SMIAPP_REG_U8_CCI_ADDRESS_CONTROL			0x0107
#define SMIAPP_REG_U8_2ND_CCI_IF_CONTROL			0x0108
#define SMIAPP_REG_U8_2ND_CCI_ADDRESS_CONTROL			0x0109
#define SMIAPP_REG_U8_CSI_CHANNEL_IDENTIFIER			0x0110
#define SMIAPP_REG_U8_CSI_SIGNALLING_MODE			0x0111
#define SMIAPP_REG_U16_CSI_DATA_FORMAT				(0x0112 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_CSI_LANE_MODE				0x0114
#define SMIAPP_REG_U8_CSI2_10_TO_8_DT				0x0115
#define SMIAPP_REG_U8_CSI2_10_TO_7_DT				0x0116
#define SMIAPP_REG_U8_CSI2_10_TO_6_DT				0x0117
#define SMIAPP_REG_U8_CSI2_12_TO_8_DT				0x0118
#define SMIAPP_REG_U8_CSI2_12_TO_7_DT				0x0119
#define SMIAPP_REG_U8_CSI2_12_TO_6_DT				0x011a
#define SMIAPP_REG_U8_CSI2_14_TO_10_DT				0x011b
#define SMIAPP_REG_U8_CSI2_14_TO_8_DT				0x011c
#define SMIAPP_REG_U8_CSI2_16_TO_10_DT				0x011d
#define SMIAPP_REG_U8_CSI2_16_TO_8_DT				0x011e
#define SMIAPP_REG_U8_GAIN_MODE					0x0120
#define SMIAPP_REG_U16_VANA_VOLTAGE				(0x0130 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_VDIG_VOLTAGE				(0x0132 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_VIO_VOLTAGE				(0x0134 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_EXTCLK_FREQUENCY_MHZ			(0x0136 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_TEMP_SENSOR_CONTROL			0x0138
#define SMIAPP_REG_U8_TEMP_SENSOR_MODE				0x0139
#define SMIAPP_REG_U8_TEMP_SENSOR_OUTPUT			0x013a
#define SMIAPP_REG_U16_FINE_INTEGRATION_TIME			(0x0200 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_COARSE_INTEGRATION_TIME			(0x0202 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ANALOGUE_GAIN_CODE_GLOBAL		(0x0204 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ANALOGUE_GAIN_CODE_GREENR		(0x0206 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ANALOGUE_GAIN_CODE_RED			(0x0208 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ANALOGUE_GAIN_CODE_BLUE			(0x020a | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ANALOGUE_GAIN_CODE_GREENB		(0x020c | CCS_FL_16BIT)
#define SMIAPP_REG_U16_DIGITAL_GAIN_GREENR			(0x020e | CCS_FL_16BIT)
#define SMIAPP_REG_U16_DIGITAL_GAIN_RED				(0x0210 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_DIGITAL_GAIN_BLUE			(0x0212 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_DIGITAL_GAIN_GREENB			(0x0214 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_VT_PIX_CLK_DIV				(0x0300 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_VT_SYS_CLK_DIV				(0x0302 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_PRE_PLL_CLK_DIV				(0x0304 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_PLL_MULTIPLIER				(0x0306 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_OP_PIX_CLK_DIV				(0x0308 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_OP_SYS_CLK_DIV				(0x030a | CCS_FL_16BIT)
#define SMIAPP_REG_U16_FRAME_LENGTH_LINES			(0x0340 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_LINE_LENGTH_PCK				(0x0342 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_X_ADDR_START				(0x0344 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_Y_ADDR_START				(0x0346 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_X_ADDR_END				(0x0348 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_Y_ADDR_END				(0x034a | CCS_FL_16BIT)
#define SMIAPP_REG_U16_X_OUTPUT_SIZE				(0x034c | CCS_FL_16BIT)
#define SMIAPP_REG_U16_Y_OUTPUT_SIZE				(0x034e | CCS_FL_16BIT)
#define SMIAPP_REG_U16_X_EVEN_INC				(0x0380 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_X_ODD_INC				(0x0382 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_Y_EVEN_INC				(0x0384 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_Y_ODD_INC				(0x0386 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_SCALING_MODE				(0x0400 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_SPATIAL_SAMPLING				(0x0402 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_SCALE_M					(0x0404 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_SCALE_N					(0x0406 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_DIGITAL_CROP_X_OFFSET			(0x0408 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_DIGITAL_CROP_Y_OFFSET			(0x040a | CCS_FL_16BIT)
#define SMIAPP_REG_U16_DIGITAL_CROP_IMAGE_WIDTH			(0x040c | CCS_FL_16BIT)
#define SMIAPP_REG_U16_DIGITAL_CROP_IMAGE_HEIGHT		(0x040e | CCS_FL_16BIT)
#define SMIAPP_REG_U16_COMPRESSION_MODE				(0x0500 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TEST_PATTERN_MODE			(0x0600 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TEST_DATA_RED				(0x0602 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TEST_DATA_GREENR				(0x0604 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TEST_DATA_BLUE				(0x0606 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TEST_DATA_GREENB				(0x0608 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_HORIZONTAL_CURSOR_WIDTH			(0x060a | CCS_FL_16BIT)
#define SMIAPP_REG_U16_HORIZONTAL_CURSOR_POSITION		(0x060c | CCS_FL_16BIT)
#define SMIAPP_REG_U16_VERTICAL_CURSOR_WIDTH			(0x060e | CCS_FL_16BIT)
#define SMIAPP_REG_U16_VERTICAL_CURSOR_POSITION			(0x0610 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_FIFO_WATER_MARK_PIXELS			(0x0700 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_TCLK_POST					0x0800
#define SMIAPP_REG_U8_THS_PREPARE				0x0801
#define SMIAPP_REG_U8_THS_ZERO_MIN				0x0802
#define SMIAPP_REG_U8_THS_TRAIL					0x0803
#define SMIAPP_REG_U8_TCLK_TRAIL_MIN				0x0804
#define SMIAPP_REG_U8_TCLK_PREPARE				0x0805
#define SMIAPP_REG_U8_TCLK_ZERO					0x0806
#define SMIAPP_REG_U8_TLPX					0x0807
#define SMIAPP_REG_U8_DPHY_CTRL					0x0808
#define SMIAPP_REG_U32_REQUESTED_LINK_BIT_RATE_MBPS		(0x0820 | CCS_FL_32BIT)
#define SMIAPP_REG_U8_BINNING_MODE				0x0900
#define SMIAPP_REG_U8_BINNING_TYPE				0x0901
#define SMIAPP_REG_U8_BINNING_WEIGHTING				0x0902
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_CTRL			0x0a00
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_STATUS			0x0a01
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_PAGE_SELECT		0x0a02
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_0			0x0a04
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_1			0x0a05
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_2			0x0a06
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_3			0x0a07
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_4			0x0a08
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_5			0x0a09
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_12		0x0a10
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_13		0x0a11
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_14		0x0a12
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_15		0x0a13
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_16		0x0a14
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_17		0x0a15
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_18		0x0a16
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_19		0x0a17
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_20		0x0a18
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_21		0x0a19
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_22		0x0a1a
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_23		0x0a1b
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_24		0x0a1c
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_25		0x0a1d
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_26		0x0a1e
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_27		0x0a1f
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_28		0x0a20
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_29		0x0a21
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_30		0x0a22
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_31		0x0a23
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_32		0x0a24
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_33		0x0a25
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_34		0x0a26
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_35		0x0a27
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_36		0x0a28
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_37		0x0a29
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_38		0x0a2a
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_39		0x0a2b
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_40		0x0a2c
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_41		0x0a2d
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_42		0x0a2e
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_43		0x0a2f
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_44		0x0a30
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_45		0x0a31
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_46		0x0a32
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_47		0x0a33
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_48		0x0a34
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_49		0x0a35
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_50		0x0a36
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_51		0x0a37
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_52		0x0a38
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_53		0x0a39
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_54		0x0a3a
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_55		0x0a3b
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_56		0x0a3c
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_57		0x0a3d
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_58		0x0a3e
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_59		0x0a3f
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_60		0x0a40
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_61		0x0a41
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_62		0x0a42
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_1_DATA_63		0x0a43
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_CTRL			0x0a44
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_STATUS			0x0a45
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_PAGE_SELECT		0x0a46
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_0			0x0a48
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_1			0x0a49
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_2			0x0a4a
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_3			0x0a4b
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_4			0x0a4c
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_5			0x0a4d
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_6			0x0a4e
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_7			0x0a4f
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_8			0x0a50
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_9			0x0a51
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_10		0x0a52
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_11		0x0a53
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_12		0x0a54
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_13		0x0a55
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_14		0x0a56
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_15		0x0a57
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_16		0x0a58
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_17		0x0a59
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_18		0x0a5a
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_19		0x0a5b
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_20		0x0a5c
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_21		0x0a5d
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_22		0x0a5e
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_23		0x0a5f
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_24		0x0a60
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_25		0x0a61
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_26		0x0a62
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_27		0x0a63
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_28		0x0a64
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_29		0x0a65
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_30		0x0a66
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_31		0x0a67
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_32		0x0a68
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_33		0x0a69
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_34		0x0a6a
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_35		0x0a6b
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_36		0x0a6c
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_37		0x0a6d
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_38		0x0a6e
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_39		0x0a6f
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_40		0x0a70
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_41		0x0a71
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_42		0x0a72
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_43		0x0a73
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_44		0x0a74
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_45		0x0a75
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_46		0x0a76
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_47		0x0a77
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_48		0x0a78
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_49		0x0a79
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_50		0x0a7a
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_51		0x0a7b
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_52		0x0a7c
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_53		0x0a7d
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_54		0x0a7e
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_55		0x0a7f
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_56		0x0a80
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_57		0x0a81
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_58		0x0a82
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_59		0x0a83
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_60		0x0a84
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_61		0x0a85
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_62		0x0a86
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_2_DATA_63		0x0a87
#define SMIAPP_REG_U8_SHADING_CORRECTION_ENABLE			0x0b00
#define SMIAPP_REG_U8_LUMINANCE_CORRECTION_LEVEL		0x0b01
#define SMIAPP_REG_U8_GREEN_IMBALANCE_FILTER_ENABLE		0x0b02
#define SMIAPP_REG_U8_GREEN_IMBALANCE_FILTER_WEIGHT		0x0b03
#define SMIAPP_REG_U8_BLACK_LEVEL_CORRECTION_ENABLE		0x0b04
#define SMIAPP_REG_U8_MAPPED_COUPLET_CORRECT_ENABLE		0x0b05
#define SMIAPP_REG_U8_SINGLE_DEFECT_CORRECT_ENABLE		0x0b06
#define SMIAPP_REG_U8_SINGLE_DEFECT_CORRECT_WEIGHT		0x0b07
#define SMIAPP_REG_U8_DYNAMIC_COUPLET_CORRECT_ENABLE		0x0b08
#define SMIAPP_REG_U8_DYNAMIC_COUPLET_CORRECT_WEIGHT		0x0b09
#define SMIAPP_REG_U8_COMBINED_DEFECT_CORRECT_ENABLE		0x0b0a
#define SMIAPP_REG_U8_COMBINED_DEFECT_CORRECT_WEIGHT		0x0b0b
#define SMIAPP_REG_U8_MODULE_SPECIFIC_CORRECTION_ENABLE		0x0b0c
#define SMIAPP_REG_U8_MODULE_SPECIFIC_CORRECTION_WEIGHT		0x0b0d
#define SMIAPP_REG_U8_MAPPED_LINE_DEFECT_CORRECT_ENABLE		0x0b0e
#define SMIAPP_REG_U8_MAPPED_LINE_DEFECT_CORRECT_ADJUST		0x0b0f
#define SMIAPP_REG_U8_MAPPED_COUPLET_CORRECT_ADJUST		0x0b10
#define SMIAPP_REG_U8_MAPPED_TRIPLET_DEFECT_CORRECT_ENABLE	0x0b11
#define SMIAPP_REG_U8_MAPPED_TRIPLET_DEFECT_CORRECT_ADJUST	0x0b12
#define SMIAPP_REG_U8_DYNAMIC_TRIPLET_DEFECT_CORRECT_ENABLE	0x0b13
#define SMIAPP_REG_U8_DYNAMIC_TRIPLET_DEFECT_CORRECT_ADJUST	0x0b14
#define SMIAPP_REG_U8_DYNAMIC_LINE_DEFECT_CORRECT_ENABLE	0x0b15
#define SMIAPP_REG_U8_DYNAMIC_LINE_DEFECT_CORRECT_ADJUST	0x0b16
#define SMIAPP_REG_U8_EDOF_MODE					0x0b80
#define SMIAPP_REG_U8_SHARPNESS					0x0b83
#define SMIAPP_REG_U8_DENOISING					0x0b84
#define SMIAPP_REG_U8_MODULE_SPECIFIC				0x0b85
#define SMIAPP_REG_U16_DEPTH_OF_FIELD				(0x0b86 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_FOCUS_DISTANCE				(0x0b88 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_ESTIMATION_MODE_CTRL			0x0b8a
#define SMIAPP_REG_U16_COLOUR_TEMPERATURE			(0x0b8c | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ABSOLUTE_GAIN_GREENR			(0x0b8e | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ABSOLUTE_GAIN_RED			(0x0b90 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ABSOLUTE_GAIN_BLUE			(0x0b92 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_ABSOLUTE_GAIN_GREENB			(0x0b94 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_ESTIMATION_ZONE_MODE			0x0bc0
#define SMIAPP_REG_U16_FIXED_ZONE_WEIGHTING			(0x0bc2 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_CUSTOM_ZONE_X_START			(0x0bc4 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_CUSTOM_ZONE_Y_START			(0x0bc6 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_CUSTOM_ZONE_WIDTH			(0x0bc8 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_CUSTOM_ZONE_HEIGHT			(0x0bca | CCS_FL_16BIT)
#define SMIAPP_REG_U8_GLOBAL_RESET_CTRL1			0x0c00
#define SMIAPP_REG_U8_GLOBAL_RESET_CTRL2			0x0c01
#define SMIAPP_REG_U8_GLOBAL_RESET_MODE_CONFIG_1		0x0c02
#define SMIAPP_REG_U8_GLOBAL_RESET_MODE_CONFIG_2		0x0c03
#define SMIAPP_REG_U16_TRDY_CTRL				(0x0c04 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TRDOUT_CTRL				(0x0c06 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TSHUTTER_STROBE_DELAY_CTRL		(0x0c08 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TSHUTTER_STROBE_WIDTH_CTRL		(0x0c0a | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TFLASH_STROBE_DELAY_CTRL			(0x0c0c | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TFLASH_STROBE_WIDTH_HIGH_CTRL		(0x0c0e | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TGRST_INTERVAL_CTRL			(0x0c10 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_FLASH_STROBE_ADJUSTMENT			0x0c12
#define SMIAPP_REG_U16_FLASH_STROBE_START_POINT			(0x0c14 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TFLASH_STROBE_DELAY_RS_CTRL		(0x0c16 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TFLASH_STROBE_WIDTH_HIGH_RS_CTRL		(0x0c18 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_FLASH_MODE_RS				0x0c1a
#define SMIAPP_REG_U8_FLASH_TRIGGER_RS				0x0c1b
#define SMIAPP_REG_U8_FLASH_STATUS				0x0c1c
#define SMIAPP_REG_U8_SA_STROBE_MODE				0x0c1d
#define SMIAPP_REG_U16_SA_STROBE_START_POINT			(0x0c1e | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TSA_STROBE_DELAY_CTRL			(0x0c20 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TSA_STROBE_WIDTH_CTRL			(0x0c22 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_SA_STROBE_TRIGGER				0x0c24
#define SMIAPP_REG_U8_SPECIAL_ACTUATOR_STATUS			0x0c25
#define SMIAPP_REG_U16_TFLASH_STROBE_WIDTH2_HIGH_RS_CTRL	(0x0c26 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TFLASH_STROBE_WIDTH_LOW_RS_CTRL		(0x0c28 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_TFLASH_STROBE_COUNT_RS_CTRL		0x0c2a
#define SMIAPP_REG_U8_TFLASH_STROBE_COUNT_CTRL			0x0c2b
#define SMIAPP_REG_U16_TFLASH_STROBE_WIDTH2_HIGH_CTRL		(0x0c2c | CCS_FL_16BIT)
#define SMIAPP_REG_U16_TFLASH_STROBE_WIDTH_LOW_CTRL		(0x0c2e | CCS_FL_16BIT)
#define SMIAPP_REG_U8_LOW_LEVEL_CTRL				0x0c80
#define SMIAPP_REG_U16_MAIN_TRIGGER_REF_POINT			(0x0c82 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAIN_TRIGGER_T3				(0x0c84 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_MAIN_TRIGGER_COUNT			0x0c86
#define SMIAPP_REG_U16_PHASE1_TRIGGER_T3			(0x0c88 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_PHASE1_TRIGGER_COUNT			0x0c8a
#define SMIAPP_REG_U16_PHASE2_TRIGGER_T3			(0x0c8c | CCS_FL_16BIT)
#define SMIAPP_REG_U8_PHASE2_TRIGGER_COUNT			0x0c8e
#define SMIAPP_REG_U8_MECH_SHUTTER_CTRL				0x0d00
#define SMIAPP_REG_U8_OPERATION_MODE				0x0d01
#define SMIAPP_REG_U8_ACT_STATE1				0x0d02
#define SMIAPP_REG_U8_ACT_STATE2				0x0d03
#define SMIAPP_REG_U16_FOCUS_CHANGE				(0x0d80 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_FOCUS_CHANGE_CONTROL			(0x0d82 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_FOCUS_CHANGE_NUMBER_PHASE1		(0x0d84 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_FOCUS_CHANGE_NUMBER_PHASE2		(0x0d86 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_STROBE_COUNT_PHASE1			0x0d88
#define SMIAPP_REG_U8_STROBE_COUNT_PHASE2			0x0d89
#define SMIAPP_REG_U8_POSITION					0x0d8a
#define SMIAPP_REG_U8_BRACKETING_LUT_CONTROL			0x0e00
#define SMIAPP_REG_U8_BRACKETING_LUT_MODE			0x0e01
#define SMIAPP_REG_U8_BRACKETING_LUT_ENTRY_CONTROL		0x0e02
#define SMIAPP_REG_U8_LUT_PARAMETERS_START			0x0e10
#define SMIAPP_REG_U8_LUT_PARAMETERS_END			0x0eff
#define SMIAPP_REG_U16_INTEGRATION_TIME_CAPABILITY		(0x1000 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_COARSE_INTEGRATION_TIME_MIN		(0x1004 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_COARSE_INTEGRATION_TIME_MAX_MARGIN	(0x1006 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_FINE_INTEGRATION_TIME_MIN		(0x1008 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_FINE_INTEGRATION_TIME_MAX_MARGIN		(0x100a | CCS_FL_16BIT)
#define SMIAPP_REG_U16_DIGITAL_GAIN_CAPABILITY			(0x1080 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_DIGITAL_GAIN_MIN				(0x1084 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_DIGITAL_GAIN_MAX				(0x1086 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_DIGITAL_GAIN_STEP_SIZE			(0x1088 | CCS_FL_16BIT)
#define SMIAPP_REG_F32_MIN_EXT_CLK_FREQ_HZ			(0x1100 | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_F32_MAX_EXT_CLK_FREQ_HZ			(0x1104 | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_U16_MIN_PRE_PLL_CLK_DIV			(0x1108 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_PRE_PLL_CLK_DIV			(0x110a | CCS_FL_16BIT)
#define SMIAPP_REG_F32_MIN_PLL_IP_FREQ_HZ			(0x110c | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_F32_MAX_PLL_IP_FREQ_HZ			(0x1110 | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_U16_MIN_PLL_MULTIPLIER			(0x1114 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_PLL_MULTIPLIER			(0x1116 | CCS_FL_16BIT)
#define SMIAPP_REG_F32_MIN_PLL_OP_FREQ_HZ			(0x1118 | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_F32_MAX_PLL_OP_FREQ_HZ			(0x111c | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_U16_MIN_VT_SYS_CLK_DIV			(0x1120 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_VT_SYS_CLK_DIV			(0x1122 | CCS_FL_16BIT)
#define SMIAPP_REG_F32_MIN_VT_SYS_CLK_FREQ_HZ			(0x1124 | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_F32_MAX_VT_SYS_CLK_FREQ_HZ			(0x1128 | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_F32_MIN_VT_PIX_CLK_FREQ_HZ			(0x112c | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_F32_MAX_VT_PIX_CLK_FREQ_HZ			(0x1130 | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_U16_MIN_VT_PIX_CLK_DIV			(0x1134 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_VT_PIX_CLK_DIV			(0x1136 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MIN_FRAME_LENGTH_LINES			(0x1140 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_FRAME_LENGTH_LINES			(0x1142 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MIN_LINE_LENGTH_PCK			(0x1144 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_LINE_LENGTH_PCK			(0x1146 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MIN_LINE_BLANKING_PCK			(0x1148 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MIN_FRAME_BLANKING_LINES			(0x114a | CCS_FL_16BIT)
#define SMIAPP_REG_U8_MIN_LINE_LENGTH_PCK_STEP_SIZE		0x114c
#define SMIAPP_REG_U16_MIN_OP_SYS_CLK_DIV			(0x1160 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_OP_SYS_CLK_DIV			(0x1162 | CCS_FL_16BIT)
#define SMIAPP_REG_F32_MIN_OP_SYS_CLK_FREQ_HZ			(0x1164 | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_F32_MAX_OP_SYS_CLK_FREQ_HZ			(0x1168 | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_U16_MIN_OP_PIX_CLK_DIV			(0x116c | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_OP_PIX_CLK_DIV			(0x116e | CCS_FL_16BIT)
#define SMIAPP_REG_F32_MIN_OP_PIX_CLK_FREQ_HZ			(0x1170 | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_F32_MAX_OP_PIX_CLK_FREQ_HZ			(0x1174 | CCS_FL_FLOAT_IREAL | CCS_FL_32BIT)
#define SMIAPP_REG_U16_X_ADDR_MIN				(0x1180 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_Y_ADDR_MIN				(0x1182 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_X_ADDR_MAX				(0x1184 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_Y_ADDR_MAX				(0x1186 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MIN_X_OUTPUT_SIZE			(0x1188 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MIN_Y_OUTPUT_SIZE			(0x118a | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_X_OUTPUT_SIZE			(0x118c | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_Y_OUTPUT_SIZE			(0x118e | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MIN_EVEN_INC				(0x11c0 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_EVEN_INC				(0x11c2 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MIN_ODD_INC				(0x11c4 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_ODD_INC				(0x11c6 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_SCALING_CAPABILITY			(0x1200 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_SCALER_M_MIN				(0x1204 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_SCALER_M_MAX				(0x1206 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_SCALER_N_MIN				(0x1208 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_SCALER_N_MAX				(0x120a | CCS_FL_16BIT)
#define SMIAPP_REG_U16_SPATIAL_SAMPLING_CAPABILITY		(0x120c | CCS_FL_16BIT)
#define SMIAPP_REG_U8_DIGITAL_CROP_CAPABILITY			0x120e
#define SMIAPP_REG_U16_COMPRESSION_CAPABILITY			(0x1300 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MATRIX_ELEMENT_REDINRED			(0x1400 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MATRIX_ELEMENT_GREENINRED		(0x1402 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MATRIX_ELEMENT_BLUEINRED			(0x1404 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MATRIX_ELEMENT_REDINGREEN		(0x1406 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MATRIX_ELEMENT_GREENINGREEN		(0x1408 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MATRIX_ELEMENT_BLUEINGREEN		(0x140a | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MATRIX_ELEMENT_REDINBLUE			(0x140c | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MATRIX_ELEMENT_GREENINBLUE		(0x140e | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MATRIX_ELEMENT_BLUEINBLUE		(0x1410 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_FIFO_SIZE_PIXELS				(0x1500 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_FIFO_SUPPORT_CAPABILITY			0x1502
#define SMIAPP_REG_U8_DPHY_CTRL_CAPABILITY			0x1600
#define SMIAPP_REG_U8_CSI_LANE_MODE_CAPABILITY			0x1601
#define SMIAPP_REG_U8_CSI_SIGNALLING_MODE_CAPABILITY		0x1602
#define SMIAPP_REG_U8_FAST_STANDBY_CAPABILITY			0x1603
#define SMIAPP_REG_U8_CCI_ADDRESS_CONTROL_CAPABILITY		0x1604
#define SMIAPP_REG_U32_MAX_PER_LANE_BITRATE_1_LANE_MODE_MBPS	(0x1608 | CCS_FL_32BIT)
#define SMIAPP_REG_U32_MAX_PER_LANE_BITRATE_2_LANE_MODE_MBPS	(0x160c | CCS_FL_32BIT)
#define SMIAPP_REG_U32_MAX_PER_LANE_BITRATE_3_LANE_MODE_MBPS	(0x1610 | CCS_FL_32BIT)
#define SMIAPP_REG_U32_MAX_PER_LANE_BITRATE_4_LANE_MODE_MBPS	(0x1614 | CCS_FL_32BIT)
#define SMIAPP_REG_U8_TEMP_SENSOR_CAPABILITY			0x1618
#define SMIAPP_REG_U16_MIN_FRAME_LENGTH_LINES_BIN		(0x1700 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_FRAME_LENGTH_LINES_BIN		(0x1702 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MIN_LINE_LENGTH_PCK_BIN			(0x1704 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MAX_LINE_LENGTH_PCK_BIN			(0x1706 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_MIN_LINE_BLANKING_PCK_BIN		(0x1708 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_FINE_INTEGRATION_TIME_MIN_BIN		(0x170a | CCS_FL_16BIT)
#define SMIAPP_REG_U16_FINE_INTEGRATION_TIME_MAX_MARGIN_BIN	(0x170c | CCS_FL_16BIT)
#define SMIAPP_REG_U8_BINNING_CAPABILITY			0x1710
#define SMIAPP_REG_U8_BINNING_WEIGHTING_CAPABILITY		0x1711
#define SMIAPP_REG_U8_BINNING_SUBTYPES				0x1712
#define SMIAPP_REG_U8_BINNING_TYPE_n(n)				(0x1713 + (n)) /* 1 <= n <= 237 */
#define SMIAPP_REG_U8_DATA_TRANSFER_IF_CAPABILITY		0x1800
#define SMIAPP_REG_U8_SHADING_CORRECTION_CAPABILITY		0x1900
#define SMIAPP_REG_U8_GREEN_IMBALANCE_CAPABILITY		0x1901
#define SMIAPP_REG_U8_BLACK_LEVEL_CAPABILITY			0x1902
#define SMIAPP_REG_U8_MODULE_SPECIFIC_CORRECTION_CAPABILITY	0x1903
#define SMIAPP_REG_U16_DEFECT_CORRECTION_CAPABILITY		(0x1904 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_DEFECT_CORRECTION_CAPABILITY_2		(0x1906 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_EDOF_CAPABILITY				0x1980
#define SMIAPP_REG_U8_ESTIMATION_FRAMES				0x1981
#define SMIAPP_REG_U8_SUPPORTS_SHARPNESS_ADJ			0x1982
#define SMIAPP_REG_U8_SUPPORTS_DENOISING_ADJ			0x1983
#define SMIAPP_REG_U8_SUPPORTS_MODULE_SPECIFIC_ADJ		0x1984
#define SMIAPP_REG_U8_SUPPORTS_DEPTH_OF_FIELD_ADJ		0x1985
#define SMIAPP_REG_U8_SUPPORTS_FOCUS_DISTANCE_ADJ		0x1986
#define SMIAPP_REG_U8_COLOUR_FEEDBACK_CAPABILITY		0x1987
#define SMIAPP_REG_U8_EDOF_SUPPORT_AB_NXM			0x1988
#define SMIAPP_REG_U8_ESTIMATION_MODE_CAPABILITY		0x19c0
#define SMIAPP_REG_U8_ESTIMATION_ZONE_CAPABILITY		0x19c1
#define SMIAPP_REG_U16_EST_DEPTH_OF_FIELD			(0x19c2 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_EST_FOCUS_DISTANCE			(0x19c4 | CCS_FL_16BIT)
#define SMIAPP_REG_U16_CAPABILITY_TRDY_MIN			(0x1a00 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_FLASH_MODE_CAPABILITY			0x1a02
#define SMIAPP_REG_U16_MECH_SHUT_AND_ACT_START_ADDR		(0x1b02 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_ACTUATOR_CAPABILITY			0x1b04
#define SMIAPP_REG_U16_ACTUATOR_TYPE				(0x1b40 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_AF_DEVICE_ADDRESS				0x1b42
#define SMIAPP_REG_U16_FOCUS_CHANGE_ADDRESS			(0x1b44 | CCS_FL_16BIT)
#define SMIAPP_REG_U8_BRACKETING_LUT_CAPABILITY_1		0x1c00
#define SMIAPP_REG_U8_BRACKETING_LUT_CAPABILITY_2		0x1c01
#define SMIAPP_REG_U8_BRACKETING_LUT_SIZE			0x1c02

/* Register bit definitions */
#define SMIAPP_IMAGE_ORIENTATION_HFLIP			BIT(0)
#define SMIAPP_IMAGE_ORIENTATION_VFLIP			BIT(1)

#define SMIAPP_DATA_TRANSFER_IF_1_CTRL_EN		BIT(0)
#define SMIAPP_DATA_TRANSFER_IF_1_CTRL_WR_EN		BIT(1)
#define SMIAPP_DATA_TRANSFER_IF_1_CTRL_ERR_CLEAR	BIT(2)
#define SMIAPP_DATA_TRANSFER_IF_1_STATUS_RD_READY	BIT(0)
#define SMIAPP_DATA_TRANSFER_IF_1_STATUS_WR_READY	BIT(1)
#define SMIAPP_DATA_TRANSFER_IF_1_STATUS_EDATA		BIT(2)
#define SMIAPP_DATA_TRANSFER_IF_1_STATUS_EUSAGE		BIT(3)

#define SMIAPP_DATA_TRANSFER_IF_CAPABILITY_SUPPORTED	BIT(0)
#define SMIAPP_DATA_TRANSFER_IF_CAPABILITY_POLL		BIT(2)

#define SMIAPP_SOFTWARE_RESET				BIT(0)

#define SMIAPP_FLASH_MODE_CAPABILITY_SINGLE_STROBE	BIT(0)
#define SMIAPP_FLASH_MODE_CAPABILITY_MULTIPLE_STROBE	BIT(1)

#define SMIAPP_CSI_SIGNALLING_MODE_CCP2_DATA_CLOCK	0
#define SMIAPP_CSI_SIGNALLING_MODE_CCP2_DATA_STROBE	1
#define SMIAPP_CSI_SIGNALLING_MODE_CSI2			2

#define SMIAPP_DPHY_CTRL_AUTOMATIC			0
/* DPHY control based on REQUESTED_LINK_BIT_RATE_MBPS */
#define SMIAPP_DPHY_CTRL_UI				1
#define SMIAPP_DPHY_CTRL_REGISTER			2

#define SMIAPP_COMPRESSION_MODE_SIMPLE_PREDICTOR	1
#define SMIAPP_COMPRESSION_MODE_ADVANCED_PREDICTOR	2

#define SMIAPP_MODE_SELECT_SOFTWARE_STANDBY		0
#define SMIAPP_MODE_SELECT_STREAMING			1

#define SMIAPP_SCALING_MODE_NONE			0
#define SMIAPP_SCALING_MODE_HORIZONTAL			1
#define SMIAPP_SCALING_MODE_BOTH			2

#define SMIAPP_SCALING_CAPABILITY_NONE			0
#define SMIAPP_SCALING_CAPABILITY_HORIZONTAL		1
#define SMIAPP_SCALING_CAPABILITY_BOTH			2 /* horizontal/both */

/* digital crop right before scaler */
#define SMIAPP_DIGITAL_CROP_CAPABILITY_NONE		0
#define SMIAPP_DIGITAL_CROP_CAPABILITY_INPUT_CROP	1

#define SMIAPP_DIGITAL_GAIN_CAPABILITY_PER_CHANNEL	1

#define SMIAPP_BINNING_CAPABILITY_NO			0
#define SMIAPP_BINNING_CAPABILITY_YES			1

/* Maximum number of binning subtypes */
#define SMIAPP_BINNING_SUBTYPES				253

#define SMIAPP_PIXEL_ORDER_GRBG				0
#define SMIAPP_PIXEL_ORDER_RGGB				1
#define SMIAPP_PIXEL_ORDER_BGGR				2
#define SMIAPP_PIXEL_ORDER_GBRG				3

#define SMIAPP_DATA_FORMAT_MODEL_TYPE_NORMAL		1
#define SMIAPP_DATA_FORMAT_MODEL_TYPE_EXTENDED		2
#define SMIAPP_DATA_FORMAT_MODEL_TYPE_NORMAL_N		8
#define SMIAPP_DATA_FORMAT_MODEL_TYPE_EXTENDED_N	16

#define SMIAPP_FRAME_FORMAT_MODEL_TYPE_2BYTE		0x01
#define SMIAPP_FRAME_FORMAT_MODEL_TYPE_4BYTE		0x02
#define SMIAPP_FRAME_FORMAT_MODEL_SUBTYPE_NROWS_MASK	0x0f
#define SMIAPP_FRAME_FORMAT_MODEL_SUBTYPE_NCOLS_MASK	0xf0
#define SMIAPP_FRAME_FORMAT_MODEL_SUBTYPE_NCOLS_SHIFT	4

#define SMIAPP_FRAME_FORMAT_DESC_2_PIXELCODE_MASK	0xf000
#define SMIAPP_FRAME_FORMAT_DESC_2_PIXELCODE_SHIFT	12
#define SMIAPP_FRAME_FORMAT_DESC_2_PIXELS_MASK		0x0fff

#define SMIAPP_FRAME_FORMAT_DESC_4_PIXELCODE_MASK	0xf0000000
#define SMIAPP_FRAME_FORMAT_DESC_4_PIXELCODE_SHIFT	28
#define SMIAPP_FRAME_FORMAT_DESC_4_PIXELS_MASK		0x0000ffff

#define SMIAPP_FRAME_FORMAT_DESC_PIXELCODE_EMBEDDED	1
#define SMIAPP_FRAME_FORMAT_DESC_PIXELCODE_DUMMY	2
#define SMIAPP_FRAME_FORMAT_DESC_PIXELCODE_BLACK	3
#define SMIAPP_FRAME_FORMAT_DESC_PIXELCODE_DARK		4
#define SMIAPP_FRAME_FORMAT_DESC_PIXELCODE_VISIBLE	5

#define SMIAPP_FAST_STANDBY_CTRL_COMPLETE_FRAMES	0
#define SMIAPP_FAST_STANDBY_CTRL_IMMEDIATE		1

/* Scaling N factor */
#define SMIAPP_SCALE_N					16

#endif /* __SMIAPP_REG_DEFS_H__ */
