# include	<ingres.h>
# include	<access.h>
# include 	<opsys.h>

/*
**	LAST_PAGE -- computes a tid for the last page in the relation.
*/

last_page(d, tid, buf)
register DESC		*d;
register TID		*tid;
register struct accbuf	*buf;
{
	long		lpage;
	struct stat	stats;

	if ((buf != 0) && (abs(d->reldum.relspec) == M_HEAP) && (buf->mainpg == 0) && (buf->ovflopg == 0))
		lpage = buf->thispage;
	else
	{
		if (fstat(d->relfp, &stats))
			syserr("last_page: fstat err %.14s", d->reldum.relid);
		lpage = stats.st_size / PGSIZE - 1;
#		ifdef xATR2
		if (tTf(26, 8))
			printf("fstat-lp %.12s %ld\n", d->reldum.relid, lpage);
#		endif
	}
	stuff_page(tid, &lpage);
	tid->line_id = 0;
	return (0);
}
