#include "gopher.h"


/*
 * Connect_To_Gopher Performs a connecting to socket 'service' on host
 * 'host'.  Host can be a hostname or ip-address.  If 'host' is null, the
 * local host is assumed.   The parameter full_hostname will, on return,
 * contain the expanded hostname (if possible).  Note that full_hostname is a
 * pointer to a char *, and is allocated by connect_to_gopher()
 *
 * Errors:
 *
 * -1 get service failed
 *
 * -2 get host failed
 *
 * -3 socket call failed
 *
 * -4 connect call failed
 */

int connect_to_gopher(host)
  char *host;
{
     int s, service;
     char  buf[MAXSTR];
     struct sockaddr_in server;
     struct hostent *hp;

     service = 7000;
     
     if (host == '\0') {
	  gethostname(buf, sizeof(buf));
	  host = buf;
     }

     if ((server.sin_addr.s_addr = inet_addr(host)) == -1) {
	  if (hp = gethostbyname(host)) {
	       bzero((char *) &server, sizeof(server));
	       bcopy(hp->h_addr, (char *) &server.sin_addr, hp->h_length);
	       server.sin_family = hp->h_addrtype;
	  } else
	       return (-2);
     } else
	  server.sin_family = AF_INET;

     server.sin_port = (unsigned short) htons(service);

     if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	  return (-3);

     setsockopt(s, SOL_SOCKET, ~SO_LINGER, 0, 0);
     setsockopt(s, SOL_SOCKET, SO_REUSEADDR, 0, 0);
     setsockopt(s, SOL_SOCKET, SO_KEEPALIVE, 0, 0);
     if (connect(s, &server, sizeof(server)) < 0) {
	  close(s);
	  return (-4);
     }
     return s;
}



void check_sock(sockfd, iNum)
  int sockfd, iNum;
{
     char DispString[80];
     char Response[40];

     Response[0] = '\0';
     
     switch(sockfd)  {
     case -4:
	  fprintf(stderr, "connect call failed ");
	  break;
     case -3:
	  (void)fprintf(stderr, "socket call failed");
	  break;
     case -2:
	  (void)fprintf(stderr, "get host failed");
	  break;
     case -1:
	  (void)fprintf(stderr, "get service failed");
	  break;
     }
     fprintf(stderr, "to host %s, port %d\n",
	     Gopher[iNum].sHost, Gopher[iNum].iPort);
     exit(-1);
     
}




char Playcmd[80];



main(argc, argv)
  int argc;
  char *argv[];
{
     int sockfd, length, i;
     char inputline[512];

     strcpy(Playcmd, "play - ");
     
     /*** add any extra command line params to the play command ***/

     if (argc > 2) {
	  for (i= 3; i <= argc; i++)
	       strcat(Playcmd, argv[i+1]);
     }

     if ((sockfd = connect_to_gopher(argv[1], atoi(argv[2])) ) < 0) {
	  check_sock(sockfd, argv[1]);
	  exit(-1);
     }

     /*** Send off a bogus line to start up the radio. ***/

     writestring(sockfd, "How's about some sound?\r\n");

/*     length = readline(sockfd, inputline, 512);
     if (inputline[0]=='-') {
	  fprintf(stderr, "%s\n", inputline + 2);
          return;
     }
*/
     
     suck_sound(sockfd);
	  
}


/*
 * this procedure just retrieves binary data from the socket and
 * pumps it into a "play" process.
 */

#define BUFSIZE 1400  /* A pretty good value for ethernet */

suck_sound(sockfd)
  int sockfd;
{
     FILE *Play;
     int j;
     char buf[BUFSIZE];

     if (Playcmd[0] == '\0')
          /*** Hey! no play command, bummer ***/
          /*** TODO, notify user that there isn't a play command, damn.***/
          return(0);

     Play = popen(Playcmd, "w");

     while(1) {
          j = read(sockfd, buf, BUFSIZE);

          if (j == 0)
               break;

          fwrite(buf, 1, j, Play);
     }
}

