/*
 * confirm.c : A popup yes/no confirmer
 *
 * George Ferguson, ferguson@cs.rochester.edu, 4 Sep 1991.
 *
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Cardinals.h>
#include <stdio.h>
extern Widget toplevel;			/* this is the only external */

/*
 * Functions defined here
 */
Boolean confirm0();			/* main public routines */
Boolean confirm1();
void confirmYes(), confirmNo();		/* public action procedures */

static Widget confirmShell,confirmDialog;
static Boolean confirmDone;
static Boolean confirmResult;

Boolean
confirm0(str)
char *str;
{
    Arg args[2];
    XEvent event;
    Window rwin,child;
    int rx,ry,cx,cy,x,y;
    unsigned int but;
    Dimension w,h;

    /* Go synchronous or the widgets don't resize properly */
    XSynchronize(XtDisplay(toplevel),True);
    /* If the popup isn't created yet, then create it */
    if (confirmShell == NULL) {
	confirmShell = XtCreatePopupShell("confirmShell",
					  transientShellWidgetClass,
					  toplevel,NULL,ZERO);
	confirmDialog = XtCreateManagedWidget("confirmDialog",
					      dialogWidgetClass,
					      confirmShell,NULL,ZERO);
	XawDialogAddButton(confirmDialog,"yesButton",confirmYes,NULL);
	XawDialogAddButton(confirmDialog,"noButton",confirmNo,NULL);
	XtRealizeWidget(confirmShell);
    }
    /* Set the label */
    XtSetArg(args[0],XtNlabel,str);
    XtSetValues(confirmDialog,args,ONE);
    /* Center the popup over the mouse */
    XtSetArg(args[0],XtNwidth,&w);
    XtSetArg(args[1],XtNheight,&h);
    XtGetValues(confirmShell,args,TWO);
    XQueryPointer(XtDisplay(toplevel),XtWindow(toplevel),
					&rwin,&child,&rx,&ry,&cx,&cy,&but);
    x = rx-w/2;
    if (x < 0)
	x = 0;
    else if (x > WidthOfScreen(XtScreen(toplevel))-w)
	x = WidthOfScreen(XtScreen(toplevel))-w;
    y = ry-h/2;
    if (y < 0)
	y = 0;
    else if (y > HeightOfScreen(XtScreen(toplevel))-h)
	y = WidthOfScreen(XtScreen(toplevel))-h;
    XtSetArg(args[0],XtNx,x);
    XtSetArg(args[1],XtNy,y);
    XtSetValues(confirmShell,args,TWO);
    /* Beep */
    XBell(XtDisplay(toplevel),0);
    /* Pop it up and block until one of the buttons is clicked */
    confirmDone = False;
    XtPopup(confirmShell,XtGrabExclusive);
    while (!confirmDone) {
	XtAppNextEvent(XtWidgetToApplicationContext(toplevel),&event);
	XtDispatchEvent(&event);
    }
    /* Okay, pop it down */
    XtPopdown(confirmShell);
    /* Back to normal */
    XSynchronize(XtDisplay(toplevel),False);
    /* And here's the selected value */
    return(confirmResult);
}

Boolean
confirm1(fmt,arg)
char *fmt,*arg;
{
    char buf[256];

    sprintf(buf,fmt,arg);
    return(confirm0(buf));
}

/*ARGSUSED*/
void
confirmYes(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    confirmResult = True;
    confirmDone = True;
}

/*ARGSUSED*/
void
confirmNo(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    confirmResult = False;
    confirmDone = True;
}
