/* gopher.h
   main gopher data structures */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing Services Office                      */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#ifndef G_GOPHER_H
#define G_GOPHER_H

#include "conf.h"

#define BOOLEAN		int		/* for TRUE/FALSE variables */

typedef	long	gopherTime;
#define	NOT_LOADED	-99		/* special "time" */


#define vStringValue(vs) (vs)->data

typedef struct vStringStruct {
	int	len;			/* allocated length */
	char	*data;			/* string value */
	} vString;


/* gopherItem reflects the gopher directory structure of the protocol 
   plus a link to create lists of items. */

typedef struct gopherItemStruct {
	char		type;
	char		userStringAndPrefix[PREFIX_LEN + USER_STRING_LEN];
	vString		selector;
	char		host[HOST_STRING_LEN];
	int		port;
	struct gopherItemStruct *next;
	} gopherItem, *gopherItemP;

/* header for a list of gopherItem's */

typedef struct gopherItemListStruct {
	gopherItemP	first;
	gopherItemP	last;
	} gopherItemList, *gopherItemListP;

/* userStringAndPrefix contains two strings concatenated together.
   The components, prefix and userString, are accesses with these macros. */

#define USER_STRING_PREFIX(gi)	(gi->userStringAndPrefix)
#define USER_STRING(gi)		((gi->userStringAndPrefix)+PREFIX_LEN)




/* Types of objects returned from a server */

#define A_FILE		'0'
#define A_DIRECTORY	'1'
#define A_CSO		'2'
#define A_ERROR		'3'
#define A_MAC_BINHEX	'4'
#define A_DOS_BINHEX	'5'
#define A_UNIX_UUENCODE	'6'
#define A_INDEX		'7'
#define A_TELNET	'8'
#define A_CNS		'9'
#define A_DUP_SERVER	'+'
#define A_SOUND		's'
#define A_EVENT		'e'
#define A_CALENDAR	'c'
#define A_EOI		'.'

#define A_BADREAD	'@'



/* gopher directory data structures */

/* gopherDir maintains the contents of a directory, and the
   information required to reobtain the directory when necessary.
   The data structure reflects the dynamic n-ary tree structure
   of the gopher-space. */

typedef struct gopherDirStruct {
	struct gopherDirStruct	*parent;
	struct gopherDirStruct	*sibling;
	struct gopherDirStruct	*child;
	struct gopherDirStruct	*next;		/* for list e.g., free, mark */
	int			markCount;
	BOOLEAN			active;
	gopherItemP		selectorItem;
	gopherItemList		contents;
	gopherTime		created;     
	char			*indexSearchString;
	} gopherDir, *gopherDirP;


/* header for a list of gopherDir's */

typedef struct gopherDirListStruct {
        gopherDirP     first;
        gopherDirP     last;
        } gopherDirList, *gopherDirListP;

#endif /* G_GOPHER_H */
