/**********************************************************************

This header file declares the routines used to take in XawText-type
manipulations and instead perform operations on a Motif list widget.
This was the simplest way to convert xrn to Motif while still
retaining most of the original code.  By translating at a lower level,
more modifications and fixes to xrn can be done once without worry
about Xaw vs. Motif.

Currently, the code for these routines is in buttons.c.  It would be
more correct to separate this into a separate file, but then this
complicates the Makefile for when MOTIF is defined vs. when it isn't.

**********************************************************************/

typedef int XawTextPosition;

#define XawTextDisableRedisplay XawNothing	/* no equivalent */
#define XawTextEnableRedisplay XawNothing	/* no equivalent */

extern void XawNothing();		/* empty proc */
extern int XawTextToMotifIndex();	/* convert text pos to list index */
extern void XawTextInvalidate();	/* update partial list content */
extern void XawTextInvalidateAll();	/* update entire list content */
extern void XawTextSetMotifString();	/* remember text string for list */
extern void XawTextSetInsertionPoint();	/* highlight particular list item */
extern XmTextPosition XawTextGetInsertionPoint();	/* get highlight pos */
extern void XawTextUnsetSelection();	/* no user selection */
extern void XawTextGetSelectionPos();	/* find user select. (vs. highlight) */
extern int XawTextTopPosition();	/* get top item position */

extern Widget ChooseText();		/* switch between text, list widgets */
extern int DesiredBoxHeight();		/* calculate height of button box */
extern void TextListSelection();	/* user selects list item callback */

