#include	<stdio.h>
#include	<midi.h>
#include	<sys/ioctl.h>
#include	<mpuvar.h>

main(argc, argv)
char	*argv[];
{
	int i, arg, fh;

	if ((fh = open("/dev/mpu0", 2)) < 0) {
	    perror("/dev/mpu0");
	    exit(1);
	}
	if (argc == 2) {				/* PEEK */
	    arg = atoi(argv[1]);
	    printf("ioctl(%d, PEEK, &arg) {arg = 0x%x} ", fh, arg);
	    i = ioctl(fh, MPU_IOC_PEEK, &arg);
	    printf("returns %d, now arg = 0x%x\n", i, arg);
	    if (i < 0)
		perror("ioctl(fh, PEEK, &arg)");
	} else if (argc == 3) {				/* POKE */
	    arg = atoi(argv[1]);
	    arg = (arg << 8) + (atoi(argv[2]) & 0xFF);
	    printf("ioctl(%d, POKE, &arg) {arg = 0x%x} ", fh, arg);
	    i = ioctl(fh, MPU_IOC_POKE, &arg);
	    printf("returns %d, now arg = 0x%x\n", i, arg);
	    if (i < 0)
		perror("ioctl(fh, POKE, &arg)");

	} else {
	    fprintf(stderr, "Usage: %s reg_offset [data]\n", argv[0]);
	    fprintf(stderr, "reg_offset is 0 for data and 1 for csr\n");
	    exit(2);
	}
}

		
		

