/*
**	mpu_immed(fd, buf)
**	Send MIDI data through MPU-401 immediately.
**	fd is file descriptor for MPU device
**	buf contains MIDI data with no time tags
**	psl 3/87
*/
#include <midi.h>
#include <mpuvar.h>

mpu_immed(fd, buf)
char	*buf;
{
	register char *cp;
	char cbuf[2];

	cbuf[0] = MPU_WANT_TO_SEND_DATA;
	for (cp = buf; *cp; cp++);
        MpuSetTrack(fd, MPU_TR_COM);
	write(fd, cbuf, 1);
	write(fd, buf, cp - buf);
        MpuSetTrack(fd, 0);
}
