/*
 * Fixes for ftpd for systems without chroot system call.
 *
 * Sam Shen (sls@ocf.berkeley.edu)
 *
 * Bugs pointed out and fixes kindly donated by
 * Richard Walker (walrmath@fac5.anu.edu.au)
 * Corey Geheim (cg377170@eng.clemson.edu)
 */
#include <string.h>
#undef NULL
#include <sys/param.h>

static char * root;
extern int guest;

int chroot(char * s)
{
    root = (char *) malloc(strlen(s)+2);
    if (!root)
	return -1;
    strcpy(root,s);
    strcat(root,"/");
    return 0;
}

char * next_component(char ** pp)
{
    static char buf[2][MAXPATHLEN];
    static int t = 0;
    int i;
    char * c, * component;
    component = buf[t];
    t = 1 - t;
    c = *pp;
    i = 0;
    while (*c) {
	component[i++] = *c;
	if (*c == '/') break;
	c++;
    }
    component[i] = '\0';
    if (*c) *pp = c + 1;
    else *pp = c;
    return component;
}

int dotdot(char * p)
{
    if (*p++ == '.')
	if (*p++ == '.')
	    if (!*p || *p == '/')
		return 1;
    return 0;
}

int singledot(char * p)
{
    if (*p++ == '.')
	if (!*p || *p == '/')
	    return 1;
    return 0;
}

int no_slashes(char * p)
{
    while (*p && *p != '/')
	p++;
    return *p == '/' ? 0 : 1;
}

char * _fixpath(char * p)
{
    static char buf[MAXPATHLEN];
    static char newpath[MAXPATHLEN];
    char * rt,* path, * rt_comp, * path_comp;
    int depth;
    int i;

    if (!guest) return p;
    if (no_slashes(p) && !dotdot(p)) return p;
    if (*p == '/') {
	strcpy(buf,root);
	p++;
    } else {
	if (getwd(buf) == 0) return NULL;
	strcat(buf,"/");
    }
    strcat(buf,p);
    path = buf;
    rt = root;
    newpath[0] = '\0';
    while (1) {
	rt_comp = next_component(&rt);
	if (!*rt_comp) break;
	path_comp = next_component(&path);
	if (strcmp(rt_comp,path_comp)) return NULL;
	strcat(newpath,path_comp);
    }
    depth = 0;
    while (*path_comp) {
	path_comp = next_component(&path);
	if (dotdot(path_comp)) {
	    if (depth != 0) {
		strcat(newpath,path_comp);
		depth--;
	    }
	} else {
	    strcat(newpath,path_comp);
	    if (!singledot(path_comp))
		depth++;
	}
    }
    return newpath;
}

