/*======================================================================
                    T Y P E S . H 
                    doc: Thu Sep  5 17:11:15 1991
                    dlm: Fri Nov 15 16:33:10 1991
                    (c) 1991 A.M.J. Thurnherr
                    uE-Info: 129 19 FALSE 0 0 72 2 2 ofnI
======================================================================*/

/* MPL */
/* Types:
	Fp		Floating Point Numbers
	Byte		Byte
	Bool		Boolean
	Col		Color
	Vec		4D Vector
	Vec3		3D Vector
	Pnt		4D Point
	Pnt3		3D Point
	Mat		4D Matrix
	Material	Material
	Stri		simple Triangle
	Tri		Triangle
	LST		Light Source Type
	LS		Light Source
	Obj		Object
	World		World Info
	PWorld		Plural World Info
	Ray		Ray
	Isect		Intersection
	PIsect		plural Intersection
	Box		Bounding Box
*/

#define	EPS	1e-5			/* Epsilon */
#define INF	1e9			/* Infinity */

typedef double	Fp;			/* Floating Point */
typedef char	Byte;

#define	TRUE	1
#define FALSE	0

typedef char	Bool;

#define	CR	0			/* Color Indices */
#define CG	1
#define CB	2

typedef Fp 	Col[3];

#define	VX	0			/* Vector coordinates */
#define	VY	1
#define	VZ	2
#define	VW	3

typedef Fp Vec[4],Vec3[3];
typedef Fp Pnt[4],Pnt3[3];
typedef Fp Mat[4][4];

typedef struct matStruct {		/* Material */
	Col	specular,		/* specular */
		ambient,		/* ambient */
		diffuse,		/* diffuse */
		emittant;		/* emittant */
	Fp	specularity;		/* specularity */
} Material;

#define	PA	0			/* Point Indices */
#define	PB	1
#define	PC	2
#define PD	3

#define NEAR	0			/* Frustrum Planes */
#define	FAR	1

typedef struct sTriStruct {		/* simple Triangle */
	int 	matId;			/* Material */
	Bool	bounded;		/* Triangle <-> Plane */
	Pnt3	v[3];			/* Vertices */
	Vec3	n[3];			/* Normals */
} STri;
	
typedef struct triStruct {		/* Triangle */
	int 	matId;			/* Material */
	Pnt3	v[3];			/* Vertices */
	Vec3	n[3];			/* Normals */
	Bool	bounded;		/* Triangle <-> Plane */

	Vec3	planeN;			/* Plane Normal Vector */
	Fp	planeD;			/* ofset */

	Fp	ABx,ABy,ABydivABx,ACx,ACy;
	Vec3	dNu,dNv;
	int	projC1,projC2;
} Tri;

typedef struct lstStruct {		/* Light Source Type*/
	Bool 	local;			/* local <-> direction */
	Col	ambient;		/* Ambient Light */
	Col	diffuse;
	Col	specular;		/* specular light */
} LST;

typedef struct lsStruct {		/* Light Source */
	int	lstId;			/* type */
	Vec3	pos;			/* Position */
	struct lsStruct *next;		/* Linked List */
} LS;

typedef struct objStruct {		/* Objec definition */
	int	nTri;			/* Number of Triangles */
	STri	*tList;			/* List of simple Triangles */
} Obj;

typedef struct rayStruct {		/* Ray */
	Pnt3	ori;			/* Origo */
	Vec3	dir;			/* Direction */
	Fp	len;			/* Length (for shadows) */
} Ray;

typedef struct isectStruct {		/* Intersection */
	Pnt3	pnt;			/* point */
	Vec3	nrm;			/* Normal */
	Vec3	planeN;			/* Real Plane Normal */
	int 	matId;			/* Triangle Data */
} Isect;

typedef plural struct PisectStruct {	/* Intersection */
	plural Tri *tri;
	Pnt3	pnt;			/* point */
	Fp	dist;			/* distance from raysource */
	Fp	u,v;			/* Triangle Parameters */
} PIsect;

typedef struct boxStruct {		/* Bounding Box */
	Vec3	min;			/* minimum extent */
	Vec3	max;			/* maximum extent */
} Box;

typedef struct worldStruct {		/* Worldinfo */
	int	nObj;			/* # of Objects */
	Obj	*oList;			/* Object List */
	Col	ambient;		/* global ambient light */
	int	nLST;			/* # of LightSourceTypes */
	LST	*lstList;		/* LST List */
	int	nMat;			/* # of materials */
	Material *mList;

	int	nTri;			/* # of Triangles read */
	LS	*lsList;		/* LS Linked List */
	Box	bBox;			/* global bounding Box */

	Bool	oriSurf;		/* orientable surfaces */
	Bool	flatShade;		/* use calc'ed normals */
} World;

typedef plural struct pWorldStruct {	/* plural worldinfo */
	int triSet;			/* # of Triangles per PE */
	Tri t;				/* ptr to Scene Triangles on PE */
} PWorld;
