#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************


CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine MaxMin (X, Y, NumCrv, NumPt)


************************************************************
*                                                          *
*  Subroutine Maximum_and_Minimum_Points                   *
*                                                          *
*    This routine is used to see if the new X & Y points   *
*    are one of the max and min points.                    *
*                                                          *
************************************************************


        Real          Xmax, Xmin, Ymax, Ymin
        Common /Data/ Xmax, Xmin, Ymax, Ymin
        Save   /Data/

        Real           WXmax, WXmin, WYmax, WYmin
        Common /windw/ WXmax, WXmin, WYmax, WYmin
        Save   /windw/

        Integer          max, num, maxC
        Common /Object/  max, num, maxC
        Save   /Object/

        Character *10   hix, hiy, lowx, lowy
        Common /winlbl/ hix, hiy, lowx, lowy
        Save   /winlbl/

        Integer NumPt(NumCrv), NumCrv, I, J
        Real    X(max,num), Y(max,num)

*       (* Initialize the max and min points to the first
*          X and Y point. *)
        Xmax = X(1,1)
        Xmin = X(1,1)
        Ymax = Y(1,1)
        Ymin = Y(1,1)

        DO 100 J = 1, NumCrv
          DO 200 I = 1, NumPt(J)
            IF (Xmax .LT. X(I,J)) Xmax = X(I,J)
            IF (Xmin .GT. X(I,J)) Xmin = X(I,J)
            IF (Ymax .LT. Y(I,J)) Ymax = Y(I,J)
            IF (Ymin .GT. Y(I,J)) Ymin = Y(I,J)
  200     CONTINUE
  100   CONTINUE

*       (*  Make sure the max and min points aren't the same. *)
        IF (Xmax .EQ. Xmin) THEN
          Xmin = Xmin -.5
          Xmax = Xmax +.5
	 ENDIF

        IF (Ymax .EQ. Ymin) THEN
          Ymin = Ymin -.5
          Ymax = Ymax +.5
        ENDIF

*       (* Initialize the window's max and min points to that of the 
*          plot's. *)
        WXmax = Xmax
        Call number (WXmax, .TRUE., hix)
        WXmin = Xmin
        Call number (WXmin, .FALSE., lowx)
        WYmax = Ymax
        Call number (WYmax, .TRUE., hiy)
        WYmin = Ymin
        Call number (WYmin, .TRUE., lowy)

        RETURN
        END
