/* Arraychar.p -- type-specific functions for class Arraychar

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	September, 1985

Function:
	
Type-specific functions for class Arraychar, such as hash() and
printOn().  Generic functions are generated from the m4 template file
Array.c.m4.

WARNING -- Make changes to the .p or .m4 files, not to the .c file
they generate.

$Log:	Arraychar.p,v $
 * Revision 2.204  89/10/07  23:18:36  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:20:56  keith
 * Pre-release
 * 
 * Revision 2.202.1.3  89/07/08  19:10:49  keith
 * Add initialization of virtual base Object to readFrom() constructors
 * 
 * Revision 2.202.1.2  89/07/07  14:02:22  keith
 * Clean up cast-away const where possible
 * 
 * Revision 2.202.1.1  89/07/01  21:53:00  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:52:57  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/20  21:39:33  keith
 * Add explicit base names to constructor initializer
 * lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:50:04  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:15:45  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:55:46  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:11:59  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:27:30  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:02:54  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

`#include' "Arraychar.h"
`#include' "nihclconfig.h"
`#include' <libc.h>
`#include' "nihclIO.h"

`#define'	THIS	Arraychar
`#define'	BASE	Collection
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(Arraychar,1,"$Header: Arraychar.p,v 2.204 89/10/07 23:18:36 keith Stab $",NULL,NULL);

static int charCmp(const void* a, const void* b)
{
	return *(const unsigned char*)a - *(const unsigned char*)b;
}

union hash_char_mask {
	unsigned in[sizeof(int)];
	char ch[sizeof(int)*sizeof(int)];
	hash_char_mask();
} mask;

hash_char_mask::hash_char_mask()
{
	for (register unsigned i=0; i<sizeof(int); i++) {
		for (register unsigned j=0; j<sizeof(int); j++) ch[sizeof(int)*i+j] = j<i ? 0xff : 0;
	}
}

unsigned THIS::hash() const
{
	register unsigned h = sz;
	register unsigned i = div_sizeof_int(sz);
	register unsigned* vv = (unsigned*)v;
	while (i--) h ^= *vv++;
	if ((i = mod_sizeof_int(sz)) != 0)
		h ^= *vv & mask.in[i];
	return h;
}

void THIS::printOn(ostream& strm) const
{
	for (register unsigned i=0; i<sz; i++) {
		if (i > 0) strm << '\t';
		strm << form("0x%.2x",(unsigned int)(unsigned char)v[i]);
	}
}

THIS::THIS(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
	strm >> sz;
	v = NEW(char,sz);
	strm.get(v,sz);
}

void THIS::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << sz;
	strm.put(v,sz);
}

Arraychar::Arraychar(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)
{
	fd >> sz;
	v = NEW(char,sz);
	fd.get(v,sz);
}

void Arraychar::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << sz;
	fd.put(v,sz);
}

ARRAYIMPLEMENT(Arraychar,char)
