#ifndef	COLLECTION_H
#define	COLLECTION_H

/*$Header: Collection.h,v 2.204 89/10/07 23:19:05 keith Stab $*/

/* Collection.h -- declarations for abstract Collection class

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Collection.h,v $
 * Revision 2.204  89/10/07  23:19:05  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:28  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:53:31  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:29  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:12:44  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/20  22:41:06  keith
 * Make all constructors non-inline.
 * 
 * Revision 2.201.1.2  89/06/01  23:14:55  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:40:56  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:16:31  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.5  89/05/12  10:56:53  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.4  89/05/05  09:57:15  keith
 * Overload reference-returning member functions (e.g.
 * operator[](int) and at(int) for const instances.
 * 
 * Revision 2.200.1.3  89/05/03  23:07:25  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.2  89/04/25  10:08:05  keith
 * Make ~Collection() virtual.
 * 
 * Revision 2.200.1.1  89/04/24  17:13:36  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:04  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:03:52  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Object.h"

class ArrayOb;
class Bag;
class Heap;
class Iterator;
class OrderedCltn;
class Set;
class SortedCltn;

class Collection: public VIRTUAL Object {	// abstract class 
	DECLARE_MEMBERS(Collection);
public:
	static const unsigned DEFAULT_CAPACITY;		// default initial collection capacity 
	static const unsigned EXPANSION_INCREMENT;	// collection (OrderedCltn) expansion increment 
	static const unsigned EXPANSION_FACTOR;		// collection (Set,Bag,Dictionary) expansion factor 
protected:
	Collection();
protected:		// _storer() functions for object I/O
	void _storer(OIOofd&) const;		// store collection using Iterator
	void _storer(OIOout&) const;		// store collection using Iterator
public:
	ArrayOb asArrayOb() const;
	Bag asBag() const;
	Heap asHeap() const;
	OrderedCltn asOrderedCltn() const;
	Set asSet() const;
	SortedCltn asSortedCltn() const;
	virtual ~Collection() {}	// Collection destructors are virtual
	virtual	Object* add(Object&) = 0;
	virtual const Collection& addAll(const Collection&);
	virtual Collection& addContentsTo(Collection&) const;
	virtual Object*& at(int) = 0;
	virtual const Object *const& at(int) const = 0;
	virtual int compare(const Object&) const = 0;
	virtual	void deepenShallowCopy();   // {}
	virtual	void doFinish(Iterator& pos) const;
	virtual	Object* doNext(Iterator&) const = 0;
	virtual	void doReset(Iterator& pos) const;
	virtual void dumpOn(ostream& strm =cerr) const;
	virtual unsigned hash() const = 0;
	virtual bool includes(const Object&) const;
	virtual bool isEmpty() const;
	virtual bool isEqual(const Object&) const = 0;
	virtual unsigned occurrencesOf(const Object&) const = 0;
	virtual void printOn(ostream& strm =cout) const;
	virtual Object* remove(const Object&) = 0;
	virtual void removeAll() = 0;
	virtual const Collection& removeAll(const Collection&);
	virtual unsigned size() const = 0;
};

#include "Iterator.h"

#endif
