#ifndef	DICTIONARY_H
#define	DICTIONARY_H

/*$Header: Dictionary.h,v 2.204 89/10/07 23:19:14 keith Stab $*/

/* Dictionary.h -- declarations for Set of Associations

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Dictionary.h,v $
 * Revision 2.204  89/10/07  23:19:14  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:40  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/03  16:22:29  keith
 * Define storer() functions as workaround for BUG_38
 * in AT&T C++ Translator 2.00.
 * 
 * Revision 2.202.1.1  89/07/01  21:53:40  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:39  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:13:03  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:15:03  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:41:05  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:16:42  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  10:57:10  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:07:43  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:14:00  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:17  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:04:11  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Set.h"

class Assoc;
class LookupKey;
class OrderedCltn;

class Dictionary: public Set {
	DECLARE_MEMBERS(Dictionary);
#ifndef BUG_38
// internal <<AT&T C++ Translator 2.00 06/30/89>> error: bus error (or something nasty like that)
protected:		// storer() functions for object I/O
	virtual	void storer(OIOofd& fd)	const	{ Set::storer(fd); };
	virtual	void storer(OIOout& strm) const	{ Set::storer(strm); };
#endif
public:
	Dictionary(unsigned size =DEFAULT_CAPACITY);
	void operator=(const Dictionary&);
	bool operator==(const Dictionary&) const;
	bool operator!=(const Dictionary& d) const { return !(*this == d); }
	virtual	Object* add(Object&);
	virtual Assoc* addAssoc(Object& key, Object& value);
	virtual Collection& addContentsTo(Collection&) const;
	virtual Collection& addKeysTo(Collection&) const;
	virtual Collection& addValuesTo(Collection&) const;
	virtual LookupKey* assocAt(const Object& key) const;
	virtual Object* atKey(const Object& key) const;
	virtual Object* atKey(const Object& key, Object& newValue);
	virtual bool includesAssoc(const LookupKey& asc) const;
	virtual bool includesKey(const Object& key) const;
	virtual bool isEqual(const Object&) const;
	virtual Object* keyAtValue(const Object& val) const;
	virtual unsigned occurrencesOf(const Object& val) const;
	virtual Object* remove(const Object& asc);
	virtual LookupKey* removeAssoc(const LookupKey& asc);
	virtual LookupKey* removeKey(const Object& key);
	virtual const Class* species() const;
private:				// shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif
