/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.lang.reflect.Array;
import tcl.lang.Command;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.JACL;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;

class GlobCmd
implements Command {
    private static final char[] specCharArr = new char[]{'*', '[', ']', '?', '\\'};
    private static final String[] validOptions = new String[]{"-nocomplain", "--"};
    private static final int OPT_NOCOMPLAIN = 0;
    private static final int OPT_LAST = 1;

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        TclObject resultList;
        block31: {
            boolean noComplain = false;
            int firstArg = 1;
            String head = "";
            String tail = "";
            boolean last = false;
            while (firstArg < argv.length && !last) {
                if (!argv[firstArg].toString().startsWith("-")) break;
                int opt = TclIndex.get((Interp)interp, (TclObject)argv[firstArg], (String[])validOptions, (String)"switch", (int)1);
                switch (opt) {
                    case 0: {
                        noComplain = true;
                        break;
                    }
                    case 1: {
                        last = true;
                        break;
                    }
                    default: {
                        throw new TclException(interp, "GlobCmd.cmdProc: bad option " + opt + " index to validOptions");
                    }
                }
                ++firstArg;
            }
            if (firstArg >= argv.length) {
                throw new TclNumArgsException(interp, 1, argv, "?switches? name ?name ...?");
            }
            resultList = TclList.newInstance();
            resultList.preserve();
            int i = firstArg;
            while (i < argv.length) {
                block30: {
                    String separators;
                    String arg = argv[i].toString();
                    switch (JACL.PLATFORM) {
                        case 1: {
                            separators = "/\\:";
                            break;
                        }
                        case 2: {
                            if (arg.indexOf(58) == -1) {
                                separators = "/";
                                break;
                            }
                            separators = ":";
                            break;
                        }
                        default: {
                            separators = "/";
                        }
                    }
                    int index = 0;
                    if (arg.startsWith("~")) {
                        while (index < arg.length()) {
                            char c = arg.charAt(index);
                            if (c == '\\' ? separators.indexOf(arg.charAt(index + 1)) != -1 : separators.indexOf(c) != -1) break;
                            ++index;
                        }
                        if (GlobCmd.strpbrk(arg.substring(1, index).toCharArray(), specCharArr) < 0) {
                            try {
                                head = FileUtil.doTildeSubst(interp, arg.substring(1, index));
                            }
                            catch (TclException e) {
                                if (noComplain) {
                                    head = null;
                                }
                                throw new TclException(interp, e.getMessage());
                            }
                        } else {
                            if (!noComplain) {
                                throw new TclException(interp, "globbing characters not supported in user names");
                            }
                            head = null;
                        }
                        if (head == null) {
                            if (noComplain) {
                                interp.setResult("");
                                return;
                            }
                            return;
                        }
                        if (index != arg.length()) {
                            ++index;
                        }
                    }
                    tail = arg.substring(index);
                    try {
                        GlobCmd.doGlob(interp, separators, new StringBuffer(head), tail, resultList);
                    }
                    catch (TclException e) {
                        if (noComplain) break block30;
                        throw new TclException(interp, e.getMessage());
                    }
                }
                ++i;
            }
            try {
                if (TclList.getLength(interp, resultList) == 0 && !noComplain) {
                    String sep = "";
                    StringBuffer ret = new StringBuffer();
                    ret.append("no files matched glob pattern");
                    ret.append(argv.length == 2 ? " \"" : "s \"");
                    i = firstArg;
                    while (i < argv.length) {
                        ret.append(sep + argv[i].toString());
                        if (i == firstArg) {
                            sep = " ";
                        }
                        ++i;
                    }
                    ret.append("\"");
                    throw new TclException(interp, ret.toString());
                }
                if (TclList.getLength(interp, resultList) <= 0) break block31;
                interp.setResult(resultList);
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                resultList.release();
                throw throwable;
            }
        }
        Object var12_13 = null;
        resultList.release();
    }

    private static int SkipToChar(String str, int sIndex, char match) {
        boolean quoted = false;
        int level = 0;
        int i = sIndex;
        int length = str.length();
        while (i < length) {
            if (quoted) {
                quoted = false;
            } else {
                char c = str.charAt(i);
                if (level == 0 && c == match) {
                    return i;
                }
                if (c == '{') {
                    ++level;
                } else if (c == '}') {
                    --level;
                } else if (c == '\\') {
                    quoted = true;
                }
            }
            ++i;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static final void doGlob(Interp interp, String separators, StringBuffer headBuf, String tail, TclObject resultList) throws TclException {
        count = 0;
        tailLen = tail.length();
        headLen = headBuf.length();
        lastChar = '\u0000';
        if (headLen > 0) {
            lastChar = headBuf.charAt(headLen - 1);
        }
        name = tail;
        tailIndex = 0;
        while (tailIndex < tailLen) {
            c = tail.charAt(tailIndex);
            if (c == '\\' && tailIndex + 1 < tailLen && separators.indexOf(tail.charAt(tailIndex + 1)) != -1) {
                ++tailIndex;
            } else if (separators.indexOf(c) == -1) break;
            ++count;
            ++tailIndex;
        }
        switch (JACL.PLATFORM) {
            case 2: {
                if (separators.charAt(0) == '/') {
                    if ((headLen != 0 || count != 0) && (headLen <= 0 || lastChar == ':')) break;
                    headBuf.append(":");
                    break;
                }
                if (count == 0) {
                    if (headLen <= 0 || lastChar == ':') break;
                    headBuf.append(":");
                    break;
                }
                if (lastChar != ':') ** GOTO lbl35
                if (true) ** GOTO lbl35
                do {
                    headBuf.append(":");
lbl35:
                    // 3 sources

                    v0 = --count;
                    --count;
                } while (v0 > 0);
                break;
            }
            case 1: {
                if (name.startsWith(":")) {
                    headBuf.append(":");
                    if (count <= 1) break;
                    headBuf.append("/");
                    break;
                }
                if (tailIndex >= tailLen || (headLen <= 0 || separators.indexOf(lastChar) != -1) && (headLen != 0 || count <= 0)) break;
                headBuf.append("/");
                if (headLen != 0 || count <= 1) break;
                headBuf.append("/");
                break;
            }
            default: {
                if (tailIndex >= tailLen || (headLen <= 0 || separators.indexOf(lastChar) != -1) && (headLen != 0 || count <= 0)) break;
                headBuf.append("/");
            }
        }
        closeBraceIndex = -1;
        openBraceIndex = -1;
        quoted = false;
        pIndex = tailIndex;
        while (pIndex != tailLen) {
            ch = tail.charAt(pIndex);
            if (quoted) {
                quoted = false;
            } else if (ch == '\\') {
                quoted = true;
                if (pIndex + 1 < tailLen && separators.indexOf(tail.charAt(pIndex + 1)) != -1) {
                    break;
                }
            } else {
                if (separators.indexOf(ch) != -1) break;
                if (ch == '{') {
                    openBraceIndex = pIndex++;
                    closeBraceIndex = GlobCmd.SkipToChar(tail, pIndex, '}');
                    if (closeBraceIndex != -1) break;
                    throw new TclException(interp, "unmatched open-brace in file name");
                }
                if (ch == '}') {
                    throw new TclException(interp, "unmatched close-brace in file name");
                }
            }
            ++pIndex;
        }
        if (openBraceIndex != -1) {
            baseBuf = new StringBuffer();
            baseBuf.append(tail.substring(tailIndex, openBraceIndex));
            baseLen = baseBuf.length();
            headLen = headBuf.length();
            pIndex = openBraceIndex;
            while (pIndex < closeBraceIndex) {
                if ((nextIndex = GlobCmd.SkipToChar(tail, ++pIndex, ',')) == -1 || nextIndex > closeBraceIndex) {
                    nextIndex = closeBraceIndex;
                }
                headBuf.setLength(headLen);
                baseBuf.setLength(baseLen);
                baseBuf.append(tail.substring(pIndex, nextIndex));
                baseBuf.append(tail.substring(closeBraceIndex + 1));
                pIndex = nextIndex;
                GlobCmd.doGlob(interp, separators, headBuf, baseBuf.toString(), resultList);
            }
            return;
        }
        firstSpecCharIndex = pIndex < tailLen ? GlobCmd.strpbrk(tail.substring(0, pIndex).toCharArray(), GlobCmd.specCharArr) : GlobCmd.strpbrk(tail.substring(tailIndex).toCharArray(), GlobCmd.specCharArr);
        if (firstSpecCharIndex != -1) {
            GlobCmd.matchFiles(interp, separators, headBuf.toString(), tail.substring(tailIndex), pIndex - tailIndex, resultList);
            return;
        }
        headBuf.append(tail.substring(tailIndex, pIndex));
        if (pIndex < tailLen) {
            GlobCmd.doGlob(interp, separators, headBuf, tail.substring(pIndex), resultList);
            return;
        }
        switch (JACL.PLATFORM) {
            case 2: {
                if (headBuf.toString().indexOf(58) == -1) {
                    headBuf.append(":");
                }
                head = headBuf.toString();
                break;
            }
            case 1: {
                if (headBuf.length() == 0) {
                    if (name.length() > 1 && name.charAt(0) == '\\' && (name.charAt(1) == '/' || name.charAt(1) == '\\') || name.length() > 0 && name.charAt(0) == '/') {
                        headBuf.append("\\");
                    } else {
                        headBuf.append(".");
                    }
                }
                head = headBuf.toString().replace('\\', '/');
                break;
            }
            default: {
                if (headBuf.length() == 0) {
                    if (name.startsWith("\\/") || name.startsWith("/")) {
                        headBuf.append("/");
                    } else {
                        headBuf.append(".");
                    }
                }
                head = headBuf.toString();
            }
        }
        GlobCmd.addFileToResult(interp, head, separators, resultList);
    }

    private static final void matchFiles(Interp interp, String separators, String dirName, String pattern, int pIndex, TclObject resultList) throws TclException {
        String[] dirListing;
        boolean matchHidden;
        int patternEnd = pIndex;
        int dirLen = dirName.length();
        int patLen = pattern.length();
        StringBuffer dirBuf = new StringBuffer();
        switch (JACL.PLATFORM) {
            case 1: {
                if (dirLen == 0) {
                    dirBuf.append("./");
                } else {
                    dirBuf.append(dirName);
                    char c = dirBuf.charAt(dirLen - 1);
                    if (c == ':' && dirLen == 2 || separators.indexOf(c) == -1) {
                        dirBuf.append("/");
                    }
                }
                pattern = pattern.toLowerCase();
                break;
            }
            default: {
                if (dirLen == 0) {
                    dirBuf.append(".");
                    break;
                }
                dirBuf.append(dirName);
            }
        }
        File dirObj = GlobCmd.createAbsoluteFileObj(interp, dirBuf.toString());
        if (!dirObj.isDirectory()) {
            return;
        }
        if (pattern.startsWith(".") || pattern.startsWith("\\.")) {
            matchHidden = true;
            dirListing = GlobCmd.addHiddenToDirList(dirObj);
        } else {
            matchHidden = false;
            dirListing = dirObj.list();
        }
        if (dirListing.length == 0 && dirName.endsWith("/")) {
            dirName = dirName.substring(0, dirLen - 1);
        }
        if (pIndex < patLen && pattern.charAt(pIndex) == '\\') {
            ++pIndex;
        }
        if (pIndex < patLen - 1) {
            ++pIndex;
        }
        int i = 0;
        while (i < dirListing.length) {
            if (matchHidden || !dirListing[i].startsWith(".")) {
                String tmp = dirListing[i];
                if (JACL.PLATFORM == 1) {
                    tmp = tmp.toLowerCase();
                }
                if (Util.stringMatch(tmp, pattern.substring(0, patternEnd))) {
                    dirBuf.setLength(dirLen);
                    dirBuf.append(dirListing[i]);
                    if (pIndex == pattern.length()) {
                        GlobCmd.addFileToResult(interp, dirBuf.toString(), separators, resultList);
                    } else {
                        dirObj = GlobCmd.createAbsoluteFileObj(interp, dirBuf.toString());
                        if (dirObj.isDirectory()) {
                            dirBuf.append("/");
                            GlobCmd.doGlob(interp, separators, dirBuf, pattern.substring(patternEnd + 1), resultList);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private static final int strpbrk(char[] src, char[] matches) {
        int i = 0;
        while (i < src.length) {
            int j = 0;
            while (j < matches.length) {
                if (src[i] == matches[j]) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static final String[] addHiddenToDirList(File dirObj) {
        void var2_3;
        String[] dirListing = dirObj.list();
        int arrayLen = Array.getLength(dirListing);
        try {
            String[] fullListing = (String[])Array.newInstance(Class.forName("java.lang.String"), arrayLen + 2);
        }
        catch (Exception e) {
            return dirListing;
        }
        int i = 0;
        while (i < arrayLen) {
            fullListing[i] = dirListing[i];
            ++i;
        }
        fullListing[arrayLen] = ".";
        fullListing[arrayLen + 1] = "..";
        return var2_3;
    }

    private static void addFileToResult(Interp interp, String fileName, String separators, TclObject resultList) throws TclException {
        TclObject[] arrayObj;
        String prettyFileName = fileName;
        int prettyLen = fileName.length();
        if (JACL.PLATFORM == 1 && prettyLen >= 2 && fileName.charAt(1) == ':') {
            if (prettyLen == 2) {
                fileName = fileName + '\\';
            } else if (fileName.charAt(2) != '\\') {
                fileName = fileName.substring(0, 2) + '\\' + fileName.substring(2);
            }
        }
        File f = FileUtil.getPathType(fileName = FileUtil.joinPath(interp, arrayObj = TclList.getElements(interp, FileUtil.splitAndTranslate(interp, fileName)), 0, arrayObj.length)) == 2 ? FileUtil.getNewFileObj(interp, fileName) : new File(interp.getWorkingDir(), fileName);
        if (prettyLen > 0 && separators.indexOf(prettyFileName.charAt(prettyLen - 1)) != -1) {
            if (f.isDirectory()) {
                TclList.append(interp, resultList, TclString.newInstance((String)prettyFileName));
            }
        } else if (f.exists()) {
            TclList.append(interp, resultList, TclString.newInstance((String)prettyFileName));
        }
    }

    private static final File createAbsoluteFileObj(Interp interp, String fileName) throws TclException {
        if (fileName.equals("")) {
            return interp.getWorkingDir();
        }
        if (JACL.PLATFORM == 1 && fileName.length() >= 2 && fileName.charAt(1) == ':') {
            String tmp = null;
            if (fileName.length() == 2) {
                tmp = fileName.substring(0, 2) + '\\';
            } else if (fileName.charAt(2) != '\\') {
                tmp = fileName.substring(0, 2) + '\\' + fileName.substring(2);
            }
            if (tmp != null) {
                return FileUtil.getNewFileObj(interp, tmp);
            }
        }
        return FileUtil.getNewFileObj(interp, fileName);
    }

    GlobCmd() {
    }
}

