#!/usr/local/bin/perl

# Might want to taintify this program some day.

eval "exec /usr/local/bin/perl $0"
  if $running_under_some_shell;

# @(#)@ dorequest	1.19 - dorequest.pl
#
# This program handles the enqueued requests for the mail server.
#
# Arguments: address file [ encoding [ limit [ parts ] ] ]
#
#   address : where to send the information to.
#	      If left empty, no splitting is done, and the result
#	      is written to stdout.
#
#   file    : the file to send.
#
#   encoding: how to encode it: uuencode, btoa or plain.
#             Default is $defaultencoding from config file
#
#   limit   : how many bytes per transmission.
#             Default is $def_limit from the config file
#
#   parts   : comma- or blank-separated list of part numbers.
#             When used, only these parts are sent.

# set these variables using perl -s
$debug = 0 unless $debug;
$nolog = 0 unless $nolog;
$nosync = 0 unless $nosync;

&source("/usr/local/lib/mailserver/config");
&source("$lib/rfc822.pl");
&source("syslog.pl");

do openlog($syslogname,'cons,pid','local7');


# argument processing

if ( $#ARGV < 1 | $#ARGV > 4 ) {
  print stderr "usage: dorequest address file [ encoding [ limit [ parts ] ] ]\n";
  print stderr "call was: $0 \"", join ("\" \"", @ARGV), "\"\n";
  do syslog('warning', 'Wrong arguments to dorequest');
  exit 1;
}

# address to send message(s) to
$address = shift (@ARGV);

# the requested file
$file = shift (@ARGV);

# encoding to be used [optional]
$encoding = ($#ARGV >= 0) ? shift (@ARGV) : $defaultencoding;

# byte limit on transmissions [optional]
$limit = ($#ARGV >= 0) ? shift (@ARGV) : $def_limit;
$limit = $minlimit if $limit < $minlimit;
$limit = $maxlimit if $limit > $maxlimit;

# list of parts [optional]
$plist = ($#ARGV >= 0) ? " " . join (" ", split (/[ \t,]/, shift (@ARGV))) . " " : "";

# printing to stdout rather than mailing... (for debugging)
if ( $address eq "" ) { $limit = 0; $nolog = 1; $nosync = 1; }

# cut down system load
do synchronise() unless $nosync;

# Proceed

# get last part (basename) of the requested file
@tmp = split (/\//, $file); 
$fname = $tmp[$#tmp];

# prepare the command to use
# $lines holds the maximum number of lines which should be put into the msg
# $cmd is the command executed to get the file
# $ct is used for the log file

if ( $encoding eq "btoa" ) {

  $code = "btoa encoded";
  # btoa has lines of 78 chars
  $lines = int ($limit / 79) - 2;
  $cmd = "$btoa < $file";
  $ct = "B";
} elsif ( $encoding eq "plain" || $encoding eq "ascii" ) {

  $code = "ascii";
  $cmd = "$cat < $file";
  $ct = "A";
  $lines = 0;
} else {

  $code = "uuencoded";
  # uuencode has lines of 61 chars
  $lines = int ($limit / 62) - 2;
  $cmd = "$uuencode \"$fname\" < $file";
  $ct = "U";
}

# See if we must split the request into several files.

if ( $lines > 0 && $limit > 0 ) {	# Yes, split 'em
  # encode and split
  system $cmd . " | $split -$lines - $tmpfile_prefix";
  # now gather all the parts, and send them
  $wild = $tmpfile_prefix . "??";
  @files = sort <${wild}>; 
  $count = $#files + 1;

  print stderr "sending ", $count, " files: ", join(" ",@files), "\n" if ( $debug );

} else {				# Nope, just send the file
  system $cmd . " > $tmpfile_prefix.aa";
  @files = "$tmpfile_prefix.aa";
  $count = 1;
}

# Now send the message(s) containing the file(s)

$num = 1;
while ( $#files >= 0 ) {

  $the_file = shift (@files);

  # Check to see if we're sending only specific parts of
  # the file.  If so, see if this is one of them to send.

  if ( $plist ne "" && index ($plist, " $num ") < 0 ) {
    # use "next" to activate "continue" block
    next;
  }

  # form "part xx of yy" message
  $part = ( $count == 1 ) ? "complete" : "part $num of $count";

  # send it
  if (open(part, $the_file)) {
    if ( $address eq "" ) {		# Don't really mail it
	    do copy ("STDOUT");
    } else {				# Yes, transfer it
	    do xfer();
    }	
    close (part);
  }

  # write a log message $xfer_size is set by 'xfer()'

  $xfer_size = "DEBUG" if $debug;
  do writelog ("\"$address\" $file $ct$num/$count $xfer_size")
    if $address ne "";

} continue {
  # remove this part, and advance
  unlink ($the_file);
  $num++;
}

# remove the lock, if any
unlink $lockfile if $lockfile;

# that's it ...
do closelog();
exit 0;

################ subroutines ################

# Build header for mail message to be sent to requestor.
# Expects to be passed variable containing name of filehandle 
# which will take head as output.

# If a second argument is present, this routine provides all
# of the mail headers, not just the required ones.  This can
# be used, for example, if piping directly into UUCP.

sub headers {
  local ($mailer, $all) = @_;
  local ($size);

  # get time and tz difference
  $tim = time;
  @tm = gmtime ($tim);
  $tzdiff = -$tm[2];
  @tm = localtime ($tim);
  $tzdiff += $tm[2];
  $this_month = $months[$tm[4]];
  $this_day = $days[$tm[6]];

  if ( $all ) {		# Build ALL headers.
    # primary headers
    $ln = sprintf ("From $myaddr  %s %s %2d %2d:%02d:%02d 19%2d",
               $this_day, $this_month, $tm[3], 
	       $tm[2], $tm[1], $tm[0], $tm[5]) .
          " remote from $host\n" .
          "Received: by $myname ($version); " .
          sprintf ("%s, %d %2s %02d %2d:%02d:%02d %s (+%02d00)\n",
                   $this_day, $tm[3], $this_month, $tm[5], 
   	           $tm[2], $tm[1], $tm[0], $timezone,
	           ($tm[8] ? 1 : 0) + $tzdiff) .
          sprintf ("Message-Id: <$$.%02d%02d%02d%02d%02d@$domain>\n",
		   $tm[5], $tm[4], $tm[3], $tm[2], $tm[1]) .
	  "$fromline\n";
  } else {		# Build only from line
	  $ln = "$fromline\n";
  }

  $ln .= "To: $address\nSubject: $fname ($part) $code\n";
  if ( $all ) {
    $ln .= sprintf ("Date: %s, %d %2s %02d %2d:%02d:%02d %s\n",
                    $this_day, $tm[3], $this_month, $tm[5], 
   	            $tm[2], $tm[1], $tm[0], $timezone);
  }
  $ln .= "Precedence: bulk\n";
  $ln .= "Errors-To: $humanaddr\n";

  foreach $xheader (@xheaders) {
	$ln .= $xheader . "\n";
  }

  # Now have total header build up...

  print $mailer "$ln\n";
  $size += length ($ln) + 1;	# Allow one blank line
}

# Routine to copy files.  Takes one argument: the filehandle to
# print file to.
#
# Expects part to be open filehandle of file we're sending.

sub copy {
  local ($mailer) = shift (@_);
  local ($size);
  local ($ln);

  $ln = "------ begin of $fname -- $code -- $part ------\n";
  $size = length ($ln);
  print $mailer $ln;
  while ( <part> ) {
    print $mailer $_;
    $size += length ($_);
  }
  $ln = "------ end of $fname -- $code -- $part ------\n";
  print $mailer $ln;
  $size += length ($ln);
}

# send the file via e-mail, avoid as much overhead as possible

sub xfer {
  # parse the address

  do rfc822_parse_addresses($address);

  # should be one, single destination
  if ( $#rfc822_addresses == 0 ) {
    if ( $debug ) {
      print stderr "[Would call $howmail using address of \'$rfc822_addresses[0]\'\n";
      do headers ("STDOUT", 0);
    }
    elsif ( open(mailer, "| $howmail") ) {
      $xfer_size = do headers("mailer", 0);
      $xfer_size += do copy("mailer");
      close mailer;
      sleep ($sleepbetween) unless $num == $count;	# allow system to stabilize
    }
  }
}

sub synchronise {

  # try to reduce system load by preventing this job to run
  # if there are other heavy tasks active

  return if $nosync;

  do {

    $notnow = 0;

    ### sleep a while if -

    ### 1) load average is too high (pick your fav method to get lav)

    if (eval $getlav > $maxlav) {
	  $notnow++;
	  do syslog('INFO', "waiting for lav"); # if $debug;
    }

    ### 2) another process is running

    if ( $lockfile && ( $notnow == 0 )) {

      if ( -e $lockfile ) {

	# check if the process is still active
	open (lf, $lockfile);
	$pid = <lf>;
	close (lf);
	chop ($pid);
	if ( ( kill 0, $pid ) > 0 ) {	# it is ...
	  $notnow++;
	  do syslog('INFO', "waiting for process $pid"); # if $debug;
	} else {			# process disappeared - seize the lock
	  open (lf, ">" . $lockfile);
	  print lf "$$\n";
	  close (lf);
	  do syslog('INFO', "seized lock of process $pid"); # if $debug;
	}
      }
      else {
	# create a lock with our pid in it.
	open (lf, ">" . $lockfile);
	print lf "$$\n";
	close (lf);
      }
    }

    sleep ($debug ? 30 : 300) if $notnow;

  } while $notnow;
}

sub writelog {

  # Write message to logfile, if possible, Otherwise use stderr.

  @tm = localtime (time);
  $msg = sprintf ("%02d/%s/%02d %02d:%02d %s\n", 
                  $tm[3], @months[$tm[4]], $tm[5], $tm[2], $tm[1], $_[0]);

  if ( !$nolog && $logfile && ( -w $logfile ) && open (l, ">>" . $logfile) ) {
    print l $msg;
    close l;
    return unless $debug;
  }

  print stderr $msg;
}

sub source {
    local($file) = @_;
    local($return) = 0;

    $return = do $file;
    &logdie("couldn't parse $file: $@") if $@;
    &logdie("couldn't do $file: $!") unless defined $return;
    &logdie("couldn't run $file") unless $return;
    $return;
} 

sub logdie {
	do syslog('alert', @_);
	do closelog();
	die;
}
