/* $Id: messages.h,v 1.3 92/12/04 07:40:16 wolf Exp $
 *
 *  Copyright (C) 1991,1992  Kimmo Suominen, Christophe Wolfhugel
 *
 *  Please read the files COPYRIGHT and AUTHORS for the extended
 *  copyrights refering to this file.
 *
 * $Log:	messages.h,v $
 * Revision 1.3  92/12/04  07:40:16  wolf
 * Added TULP_MAILPRIVATE and TULP_HDRMAILNAK (Dominique Marant)
 * 
 * Revision 1.2  92/07/13  21:20:51  kim
 * Moved all messages from lc.c into this file.
 * 
 * Revision 1.1  1992/07/12  21:51:17  kim
 * Return messages for various commands.
 */

/* Messages in the execution log. */

#define TULP_SYNTAX "\
  The syntax you have given is wrong.\n\
  To get a help file send the command 'HELP' to listserv.\n"

#define TULP_NOSUCHLIST "\
  The list specified is not relayed on node %s.\n\
  To see all relayed lists send the command 'LIST' to listserv.\n",HOST

#define TULP_NONESTORED "\
  Sorry, no files are stored on that list.\n"

#define TULP_INDNOFILES "\
  Sorry, no files were found, an empty index will be sent.\n"

#define TULP_GETNOSUCHFILE "\
  Sorry, the requested file does not exist.\n"

#define TULP_REVPRIVATE "\
  Sorry, you are not allowed to review that list.\n\
  Only the header of the list will be mailed to you.\n"

#define TULP_SUBCLOSED "\
  Subscriptions to that list are currently closed.  Please, try again later.\n"

#define TULP_SUBFORWARDED "\
  Your subscription request has been forwarded to the owner(s) of the list.\n\
  You will be sent a notification as soon as you get added to the list.\n"

#define TULP_NOTONLIST "\
  Sorry, you are not a subscriber to the list, or your address has changed.\n\
  Please, resend your request from the original subscription address.\n"

#define TULP_SIGDONE "\
  You have been removed from the list.\n"

#define TULP_SUBALREADY "\
  Your subscription record has been updated.\n"

#define TULP_NOTOWNER "\
  Sorry, you are not an authorized owner on that list.\n"

#define TULP_DELSUCCESS "\
  The user specified has been successfully deleted from the list.\n"

#define TULP_DELNOTONLIST "\
  The user specified was not found on the list.\n"

#define TULP_DELINCONSISTENT "\
  The user was not removed from the list for some reason,\n\
  even though the address was found on the list.  Perhaps\n\
  there are problems with memory, or there is a bug around.\n"

#define TULP_ADDSUCCESS "\
  The user specified has been successfully added to the list.\n"

#define TULP_ADDALREADY "\
  The subscription record has been updated for the user specified.\n"

#define TULP_MAILPRIVATE "\
  Sorry, you are not a subscriber to the list, or your address has changed.\n\
  So, you are not allowed to send mail to this list. \n\
  Please, resend your mail from the original subscription address.\n\
  \n\
    ------ Unsent message follows ------\n"

  
/* General problems and comments */

#define TULP_NOBODY "\
  Sorry, I cannot see your message anywhere.\n"

#define TULP_NOCOMMANDS "\
  Sorry, I could not understand a word you said.\n"

#define TULP_EXITING "\
  End of commands detected.\n"

#define TULP_SAYWHAT "\
  Command not understood.\n"

#define TULP_OKAY "\
  Command executed.\n"

/* Totals:
 * p1 - cpu seconds
 * p2 - cpu type
 */

#define TULP_TOTAL(p1,p2) "\
\n\
Total CPU time:  %2.2f seconds\n\
CPU type:        %s\n",p1,p2

/* Messages for notifies being mailed
 *
 * p1     - subscriber address
 * p2     - list name
 * p3 ... - additional
 */

#define TULP_ADDBY(p1,p2,p3) "\
You have been added to list %s\n\
as: %s\n\
by: %s\n\
\n",p2,p1,p3

#define TULP_SUBUPDATED(p1,p2,p3) "\
Subject: Your subscription on list '%s'\n\
To: %s\n\
\n\
Your subscription record on list %s has been updated\n\
to: %s\n\
by: %s\n",p2,p1,p2,p1,p3

#define TULP_DELREMOVED(p1,p2,p3) "\
Subject: Your removal from list '%s'\n\
To: %s\n\
\n\
You have been removed from list %s\n\
by: %s\n",p2,p1,p2,p3

#define TULP_SUBREQUEST(p1,p2,p3) "\
Subject: SUB %s\n\
To: Owners of list <%s@%s>\n\
\n\
Dear Owners,\n\
\n\
The following subscription request has been made:\n\
ADD %s %s %s\n\
\n\
Virtually,\n\
\n\
	The Listserv Management\n",p2,p2,HOST,p2,p1,p3

#define TULP_SIGSUCCESS(p1,p2) "\
Subject: SIG %s\n\
To: Owners of list <%s@%s>\n\
\n\
Dear Owners,\n\
\n\
User %s\n\
has been successfully removed from list %s.\n\
\n\
Virtually,\n\
\n\
	The Listserv Management\n",p2,p2,HOST,p1,p2

#define TULP_SIGFAILED(p1,p2) "\
Subject: Failed SIG %s\n\
To: Owners of list <%s@%s>\n\
\n\
Dear Owners,\n\
\n\
User %s\n\
was not found on list %s.\n\
\n\
Virtually,\n\
\n\
	The Listserv Management\n",p2,p2,HOST,p1,p2

/* Message headers */

#define TULP_HDRHELP(p1) "\
Subject: Usage information\n\
To: %s\n\
\n",p1

#define TULP_HDRLIST(p1) "\
Subject: Relayed lists\n\
To: %s\n\
\n\
The following lists are realyed at node %s:\n\
\n",p1,HOST

#define TULP_HDRREV(p1,p2) "\
Subject: Recipients of list '%s'\n\
To: %s\n\
\n",p2,p1

#define TULP_HDRWELCOME(p1,p2) "\
Subject: Welcome to list '%s'\n\
To: %s\n\
\n",p2,p1

#define TULP_HDRINDEX(p1,p2) "\
Subject: Index of files on list '%s'\n\
To: %s\n\
\n\
The following files are available on list %s:\n\
\n",p2,p1,p2

#define TULP_HDRGET(p1,p2,p3) "\
Subject: File '%s' on list '%s'\n\
To: %s\n\
\n",p3,p2,p1

#define TULP_HDROUTPUT(p1) "\
Subject: Output of your job\n\
To: %s\n\
\n",p1

#define TULP_HDRMAILNAK(p1,p2) "\
Subject: Returned mail: Private list '%s'\n\
To: %s\n\
\n",p2,p1

/* $RCSfile: messages.h,v $ */
