#!/bin/sh
export PGPPATH=.
export USEPASS="-p testpass"

PKALGS="1 16"
SIGALGS="17 1 16"
CONVALGS="1 2 3  0 4 5"
HASHALGS="1 2 3  5"
#HASHALGS="$HASHALGS 4"
#CONVALGS="$CONVALGS 6"

echo ========== Generating key:
#needs existing pubring.pkr with good parameters in the first key.
#I could use newkeygen, but it takes a while...

if [ -s pubring.pkr ] ; then
    ./newkey5 -K 0 -k 0 -r pubring.pkr -u "Test Key" $USEPASS
else
    ./newkey5 -g 768 -u "Test Key" $USEPASS
fi

#this probably should be a cat, but...
mv pubnew.pkr pubring.pkr
mv secnew.skr secring.skr

#fix pubring to allow crypyption
./lookup5 -o rdx.one -x -m Test
./minipgp5 -3 -i rdx.one -t 24 $USEPASS >>pubring.pkr
echo -ne "\260\001\147" >>pubring.pkr
#strictly, you also need to use pgpk -s to sign the DSS key on the pubring

./newkey5 -3 -g 512
cat secnew.skr >>secring.skr
cat pubnew.pkr >>pubring.pkr

echo ========== Crypt test

./minipgp5 -i newkey5 -o rdx.one -l rdx 
./minipgp5 -z -i rdx.one -o rdx.two
./minipgp5 -i rdx.two -k 0 -o rdx.enc

./minipgp5 -i rdx.enc -o rdx.one $USEPASS
./minipgp5 -i rdx.one -o rdx.two
./minipgp5 -i rdx.two -o rdx
cmp rdx newkey5

echo ========== Crypt and One pass sig test

for pka in $PKALGS; do
    for siga in $SIGALGS; do
        for hash in $HASHALGS; do
            for alg in $CONVALGS; do
    for sigt in -3 -4; do

                echo testing enc $pka/$alg, hash $hash, sig $siga$sigt

                ./minipgp5 -i newkey5 -o rdx.one -l rdx
        ./minipgp5 -o rdx.pre -A $siga -a $hash -t 1 $USEPASS -1 >rdx.pre
        ./minipgp5 -i newkey5 -o rdx.two -A $siga -a $hash -t 1 $USEPASS $sigt
                cat rdx.pre rdx.one rdx.two >rdx.all
                ./minipgp5 -z <rdx.all >rdx.two
                ./minipgp5 -i rdx.two -o rdx.enc -a $alg -A $pka -k 0
                rm -f rdx rdx.pre rdx.one rdx.two rdx.all

                ./minipgp5 -i rdx.enc -o rdx.one $USEPASS
                ./minipgp5 -i rdx.one -o rdx.two
                ./minipgp5 -i rdx.two -o rdy.out
                if cmp rdy.out newkey5 ; then echo decrypt ok; else exit 0; fi
            done
        done
    done
    done
done

echo ========== Detached Signature test

for siga in $SIGALGS; do
for sigt in "" -4; do
    for hash in $HASHALGS; do
        ./minipgp5 -3 -i minipgp5 -o test.sig $USEPASS -a $hash -A $siga $sigt
        ./minipgp5 -i minipgp5 -s test.sig
    done
done
done

rm test.sig

echo ========== Conventional test

for xa in 3 1 0; do #salt/iterated types
for ya in $HASHALGS; do
for a in $CONVALGS; do
    for za in $CONVALGS; do
        echo testing conv-key only a C:$a S:$xa H:$ya SC:$za
        ./minipgp5 -x $xa -y $ya -s $za -a $a -C $USEPASS <README >cvt.one
        ./minipgp5 $USEPASS <cvt.one >cvt.two
        if cmp cvt.two README ; then true; else exit 0; fi
    done
    echo testing conv only a C:$a S:$xa H:$ya
    ./minipgp5 -x $xa -y $ya -s $a -a $a -c $USEPASS <README >cvt.two
    ./minipgp5 $USEPASS <cvt.one >cvt.two
    if cmp cvt.two README ; then true; else exit 0; fi
    rm -f cvt.one cvt.two
done
done
done
